/*
 * Decompiled with CFR 0.152.
 */
package org.ndeftools.wellknown;

import android.nfc.NdefRecord;
import org.ndeftools.Record;
import org.ndeftools.wellknown.Action;

public class ActionRecord
extends Record {
    public static byte[] type = new byte[]{97, 99, 116};
    private Action action;

    public static ActionRecord parseNdefRecord(NdefRecord ndefRecord) {
        return new ActionRecord(Action.getActionByValue(ndefRecord.getPayload()[0]));
    }

    public ActionRecord(Action action) {
        this.action = action;
    }

    public ActionRecord() {
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public boolean hasAction() {
        return this.action != null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActionRecord other = (ActionRecord)obj;
        return this.action == other.action;
    }

    @Override
    public NdefRecord getNdefRecord() {
        if (!this.hasAction()) {
            throw new IllegalArgumentException("Expected action");
        }
        return new NdefRecord(1, type, this.id != null ? this.id : this.EMPTY, new byte[]{this.action.getValue()});
    }
}

