#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

void busclk_init() {						

	/********************************************/
	/************ PLL INITIALIZATION ************/
	/********************************************/
	CPMUCLKS_PLLSEL = 1;			//FBUS = FPLL/2.   FBUS = 16MHz, 
	
	CPMUREFDIV_REFFRQ = 1;			//Reference clock between 2MHZ and 6MHZ.	
	CPMUREFDIV_REFDIV = 0x1;		//FREF=4/(1+1) = 2MHZ	
	
	CPMUSYNR_VCOFRQ = 0x0;          //FVCO is between 32MHZ and 48MHZ	
	
	CPMUSYNR_SYNDIV = 0x7;			//FVCO = 2xFREFx(SYNDIV+1)   =   FVCO = 2x4x(7+1) = 32MHZ 
	
	CPMUPOSTDIV_POSTDIV = 0x0;		//FPLL = FVCO/(POSTDIV+1).  FPLL = 32MHZ/(0+1)    FPLL = 32MHz	
	CPMUOSC_OSCE = 1;				//External oscillator enable. 8MHZ.        FREF=FOSC/(REFDIV+1)		
	while(!CPMUIFLG_LOCK){}			// Wait for LOCK.      	
	CPMUIFLG = 0xFF;				// clear CMPMU flags
	  
	ECLKCTL_NECLK = 1;				// BUSCLock by PS3 enabled	
	}




void main(void) {
  busclk_init();
  EnableInterrupts;

	/*DESCRIPTION: This function set the SPI module and send the data (ABCD) to the data register
	 * */
	   
 /* SCI0CR2 = 0;
  SCI0SR2 = 0x04; //Break Transmit Character Length
  //SCI0BD = 833; //baoud rate
  SCI0CR1 = 0;
  SCI0SR2_AMAP = 1; //Alternative Map   limpia todo
  SCI0ACR1 = 0x80; //Receive Input Active Edge Interrupt Enable*/
 /* SCI0ACR2 = 0x04;
  SCI0ASR1 = 0xFF;*/
  
  	  	/*1. SPI Clock Phase Bit */
		SPI0CR1_CPHA = 0; //Sampling of data occurs at even edges (2,4,6,...) of the SCK clock.
		
		//SPI0CR1_CPOL
		SPI0CR2_XFRW = 1; //16 bit transfers according to MMA6900 datasheet
		
		SPI0BR =0x0F; //slowest baudrate
		
		/*Slave Select Output Enable*/
		SPI0CR2_MODFEN = 1;
		
		SPI0CR1_SSOE = 1; //The SS output feature is enabled only in master mode
		
				
		/*SPI Master/Slave Mode Select Bit*/
		SPI0CR1_MSTR=1;	//SPI is master mode
		
		/*SPI System Enable Bit*/
		SPI0CR1_SPE=1; 	//enable SPI module
		
		//write
		SPI0DR = 0xAB;
	    while(SPI0SR_SPTEF==0){};

  for(;;) {
    __RESET_WATCHDOG();	/* feeds the dog */
    
	//Write in SPI buffer
	SPI0DR = 0xABCD;
	
    while(SPI0SR_SPTEF==0){}; //Wait until SPI data register is empty
    
  } /* loop forever */
  /* please make sure that you never leave main */

}
