#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
void busclk_init(void);

void busclk_init() {						

	/********************************************/
	/************ PLL INITIALIZATION ************/
	/********************************************/
	CPMUCLKS_PLLSEL = 1;			//FBUS = FPLL/2.   FBUS = 16MHz, 
	
	CPMUREFDIV_REFFRQ = 1;			//Reference clock between 2MHZ and 6MHZ.	
	CPMUREFDIV_REFDIV = 0x1;		//FREF=4/(1+1) = 2MHZ	
	
	CPMUSYNR_VCOFRQ = 0x0;          //FVCO is between 32MHZ and 48MHZ	
	
	CPMUSYNR_SYNDIV = 0x7;			//FVCO = 2xFREFx(SYNDIV+1)   =   FVCO = 2x4x(7+1) = 32MHZ 
	
	CPMUPOSTDIV_POSTDIV = 0x0;		//FPLL = FVCO/(POSTDIV+1).  FPLL = 32MHZ/(0+1)    FPLL = 32MHz	
	CPMUOSC_OSCE = 1;				//External oscillator enable. 8MHZ.        FREF=FOSC/(REFDIV+1)		
	while(!CPMUIFLG_LOCK){}			// Wait for LOCK.      	
	CPMUIFLG = 0xFF;				// clear CMPMU flags
	  
	ECLKCTL_NECLK = 0;				// BUSCLock by PS3 enabled	
	}


void main(void) {
	
  busclk_init();
  EnableInterrupts;
  
  /* This function enable the over-current detector on PP7 (EVDD)*/
  	
  	DDRP_DDRP7 = 1; //Configurate PP7 as output
  	DDRP_DDRP1 = 1; //Configurate PP1 as output
  	DDRT_DDRT5 = 1; //Configurate PP1 as output
  	
  	PTP_PTP1 = 1;
  	PTP_PTP7 = 1; //PP7 high
  	
  	OCIFP_OCIFP7=1; //Clear over-current interrupt flag
  	//OCIEP_OCIEP7=0; //Over-current interrupt disable
  	OCIEP_OCIEP7=1; //Over-current interrupt enable
  	
  	OCPEP_OCPEP7=1; //Over current detector enable on PP7	
  
  	/*An asserted flag immediately forces the related EVDD1 pin low to protect the device.
  	The flag must be cleared to re-enable the driver.*/
  	
  for(;;) {
    __RESET_WATCHDOG();	/* feeds the dog */
    
  } /* loop forever */
  /* please make sure that you never leave main */

}

//Timer Overflow Interrupt Function 
void interrupt VectorNumber_Vevdd1ppx EVDD_OCP(){
	
	//change LED state
	PTP_PTP1 ^= 1;
	PTT_PTT5 ^= 1;
}
