************************************************************************											    
* MCF5307 COLDFIRE Assembly Header, Sample Initialization File        
* and Test Code 								
*
* Developed by: John Cunningham
*               June 1997  
*
* Modified by:  Michael Norman
* Date:         June, 17 1998
* Revision:     6/17/98
*
* Motorola
* Imaging and Storage Systems Division 
* Austin, TX 								
***********************************************************************
*
* This file contains the following information to aid designers        
* using the MCF5307: 								     
*
* 1) Assembly header listing (i.e. EQUATES memory map)                  
* 2) Module initialization code (SIM, UART, TIMER etc.) 
* 3) Sample test code for TIMER, UART and DMA
* 4) Batch file for assembling with DIAB DATA assembler 
* 5) Initialization file for use on the MCF5307 development system 
* 6) DIAB DATA linker file
***********************************************************************

****************
* Introduction *
***********************************************************************
*
* This file provides examples on initializing and configuring 
* the various modules on the COLDFIRE 5307 processor. 
* An explanation of how the module is configured is shown prior to 
* the actual code. It is best viewed using WORDPAD by Microsoft. 
*
* This code is written as if it were for a specific 
* design. The specifications for that design are: 
*
* 1)Code space less than 16 meg (only address lines 0:23 used) 
* 2)SDRAM is used, size is 8 Meg, one bank utilized 
* 3)Upper addresses used for chip selects 
* 4)Both UARTS are used  
* 5)MBUS port (I2C) is used, (interrupts disabled) 
* 5)Parallel port is used 
* 6)Timers are used (interrupts disabled) 
* 8)SRAM is used. Stack pointer is set to the top of the SRAM 
* 9)Cache disabled
***********************************************************************

***********************************************************************
* IMPORTANT:
*
* The SBC5307 development system uses a different memory mapping when 
* compared to this initialization example code. The evaluation board
* boots out of FLASH and sets its code space to run out of SDRAM. All 
* lines that have been commented out are to enable this code to work
* on the SBC5307 development system
*
* ALSO: Make sure to use at least a 1 amp power supply with the 
* development system. A 800ma wall-pack power supply has been 
* known not to have enough current when running UARTs. 
*
***********************************************************************
* The 5307 development system sets these registers to the following 
* values:
* RAMBAR $00800000
* MBAR   $10000000
* CACR   $00000000
* ACR0   $00000000
* ACR1   $00000000
* VBR    $00000000
*
**********************************************************************
*
* This code has been tested on the SBC5307 eval system with the 
* SDRAM, CHIP SELECTS, and the PAR register commented out ";". 
*
* This code gives the designer an idea on how to 
* initialize and test the many modules and registers on the 5307. This 
* code can be used, as is, in an embedded application, where the 
* code for the SDRAM, CHIP SELECTS, and the PAR are configured as shown 
* in this example. The user just needs to uncomment the lines. 
*
* Unfortunately, this code has only been tested with the 5307 
* development system as it is written now. It is the responsibility 
* of the end user to verify that this example code works in their 
* design (i.e. with specific lines uncommented such as CACHE or SDRAM 
* initialization code). 
*
***********************************************************************

**************
* Memory map *
***********************************************************************
* The memory map for this example is set up as follows. This is to
* provide the designer with an idea of how to set up a board (i.e. 
* microcontroller + memory configuration). Remember, this 
* map differs if using the SBC5307 development system. 
*
* $00000000 ------------------------- 
*           -  usable code space    - 
*           -                       -
*           -                       -
* $000F0000 ------------------------- 
*           -                       -
*           -                       -
* $00700000 -------------------------  
*           -  SDRAM space (8 meg)  -
*           -                       -
* $00EFFFFF ------------------------- 
*           -                       -
*           -                       -
* $00F00000 ------------------------- 
*           -  unused               - 
*           -                       -
*           -                       -
* $20000000 ------------------------- 
*           -  SRAM space           -
*           -  (4096 bytes)         -
*           -                       -
* $20000FFF ------------------------- 
* $20001000 ------------------------- 
*           -  unused               - 
*           -                       -
*           -                       -
* $FFEFFFFF ------------------------- 
* $FFF003FD ------------------------- 
*           -  unused               -  
*           -                       -
* $FFFF0200 ------------------------- 
*           -  unused               - 
*           -                       -
* $FFFFF000 ------------------------- 
*           -  Module base          -
*           -                       -
*           -                       -
* $FFFFF3FF ------------------------- 
*
**********************************************************************

*************************************
* DIAB DATA Version 4.1a batch file *
***********************************************************************
* The following lines are the lines used to compile this code. This 
* batch file assumes the following: 
* 1) The DIAB DATA compiler is located on the C drive 
* 2) The assembly file is named 5307jm.s and is located in the 
* directory c:\5307\test 
*
* Create a directory "C:\5307\test. Create a file called 5307.bat  
* with the 3 command lines listed below and copy it into the 
* C:\5307\test directory. Make sure to remove the "*" comments. 
* NOTE: Although not shown below, the entire command string needs
*       to be on one line.  If it is not shown below, it is due to 
*       word wrapping by the text editor.
*
* REM "Line 1 - Assemble"  
* c:\diab\4.1a\win32\bin\das -Xasm-debug-on -l -o c:\test\5307jm.o -tMCF5307FS c:\test\5307jm.s 
*  
* REM "Line 2 - Link & Convert to S-Record""
* c:\diab\4.1a\win32\bin\dld -m2 -o c:\test\5307jm.elf c:\test\5307jm.o -lc ace_diab.lnk > 5307.map
***********************************************************************

***********************
* DIAB DATA link file *
***********************************************************************
*
* In addition to the batch file and the assembly file, DIAB DATA uses 
* a link file. For this design, copy the lines listed below into the 
* C:\5307\test directory and name the file "Ace_diab.lnk". 
* For syntax information, refer to the Diab Data manual.
***********************************************************************
*
* MEMORY
* {
* ram : org = 0x10000,len = 0x100000
* }
*
* SECTIONS
* {
* .text: {} >ram
* .data: {} >ram
* .bss: {} >ram
* }
*
* __HEAP_START = ADDR(.bss)+SIZEOF(.bss);
* __SP_INIT = ADDR(ram)+SIZEOF(ram);
* STKTOP = __SP_INIT;
* __HEAP_END = __SP_INIT-0x800;
* __SP_END = __HEAP_END;
* __DATA_ROM = ADDR(.text)+SIZEOF(.text);
* __DATA_RAM = ADDR(.data);
* __DATA_END = ADDR(.data)+SIZEOF(.data);
* __BSS_START = ADDR(.bss);
* __BSS_END = ADDR(.bss)+SIZEOF(.bss);
* ___HEAP_START = __HEAP_START;
* ___SP_INIT = __SP_INIT;
* ___HEAP_END = __HEAP_END;
* ___SP_END = __SP_END;
* ___DATA_ROM = __DATA_ROM;
* ___DATA_RAM = __DATA_RAM;
* ___DATA_END = __DATA_END;
* ___BSS_START = __BSS_START;
* ___BSS_END = __BSS_END;
*
***********************************************************************

*              ****************************
*              * CPU Registers Memory Map *
*              * (Begin EQUATES section)  *
*              ****************************

*******************
* EQUATES SECTION *
************************************************************************
* The MBAR (Module Base Address Register)defines the base address 
* of all internal peripheral registers. It is accessed in the CPU 
* space via the MOVEC instruction. See COLDFIRE 5307 User manual, 
* pg 8-2. An example on setting the MBAR to location $10000000 
* would be:
*
* move.l   #$10000000,D0 
* movec    D0,MBAR 
*
*
* The assembler/compiler knows to store it in the system control 
* register MBAR and "MBAR" does not have to be defined in an EQU 
* statement Make sure you type "MBAR" (Not case sensitive). 
*
* All the other registers are offsets of the MBAR. I created a variable
* called MBARx and used an "EQU" statement to define its value. Make 
* sure to give the MBARx value the same value you stored in the MBAR. 
* Example
*
* MBARx EQU $10000000
*
* The MBARx value was defined to provide valid addresses for the 
* rest of the memory map. 
***********************************************************************

***********************************************************************
*
* The MBARx value that is commented out below is for this memory-
* mapped design example. 
* It is commented out to enable this code to run on the 
* SBC5307 development system. If you are using this code example 
* without the development system, comment out the line that sets 
* MBARx to $10000000 and uncomment the line that sets it to $FFFFF000. 
*
* The VBR is also commented out for the same reason as the MBARx value. 
* To properly set the VBR, it should be stored in external or 
* internal memory (usually in a table style format).
*
* I suggest using the first $3FF of your RAM for the 
* vector table. Therefore, to use this code for this design example 
* comment the line that sets VBRx to $00000000 and use the line that 
* sets it to $00700000 which is the beginning of SDRAM. 
*
***********************************************************************



***********************************************************************
* NOTE: CPU registers must be accessed through a MOVEC instruction 
* Registers that use the "MOVEC" command are: 
* 1)MBAR 2)VBR 3)CACR 4)ACR0 5)ACR1 6)RAMBAR
*
* The assembler/compiler recognizes the above listed names and 
* do not have to be defined in an EQU statement. The example 
* below will store the correct value in MBAR. This is also true 
* for VBR, CACR, ACR0, ACR1, RAMBAR
***********************************************************************
*
* Example:
*
* move.l  #value,D0  ;Load data register with value 
* movec   D0,MBAR    ;Place value into CPU register 
**********************************************************************

;MBARx EQU $FFFFF000 ;Module Base Address value
                     ;($FFFFF000 - $FFFFF1F0)(496 bytes)
MBARx EQU $10000000  ;Module Base Address value
                     ;($10000000 - $100001F0)(496 bytes)
***********************************************************************
* The 5307 development system comes with 8 Meg of SDRAM where it 
* executes its program code.
* The 5307 development system begins executing code at 
* address $00020000 and sets the VBR at location $00000000. The entire
* vector table uses 1024 bytes (Interrupts 0-255, 4 bytes each).
*
* This example initialization sets the SDRAM0 bank at $00700000. 
***********************************************************************

VBRx    EQU $00000000     ;Vector Base Address ($000-3FC) 1020 bytes. 
;RAMBARx EQU $20000000 ;SRAM Base Address (4096 bytes)
                       ;and address masks (pg 6-2,3)
RAMBARx EQU $00800000  ;SRAM Base Address for use with 5307 eval. board
SDRAM0x EQU $0070      ;base address of SDRAM0, $00700000

*****************************
* System Integration Module *
***********************************************************************

*************************
* Reset Status Register *
*************************

RSR    EQU MBARx+$0000   ;Reset Status Register, 8-bit, R/W

**************************
* Software Watchdog EQUs *
**************************

SYPCR  EQU MBARx+$0001 ;System Protection Control Register, 8-bit, R/W
SWIVR  EQU MBARx+$0002 ;Software Watchdog Int. Vector Register, 8-bit, W
SWSR   EQU MBARx+$0003 ;Software Watchdog Service Register, 8-bit, W

***********
* PAR EQU *
***********

PAR    EQU MBARx+$0004 ;Pin Assignment Register, 16-bit, R/W

*************
* PLLCR EQU *
*************

PLLCR  EQU MBARx+$0005 ;PLL Control Register, 8-bit, R/W

******************
* Interrupt EQUs *
******************

IRQPAR EQU MBARx+$0006 ;Inerrupt Assignment Register, 8-bit, R/W
IPR    EQU MBARx+$0040 ;Interrupt Pending Register, 32-bit, R
IMR    EQU MBARx+$0044 ;Interrupt Mask Register, 32-bit, R/W
AVCR   EQU MBARx+$0051 ;Autovector Control Register, 8-bit, R/W
ICR0   EQU MBARx+$004C ;Interrupt Control Register SWT, 8-bit, R/W
ICR1   EQU MBARx+$004D ;Interrupt Control Register TIMER1, 8-bit, R/W
ICR2   EQU MBARx+$004E ;Interrupt Control Register TIMER2, 8-bit, R/W
ICR3   EQU MBARx+$004F ;Interrupt Control Register MBUS, 8-bit, R/W
ICR4   EQU MBARx+$0050 ;Interrupt Control Register UART1, 8-bit, R/W
ICR5   EQU MBARx+$0051 ;Interrupt Control Register UART2, 8-bit, R/W
ICR6   EQU MBARx+$0052 ;Interrupt Control Register DMA0, 8-bit, R/W
ICR7   EQU MBARx+$0053 ;Interrupt Control Register DMA1, 8-bit, R/W
ICR8   EQU MBARx+$0054 ;Interrupt Control Register DMA2, 8-bit, R/W
ICR9   EQU MBARx+$0055 ;Interrupt Control Register DMA3, 8-bit, R/W
ICR10  EQU MBARx+$0056 ;Interrupt Control Register RESERVED
ICR11  EQU MBARx+$0057 ;Interrupt Control Register RESERVED

*****************************
* DRAM Controller Registers *
*******************************************************************
* This section defines the DRAM controller, See pg 11-6 of the 
* 5307 users manual 
*******************************************************************
DCR   EQU MBARx+$0100 ;DRAM Control Register, 16-bit, R/W
DACR0 EQU MBARx+$0108 ;DRAM Bank 0 Address/Control Register, 32-bit, R/W
DCMR0 EQU MBARx+$010C ;DRAM Bank 0 Mask Register, 32-bit, R/W
DCAR1 EQU MBARx+$0110 ;DRAM Bank 1 Address/Control Register, 32-bit, R/W
DCMR1 EQU MBARx+$0114 ;DRAM Bank 1 Mask Register, 32-bit, R/W

*************************
* Chip Select Registers *
*******************************************************************
* This section defines Chip Selects for the 5307 Processor 
* The information for this section can be found in Section 9 of the 
* Users manual. 
*******************************************************************
CSAR0 EQU MBARx+$0080 ;Chip-Select 0 Base Address Register, 16-bit, R/W
CSMR0 EQU MBARx+$0084 ;Chip-Select 0 Mask Register, 32-bit, R/W
CSCR0 EQU MBARx+$008A ;Chip-Select 0 Control Register, 16-bit, R/W
CSAR1 EQU MBARx+$008C ;Chip-Select 1 Base Address Register, 16-bit, R/W
CSMR1 EQU MBARx+$0090 ;Chip-Select 1 Mask Register, 32-bit, R/W
CSCR1 EQU MBARx+$0096 ;Chip-Select 1 Control Register, 16-bit, R/W
CSBAR EQU MBARx+$0098 ;Chip-Select 2-7 Base Address Register, 8-bit, R/W
CSMR2 EQU MBARx+$009C ;Chip-Select 2 Mask Register, 16-bit, R/W
CSCR2 EQU MBARx+$00A2 ;Chip-Select 2 Control Register, 16-bit, R/W
CSMR3 EQU MBARx+$00AA ;Chip-Select 3 Mask Register, 16-bit, R/W
CSCR3 EQU MBARx+$00AE ;Chip-Select 3 Control Register, 16-bit, R/W
CSMR4 EQU MBARx+$00B6 ;Chip-Select 4 Mask Register, 16-bit, R/W
CSCR4 EQU MBARx+$00BA ;Chip-Select 4 Control Register, 16-bit, R/W
CSMR5 EQU MBARx+$00C2 ;Chip-Select 5 Mask Register, 16-bit, R/W
CSCR5 EQU MBARx+$00C6 ;Chip-Select 5 Control Register, 16-bit, R/W
CSMR6 EQU MBARx+$00CE ;Chip-Select 6 Mask Register, 16-bit, R/W
CSCR6 EQU MBARx+$00D2 ;Chip-Select 6 Control Register, 16-bit, R/W
CSMR7 EQU MBARx+$00DA ;Chip-Select 7 Mask Register, 16-bit, R/W
CSCR7 EQU MBARx+$00DE ;Chip-Select 7 Control Register, 16-bit, R/W

*******************
* Timer Registers *
*******************

***********
* Timer 1 *
***********
TMR1 EQU MBARx+$0140 ;TIMER1 Mode Register, 16-bit, R/W
TRR1 EQU MBARx+$0144 ;TIMER1 TIMER1 Mode Register, 16-bit, R/W
TCR1 EQU MBARx+$0148 ;TIMER1 Capture Register, 16-bit, R
TCN1 EQU MBARx+$014C ;TIMER1 Counter, 16-bit, R/W
TER1 EQU MBARx+$0151 ;TIMER1 Event Register, 8-bit, R/W
***********
* Timer 2 *
***********
TMR2 EQU MBARx+$0180 ;TIMER2 Mode Register, 16-bit, R/W
TRR2 EQU MBARx+$0184 ;TIMER2 Mode Register, 16-bit, R/W
TCR2 EQU MBARx+$0188 ;TIMER2 Capture Register, 16-bit, R
TCN2 EQU MBARx+$018C ;TIMER2 Counter, 16-bit, R/W
TER2 EQU MBARx+$0191 ;TIMER2 Event Register, 8-bit, R/W

************************
* DMA Module Registers *
************************
SAR0  EQU MBARx+0x300 ;Source Address Register 0, 32-bit, R/W
DAR0  EQU MBARx+0x304 ;Destination Address Register 0, 32-bit, R/W
DCR0  EQU MBARx+0x308 ;DMA Control Register 0, 16-bit, R/W
BCR0  EQU MBARx+0x30C ;Byte Count Register 0, 16-bit, R/W
DSR0  EQU MBARx+0x310 ;DMA Status Register 0, 8-bit, R/W
DIVR0 EQU MBARx+0x314 ;DMA Interrupt Vector Register 0, 8-bit, R/W

*************************
* UART Module Registers *
*******************************************************************
* The MCF5307 contains 2 universal asynchronous/synchronous 
* receiver/transmitters (UARTS) that act independently. See 
* pg 14-1 of the users manual. Note that some registers are 
* defined with the same address location, such as USR & USCR. 
* because one register is valid if READ and the other is 
* valid when WRITE. See pg 14-18, table 14-1 for details in the 
* 5307 user's manual. 
******************************************************************
*********
* UART1 *
*********
UMR11  EQU MBARx+$01C0 ;UART1 UMR1 Mode Register, 8-bit, R/W
UMR21  EQU MBARx+$01C0 ;UART1 UMR2 Mode Register, 8-bit, R/W
USR1   EQU MBARx+$01C4 ;UART1 Status Register, 8-bit, R
UCSR1  EQU MBARx+$01C4 ;UART1 Clock Select Register, 8-bit, W
UCR1   EQU MBARx+$01C8 ;UART1 Command Register, 8-bit, W
URB1   EQU MBARx+$01CC ;UART1 Receiver Buffer, 8-bit, R
UTB1   EQU MBARx+$01CC ;UART1 Transmitter Buffer, 8-bit, W
UIPCR1 EQU MBARx+$01D0 ;UART1 Input Port Change Register, 8-bit, R
UACR1  EQU MBARx+$01D0 ;UART1 Auxiliary Control Register, 8-bit, W
UISR1  EQU MBARx+$01D4 ;UART1 Interrupt Status Register, 8-bit, R
UIMR1  EQU MBARx+$01D4 ;UART1 Interrupt Mask Register, 8-bit, W
UBG11  EQU MBARx+$01D8 ;UART1 Baud Rate Generator PreScale MSB, 8-bit, W
UBG21  EQU MBARx+$01DC ;UART1 Baud Rate Generator PreScale LSB, 8-bit, W
UIVR1  EQU MBARx+$01F0 ;UART1 Interrupt Vector Register, 8-bit, R/W
UIP1   EQU MBARx+$01F4 ;UART1 Input Port Register, 8-bit, R
UOP11  EQU MBARx+$01F8 ;UART1 Output Port Bit Set Command, 8-bit, W
UOP01  EQU MBARx+$01FC ;UART1 Output Port Bit Reset Command, 8-bit, W
*********
* UART2 *
*********
UMR12  EQU MBARx+$0200 ;UART2 UMR1 Mode Register, 8-bit, R/W
UMR22  EQU MBARx+$0200 ;UART2 UMR1 Mode Register, 8-bit, R/W
USR2   EQU MBARx+$0204 ;UART2 Status Register, 8-bit, R
UCSR2  EQU MBARx+$0204 ;UART2 Clock Select Register, 8-bit, W
UCR2   EQU MBARx+$0208 ;UART2 Command Register, 8-bit, W
URB2   EQU MBARx+$020C ;UART2 Receiver Buffer, 8-bit, R
UTB2   EQU MBARx+$020C ;UART2 Transmitter Buffer, 8-bit, W
UIPCR2 EQU MBARx+$0210 ;UART2 Input Port Change Register, 8-bit, R
UACR2  EQU MBARx+$0210 ;UART2 Auxiliary Control Register, 8-bit, W
UISR2  EQU MBARx+$0214 ;UART2 Interrupt Status Register, 8-bit, R
UIMR2  EQU MBARx+$0214 ;UART2 Interrupt Mask Register, 8-bit, W
UBG12  EQU MBARx+$0218 ;UART1 Baud Rate Generator PreScale MSB, 8-bit, W
UBG22  EQU MBARx+$021C ;UART2 Baud Rate Generator PreScale LSB, 8-bit, W
UIVR2  EQU MBARx+$0230 ;UART2 Interrupt Vector Register, 8-bit, R/W
UIP2   EQU MBARx+$0234 ;UART2 Input Port Register, 8-bit, R
UOP12  EQU MBARx+$0238 ;UART2 Output Port Bit Set Command, 8-bit, W
UOP02  EQU MBARx+$023C ;UART2 Output Port Bit Reset Command, 8-bit, W

***********************
* General Purpose I/O *
*******************************************************************
* These registers define the 16-bit port. The 16-bit port is muxed 
* with the upper address lines A[31:24], TIP', DREQ'[1:0], TM[2:0],
* and TT[1:0]. The PAR defines what function these pins have 
* (i.e Debug or parallel port). See pg 10-1,5 to set up the PAR 
* Register, port direction and logic level. 
******************************************************************
PADDR  EQU MBARx+$0244 ;Port A Data Direction Register, 16-bit, R/W
PADAT  EQU MBARx+$0248 ;Port A Data Register, 16-bit, R/W

*******************
* M-BUS Registers *
*******************************************************************
* The M-bus is a high speed, 2 wire, serial bus that provides
* bidirectional serial transmission between on-board devices 
* The bus is compatible with the Phillips I2C standard. See pg 
* 15-1 of the 5307 user's manual 
******************************************************************
MADR   EQU MBARx+$0280 ;M-BUS Address Register, 8-bit, R/W
MFDR   EQU MBARx+$0284 ;M-BUS Frequency Divider Register, 8-bit, R/W
MBCR   EQU MBARx+$0288 ;M-BUS Control Register, 8-bit, R/W
MBSR   EQU MBARx+$028C ;M-BUS Status Register, 8-bit, R/W
MBDR   EQU MBARx+$0290 ;M-BUS Data I/O Register, 8-bit, R/W

*              ****************************
*              * CPU Registers Memory Map *
*              * (End EQUATES section)    *
*              ****************************

********************************************************************

*************************
* Interrupt vector table*
********************************************************************
* This table defines where the program will go when an interrupt 
* occurs. Since these values are loaded as an offset of the VBR, 
* the label header "VBRx" is used to define the location. This 
* was created in the EQU section. If you change the value of the 
* VBR make sure it is the same value as the VBRx in the EQU 
* section 
* 
* For example, in the UART1 configuration (later in this code example,
* I defined the UIVR1 interrupt register to have an interrupt vector of * 64 ($100 hex) 

* If the interrupt for UART1 was enabled and an interrupt occured,
* the processor would load the program counter with the value 
* found at interrupt vector number 64. Since I loaded that place 
* with "UART1_INT", the program will jump to the label UART1_INT. 
* 
* Although there are 64-255 possible "user defined interrupt 
* vectors", I only listed 64-100 below. Also, for those I have 
* not set up, I left them set to $FFFFFFFF. The end user of this 
* code should insert the proper value for these interrupt vectors 
* 
* The vector table shown interrupt vectors 0-100 where
* interrupts 0-63 are processor defined and 64-100 are
* user defined.
*******************************************************************
V_TABLE:
     DC.L $FFFFFFFF  ;0  (Initial stack Pointer) 
     DC.L $FFFFFFFF  ;1  (Initial program counter)
     DC.L $FFFFFFFF  ;2  (Access Error)
     DC.L $FFFFFFFF  ;3  (Address error)
     DC.L $FFFFFFFF  ;4  (Illegal Instruction)
     DC.L $FFFFFFFF  ;5  (reserved)
     DC.L $FFFFFFFF  ;6  (reserved)
     DC.L $FFFFFFFF  ;7  (reserved)
     DC.L $FFFFFFFF  ;8  (Privilege violation)
     DC.L $FFFFFFFF  ;9  (Trace)
     DC.L $FFFFFFFF  ;10 (Unimplemented line-a code)
     DC.L $FFFFFFFF  ;11 (Unimplemented line-f code)
     DC.L $FFFFFFFF  ;12 (Debug Interrupt)
     DC.L $FFFFFFFF  ;13 (reserved)
     DC.L $FFFFFFFF  ;14 (Format error)
     DC.L $FFFFFFFF  ;15 (Uninitialized interrupt)
     DC.L $FFFFFFFF  ;16 (reserved)
     DC.L $FFFFFFFF  ;17 (reserved)
     DC.L $FFFFFFFF  ;18 (reserved)
     DC.L $FFFFFFFF  ;19 (reserved)
     DC.L $FFFFFFFF  ;20 (reserved)
     DC.L $FFFFFFFF  ;21 (reserved)
     DC.L $FFFFFFFF  ;22 (reserved)
     DC.L $FFFFFFFF  ;23 (reserved)
     DC.L $FFFFFFFF  ;24 (Spurious interrupt)
     DC.L TIMER2_INT ;26 (Autovector 2)
     DC.L TIMER1_INT ;25 (Autovector 1)
     DC.L MBUS_INT   ;27 (Autovector 3)
     DC.L $FFFFFFFF  ;28 (Autovector 4)
     DC.L $FFFFFFFF  ;29 (Autovector 5)
     DC.L $FFFFFFFF  ;30 (Autovector 6)
     DC.L $FFFFFFFF  ;31 (Autovector 7)
     DC.L $FFFFFFFF  ;32 (Trap 0)
     DC.L $FFFFFFFF  ;33 (Trap 1)
     DC.L $FFFFFFFF  ;34 (Trap 2)
     DC.L $FFFFFFFF  ;35 (Trap 3)
     DC.L $FFFFFFFF  ;36 (Trap 4)
     DC.L $FFFFFFFF  ;37 (Trap 5)
     DC.L $FFFFFFFF  ;38 (Trap 6)
     DC.L $FFFFFFFF  ;39 (Trap 7)
     DC.L $FFFFFFFF  ;40 (Trap 8)
     DC.L $FFFFFFFF  ;41 (Trap 9)
     DC.L $FFFFFFFF  ;42 (Trap 10)
     DC.L $FFFFFFFF  ;43 (Trap 11)
     DC.L $FFFFFFFF  ;44 (Trap 12)
     DC.L $FFFFFFFF  ;45 (Trap 13)
     DC.L $FFFFFFFF  ;46 (Trap 14)
     DC.L $FFFFFFFF  ;47 (Trap 15)
     DC.L $FFFFFFFF  ;48 (reserved)
     DC.L $FFFFFFFF  ;49 (reserved)
     DC.L $FFFFFFFF  ;50 (reserved)
     DC.L $FFFFFFFF  ;51 (reserved)
     DC.L $FFFFFFFF  ;52 (reserved)
     DC.L $FFFFFFFF  ;53 (reserved)
     DC.L $FFFFFFFF  ;54 (reserved)
     DC.L $FFFFFFFF  ;55 (reserved)
     DC.L $FFFFFFFF  ;56 (reserved)
     DC.L $FFFFFFFF  ;57 (reserved)
     DC.L $FFFFFFFF  ;58 (reserved)
     DC.L $FFFFFFFF  ;59 (reserved)
     DC.L $FFFFFFFF  ;60 (reserved)
     DC.L $FFFFFFFF  ;61 (reserved)
     DC.L $FFFFFFFF  ;62 (reserved)
     DC.L $FFFFFFFF  ;63 (reserved)
     DC.L UART1_INT  ;64 (user defined interrupt)
     DC.L UART2_INT  ;65 (user defined interrupt)
     DC.L $FFFFFFFF  ;66 (user defined interrupt)
     DC.L $FFFFFFFF  ;68 (user defined interrupt)
     DC.L $FFFFFFFF  ;69 (user defined interrupt)
     DC.L WDOG_INT   ;70 (user defined interrupt)
     DC.L $FFFFFFFF  ;71 (user defined interrupt)
     DC.L $FFFFFFFF  ;72 (user defined interrupt)
     DC.L $FFFFFFFF  ;73 (user defined interrupt)
     DC.L $FFFFFFFF  ;74 (user defined interrupt)
     DC.L $FFFFFFFF  ;75 (user defined interrupt)
     DC.L $FFFFFFFF  ;76 (user defined interrupt)
     DC.L $FFFFFFFF  ;77 (user defined interrupt)
     DC.L $FFFFFFFF  ;78 (user defined interrupt)
     DC.L $FFFFFFFF  ;79 (user defined interrupt)
     DC.L $FFFFFFFF  ;80 (user defined interrupt)
     DC.L $FFFFFFFF  ;81 (user defined interrupt)
     DC.L $FFFFFFFF  ;82 (user defined interrupt)
     DC.L $FFFFFFFF  ;83 (user defined interrupt)
     DC.L $FFFFFFFF  ;84 (user defined interrupt)
     DC.L $FFFFFFFF  ;85 (user defined interrupt)
     DC.L $FFFFFFFF  ;86 (user defined interrupt)
     DC.L $FFFFFFFF  ;87 (user defined interrupt)
     DC.L $FFFFFFFF  ;88 (user defined interrupt)
     DC.L $FFFFFFFF  ;89 (user defined interrupt)
     DC.L $FFFFFFFF  ;90 (user defined interrupt)
     DC.L $FFFFFFFF  ;91 (user defined interrupt)
     DC.L $FFFFFFFF  ;92 (user defined interrupt)
     DC.L $FFFFFFFF  ;93 (user defined interrupt)
     DC.L $FFFFFFFF  ;94 (user defined interrupt)
     DC.L $FFFFFFFF  ;95 (user defined interrupt)
     DC.L $FFFFFFFF  ;96 (user defined interrupt)
     DC.L $FFFFFFFF  ;97 (user defined interrupt)
     DC.L $FFFFFFFF  ;98 (user defined interrupt)
     DC.L $FFFFFFFF  ;99 (user defined interrupt)
     DC.L $FFFFFFFF  ;100 (user defined interrupt)
 
*******************************************************************
* The  XDEF command is for the DIAB DATA compiler and it lets the 
* SDS source level debugger know where to begin running the code. 
* The  XDEF also shows the label when running the code in the SDS
* SingleStep Debugger versus only seeing the address locations.
*******************************************************************

  XDEF _main
_main

     move.w #$2000,D0     ;Reset SR. Interrupts
     move.w D0,SR         ;possible at levels 0-7

*******************************************************************
* The lines below are commented out for use on the SBC5307 
* development system. If you are using this example without 
* the use of the development system, uncomment them. (i.e remove 
* the ";" at the begnning of each line. 
*******************************************************************

*******************************************************************
* IMPORTANT: Changes if using the 5307 evaluation board. 
* 
* If you are not using this code on the 5307 development system, 
* uncomment the code listed below. It will overwrite the 
* Debuggers configurations for the MBR, VBR, DCAR0, & RAMBARx registers.
*
* Also, uncomment the RAMBARx EQU that sets the SRAM location
* to 0x20000000 in the above EQU section. 
* See pg 3-4 of the eval board SBC5307 User's manual, Rev 2.0 
* 
* The SDS Debugger uses a configuration file that 
* sets the below listed registers. This is used for
* the SBC5307 evaluation board. See pg 3-4 of the SBC5307 
* development system users manual 
*******************************************************************
* Register From        To 
* VBR =    $00000000 - $000003FF 
* MBAR =   $10000000 - $100003FF 
* RAMBAR = $00800000 - $00800FFF 
* DCAR0 =  $00000000 - $007FFFFF
*
*******************************************************************

****************************************
* Define base addresses of MBAR, & VBR *
*******************************************************************
* Initialize the base modules. The values were defined earlier in 
* the EQU section. The code below defines where each MBAR & VBR 
* are located in the memory map. 
*******************************************************************

;     move.l #MBARx,D0       ;define the init location of the Modules
;     movec  D0,MBAR         ;See pg. 8-3,4 of the users manual

*******************************************************************
* A vector table called V_TABLE is used to store the correct 
* values for the vector interrupts, see pg 3-7 of the 5307 user's 
* manual 
*******************************************************************

     move.l  #VBRx,D0       ;define the init location of the
     movec   D0,VBR         ;Vector Base register
 
     clr.l   D0
     lea.l   VBRx,A0        ;point A0 to the VBRx location
     lea.l   V_TABLE,A1

VT_INIT:
     move.l (A1)+,(A0)+     ;point A1 to the vector table
     addi.l  #1,D0
     cmp.l   #100,D0        ;D0 is just a counter to set up
     bne     VT_INIT        ;100 of 256 possible interrupts

********
* CH 5 *
*******************************************************************
* CACHE Initialization Section 5 (Users manual)                   *
*******************************************************************
* 
* The cache uses only 3 registers for configuration: CACR, ACR0, 
* & ACR1. The CACR register controls the operation of the cache. 
* The ACR0 & ACR1 registers define what memory space is cacheable.
* This is accomplished by setting the base and mask bits (pg 5-7 
* of the 5307 users manual). 
* The registers can be set up to define what memory space is 
* or is not cacheable (pg 5-8, bits 5 and 6, "CM"). 
*******************************************************************
*****************
* ACR registers *
*****************
*******************************************************************
* The ACR registers define what areas of memory are cacheable. 
* Bits 31:24 define the base address and bits 23:16 mask off the 
* address comparison bits. For example, to define a space in 
* memory, $01FFFFFF to $03FFFFFF, you would do the following: 
* 
* 31 30 29 28 27 26 25 24 
* ------------------------------ 
* Bits 31:24 0 0 0 0 0 0 0 1 (base address) 
* Bits 23:16 0 0 0 0 0 0 1 1 (mask) 
* 
* The above diagram show that the base address starts at $01xxxxxx
* and the mask ignores the lower 2 bits and only compares the 
* upper bits (31:26). Therefore, the cacheable memory goes up 
* to $03FFFFFF. 
* It is also possible to define the same memory space listed above
* as non-cacheable. This is accomplished by setting the "CM" bits 
* in the ACR registers. The users has a maximum of 2 ACR 
* registers to use. 
*******************************************************************
* The cache is set up as follows (see pg 5-2,3,4,5,6): 
* 1) Cache is enabled (bit 31) 
* 2) CPUSHL is enabled (bit 28) 
* 3) Cache freeze is in normal operation (bit 27) 
* 4) Cache is not invalidated (bit 24) 
* 5) Burst fetches on non cacheable disabled (bit 10) 
* 6) Default cache mode enabled (bit 9) 
* 7) Buffered writes enabled (bit 8) 
* 8) Both read and write capability (bit 5) 
* 9) line miss fetches (bits 1,0) 
*******************************************************************
;     move.l #91000323,D0  ;disable cache but set up other
;     movec D0,CACR        ;functions for demonstration
                           ;CACRx defined in EQU section
                           ;which is $80000321
;     move.l #$0103C020,D0 ;cached memory from $01000000
;     movec D0,ACR0        ;to $03FFFFFF. ignore modes,enable
                           ;ACR0, buffered writes and enable
                           ;both read and write.

********
* CH 6 *
*******************************************************************
* SRAM Initialization Section 6 (Users manual)                    *
*******************************************************************
* The SRAM is set up easily since it only has one register to 
* initialize, RAMBAR. The SRAM base register can be set up on 
* any 32K byte boundary (pg 6-2). The lower 8 bits define what 
* type of data can be used or accessed and bits 31..9 
* define the location of the base address. The value of RAMBARx 
* was defined earlier in the EQU statements section. 
* 
* The SRAM is configured, pg 6-2 of users manual, as follows: 
* 1)Base address is $20000000 (bits 31:9) 
* 2)Allow read and write capabilities (bit 8) 
* 3)CPU space, User, and Supervisor code capable (bits 5:1) 
* 4)Validate the SRAM space. After loading the SRAM with 
* valid data, enable this bit. This is a good design 
* practice to do when powering up or resetting the chip 
* (bit 0) 
*******************************************************************
;     move.l #RAMBARx+1,D0 ;define the init location of the
;     movec D0,RAMBAR      ;SRAM base register (pg 6-2,3)
                           ;RAMBARx value was defined in the EQU 
                           ;section as $20000000

******
*CH 8*
*******************************************************************
* SIM Initialization Section 8 (Users manual)                     *
*******************************************************************
* The MCF5307 SIM provides a centralized interrupt controller for 
* the following modules 
* 1)External interrupts 
* 2)Software Watchdog Timer 
* 3)Timer Modules 
* 4)MBUS (I2C) module 
* 5)UART modules 
* 6)DMA Channels

*******************************
* Interrupt Control Registers *
*******************************************************************
* Written below is the code that will set up the interrupts 
* for the 5307. The interrupt levels and priorities were chosen 
* at random for demonstrative purposes. The end user should 
* define the interrupt level and priorities for their own 
* applications 
* The lines that are commented for the SIM are commented out to 
* enable this code to function on the SBC5307 development system 
*******************************************************************
*******************************************************************
* NOTE: Interrupt values were chosen randomly for demonstrative 
* purposes. The end user should change these for their own 
* application needs. 
*******************************************************************
     move.b #%10000100,D0  ;set up Timer 1 Interrupt
     move.b D0,ICR1        ;Level 1 interrupt, Priority 0,
                           ;Autovector=ON, see pg 8-5,6,7
                           ;Vector Number = 24 + IL = 25
     move.b #%10001001,D0  ;set up Timer 2 Interrupt
     move.b D0,ICR2        ;Level 2 interrupt, Priority 1,
                           ;Autovector=ON
                           ;Vector Number = 24 + IL = 26
     move.b #%10001110,D0  ;set up MBUS Interrupt
     move.b D0,ICR3        ;Level 3 interrupt, Priority 2,
                           ;Autovector=On,
                           ;Vector Number = 24 + IL = 27
     move.b #%00011011,D0  ;set up UART1 Interrupt
     move.b D0,ICR4        ;Level 6 interrupt, Priority 3,
                           ;Autovector=Off
     move.b #%00001001,D0  ;set up UART2 Interrupt
     move.b D0,ICR5        ;Level 1 interrupt, Priority 1,
                           ;Autovector=Off
 
**************************
* IMR register, pg 8-8,9 *
**************************
*******************************************************************
* No external interrupts enabled. UART1, UART2 interrupts are 
* disabled. MBUS, TIMER2 and TIMER2 have interrupts disabled 
* (i.e masked. See pg 8-8 of the users manual). The SIM 
* initialized the UART's for interrupt vectors and the 
* TIMERS, M-BUS  for autovector. Enable the interrupts for each 
* individual module in the IMR register if you want them enabled. 
* 
* A logic "0" enables the corresponding interrupt and a logic "1" 
* masks the interrupt. Bits 16:1 are used. 
* 
* Note: How each module interrupts the processor is defined in 
* each module's configuration. 
*******************************************************************
     move.l #$0003FFFE,D0  ;set up the IMR (interrupt mask
                           ;register) for no interrupts
     move.l D0,IMR         ;see pg 8-12,13 of the users manual

*******************************
* Autovector Control Register *
*******************************
*******************************************************************
* This 8-bit register determines whether the external interrupts
* are autovectored.  See pg 8-7,8.  Since no external interrupts 
* are enabled (IMR bits 7:1), none of the external interrupts 
* will be autovectored.
*******************************************************************
     move.w #$00,D0        ;set up the AVCR so that no external
     move.w D0,AVCR        ;interrupts are autovectored, do not 
                           ;block address strobe 

******************
* Watchdog timer *
******************
     move.b #$00,D0        ;Disable "Watchdog" and bus monitor
     move.b D0,SYPCR       ;see pg 8-12 of the users manual
     move.b #70,D0         ;Watchdog interrupt vector # 70
     move.b D0,SWIVR       ;the processor knows vector 70 is
                           ;vector offset $118
                           ;see pg 8-13 of the users manual
                           ;$70 is a random choice

************************
* PLL Control Register *
************************
*******************************************************************
* This 8-bit register is used to enable/disable the STOP instruction
* acknowledgment and to set the interrupt level that will awaken
* the processor from a STOP.  See pg. 8-14,15.
*******************************************************************
     move.b #$80,D0        ;enable STOP instruction to be acknowledged
     move.b D0,PLLCR       ;any interrupt will awaken core

********
* CH 9 *
******************************************************************
* CHIP SELECT Initialization Section 9 (Users manual)            *
******************************************************************
* The chip select is set up to control the external memory and 
* the DRAM. In this example, the chip select is set up for a 
* single external FLASH device, 29F040. It has 20 address lines 
* and an 8 bit data input/output. If code size becomes larger than  
* the FLASH device, a larger device can be used. Remember that 
* the MCF5307 address lines A31:24 are muxed with the parallel  
* port.  If your code exceeds 16 meg (i.e. 24 bits wide), you will  
* need to alter you PAR register for correct PP/Address logic.  
* This is shown on pg 8-19 in the PAR pin assignments table 
*******************************************************************
* Chip select 0 (CS0) will be set up as the /CS to the 29F040. 
* The entire address space (20 address lines) will be dedicated 
* to the FLASH. Any additional peripherals that are added should 
* use the other chip selects and be defined somewhere above the 
* memory map of the FLASH user code (i.e. address lines 20 and up)
*******************************************************************
* Chip select 1 is set up for addresses $001F0000 to $001FFFFF 
* (65K space). This can be used for an external peripheral. It
* is configured for user data (UD). 
*******************************************************************
*******************************************************************
* NOTE: These lines have been commented out for use on the SBC5307 
* development board. 
*******************************************************************
****************
*Chip select 0 *
****************
;     move.w #$0000,D0    ;set base address for Chip Select 0
;     move.w D0,CSAR0     ;to $00000000.
                          ;see pg 9-9 of the users manual
*****************
*CSMR0 register *
*******************************************************************
* This register defines the address mask and what types of 
* accesses to the defined memory space are enabled. The CSAR 
* register defined the base address. In this example that was 
* $00000000. To define a space from $00000000 to $000FFFFF, the 
* CSMR register needs to mask off the lower 20 bits. A logic "1" 
* means: do not use this bit in the comparison. The table below 
* shows that once an address call to bit 20 of higher occurs, it 
* will fall outside the range of Chips Select 0. 
* 
*  Bits      31 30 29 28 27 26 25 24 23 22 21 20 19 18 17 16 
* ----------------------------------------------------------
* (CSARx)     0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0 
* (CSMR0 reg) 0  0  0  0  0  0  0  0  0  0  0  0  1  1  1  1 
* 
* The above table shows that an access to bit 20 or higher is 
* not defined for chip select 0. See pg 9-10,11 for details. 
*******************************************************************
* Note:  CSMR0 and CSMR1 determine the address mask and definition 
* of which types of accesses are allowed for CS[0:1].  However,
* for CS[2:7] the Chip Select Base Address Register, CSBAR, defines
* the base address location of memory dedicated to these signals.
* For CS[2:7], only the upper 8 bits are implemented allowing for 
* memory block sizes of 2M for each chip-select.  See pgs 9-9,10
* and table 9-6.
*******************************************************************
;     move.l #$000F0000,D0 ;set the mask register for CS0
;     move.l D0,CSMR0      ;0-19 (i.e. $00000000 to $000FFFFF).
                           ;All access types (SC,SD,UC,UD
                           ;C/I) valid. see pg 9-10,11
                           ;of the users manual

******************
* CSCR0 register *
*******************************************************************
* CSCR0 chip select control register is defined as follows (see 
* pg 9-13,14 in the users manual): 
* 1)longest # of wait states until /TA is asserted (bits 13-10)
* 2)burst read enabled (bit 4) 
* 3)port size for data is 8 bits (bits 7,6) 
* 4)auto-acknowledge enable (bit 8)
*******************************************************************
;     move.w #$3D50,D0     ;set up the chip select
;     move.w D0,CSCR0      ;control register

*****************
* Chip select 1 *
*****************
;     move.w #$0010,D0     ;set base address for Chip Select 1
;     move.w D0,CSAR1      ;to $00100000.
                           ;see pg 9-10,11 of the users manual
;     move.l #$000F001C,D0 ;set the mask register for addresses
;     move.l D0,CSMR1      ;$00100000 to $001FFFFF (65K space)
                           ;Only valid access is UD (user data)
                           ;See pg 9-11,12 of the users manual
*********
* CH 10 *
*******************************************************************
* Parallel Port Initialization Section 10 (Users manual)          *
*******************************************************************
* The following 2 lines set up the PAR register. See pg 8-19, 
* table 8-12, and pg 10-1. In this example the register has been  
* set up to enable the pins as parallel port signals. 
*******************************************************************
     move.w #00,D0          ;set up PAR (Pin Assignment Register.)
     move.b D0,PAR        

*****************************************************************
* The 5307 has one 16 bit parallel port for general I/O. The pins 
* are muxed with the upper address lines A[31:24], /TIP, /DREQ[1:0], 
* TM[2:0], and TT[1:0]. The PAR defines what function these pins  
* have.  The port is set up as follows: 
* 
* 1) Bit 15 is configured as an input 
* 2) Bits 14:0 are configured as outputs. All outputs are 
*    set to logic "1" 
* For proper operation, the PAR needs to be initialized to logic "0" 
*******************************************************************
     move.w #$7FFF,D0       ;Bit 15 is an input, bits 6:0 outputs
     move.w D0,PADDR        ;see pg 10-3 of the users manual
     move.w #$7FFF,D0       ;Initialize the Parallel port Data reg.
     move.w D0,PADAT        ;outputs to logic "1".
                            ;see pg 10-4 of the users manual

*********
* CH 11 *
*******************************************************************
* DRAM Initialization Section 10 (Users manual)                   *
*******************************************************************
* The DRAM controller is glueless and can be set up as: 
* 1) Synchronous or Asynchronous DRAMs
* 2) 2 banks, widths of 8-, 16-, and 32-bits 
* 3) Up to 256M byte sizes 
* 4) Normal, fast page, and burst mode. Also supports EDO 
* 5) Programmable refresh rates 
* 
* This example initializes the controller for synchronous mode
* operation.  In this mode, signals, registers, and timing differ
* greatly from the asynchrounous mode.  The mode is selected by
* setting bit 7, SO, of the DRAM Control Register, DCR (see pg
* 11-23).  Each bank is individually programmable except for the  
* DRAM Control Register, DCR. This register applys to both 
* banks. The registers initialized in this example are: 
* 1) DCR - programmable options for refresh logic
* 2) DACR0 - base address compare value and control bits
* 3) DMR0 - contains bits to mask off the compare function for
*           addresses
*******************************************************************
******************
* DACR0 register *
* ****************
* This register is used to set the base address of DRAM memory.
* This example initializes the DRAM at address $00700000. This 
* was defined earlier in the EQU section with the variable 
* DRAM0x. The size of the DRAM is initialized by the DCMR 
* register.  
* The DACR0 also defines the several control and refresh 
* configurations.  See pgs 11-26,27.
*******************************************************************
*****************
* DCMR Register *
*******************************************************************
* The following table defines typical values for common 
* DRAM configurations. Load the values into the DCMR 
* register for each size. The following table assumes 
* the transfer types (user, supervisor, write protect, CPU/IACK,
* alternate master), bits 6:1 are left at logic "0". 
* Bits 9-17 of this register is not used, therefore, a 1 meg or  
* larger DRAM will always have a hex "C" in the fifth position. 
* For example, a 1 meg DRAM will have a base address and a size 
* from $0 to $FFFFF. A 4 meg will have a size from $0 to 3FFFFF. 
* See pg 11-11 of the 5307 users manual. 
* 
* DRAM SIZE  DCMR value 
*    512K    $00040000 
*   1 MEG    $000C0000 
*   2 MEG    $001C0000 
*   4 MEG    $003C0000 
*   8 MEG    $007C0000 
*  16 MEG    $00FC0000 
* 
* Example code for setting up 8 meg DRAM for bank 0: 
* move.l #$007C0000,D0 
* move.l D0,DCMR0 
* 
* NOTE: Base address can be located anywhere as long as it 
* does not conflict with other memory spaces. 
*******************************************************************
*****************
* DCR0 register *
*******************************************************************
* This register provides programmable options fro the refresh logic
* as well as the control bit to determine if the module is 
* operating with synchronous or asynchronous DRAMs.
*
*******************************************************************
* This example is configured as follows: 
* 
* 1) Synchronous Operation (DCR bit 15)
* 2) 6 clocks inserted between refresh commands (DCR bits 10:9)
* 3) Refresh Count is $C0 (DCR bits 8:0)
* 4) CASL[1:0] = 01 (DACR0 bits 13:12)
* 5) Command Bit = 20, Bank Select Bits 21 & up (DACR0 bits 10:8)
* 6) Precharge All command initiated (DACR bit 3)
* 7) Write capabilities are enabled (DMR0 bit ) 
*******************************************************************
;     move.w #$8230,D0         ;set DCR as specified above
;     move.w D0,DCR            ;see pg 11-23
;     move.l #DRAM0x+$1300,D0  ;set address base and refresh 
;     move.l D0,DACR0          ;controls, see pg 11-26
;     move.l #$003E0000,D0     ;set up the DCMR0
;     move.l D0,DCMR0          ;4Meg RAM size, see pg 11-11

*********
* CH 12 *
*******************************************************************
* Timer Initialization Section 12 of the users manual             *
*******************************************************************
* The 5307 has two timers. They can be free running or count to 
* a value and reset. The following examples set up the timers: 
* 
* Timer 1 will count to $AFAF, toggle its output, and reset back 
* to $0000. This will continue infinitely until the timer is 
* disabled or a reset occurs. No interrupts are set. Prescale 
* is set at 256 and the system clock is divided by 16. 
* Therefore resolution is (16*(256))/45mhz = 1.38889ns. Time out 
* period is (16*256*44976)/45mhz = 4.09382s. ($0 - $AFAF = 44976 
* decimal) 
* 
* Timer 2 will be free-running and send out a logic pulse 
* every time it compares the count value in the TRR register 
* value, which for now, is randomly chosen as $1234. 
* Prescale is set at 127 with the sys_clock initially 
* divided by 16 (by setting bits 2&1 of the TMR register to 10 
* therefore, resolution is (16*(127))/45mhz = 45.15556us. 
* Interrupts are NOT enabled. 
*******************************************************************
* NOTE: The timers were initialized in the SIM to have interrupt 
* values. The examples below have the interrupts disabled 
* The initialization in the SIM configuration was for reference. 
* See the SIM initialization to see how the autovectors have been 
* set up. The Timers CANNOT provide interrupt vectors, only 
* autovectors. 
* 
* See the SIM initialization code and also pg. 8-6  for setting 
* up the ICRs 
*******************************************************************
***********
* Timer 1 *
***********
****************
* TMR register *
*******************************************************************
* Bits 15:8 sets the prescale to 256 ($FF) 
* Bits 7:6 set for no interrupt ("00") 
* Bits 5:4 sets output mode for "toggle". No interrupts("10") 
* Bits 3 set for "restart" ("1") 
* Bits 2:1 set the clocking source to system clock/16 ("10") 
* Bits 0 enables/disables the timer ("0") 
*******************************************************************
     move.w #$FF2C,D0        ;Setup the Timer mode register (TMR1)
     move.w D0,TMR1          ;see pg 12-4 of the users manual
                             ;Bit 1 is set to 0 to disable the timer
                             ;See the Timer test code at the end of
                             ;this file.
     move.w #$0000,D0        ;writing to the timer counter with
     move.w D0,TCN1          ;any value resets it to zero
*****************
* TRR1 register *
*******************************************************************
* The TRR register is set to $AFAF. The timer will count up to 
* this value (TCN = TRR), toggle the "TOUT" pin, and reset the 
* TCN to $0000. See pg 12-5 
*******************************************************************

     move.w #$AFAF,D0        ;Setup the Timer reference register (TRR1)
     move.w D0,TRR1          ;see pg 12-5 of the users manual

*******************************************************************
* Other registers used for TIMER 1 
* 
* TCR1                  ;TIMER1 Capture Register, 16-bit, R 
* TER1                  ;TIMER1 Event Register, 8-bit, R/W 
*******************************************************************
***********
* Timer 2 *
***********
*****************
* TMR2 register *
*****************
*******************************************************************
* Bits 15:8 set the prescale to 127 ($7F) 
* Bits 7:6 set the capture mode and interrupt ("00") 
* Bits 5:4 set the output mode for "pulse" and no interrupt ("00")
* Bits 3 set for free-running ("0") 
* Bits 2:1 set the clocking source to clk/16 ("10") 
* Bits 1 enables the timer ("0") 
*******************************************************************
     move.w #$7F04,D0        ;Setup the Timer mode register (TMR2)
     move.w D0,TMR2          ;see pg 12-4 of the users manual
     move.w #$1234,D0        ;Set the Timer reference to $1234
     move.w D0,TRR2          ;see pg 12-5 of the users manual
     move.w #$0000,D0        ;writing to the timer counter with
     move.w D0,TCN2          ;any value resets it to zero
*******************************************************************
* 0ther registers used 
* 
* TCR2 ;TIMER2 Capture Register, 16-bit, R 
* TER2 ;TIMER2 Event Register, 8-bit, R/W 

*********
* CH 13 *
*******************************************************************
* DMA Initialization Section 13 (Users manual)                    *
*******************************************************************
* The Direct Memory Access Controller (DMA) on the 5307 provides
* a quick and efficient process for moving blocks of data with
* minimal processor overhead.  The 5307 provides four channels of 
* DMA that allow byte, word, or longword operand transfers.  These
* transfers can be single or dual address to off-chip devices or 
* dual address to on-chip devices.  See pgs 13-2,3,4.
* 
* Initializing one DMA channel requires the configuration of four 
* registers (see pgs 13-6,7,8):
*      SAR#   Source Address Register #
*      DAR#   Destination Address Register #
*      BCR#   Byte Count Register #
*      DCR#   DMA Control Register #
* 
* The status of the DMA Controller Module is reported by the DMA
* Status Register (DSR).  See pg 13-10,11.
* 
* This example sets up DMA channel 0 as follows:
* 1) Source address is the address of DMA_PATTERN (a data table at
*    the end of this file)
* 2) Destination address is 0x20000
* 3) Number of bytes to be transferred is 128
* 4) The SAR increments after each successful transfer
* 5) The DAR increments after each successful transfer
* 6) The size of the source bus cycle is a longword (32 bits)
* 7) The size of the destination bus cylce is a word (16 bits)
*
* Note:  This code is setup to work on the 5307 eval board.  If you
* are using this code on another system, the source and destination
* addresses should be modified for your design parameters.

*******************************************************************
* The code below initializes the DMA channel 0 as described above.*
*******************************************************************
# Source and Destination Addresses  
SOURCE  EQU     DMA_PATTERN
DEST    EQU     0x00020000

     move.l  #SOURCE,d0
     move.l  d0,SAR0         ;write source address register

     move.l  #DEST,d0
     move.l  d0,DAR0         ;write destination address register

     move.w  #(128),d0       
     move.w  d0,BCR0         ;write byte count register - 128 bytes

     move.w  #0x004C,d0      ;write DMA control register and start
                             ;transfer
     move.w  d0,DCR0         ;see pgs 13-8,9,10

*********
* CH 14 *
*******************************************************************
* UART Initialization Section 11 (Users manual)                   *
*******************************************************************
* The dual UARTs on the 5307 are initialized for baud rate, 
* bits/character, parity, etc. Some important points are: 
* 
* 1)To initialize the UARTs you MUST reset each UART in the 
* UCR register. 
* 2)Setting up each UARTs UMR1&2 registers can be confusing. 
* For proper initialization, reset the mode register pointer
* in the UCR register (MISCX=001, pg 14-25). This sets the 
* pointer at UMR1. Now, configure the UMR1 register. The 
* pointer will automatically increment to UMR2. Now write 
* to UMR2 (which is the same address as UMR1. The pointer 
* is internal to the processor and cannot be seen by the 
* programmer. 
* 
* This is also explained in the paragraph describing UMR1 
* on pg 14-18. 
* 
* Also, see pg 14-35 for initialization procedures 
*******************************************************************

*******************************************************************
* NOTE: UART Interrupts were disabled earlier in the IMR 
* initialization in the SIM section.
*******************************************************************

*********
* UART1 *
*********
*******************************************************************
* The code below initializes the UART1 as described on pg 14-25   *
*******************************************************************
     move.b #%00100000,D0    ;UART1 receiver reset
     move.b D0,UCR1          ;see pg 14-25 of the users manual
     move.b #%00110000,D0    ;UART1 transmitter reset
     move.b D0,UCR1          ;see pg 14-25 of the users manual
     move.b #%00010000,D0    ;UART1 Mode register reset
     move.b D0,UCR1          ;see pg 14-25 of the users manual
                             ;this sets the pointer to UMR1
********
* UMR1 *
*******************************************************************
* 
* UMR1 is set up as described below: 
* 1) Receiver request to send is automatically negated 
*    when FIFO has an empty position (BIT 7,UMR1). When 
*    the UART is acting as a receiver, the /RTS acts as 
*    a /CTS to the external UART sending the data. 
* 2) Receiver interrupts when FIFO is full, not a single 
*    received byte (BIT 6, UMR1) 
* 3) Error occurs in BLOCK mode (bit 5) 
* 3) No parity (BIT 4,3,2, UMR1) 
* 4) 8 bits per character (BIT 1,0 UMR1) 
*******************************************************************
* Note that UMR11 and UMR21 both point to the same address in the 
* EQU section. Resetting the Mode register pointer (UCR1 
* register) sets the pointer to UMR1. After writing to UMR1 
* the pointer points to UMR2. You should initialize UMR2 
* immediately after initializing UMR1. 
* 
* See pgs 14-(18-20)of the users manual. 
*******************************************************************
********
*(UMR2)*
*******************************************************************
* UMR2 for UART1 is set up as follows: 
* 1) Normal Mode (NO echo or loopback (BIT 7,6,UMR2) 
* 2) Transmitter ready-to send /RTS has no effect, (BIT 5, UMR2) 
* 3) Transmitter /CTS assert has no effect (BIT 4, UMR2) 
* 4) 1 stop but is sent (BIT 3,2,1,0 UMR2) 
* 
* See pg 14-(20-22) of the users manual 
*******************************************************************
     move.b #$F3,D0         ;set up the UMR1 (UART1 mode register)
     move.b D0,UMR11        ;see pg 14-18,19 of the users manual
                            ;After writing to this register, the mode
                            ;pointer points to UMR2 which I have defined
                            ;as UMR21, in the EQU section. Note that
                            ;this has the same address as UMR11. See
                            ;next  command below
     move.b #$07,D0         ;set up the UMR2 (UART1 mode register)
     move.b D0,UMR21        ;see pg 14-20,21 of the users manual
     move.b #$DD,D0         ;select timer mode as the Tx/Rx clocking
     move.b D0,UCSR1        ;see pg 14-24 of the users manual
     move.b #$00,D0         ;Disable interrupts for the COS&/CTS
     move.b D0,UACR1        ;see pg 14-30 of the users manual
     move.b #$00,D0         ;No interrupts enabled
     move.b D0,UIMR1        ;see pg 14-32 of the users manual
     move.b #64,D0          ;Interrupt vector set to 64 ($100)
     move.b D0,UIVR1        ;see pg 14-33 of the users manual
                            ;vector 64 was a random choice.
                            ;64 decimal is converted by the processor
                            ; to the vector offset hex value of $100
*******************************************************************
* UART1 (UBG11 & UBG21)                                           *
*******************************************************************
* Baud rate is set by taking the system clock, dividing by 
* 32, then divide that value by the concatenation of the decimal 
* value in UBG1 & UBG2. 
* This example assumes that the clock select is in Timer mode 
* as described on pg 14-24 in the USCR register 
* Below is an example and some approximate common baud rates: 
* 
* Example: 9600 baud rate (25mhz system clock) 
* 9600 = 25mhz * (1/32) * (1/81) where UBG1=0 
* & UBG2=81 decimal 
* =51 hex) 
********************************************************************
* baud rate   UBG1(hex)       UBG2(hex) (33MHZ sys clock)            
* 300         0D              6E                                     
* 1200        03              5B                                     
* 2400        01              AE                                     
* 4800        00              D7                                     
* 9600        00              6B                                     
* 19200       00              36                                     
* 28800       00              24                                     
* 33600       00              1F                                     
* 56000       00              12                                    
* 128000      00              08                                     
* 515625      00              02 (maximum)                          
********************************************************************
* baud rate   UBG1(hex)       UBG2(hex) (45MHZ sys clock)            
* 300         12              4F                                    
* 1200        04              94                                     
* 2400        02              4A                                    
* 4800        01              25                                    
* 9600        00              92                                    
* 19200       00              49                                   
* 28800       00              24                                   
* 33600       00              2A                                    
* 56000       00              12                                     
* 128000      00              09                                    
* 703125      00              02 (maximum)                           
********************************************************************
 
     move.b #$00,D0          ;Set baud rate to 9600 (45 mhz clk)
     move.b D0,UBG11         ;see pg 14-32 of the users manual
     move.b #$92,D0          ;concatenated HEX value $0092
     move.b D0,UBG21         

*********
* UART2 *
*********
*******************************************************************
* The code below initializes the UART2 as described on pg 14-25   *
*******************************************************************
     move.b #%00100000,D0    ;UART2 receiver reset
     move.b D0,UCR2          ;see pg 14-25,26 of the users manual
     move.b #%00110000,D0    ;UART2 transmitter reset
     move.b D0,UCR2          ;see pg 14-25,26 of the users manual
     move.b #%00010000,D0    ;UART2 Mode register reset
     move.b D0,UCR2          ;see pg 14-25,26 of the users manual
                             ;this sets the pointer to UMR1
********
* UMR1 *
*******************************************************************
*  
* UMR1 for UART 2 is set up as described below: 
* 1) Receiver request to send is automatically negated 
*    when FIFO has an empty position (BIT 7,UMR1). When 
*    the UART is acting as a receiver, the /RTS acts as 
*    a /CTS to the external UART sending the data. 
* 2) Receiver interrupts when FIFO is full, not a single 
*    received byte (BIT 6, UMR1) 
* 3) Error occurs in BLOCK mode (bit 5) 
* 3) No parity (BIT 4,3,2, UMR1) 
* 4) 8 bits per character (BIT 1,0 UMR1) 
* 
* Note that UMR1 and UMR2 both point to the same address in the 
* EQU section. Resetting the Mode register pointer (UCR1 
* (register) sets the pointer to UMR1. 
* 
* See pgs 14-(18-22)of the users manual. 
*******************************************************************
********
*(UMR2)*
*******************************************************************
* UMR2 for UART2 is set up as follows: 
* 1) Normal Mode (NO echo or loopback (BIT 7,6,UMR2) 
* 2) Transmitter ready-to send /RTS has no effect, (BIT 5, UMR2) 
* 3) Transmitter /CTS assert has no effect (BIT 4, UMR2) 
* 4) 1 stop but is sent (BIT 3,2,1,0 UMR2) 
* 
* See pg 14-(20-22) of the users manual 
*******************************************************************
     move.b #$F3,D0          ;set up the UMR1 (UART1 mode register)
     move.b D0,UMR12         ;see pg 14-18,19 of the users manual
     move.b #$07,D0          ;set up the UMR2 (UART1 mode register)
     move.b D0,UMR22         ;see pg 14-20,21 of the users manual
     move.b #$DD,D0          ;select timer mode as the Tx/Rx clocking
     move.b D0,UCSR2         ;see pg 14-24 of the users manual
     move.b #$00,D0          ;Disable interrupts for the COS&/CTS
     move.b D0,UACR2         ;see pg 14-30 of the users manual
     move.b #$02,D0          ;Interrupt only when FIFO is full
     move.b D0,UIMR2         ;see pg 14-31 of the users manual
     move.b #65,D0           ;Interrupt vector set to 65
     move.b D0,UIVR2         ;see pg 14-33 of the users manual
                             ;65 was a random choice.
                             ;65 decimal is converted by the processor
                             ; to the vector offset hex value of $104
*******************************************************************
* UART2 (UBG12 & UBG22) pg 14-32                                  *
*******************************************************************
     move.b #$00,D0         ;Set baud rate to 33,600 (25 mhz clk)
     move.b D0,UBG12        ;see pg 14-32 of the users manual
     move.b #$2A,D0         ;HEX value $0017
     move.b D0,UBG22 

*******************************************************************
* END MODULE INITIALIZATION                                       *
*******************************************************************

*******************************************************************
* MAIN code. 
*******************************************************************
* 
* Written below are some code segments to show and explain how 
* some of the modules of the 5307 are used and configured. A 
* brief explanation of each is as follows: 
* 
* 1) TIMER1 code segment 
*    This piece of code counts to $AFAF 5 times. Everytime it 
*    reaches $AFAF is sets the output reference bit (and pin). 
*    The counter resets after reaching $AFAF and begins counting 
*    again. Once the counter reaches 2,the code segment finishes
*    and runs the UART TRANSMIT code segment. 
*
* 2) UART TRANSMIT code segment 
*    This piece of code transmits a message to a terminal such 
*    as WIN95 Hyperterm. It sends the message "Welcome to 
*    Motorola's COLDFIRE V3!!!" After completing this section, 
*    the Program moves on to the UART RECEIVE code segment. 
*
* 3) UART RECEIVE code segment 
*    This piece of code recieves characters from a terminal such 
*    as WIN95 Hyperterm. It polls the RxRDY bit for a character 
*    and stores it into memory. After receiving 26 characters 
*    it moves on the the UART INTERRUPT WITH INTERRUPTS code 
*    segment. You must send 26 characters to exit this part of 
*    the program otherwise it will continue to loop. 
*
* 4) UART RECEIVE WITH INTERRUPTS code segment 
*    This piece of code recieves characters from a terminal such 
*    as WIN95 Hyperterm. It uses interrupts to service the 
*    storing of the character into memory. It counts up to 10 
*    characters and stores it into memory. After receiving 10 
*    characters the program jumps to the DMA TRANSFER code segment.
*    You must send 10 characters to exit this part of the program.
*   
* 5) DMA TRANSFER code segment
*    This short piece of code starts a DMA transfer by writing 
*    to bit 0 of the DMA Control Register (DCR).  Channel 0 of 
*    DMA was initialized above.  Once the transfer is complete,
*    the code halts by executing the HALT command.  If you are 
*    using the SDS debugger, once the processor is halted, you 
*    can verify that the block of memory was transferred by viewing 
*    the destination address (0x20000 for the 5307 eval board 
*    configuration) in the memory window.
*******************************************************************
  XDEF _test_code

_test_code:
     lea.l  RAMBARx+$200,A7  ;Setup the stack pointer (A7)
                             ;to point to the top of the
                             ;SRAM. SRAM will be used as
                             ;part of the stack.
********************
* TIMER1 test code *
*******************************************************************
* This simple piece of code enables TIMER1 and increments a 
* a counter each time it toggles its output. (See the TIMER1 
* configuration code). The code monitors bit 1 of the TER 
* register (pg 12-6 of the users manual). When the "ref" bit of 
* the TER register is set the counter increment until it reaches 
* 2 decimal. Then the code will jump out of the loop, disable 
* TIMER1 and go on to the next piece of code. This creates a 
* delay of approximatly 8.2 seconds. 
* 
* INFO: You must write a "1" to the REF bit, bit 1, of the TER 
* register to clear it. 
*******************************************************************
 XDEF T1_TST
T1_TST:
     clr.l  D0               ;clear D3-D0 data registers
     clr.l  D1
     clr.l  D2
     clr.l  D3
     move.w #$0000,D0        ;A write of any value to the TCN resets
     move.w D0,TCN1          ;it to all zeros. See pg 12-6 of users
                             ;manual
     move.b #$03,D1          ;reset the REF & CAP bit in the TER
     move.b D1,TER1          ;by writing a "1" see pg 13-6
     move.w TMR1,D0          ;these 3 lines enable the timer
     bset   #0,D0            ;by setting bit 1 of the TMR1
     move.w D0,TMR1          ;see pg 12-4 of the users manual
 
 XDEF T1_LP
T1_LP:
     move.b TER1,D1          ;load the Timer Event register into D1
     btst   #1,D1            ;Does TRR1=TCN1. (i.e. 'ref", bit 1
                             ;is set? TRR1 was defined as $AFAF
                             ;in the Timer1 initialization
     beq    T1_LP            ;If("0")then continue looping. Go to next
                             ;command below when = "1"
     addi.l #1,D2            ;count from 0 to 5
     cmp.l  #2,D2            ;does D2 = 2 yet
     beq    T1_FIN           ;Finish if equal to 5
     move.b #$02,D1          ;reset the ref bit in the TER
     move.b D1,TER1          ;by writing a "1" see pg 13-6
     jmp    T1_LP            ;loop until D2 = 5
 
 XDEF T1_FIN
T1_FIN:
     move.w TMR1,D0          ;these 3 lines disable TIMER1
     bclr   #0,D0            ;by clearing bit 0 of the TMR1
     move.w D0,TMR1          ;pg 12-4
     move.b #$02,D1          ;reset the ref bit in the TER
     move.b D1,TER1          ;pg 12-6
     move.w #$0000,D3        ;reset the counter to zero's
     move.w D3,TCN1          ;pg 12-5
 
****************************
* UART1 transmit test code *
*******************************************************************
* The code below prints out a message out of UART 1. The message 
* is "Welcome to Motorola COLDFIRE". The code keeps sending out 
* the UART until the number "0" is recognized at the end of the 
* character string. 
* 
* If you are using the SDS debugger, you can use one computer to 
* check out this code. Connect a 9 pin serial cable form the 
* 5307 board (connector J1, BDM). Use Win95's Hyperterminal with the 
* following settings: 
* 9600 baud, 8 data bits,1 stop bit, no parity, 
* Hardware flow control=none 
* 
* Then run this program on the 5307 board. The message 
* "Welcome to Motorola's COLDFIRE" should appear on the Hyper- 
* terminal screen. 
* Make sure to turn of 16550 UARTs are disabled. This can be 
* done in the WIN95 Hyperterminal under advanced settings. 
*******************************************************************
 XDEF U1_T
U1_T:
     lea.l  UART_T_Welcome,A1;set the address pointer to the beginning 
                             ;of the string to be transmitted
     lea.l  U1_R,A0          ;set the address pointer to the beginning
                             ;of the routine to jump to when done

 XDEF UART1_T
UART1_T:
     clr.l  D0               ;clear the registers
     clr.l  D1
     move.b #%00000100,D1    ;enable the transmitter (pg 14-25,26)
     move.b D1,UCR1          ;and disable receiver
 
 XDEF LOOP1
LOOP1:
     move.b (A1)+,D0         ;load the character into D0
                             ;from the "MOT" ascii line
     cmp.l  #$00,D0          ;is the character an acsii null ($00)
     beq    URT_FIN          ;if so, jump out of loop
     move.b D0,UTB1          ;load the value in the transmit
                             ;buffer. Loading the UTB1
                             ;begins the transmission
 XDEF WAIT
WAIT:
     move.b USR1,D1
     btst   #$03,D1          ;test bit 3 (transmitter empty)
     beq    WAIT
     jmp    LOOP1                

 XDEF URT_FIN
URT_FIN:
     jmp    (A0)             ;jump to routine pointed to by A0
*************************************
* End UART1 transmit test code      *
*************************************
*******************************
* UART1 receive test code     *
*******************************************************************
* The code below receives text data from a terminal. The best way
* to run this code is to create a text file of the alphabet and 
* send it to the 5307 board 
* This code polls the RxRDY bit to see if a character has been 
* received. If one has, it gets stored into memory by the A1 
* address pointer and the pointer is incremented 
* A counter counts for 26 charcaters. When the counter, D2, 
* reaches 25 (i.e.0-25=26)the routine leaves the loop and ends 
* this part of the UART receive test code. 
*******************************************************************
 XDEF U1_R
U1_R:
     lea.l  UART_T_Send_26,A1;set the address pointer to the beginning 
                             ;of the string to be transmitted
     lea.l  UART1_R,A0       ;set the address pointer to the beginning
                             ;of the routine to jump to when done 
     jmp    UART1_T          ;jump to uart transmit code

 XDEF UART1_R
UART1_R:
     lea.l  UART_R,A1        ;set the address pointer to the
                             ;beginning of the string
     clr.l  D0               ;clear the registers
     clr.l  D1
     clr.l  D2
     move.b #%00001001,D1    ;enable the receiver(pg 14-25,26)
     move.b D1,UCR1          ;and disable transmitter

 XDEF RWAIT
RWAIT:
     move.b USR1,D1
     btst   #$0,D1           ;has a character been received?
     nop
     beq    RWAIT            ;if "0", then loop to RWAIT
     move.b URB1,D0
     move.b D0,(A1)+         ;load the character into D0
                             ;and store in the storage at
                             ;UART_R
     addi.l #1,D2            ;count up to 26 
     cmp.l  #26,D2
     beq    UR_FIN
     jmp    RWAIT
 XDEF UR_FIN
UR_FIN
     nop
*************************************************
* UART1 receive test code (Interrupts Enabled)  *
*******************************************************************
* This code implements the use of interrupts. The processor  
* interrupts when the URT1 receives a character. The interrupt 
* routine called "URT1_INT" stores the value into a memory block 
* called "U1_RINT". After 10 characters are received, the code 
* disables interrupts and stops with a HALT command. 
* 
* The interrupt vectors were defined in the SIM section and URT1 
* was assigned vector #64. In the vector table, vector number 
* 64 points to URT1_INT 
* 
*******************************************************************
 XDEF U1_RI
U1_RI: 
     lea.l  UART_T_Send_10,A1;set the address pointer to the beginning 
                             ;of the string to be transmitted
     lea.l  UART1_RI,A0      ;set the address pointer to the beginning
                             ;of the routine to jump to when done 
     jmp    UART1_T          ;jump to UART transmit code

 XDEF UART1_RI
UART1_RI:
     lea.l U1_RINT,A0        ;set the address pointer to the
                             ;beginning of the string
     clr.l  D0               ;clear the registers
     clr.l  D1 
     clr.l  D2 
     move.b #%00100000,D0    ;UART1 receiver reset
     move.b D0,UCR1          ;see pg 14-25 of the users manual
     move.b #%00110000,D0    ;UART1 receiver transmitter
     move.b D0,UCR1          ;see pg 14-25 of the users manual
     move.b #%00001001,D0    ;enable the receiver and disable transmitter
                             ;(pg 14-25)
     move.b D0,UCR1          
     move.b #%00010000,D0    ;UART1 Mode register reset
     move.b D0,UCR1          ;see pg 14-25 of the users manual
                             ;this sets the pointer to UMR1
*********************************
* Set up UMR1 for interrupts on *
* RxRDY (bit 6)                 *
*********************************
     move.b #$B3,D0          ;set up the UMR1 (UART1 mode register)
     move.b D0,UMR11         ;see pg 14-18,19 of the users manual
                             ;After writing to this register, the mode
                             ;pointer points to UMR2 which I have 
                             ;defined
                             ;as UMR21, in the EQU section. See next
                             ;command below
     move.b #$07,D0          ;set up the UMR2 (UART1 mode register)
     move.b D0,UMR21         ;see pg 14-20,21 of the users manual
     move.l IMR,D0           ;enable interrupts for UART1 in the SIM
     bclr.l #12,D0           ;see pg 8-8 of users manual
     move.l D0,IMR           ;I used 3 lines of code to retain
                             ;original settings in the IMR
                             ;pg 8-8
     move.b #$02,D0          ;set the receiver to interrupt on
     move.b D0,UIMR1         ;RxRDY. This is bit 2 of the UIMR1
*******************************************************************
* Below is a loop that will continue until D2=10. The when a 
* character is received, an interrupt will occur and load the 
* character into the storage bytes located at "URT1_R_INT".
* The interrupt will return to the loop below. When D2=10 the 
* processor will leave the loop, disable UART1 interrupts and halt
*******************************************************************
     clr.l D1
     clr.l D0
 XDEF UNTIL_10
UNTIL_10
     move.b USR1,D1
     move.w IPR,D1
     cmp.l  #10,D2
     bne    UNTIL_10         ;loop until D2=10
     move.w IMR,D0           ;disable interrupts for UART1
     bset   #12,D0           ;see pg 8-8 of users manual
     move.w D0,IMR
*****************************************************************
* DMA TRANSFER test code                                        *
*****************************************************************
 XDEF DMA
DMA:
     move.w DCR0,D0
     bset.l #0,D0            ;set bit 0 of DMA Control Register
     move.w D0,DCR0          ;this starts the DMA transfer
                         
loop:
     nop
     nop
     move.b  DSR0,d0
     btst    #0,d0           ;test to see if transfer complete
     beq     loop            ;branch back if its not

****************************************************************
* Transmit end of Demo String                                  *
****************************************************************

 XDEF Finish
Finish: 
     lea.l  End_of_demo,A1   ;set the address pointer to the beginning 
                             ;of the string to be transmitted
     lea.l  Done,A0          ;set the address pointer to the beginning
                             ;of the routine to jump to when done 
     jmp    UART1_T          ;jump to UART transmit code

Done:
     halt                    ;halt when done copying

******************************
* Interrupt handler routines *
******************************
 XDEF UART1_INT
UART1_INT:
     move.b URB1,D0         ;load the received character
                            ;into the D0 register
     move.b D0,(A0)+        ;load the character into D0
                            ;and store in the storage at
                            ;URT1_RINT
     addi.l #1,D2           ;count up to 10 (0-9)
     rte


UART2_INT:
     rte

TIMER1_INT:
     rte

TIMER2_INT:
     rte

MBUS_INT:
     rte

WDOG_INT:
     move.b $55,D0
     move.b D0,SWSR
     move.b $AA,D0
     move.b D0,SWSR
     rte

*****************************************
* Definitions and reserved memory bytes *
*****************************************
 XDEF UART_T_Welcome
UART_T_Welcome:
     DC.B $0D               ;Ascii code for carriage feed
     DC.B $0A               ;Ascii code for line feed
     DC.B $0A               ;Ascii code for line feed
 .ascii "Welcome to Motorola's COLDFIRE V3!!"
     DC.B $0D               ;Ascii code for carriage feed
     DC.B $0A               ;Ascii code for line feed
     DC.B $0A               ;Ascii code for line feed
     DC.B $00               ;Ascii code for NULL
 XDEF UART_T_Send_26
UART_T_Send_26:
 .ascii "Send 26 characters now..."
     DC.B $0D               ;Ascii code for carriage feed
     DC.B $0A               ;Ascii code for line feed
     DC.B $0A               ;Ascii code for line feed
     DC.B $00               ;Ascii code for NULL

 XDEF UART_T_Send_10
UART_T_Send_10:
     DC.B $0D               ;Ascii code for carriage feed
     DC.B $0A               ;Ascii code for line feed
     DC.B $0A               ;Ascii code for line feed
 .ascii "Now type 10 characters..."
     DC.B $0D               ;Ascii code for carriage feed
     DC.B $0A               ;Ascii code for line feed
     DC.B $0A               ;Ascii code for line feed
     DC.B $00               ;Ascii code for NULL

 XDEF End_of_demo
End_of_demo:
     DC.B $0D               ;Ascii code for carriage feed
     DC.B $0A               ;Ascii code for line feed
     DC.B $0A               ;Ascii code for line feed
 .ascii "Congratulations.... You have completed the 5307 demo!"
     DC.B $0D               ;Ascii code for carriage feed
     DC.B $0A               ;Ascii code for line feed
     DC.B $0A               ;Ascii code for line feed
     DC.B $00               ;Ascii code for NULL

 XDEF UART_R
UART_R:
     DS.B 26                ;Storage for 26 characters (alphabet)
                            ;from a terminal
 XDEF U1_RINT
U1_RINT:
     DS.B 10                ;Storage for 10 characters (alphabet)
                            ;from a terminal

 XDEF DMA_PATTERN
DMA_PATTERN:            ;Block of memory to be moved by DMA, 128 bytes
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
     DC.L 0xDEADBEEF
 
