/*
 * File:        main.c
 * Purpose:     Main process
 *
 * Notes:       This is the demo application that comes installed 
 *              on the M5211DEMO platform.
 * 
 * License:     All software covered by license agreement in -
 *              docs/Freescale_Software_License.pdf
 */

#include "common.h"
#include "uif.h"

/********************************************************************/
void 
main (void)
{
    mcf5xxx_irq_enable();
    
    printf("\n");
    printf("**************************************************\n");
    printf("*                                                *\n");
    printf("*                    ADC Demo                    *\n");
    printf("*                                                *\n");
    printf("**************************************************\n");
    printf("\n");
    
    printf("Hello!  Welcome to the M5211DEMO Evaluation Board.\n");
    printf("\n");
    printf("Currently running on the M5211DEMO EVB is a simple\n");
    printf("program to demonstrate the capabilities of this EVB.\n");
    printf("The speed at which the LEDs toggle is dependent on \n");
    printf("the input voltage that is supplied to the A/D converter.\n");
    printf("This voltage is controlled via the potentiometer that\n");
    printf("is on the board. Simply adjust the potentiometer (RV1)\n");
    printf("and the LEDs will toggle at varying speeds.\n");
    printf("\n");
    printf("For additional information on using the M5211DEMO EVB, \n");
    printf("how to program the flash on this device, and other \n");
    printf("information, please refer to the \"Startup Guide\".\n");

    
    /* Initialize the CRTL1 register to all 0's */
    MCF_ADC_CTRL1 = 0;  
    
    /* Setting divisor in CTRL2 register */
    MCF_ADC_CTRL2 = MCF_ADC_CTRL2_DIV(3);
    
    /* Setting PortAN Pin 0 as ADC functionality */
    MCF_GPIO_PANPAR |= MCF_GPIO_PANPAR_PANPAR0;
    
    /* Setting Power Register appropriately */
    MCF_ADC_POWER = MCF_ADC_POWER_PUDELAY(2);

    
    /* Set SMODE to "Loop Sequential" */
    MCF_ADC_CTRL1 |= MCF_ADC_CTRL1_SMODE(2);
    
    /* Set start bit */
    MCF_ADC_CTRL1 |= MCF_ADC_CTRL1_START0;

    
    /* Below is the code for the loop that keeps the LEDs toggling 
        indefinitely.
    */
     
    while(1)
    {
        int i;
        int delay;

        for (i = 1; i < 8; i<<=1)
        {
            /* 
             * Below are the steps for toggling the LEDs:
             * - Wait for the Ready bits to be set
             * - Calculate the Delay based on the input from the potentiometer
             * - Light the appropriate LED for the amount of time determined
             *      from the calculation of the delay variable
             *
             *  These are the steps for moving the LEDs in one direction
             *  (increasing in binary: 1, 2, 4, 8)
             */
             
            while (!(MCF_ADC_ADSTAT & MCF_ADC_ADSTAT_RDY0)){};
            delay = (300000 - (((MCF_ADC_ADRSLT0 >> 3)  * 275000) / 4096));
            board_led_display(i);                               
            cpu_pause(delay);                                   
        }
        for (i = 8; i > 1; i>>=1)
        {
            /*
             *  These are the same steps for moving the LEDs, but
             *  in the opposite direction
             *  (decreasing in binary: 8, 4, 2, 1)
             */
             
            while (!(MCF_ADC_ADSTAT & MCF_ADC_ADSTAT_RDY0)){};  
            delay = (300000 - (((MCF_ADC_ADRSLT0 >> 3)  * 275000) / 4096));
            board_led_display(i);                           
            cpu_pause(delay);                                   
        }
    }
}

/********************************************************************/
