/*
 * File:		main.c
 * Purpose:		Simple LED example
 *
 * License:     All software covered by license agreement in -
 *              docs/Freescale_Software_License.pdf
 */

#include "common.h"

/********************************************************************/

#define DELAY   150000  /* Delay in micro-seconds */

/********************************************************************/
void 
main (void)
{
	int i;
	
    /* Global interrupt enable */
	mcf5xxx_irq_enable();
    switch ((MCF_CCM_CIR & 0xFFC0) >> 6)
    {
        case 0x3C:
            printf("MCF5211");      
            break;
        case 0x42:
            printf("MCF5212");
            break;   
        case 0x43:
            printf("MCF5213");
            break;
        default:
            printf("Unknown ");
            break;
    }
    printf(" Rev. %d",(MCF_CCM_CIR & 0x003F));
	printf("Running the \"Example\" project\n");
	
    /* 
     * This is the example project.
     * To create a new project, copy the example project files into
     * a new project folder and make modifications there.  The 
     * project make/build files are in the mcf5213/build directory.
     *
     * This project simply toggles the LEDs
     */
	while(1)
	{
	    for (i = 1; i < 8; i<<=1)
	    {
	        board_led_display(i);
	        cpu_pause(DELAY);
	    }
	    for (i = 8; i > 1; i>>=1)
	    {
	        board_led_display(i);
	        cpu_pause(DELAY);
	    }
	}
}
/********************************************************************/
