/*
                     MC68HC05C8  HEADER

WRITTEN:    9/21/89
REVISION:   0.9
USE FOR:    MC68HC05C8 | MC68HCL05C8 | MC68HSC05C8

The following header describes the memory, vectors, peripherals and special
instructions for the MC68HC05C8 microprocessor.  The information is taken from
the Motorola Data Sheet and is assumed to be correct.  It is specifically
designed to work with the Byte Craft C6805 Compiler, and is offered free for
your convenience.

I have taken most of the mnemonics directly from the Motorola literature with
the exception of those labels which could cause confusion with the compiler
or the assembler.  Please check all labels before using.

If you discover any errors or omissions, please communicate them to me through
the FREEWARE bulletin board or directly at the Motorola Detroit Sales Office
(313) 347-6800 (Before 10/15/89: 261-6200).

Mike Pauwels,  Senior FAE

******************************************************************************
*                                                                            *
* This product is distributed without charge to users via the MOTOROLA       *
* FREEWARE Bulletin Board.  The product is provided "as is" without warranty *
* of any kind either expressed or implied, including, but not limited to any *
* warranties of merchantability and fitness for a particular purpose.  All   *
* risks of using this product including the entire costs of any necessary    *
* remedies are those of the user and MOTOROLA assumes no liability of any    *
* kind.                                                                      *
*                                                                            *
******************************************************************************

*/


/*                   MEMORY MAP                                              */

#pragma memory ROMPAGE0 [48]    @ 0x0020 ;
#pragma memory RAMPAGE0 [176]   @ 0x0050 ;
#pragma memory ROMPAGE1 [7680]  @ 0x0100 ;


/*                   INTERRUPT VECTORS                                       */

#pragma vector __RESET @ 0x1ffe ;
#pragma vector SWI     @ 0x1ffc ;
#pragma vector IRQ     @ 0x1ffa ;
#pragma vector TIMER   @ 0x1ff8 ;
#pragma vector SCI     @ 0x1ff6 ;
#pragma vector SPI     @ 0x1ff4 ;


/*                   INPUT/ OUTPUT PORTS                                     */

#pragma portrw porta   @ 0x00;  /* General Purpose I/O Port                  */
#pragma portrw portb   @ 0x01;  /* General Purpose I/O Port                  */
#pragma portrw portc   @ 0x02;  /* General Purpose I/O Port                  */
#pragma portr  portd   @ 0x03;  /* in  ,-    ,SS   ,SCK  ,MOSI ,MISO,TxD,RxD */
#pragma portrw ddra    @ 0x04;  /* Data direction, Port A                    */
#pragma portrw ddrb    @ 0x05;  /* Data direction, Port B                    */
#pragma portrw ddrc    @ 0x06;  /* Data direction, Port C                    */


/*        SERIAL PERIPHERAL INTERFACE REGISTERS                              */

#pragma portrw spcr    @ 0x0A;  /* SPIE,SPE,-,MSTR,CPOL,CPHA,SPR1,SPR0       */
#define spie   7                /* Serial Peripheral Interrupt Enable        */
#define spe    6                /* Serial Peripheral Enable                  */
#define master 4                /* Master (= 1) | Slave (= 0)                */
#define cpol   3                /* Clock Polarity                            */
#define cpha   2                /* Clock Phase                               */
#define spr1   1                /* SPI Clock Rate Bit                        */
#define spr0   0                /* SPI Clock Rate Bit                        */

#pragma portrw spsr    @ 0x0B;  /* SPIF,WCOL,-,MODF,-,-,-,-                  */
#define spif   7                /* Serial Peripheral Data Transfer Flag      */
#define wcol   6                /* Write Collision                           */
#define modf   4                /* Mode Fault                                */

#pragma portrw spdr    @ 0x0C;  /* SPI Data                                  */


/*      SERIAL COMMUNICATIONS INTERFACE REGISTERS                            */

#pragma portw baud     @ 0x0D;  /* -,-,SCP1,SCP0;-,SCR2,SCR1,SCR0            */
#define baud9600 0x30           /* 9600 Baud; Assumes 4.0 MHz Xtal           */
#define baud1200 0x33           /* 1200 Baud; Assumes 4.0 MHz Xtal           */
#define baud8192 0x22           /* 8192 Baud; Assumes 4.1943 MHz Xtal        */
                         /* Other Baud Rates: See MicroProcessor Data Sheet  */

#pragma portw  sccr1   @ 0x0E;  /* R8,T8,-,M;WAKE,-,-,-                      */
#define r8     7                /* Recieve Data Bit 8                        */
#define t8     6                /* Transmit Data Bit 8                       */
#define m      4                /* SCI Character Word Length                 */
#define wake   3                /* Wake Up Select                            */

#pragma portw  sccr2   @ 0x0F;  /* TIE,TCIE,RIE,ILIE;TE,RE,RWU,SBK           */
#define tie  7                  /* Transmit Interrput Enable                 */
#define tcie 6                  /* Transmit Complete Interrupt Enable        */
#define rie  5                  /* Receive Interrupt Enable                  */
#define ilie 4                  /* Idle Line Interrupt Enable                */
#define te   3                  /* Transmit Enable                           */
#define re   2                  /* Receive Enable                            */
#define rwu  1                  /* Receiver Wake-Up                          */
#define sbk  0                  /* Send Break                                */

#pragma portr  scsr    @ 0x10;  /* TDRE,TC,RDRF,IDLE;OR,NF,FE,-              */
#define tdre   7                /* Transmit Data Register Empty              */
#define tc     6                /* Transmit Complete                         */
#define rdrf   5                /* Receive Data Register Full                */
#define idle   4                /* Idle Line Flag                            */
#define or     3                /* Overrun Flag                              */
#define nf     2                /* Noise Flag                                */
#define fe     1                /* Framing Error                             */

#pragma portrw scdat   @ 0x11;  /* SCI Data                                  */
#pragma portr  rdr     @ 0x11;  /* SCI Receive Data (same as scdat)          */
#pragma portw  tdr     @ 0x11;  /* SCI Transmit Data (same as scdat)         */


/*                    TIMER REGISTERS                                        */

#pragma portrw tcr     @ 0x12;  /* ICIE,OCIE,TOIE,0;0,0,IEGE,OLVL            */
#define icie   7                /* Input Capture Interrupt Enable            */
#define ocie   6                /* Output Compare Interrupt Enable           */
#define toie   5                /* Timer Overflow Interrupt Enable           */
#define iege   1                /* Input Edge                                */
#define olvl   0                /* Output Level                              */

#pragma portr  tsr     @ 0x13;  /* ICF,OCF,TOF,0; 0,0,0,0                    */
#define icf    7                /* Input Capture Flag                        */
#define ocf    6                /* Output Compare Flag                       */
#define tof    5                /* Timer Overflow Flag                       */

#pragma portr  ichr    @ 0x14;  /* Input Capture Reg High Byte               */
#pragma portr  iclr    @ 0x15;  /* Input Capture Reg Low Byte                */
#pragma portrw ochr    @ 0x16;  /* Output Compare Reg High Byte              */
#pragma portrw oclr    @ 0x17;  /* Output Compare Reg Low Byte               */
#pragma portr  tchr    @ 0x18;  /* Timer Counter Register High Byte          */
#pragma portr  tclr    @ 0x19;  /* Timer Counter Register Low Byte           */
#pragma portr  achr    @ 0x1A;  /* Alternate Count Reg High Byte             */
#pragma portr  aclr    @ 0x1B;  /* Alternate Count Reg Low Byte              */


/*                   MC68HC05 INSTRUCTIONS                                   */

#pragma has STOP ;
#pragma has WAIT ;
#pragma has MUL ;

