/*******************************************************************************/
/**
  \mainpage 
  
  \n Copyright (c) 2007 Freescale Semiconductor
  \n Freescale Confidential Proprietary
  
  \brief        Sample code for EVB9S12XF512E.
  
  \author   	Freescale Semiconductor
  \author       Jaime Orozco
  \author   	Guadalajara Applications Laboratory RTAC Americas
  
  \version      1.1
  \date         March/12/2007
  
Stand-alone sample code for EVB9S12XF512E, compiled with CW for HCS12(X) v4.6
*/
/*******************************************************************************/
/*                                                                             */
/* All software, source code, included documentation, and any implied know-how */
/* are property of Freescale Semiconductor and therefore considered            */ 
/* CONFIDENTIAL INFORMATION.                                                   */
/*                                                                             */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY. */
/*                                                                             */
/* All Confidential Information remains the property of Freescale Semiconductor*/
/* and will not be copied or reproduced without the express written permission */
/* of the Discloser, except for copies that are absolutely necessary in order  */
/* to fulfill the Purpose.                                                     */
/*                                                                             */
/* Services performed by FREESCALE in this matter are performed AS IS and      */
/* without any warranty. CUSTOMER retains the final decision relative to the   */
/* total design and functionality of the end product.                          */
/*                                                                             */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the    */
/* success of this project.                                                    */
/*                                                                             */
/* FREESCALE disclaims all warranties, express, implied or statutory including,*/
/* but not limited to, implied warranty of merchantability or fitness for a    */
/* particular purpose on any hardware, software or advise supplied to the      */
/* project by FREESCALE, and or any product resulting from FREESCALE services. */
/*                                                                             */
/* In no event shall FREESCALE be liable for incidental or consequential       */
/* damages arising out of this agreement. CUSTOMER agrees to hold FREESCALE    */
/* harmless against any and all claims demands or actions by anyone on account */
/* of any damage,or injury, whether commercial, contractual, or tortuous,      */
/* rising directly or indirectly as a result of the advise or assistance       */
/* supplied CUSTOMER in connection with product, services or goods supplied    */
/* under this Agreement.                                                       */
/*                                                                             */
/*******************************************************************************/

/** S12X derivative information */ 
#include "M9S12XF512.h"     

/** Common defines and macros */
#include <hidef.h>

/** Variable types and common definitions */
#include "typedefs.h"    

/** CPU definitions */
#include "Cpu.h"

/** Interrupt service routines prototypes */
#include "Interrupts.h"

/** Macro definitions for general purpose I/O handling  */
#include "GPIO_macros.h"

/** SPI definitions */
#include "SPI_driver.h"

/** SBC definitions */
#include "SBC_driver.h"

/** CAN channel definitions and function prototypes  */
#include "CAN_driver.h"

/** FlexRay function prototypes */
#include "FlexRay_handler.h"

/** Task code for the scheduler */
extern UINT8 gu8TaskCode;


/*******************************************************************************/

void main(void) 
{       
    /* Initialize CPU, PLL, peripherals and interruption settings */ 
    vfnClock_Settings();   
     
    vfnIPLL_Startup();    
    
    vfnPeripheral_Settings();  
           
    vfnInterrupts_Init();  
        
        
    vfnSPI_Init();          /* Start SPI module */  
        
    vfnSBC_DebugMode();     /* Set SBC in Debug mode */
    
    vfnCAN_Init();          /* Initialize MSCAN module */
    
    vfnFlexRay_Init();      /* FlexRay module configuration */
    
    gu8TaskCode=0;          /* Initialize the task code for the scheduler */
    
    ENABLE_INTERRUPTS();
        
        for (;;)            /* Endless loop,waiting for interrupts */     
            ;                                            
}           

/*******************************************************************************/