/*******************************************************************************/
/**
Copyright (c) 2007 Freescale Semiconductor
Freescale Confidential Proprietary
\file       Interrupts.c
\brief      Interrupt Service Routines
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     Jaime Orozco
\version    1.1
\date       March/12/2007
*/
/*******************************************************************************/
/*                                                                             */
/* All software, source code, included documentation, and any implied know-how */
/* are property of Freescale Semiconductor and therefore considered            */ 
/* CONFIDENTIAL INFORMATION.                                                   */
/*                                                                             */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY. */
/*                                                                             */
/* All Confidential Information remains the property of Freescale Semiconductor*/
/* and will not be copied or reproduced without the express written permission */
/* of the Discloser, except for copies that are absolutely necessary in order  */
/* to fulfill the Purpose.                                                     */
/*                                                                             */
/* Services performed by FREESCALE in this matter are performed AS IS and      */
/* without any warranty. CUSTOMER retains the final decision relative to the   */
/* total design and functionality of the end product.                          */
/*                                                                             */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the    */
/* success of this project.                                                    */
/*                                                                             */
/* FREESCALE disclaims all warranties, express, implied or statutory including,*/
/* but not limited to, implied warranty of merchantability or fitness for a    */
/* particular purpose on any hardware, software or advise supplied to the      */
/* project by FREESCALE, and or any product resulting from FREESCALE services. */
/*                                                                             */
/* In no event shall FREESCALE be liable for incidental or consequential       */
/* damages arising out of this agreement. CUSTOMER agrees to hold FREESCALE    */
/* harmless against any and all claims demands or actions by anyone on account */
/* of any damage,or injury, whether commercial, contractual, or tortuous,      */
/* rising directly or indirectly as a result of the advise or assistance       */
/* supplied CUSTOMER in connection with product, services or goods supplied    */
/* under this Agreement.                                                       */
/*                                                                             */
/*******************************************************************************/

/** S12X derivative information */ 
#include "M9S12XF512.h"     

/** Macro definitions for general purpose I/O handling  */
#include "GPIO_macros.h"

/** Variable types and common definitions */
#include "typedefs.h"   

/** CAN channel definitions and function prototypes  */
#include "CAN_driver.h"

/** Task scheduler function prototypes */
#include "Scheduler.h"

/** Task code for the scheduler */
UINT8 gu8TaskCode;


/*******************************************************************************/
/**
* \brief    Real Time Interrupt service routine, \n
            SBC watchdog clearing and time base for the scheduler
* \author   Jaime Orozco
*/
#pragma CODE_SEG __NEAR_SEG NON_BANKED

void interrupt Scheduler_RTI_Isr(void)
{
    CRGFLG_RTIF = 1;    /* Clear the real time interrupt flag */ 
    
    XGSWT= 0x0101;      /* Software trigger to the XGATE */
    
    /* Execute the next task in the schedulerand update the task code */
    gu8TaskCode=u8Scheduler(gu8TaskCode);  
}
#pragma CODE_SEG Scheduler_RTI_CODE


/*******************************************************************************/
/**
* \brief    XIRQ service routine
* \author   Jaime Orozco
*/
#pragma CODE_SEG __NEAR_SEG NON_BANKED

void interrupt External_XIRQ_Isr(void)
{
    LED_TOGGLE(D26);   /* Toggle LED indicator */
}
#pragma CODE_SEG External_XIRQ_CODE


/*******************************************************************************/
/**
* \brief    CAN reception interrupt service routine
* \author   Jaime Orozco
*/
#pragma CODE_SEG __NEAR_SEG NON_BANKED

void interrupt CANRx_Isr(void)
{    
    LED_ON(D29); /* Turn ON LED indicators */
    vfnCAN_ReceivedFrame(); /* Read received frame */           
}

#pragma CODE_SEG CANRx_Isr_CODE


/*******************************************************************************/





