/*******************************************************************************/
/**
Copyright (c) 2007 Freescale Semiconductor
Freescale Confidential Proprietary
\file       FlexRay_handler.c
\brief      FlexRay module handling routines.
            Code based on the Transmit/Receive application example 
            for the FlexRay UNIFIED driver in polling mode
            (transmit_receive_node2.c) made by R62779.            
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     Jaime Orozco
\version    1.2
\date       March/12/2007
*/
/*******************************************************************************/
/*                                                                             */
/* All software, source code, included documentation, and any implied know-how */
/* are property of Freescale Semiconductor and therefore considered            */ 
/* CONFIDENTIAL INFORMATION.                                                   */
/*                                                                             */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY. */
/*                                                                             */
/* All Confidential Information remains the property of Freescale Semiconductor*/
/* and will not be copied or reproduced without the express written permission */
/* of the Discloser, except for copies that are absolutely necessary in order  */
/* to fulfill the Purpose.                                                     */
/*                                                                             */
/* Services performed by FREESCALE in this matter are performed AS IS and      */
/* without any warranty. CUSTOMER retains the final decision relative to the   */
/* total design and functionality of the end product.                          */
/*                                                                             */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the    */
/* success of this project.                                                    */
/*                                                                             */
/* FREESCALE disclaims all warranties, express, implied or statutory including,*/
/* but not limited to, implied warranty of merchantability or fitness for a    */
/* particular purpose on any hardware, software or advise supplied to the      */
/* project by FREESCALE, and or any product resulting from FREESCALE services. */
/*                                                                             */
/* In no event shall FREESCALE be liable for incidental or consequential       */
/* damages arising out of this agreement. CUSTOMER agrees to hold FREESCALE    */
/* harmless against any and all claims demands or actions by anyone on account */
/* of any damage,or injury, whether commercial, contractual, or tortuous,      */
/* rising directly or indirectly as a result of the advise or assistance       */
/* supplied CUSTOMER in connection with product, services or goods supplied    */
/* under this Agreement.                                                       */
/*                                                                             */
/*******************************************************************************/

/** S12X derivative information */ 
#include "M9S12XF512.h"       

/** Macro definitions for general purpose I/O handling  */
#include "GPIO_macros.h"

/** Standard and driver types */
#include "Fr_UNIFIED_types.h"  

/** UNIFIED driver implementation */         
#include "Fr_UNIFIED.h"        
         
/** Configuration data for the FlexRay node */
#include "Fr_UNIFIED_cfg.h"


/** Transmit MB 1, slot 4 */
#define TX_SLOT_4   1   
/** Receive MB 2, slot 1 */
#define RX_SLOT_1   2   
/** Transmit MB 4, slot 5 */
#define TX_SLOT_5   4   
/** Double Transmit Buffer - transmit sideMB 5, slot 5 */
#define TX_SLOT_5_TRANSMIT_SIDE     5   
/** Transmit MB 11, slot 62 */
#define TX_SLOT_62  11  
/** Transmit MB 12, slot 63 */
#define TX_SLOT_63  12  


/** Return values */
Fr_return_type return_value;      
/** Current protocol state */      
Fr_POC_state_type protocol_state;       
/** Current wakeup status */
Fr_wakeup_state_type wakeup_status;     
/** Current cycle value */
uint8 current_cycle;   


/** Definition of the variables used for updating of the transmit MBs */
/** Data array - static segment, slot 4 */
uint16 tx_data_4[16] = {0};             
/** Data array - static segment, slot 5 */
uint16 tx_data_5[16] = {0};             
/** Data array - dynamic segment, slot 62 */
uint16 tx_data_62[8] = {0};             
/** Data array - dynamic segment, slot 63 */
uint16 tx_data_63[8] = {0};             
/** Variable used for storing of the return values */
Fr_tx_MB_status_type tx_return_value;   
/** Variable to determine if data has been tranmsitted */
Fr_tx_status_type tx_status;            

/** Variables used for storing data and status from the receive MBs */
/** Data array - static segment, slot 1 */
uint16 rx_data_1[16] = {0};             
/** Received data length */
uint8 rx_data_length = 0;               
/** Received frame status */
uint16 rx_status_slot = 0;              
/** Variable used for storing of the return values */
Fr_rx_MB_status_type rx_return_value;   
/** Variable to determine if a frame has been received */
Fr_rx_status_type rx_status;            

/** The number of the message buffer access errors */
uint16 mb_access_error = 0;             
/** The number of the CHI related errors */
uint16 chi_error = 0;                   
/** The number of the transmission across boundary errors */
uint16 transmission_across_boundary = 0;    
/** The number of boundary violation errors */
uint16 violation = 0;                   
/** Internal protocol error detected */
boolean protocol_error = FALSE;         
/** Communication cycle */
boolean cycle_starts = FALSE;  


/******************************************************************************/
/**
* \brief    Error function for debugging 
* \author   R62779
* \param    u8number: error code
* \return   void
*/
void Failed(uint8 u8number)               
{    
    while(1);       /* Function only for debugging, CC should be restarted  */
}

/*******************************************************************************/
/**
* \brief    FlexRay module configuration
* \author   Jaime Orozco
* \param    void
* \return   void
*/
void vfnFlexRay_Init(void)
{
    /* Enable the FlexRay CC and force it into FR_POCSTATE_CONFIG */
    return_value = Fr_init(&Fr_HW_cfg_00, &Fr_low_level_cfg_set_00);
    if(return_value == FR_NOT_SUCCESS) 
        Failed(1);   /* Call debug function in case of any error */

    /* Initialization of the FlexRay CC with protocol configuration parameter */
    Fr_set_configuration(&Fr_HW_cfg_00, &Fr_low_level_cfg_set_00);
    
    /* Initialization of all message buffers, receive shadow buffers 
       and FIFO storages */
    Fr_buffers_init(&Fr_buffer_cfg_00[0], &Fr_buffer_cfg_set_00[0]);
    
    /* Set callback functions */
    /* No FlexRay interrupt is enabled -> no callback function */

    /* Leave FR_POCSTATE_CONFIG state */
    return_value = Fr_leave_configuration_mode();
    if(return_value == FR_NOT_SUCCESS)
        Failed(2);   /* Call debug function in case of any error */

    /* Retrieve the wakeup state */
    wakeup_status = Fr_get_wakeup_state();
    
    /* Check whether a wakeup pattern has been received */
    if(wakeup_status == FR_WAKEUPSTATE_UNDEFINED)
    {   /* No wakeup pattern has been received */
        /* Initiate wakeup procedure */
        return_value = Fr_send_wakeup();
        if(return_value == FR_NOT_SUCCESS)
            Failed(3);   /* Call debug function in case of any error */    
    }
    
   
    protocol_state = Fr_get_POC_state();    /* Load current POC state */
    
    /* Wait till the FR CC is not in the FR_POCSTATE_READY */
    while(Fr_get_POC_state() != FR_POCSTATE_READY)  
    {
        protocol_state = Fr_get_POC_state();    /* Load current POC state */
    }  
   
    /* Initialize startup */
    return_value = Fr_start_communication();
    if(return_value == FR_NOT_SUCCESS)
        Failed(4);   /* Call debug function in case of any error */
    
    protocol_state = Fr_get_POC_state();    /* Load current POC state */
    
    /* Wait till the FR CC is not in the FR_POCSTATE_NORMAL_ACTIVE */
    while(Fr_get_POC_state() != FR_POCSTATE_NORMAL_ACTIVE)  
    {
        protocol_state = Fr_get_POC_state();    /* Load current POC state */
    }
    
    protocol_state = Fr_get_POC_state();    /* Load current POC state */

    /* The first initialization of the MB 1 */
    tx_return_value = Fr_transmit_data(TX_SLOT_4, &tx_data_4[0], 16);
    if(tx_return_value == FR_TXMB_NO_ACCESS)
        Failed(4);   /* Call debug function in case of any error */

    /* The first initialization of the MB */
    tx_return_value = Fr_transmit_data(TX_SLOT_5, &tx_data_5[0], 16);
    if(tx_return_value == FR_TXMB_NO_ACCESS)
        Failed(6);   /* Call debug function in case of any error */
 
    /* The first initialization of the MB */
    tx_return_value = Fr_transmit_data(TX_SLOT_62, &tx_data_62[0], 8);
    if(tx_return_value == FR_TXMB_NO_ACCESS)
        Failed(7);   /* Call debug function in case of any error */

    /* The first initialization of the MB */
    tx_return_value = Fr_transmit_data(TX_SLOT_63, &tx_data_63[0], 8);
    if(tx_return_value == FR_TXMB_NO_ACCESS)
        Failed(8);   /* Call debug function in case of any error */

    
    /* No FlexRay interrupt is enabled */

    wakeup_status = Fr_get_wakeup_state();  /* Load current wakeup status */
}
    
/******************************************************************************/
/**
* \brief    FlexRay events handler
* \author   Jaime Orozco
* \param    void
* \return   void
*/
    
void vfnFlexRay_Handler(void)
{
    /* Check whether or not the communication cycle has been started  */
    cycle_starts = Fr_check_cycle_start(&current_cycle);
        
        if(cycle_starts)    /* Did the communication cycle start? */
        {
            /* TRANSMIT SINGLE BUFFER - update transmit MB 1 with new data */
            tx_status = Fr_check_tx_status(TX_SLOT_4);  
            
            /* Check whether data has been transmitted */
            if(tx_status == FR_TRANSMITTED)
            {
                tx_data_4[0] -= 100;    /* Decrement variable */
                
                /* Update transmit MB with new data */
                tx_return_value = Fr_transmit_data(TX_SLOT_4, &tx_data_4[0], 16);  
				
				/* Increment variable in case of MB access error */
				if(tx_return_value == FR_TXMB_NO_ACCESS) mb_access_error++; 
				
				LED_OFF(D25);   /* Clear LED indicator */
             }

            /* TRANSMIT DOUBLE BUFFER 
               update double transmit MB 4 with new data */
            /* Check whether data has been transferred or transmitted */
            tx_status = Fr_check_tx_status(TX_SLOT_5);  
            
            /* Update commit side of double MB in case that 
               Internal Message Transfer has been performed */
            if((tx_status == FR_TRANSMITTED) || 
               (tx_status == FR_INTERNAL_MESSAGE_TRANSFER_DONE))
            {
                tx_data_5[0] += 100;  /* Increment variable */
                
                /* Update transmit MB with new data */
                tx_return_value = Fr_transmit_data(TX_SLOT_5, &tx_data_5[0], 16); 
                 
                /* Increment variable in case of MB access error */
                if(tx_return_value == FR_TXMB_NO_ACCESS) mb_access_error++;                                  
            }

            /* TRANSMIT BUFFER - update transmit MB 11 with new data */
            tx_status = Fr_check_tx_status(TX_SLOT_62);   
            
            /* Check whether data has been transmitted */
            if(tx_status == FR_TRANSMITTED)
            {
                tx_data_62[0] += 50;    /* Increment variable */
                
                /* Update transmit MB with new data */
                tx_return_value = Fr_transmit_data(TX_SLOT_62, &tx_data_62[0], 0); 
                
                /* Increment variable in case of MB access error */
                if(tx_return_value == FR_TXMB_NO_ACCESS) mb_access_error++;        
                
                LED_OFF(D28);   /* Clear LED indicator */
            }

            /* RECEIVE BUFFER - copy received data from receive MB 2 */
            /* Check whether the MB has been updated in last matching slot */            
            rx_status = Fr_check_rx_status(RX_SLOT_1);  
            
            if(rx_status == FR_RECEIVED) /* MB data field updated in last slot */
            {
                /* Copy data into given data array */
                rx_return_value = Fr_receive_data(RX_SLOT_1, &rx_data_1[0],
                                                  &rx_data_length, &rx_status_slot);
                                                  
                /* Increment variable - to be transmitted later on */                                  
                tx_data_5[1]++;        
                
                /* Copy slot status into variable - to be transmitted later on */                 
                tx_data_5[2] = rx_status_slot;     
                     
                /* Increment variable in case of MB access error */
                if(rx_return_value == FR_RXMB_NO_ACCESS) mb_access_error++;        
                
                LED_OFF(D23);   /* Clear LED indicator */
            }
            
            /* Increment variable - to be transmitted later on */         
            tx_data_5[3]++;	
            						    
            /* Store current cycle number into transmit data array */
            tx_data_5[4] = current_cycle;              
            
            /* Check whether the CHI related error has been occured */
            /* Increment variable if CHI error occured  */
            if(Fr_check_CHI_error() != 0) chi_error++; 
            
            /* Store the number of the CHI related errors */ 
            tx_data_5[6] = chi_error;                   
            
            /* Check whether or not the frame transmission 
               across boundary has been occured */
            /* Increment variable if error occured */
            if(Fr_check_transmission_across_boundary(FR_CHANNEL_AB)) 
                transmission_across_boundary++;
            
            /* Store the number of errors */
            tx_data_5[7] = transmission_across_boundary;    
            
            /* Check whether or not the frame transmission in dynamic segment
               exceeded the dynamic segment boundary */
            /* Increment variable if error occured */
            if(Fr_check_violation(FR_CHANNEL_AB)) violation++;
            
            tx_data_5[8] = violation;    /* Store the number of errors */
        }

        /* Check whether or not the protocol engine has detected 
           an internal protocol error */
        /* TRUE -> Protocol engine goes into the FR_POCSTATE_HALT state */  
        protocol_error = Fr_check_internal_protocol_error();    

        /* TRANSMIT BUFFER - update transmit MB 12 with new data */
        /* Check whether data has been transmitted */
        tx_status = Fr_check_tx_status(TX_SLOT_63);     
        if(tx_status == FR_TRANSMITTED)
        {
            tx_data_63[0] -= 50;    /* Decrement variable */
            
            /* Update transmit MB with new data */
            tx_return_value = Fr_transmit_data(TX_SLOT_63, &tx_data_63[0], 0); 
            
            /* Increment variable in case of MB access error */ 
            if(tx_return_value == FR_TXMB_NO_ACCESS) mb_access_error++;                    
        }
        
        /* Store the value of access errors to the transmit data array */
    tx_data_5[5] = mb_access_error;   
    
}

/******************************************************************************/