/*******************************************************************************/
/**
Copyright (c) 2007 Freescale Semiconductor
Freescale Confidential Proprietary
\file       Cpu.c
\brief      S12XF512 CPU initialization, bus clock @40MHz
            and interrupts configuration routines
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     Jaime Orozco
\version    1.1
\date       March/12/2007
*/
/*******************************************************************************/
/*                                                                             */
/* All software, source code, included documentation, and any implied know-how */
/* are property of Freescale Semiconductor and therefore considered            */ 
/* CONFIDENTIAL INFORMATION.                                                   */
/*                                                                             */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY. */
/*                                                                             */
/* All Confidential Information remains the property of Freescale Semiconductor*/
/* and will not be copied or reproduced without the express written permission */
/* of the Discloser, except for copies that are absolutely necessary in order  */
/* to fulfill the Purpose.                                                     */
/*                                                                             */
/* Services performed by FREESCALE in this matter are performed AS IS and      */
/* without any warranty. CUSTOMER retains the final decision relative to the   */
/* total design and functionality of the end product.                          */
/*                                                                             */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the    */
/* success of this project.                                                    */
/*                                                                             */
/* FREESCALE disclaims all warranties, express, implied or statutory including,*/
/* but not limited to, implied warranty of merchantability or fitness for a    */
/* particular purpose on any hardware, software or advise supplied to the      */
/* project by FREESCALE, and or any product resulting from FREESCALE services. */
/*                                                                             */
/* In no event shall FREESCALE be liable for incidental or consequential       */
/* damages arising out of this agreement. CUSTOMER agrees to hold FREESCALE    */
/* harmless against any and all claims demands or actions by anyone on account */
/* of any damage,or injury, whether commercial, contractual, or tortuous,      */
/* rising directly or indirectly as a result of the advise or assistance       */
/* supplied CUSTOMER in connection with product, services or goods supplied    */
/* under this Agreement.                                                       */
/*                                                                             */
/*******************************************************************************/

/** S12X derivative information */ 
#include "M9S12XF512.h"  

/** Common defines and macros */
#include <hidef.h>   

/** Variable types and common definitions */
#include "typedefs.h"   

/** XGATE definitions */
#include "xgate.h"


/*******************************************************************************/
/**
* \brief    PLL initialization, Bus Clock @ 40MHz
* \author   Jaime Orozco
* \param    void
* \return   void
*/
void vfnClock_Settings(void)
{    
    /* Bus Clock = OSCCLK * (SYNR+1) / ((REFDV+1)(2*POSTDIV))    */
    /*     40MHz =  4MHz  * (9+1) / (1)                          */
    PLLCTL_PLLON = 0;       /* Disable the PLL */
    SYNR_SYN = 0x09;        /* Set PLL synthesizer register to 9 */
    REFDV_REFDV = 0x00;     /* Set PLL divider register to 0 */
    
    /* Fvco = 2*OSCCLK*(SYNR+1)/(REFDV+1) = 8MHz* 10/1 = 80MHz   */
    /*                                    -> VCOFRQ = 01b        */        
    SYNR_VCOFRQ1 = 0;
    SYNR_VCOFRQ0 = 1;
        
    /* Fref = OSCCLK/(REFDV+1) = 4MHz/1 = 4MHz -> REFRQ= 01b     */    
    REFDV_REFFRQ1 = 0;
    REFDV_REFFRQ0 = 1;
    
    PLLCTL_PLLON = 1;   /* PLL enabled */
    
        while(!CRGFLG_LOCK)
            ;       /* Wait until the PLL is within the desired frequency */
                
    CLKSEL_PLLSEL = 1;    /* Select clock source from PLL */      
}


/*******************************************************************************/
/**
* \brief    FlexRay IPLL initialization @ 80MHz
* \author   Jaime Orozco
* \param    void
* \return   void
*/
void vfnIPLL_Startup(void)
{
    /* Fvco = 2*OSCCLK*(SYNR+1)/(REFDV+1) = 8MHz*(9+1)/1 = 80MHz -> VCOFRQ = 01b */
    CGMSYN_SYN = 0x09;     
    CGMREF_REFDIV = 0x00;
    
    CGMSYN_VCOFRQ1 = 0;
    CGMSYN_VCOFRQ0 = 1;
    
    /* Fref = OSCCLK/(REFDIV+1) = 4MHz/1 = 4MHz -> REFFRQ = 01b  */ 
    CGMREF_REFFRQ1 = 0;
    CGMREF_REFFRQ0 = 1;

    CGMCTL_DIV2 = 0;    /* DIV2=0 -> IPLL = Fvco  */ 

    CGMCTL_PLLON=1;     /* IPLL enabled */

        while(!CGMFLG_LOCK)
            ;       /* Wait until the PLL is within the desired frequency */
}

/*******************************************************************************/
/**
* \brief    CPU, XGATE, memory and ports settings
* \author   Jaime Orozco
* \param    void
* \return   void
*/
void vfnPeripheral_Settings(void)
{  
    /* Initialize the XGATE vector block and the XGVBR register */    
    XGVBR= (unsigned int)(void*__far)(XGATE_VectorTable - XGATE_VECTOR_OFFSET);    
    XGMCTL= 0xFBC1;     /* Enable XGATE mode and interrupts */
    
    /* FlexRay module access all memory */
    RAMFRL = 0x00;
    RAMFRU = 0xFF;
    
    /* COP module configuration */
    COPCTL = 0x00;              /* COP disable */ 
    
    MMCCTL1 = 1;    /* Enables Flash in the memory map */                  
    DIRECT = 0;     /* Default location for direct page */              
    IVBR = 0xFF;    /* Default vector base address */    
    
    
    /* Unused ports are configured as outputs set to zero */
    PORTA = 0;      /* Port A */
    DDRA = 0xFF;    
    PORTB = 0;      /* Port B */
    DDRB = 0xFF;    
    PORTC = 0;      /* Port C */
    DDRC = 0xFF;    
    PORTD = 0;      /* Port D */
    DDRC = 0xFF;
    PORTK = 0;      /* Port K  */
    DDRK= 0xFF;     
    RDRIV = 0xFF;   /* Reduced drive on ports A, B, C, D, E, K. */        
    
    
    /* Port E as input with pull-ups enabled */
    DDRE = 0;       
    PUCR_PUPEE = 1;            
        
        
    /* Port T low nibble used for general purpose LEDs D26 to D29 */     
    PTT = 0x0F;         /* Initial output state */     
    RDRT = 0xFF;        /* Reduced drive */
    DDRT = 0x7F;        /* PT7 as input, remaining pins are outputs */      
    PPST_PPST7 = 0;     /* Pull-up enabled for input pin PT7 */
    PERT_PERT7 = 1; 
    
    
    /* Port S outputs cleared, the signals assigned to SPI0 */
    /* are configured when enabling the SPI0 module */
    PTS = 0;        
    DDRS = 0xFF;    
    RDRS = 0xFF;  
         
         
    /* Unused ports are configured as outputs set to zero and reduced drive */    
    PTP = 0;        /* Port P */
    DDRP = 0xFF;
    RDRP = 0xFF; 
    
    
    /* Port H outputs 3 and 7 are used to enable FlexRay Transceivers TJA1080 */ 
    /* the other pins are configured by the FlexRay module */               
    DDRH_DDRH3 = 1;    
    DDRH_DDRH7 = 1;    
    RDRH = 0xFF;     /* Reduced drive */        
    PERH = 0;        /* Pull devices disabled */
    PTH = 0x88;      /* FlexRay Transceivers enabled */
    
    
    /* Port J inputs 5 and 6 receive signals from FlexRay transceivers */
    PTJ = 0;
    DDRJ_DDRJ5 = 0;    
    DDRJ_DDRJ6 = 0;     
    PERJ = 0;        /* Pull devices disabled */ 
      
                        
    /* Port AD0 unused, outputs set to zero */      
    PT0AD = 0;           
    RDR0AD = 0xFF;  
    DDR0AD = 0xFF;   
    
    
    /* PortAD1 used for general purpose LEDs D22 to D25 */ 
    PT1AD = 0x0F;   /* Initial output state */ 
    RDR1AD = 0xFF;  /* Reduced drive */
    DDR1AD = 0xFF;  /* Port AD as output */        
}


/*******************************************************************************/
/**
* \brief    Interrupts configuration
* \author   Jaime Orozco
* \param    void
* \return   void
*/
void vfnInterrupts_Init(void)
{
    /* Access to configuration data registers for interrupts */ 
    INT_CFADDR = 0xF0;  /* Vectors from 0xFFF0 to 0xFFF8 */  
    INT_CFDATA0 = 0x06; /* Real Time Interrupt, priority 6 */    
    
    INT_CFADDR = 0xE0;  /* Vectors from 0xFFE0 to 0xFFE8 */
    INT_CFDATA0 = 0x84; /* Input Capture channel 7 assigned to XGATE, priority 4 */
    
    INT_CFADDR = 0x70;  /* Vectors from 0xFF70 to 0xFF78 */
    INT_CFDATA1 = 0x84; /* Software trigger 0 for XGATE, priority 4 */
        
    TIOS_IOS7 = 0;      /* Channel 7 configured as input capture */    
    TCTL3_EDG7B = 1;    /* Channel 7 input capture enabled in falling edges */    
    TCTL3_EDG7A = 0;                             
    
    ICSYS = 0;          /* Input capture channels in normal mode */
    PACTL = 0;          /* Pulse acumulator disabled */                                      
                                
    RTICTL_RTDEC = 1;   /* Real time interrupt decimal divider */                                                                      
    RTICTL_RTR = 0x55;  /* Divider = 300x10^3; RTI period=300k/4MHz = 75 ms */  
                        
    TSCR2 = 4;          /* Set timer prescaler to 16 */
  
    TFLG1_C7F = 1;      /* Clear input capture 7 interrupt request flag */
    TIE_C7I = 1;        /* Interrupt enabled for Timer channel 7 */
        
    XIRQ_ENABLE();      /* Enable XIRQ */   
    
    CRGFLG_RTIF = 1;    /* Clear real time interrupt flag */    
    CRGINT_RTIE = 1;    /* Enable real time interrupt */    
    TSCR1_TEN = 1;      /* Timer enable */
}

/*******************************************************************************/
