#ifndef MGT5200_USB_H
#define MGT5200_USB_H

/*
* (C) Copyright Motorola, Inc., 2000
*     All rights reserved.
*
* Module Name: usb.h
* Description: tabasco usb header file
* Rev History: see "cvs log usb.h"
*
* usb.h,v 1.5 2001/06/18 18:58:30 weintrit Exp
*
*/
 
typedef struct {
	volatile uint32  HcRevision;              /* MBAR + 1000 */
	volatile uint32  HcControl;               /* MBAR + 1004 */
	volatile uint32  HcCommandStatus;         /* MBAR + 1008 */
	volatile uint32  HcInterruptStatus;       /* MBAR + 100C */
	volatile uint32  HcInterruptEnable;       /* MBAR + 1010 */
	volatile uint32  HcInterruptDisable;      /* MBAR + 1014 */
	volatile uint32  HcHCCA;                  /* MBAR + 1018 */
	volatile uint32  HcPeriodCurrentED;       /* MBAR + 101C */
	volatile uint32  HcControlHeadED;         /* MBAR + 1020 */
	volatile uint32  HcControlCurrentED;      /* MBAR + 1024 */
	volatile uint32  HcBulkHeadED;            /* MBAR + 1028 */
	volatile uint32  HcBulkCurrentED;         /* MBAR + 102C */
	volatile uint32  HcDoneHead;              /* MBAR + 1030 */
	volatile uint32  HcFmInterval;            /* MBAR + 1034 */
	volatile uint32  HcFmRemaining;           /* MBAR + 1038 */
	volatile uint32  HcFmNumber;              /* MBAR + 103C */
	volatile uint32  HcPeriodicStart;         /* MBAR + 1040 */
	volatile uint32  HcLSThreshold;           /* MBAR + 1044 */
	volatile uint32  HcRhDescriptorA;         /* MBAR + 1048 */
	volatile uint32  HcRhDescriptorB;         /* MBAR + 104C */
	volatile uint32  HcRhStatus;              /* MBAR + 1050 */
	volatile uint32  HcRhPort1Status;         /* MBAR + 1054 */
	volatile uint32  HcRhPort2Status;         /* MBAR + 1058 */
} OHCI_regs;

#define OHCI_HC_REVISION_REV_MASK		0x000000FFUL

#define OHCI_HC_CONTROL_CBSR_11			0x00000000UL
#define OHCI_HC_CONTROL_CBSR_21			0x00000001UL
#define OHCI_HC_CONTROL_CBSR_31			0x00000002UL
#define OHCI_HC_CONTROL_CBSR_41			0x00000003UL
#define OHCI_HC_CONTROL_CBSR_MASK		0x00000003UL
#define OHCI_HC_CONTROL_PLE				0x00000004UL
#define OHCI_HC_CONTROL_IE				0x00000008UL
#define OHCI_HC_CONTROL_CLE				0x00000010UL
#define OHCI_HC_CONTROL_BLE				0x00000020UL
#define OHCI_HC_CONTROL_HCFS_RESET		0x00000000UL
#define OHCI_HC_CONTROL_HCFS_RESUME		0x00000040UL
#define OHCI_HC_CONTROL_HCFS_OPERAT		0x00000080UL
#define OHCI_HC_CONTROL_HCFS_SUSPEND	0x000000C0UL
#define OHCI_HC_CONTROL_HCFS_MASK       0x000000C0UL
#define OHCI_HC_CONTROL_IR				0x00000100UL
#define OHCI_HC_CONTROL_RWC				0x00000200UL
#define OHCI_HC_CONTROL_RWE				0x00000400UL

#define OHCI_HC_CMDSTAT_HCR				0x00000001UL
#define OHCI_HC_CMDSTAT_CLF				0x00000002UL
#define OHCI_HC_CMDSTAT_BLF				0x00000004UL
#define OHCI_HC_CMDSTAT_OCR				0x00000008UL
#define OHCI_HC_CMDSTAT_SOC_MASK		0x00000300UL

#define OHCI_HC_INTSTAT_SO				0x00000001UL
#define OHCI_HC_INTSTAT_WDH				0x00000002UL
#define OHCI_HC_INTSTAT_SF				0x00000004UL
#define OHCI_HC_INTSTAT_RD				0x00000008UL
#define OHCI_HC_INTSTAT_UE				0x00000010UL
#define OHCI_HC_INTSTAT_FNO				0x00000020UL
#define OHCI_HC_INTSTAT_RHSC			0x00000040UL
#define OHCI_HC_INTSTAT_OC				0x40000000UL

#define OHCI_HC_INTEN_SO				0x00000001UL
#define OHCI_HC_INTEN_WDH				0x00000002UL
#define OHCI_HC_INTEN_SF				0x00000004UL
#define OHCI_HC_INTEN_RD				0x00000008UL
#define OHCI_HC_INTEN_UE				0x00000010UL
#define OHCI_HC_INTEN_FNO				0x00000020UL
#define OHCI_HC_INTEN_RHSC				0x00000040UL
#define OHCI_HC_INTEN_OC				0x40000000UL
#define OHCI_HC_INTEN_MIE				0x80000000UL

#define OHCI_HC_INTDIS_SO				0x00000001UL
#define OHCI_HC_INTDIS_WDH				0x00000002UL
#define OHCI_HC_INTDIS_SF				0x00000004UL
#define OHCI_HC_INTDIS_RD				0x00000008UL
#define OHCI_HC_INTDIS_UE				0x00000010UL
#define OHCI_HC_INTDIS_FNO				0x00000020UL
#define OHCI_HC_INTDIS_RHSC				0x00000040UL
#define OHCI_HC_INTDIS_OC				0x40000000UL
#define OHCI_HC_INTDIS_MIE				0x80000000UL

#define OHCI_HC_FMINTERVAL_FI_MASK		0x00003FFFUL
#define OHCI_HC_FMINTERVAL_FSMPS_MASK	0x7FFF0000UL
#define OHCI_HC_FMINTERVAL_FSMPS_SHIFT	16
#define OHCI_HC_FMINTERVAL_FIT			0x80000000UL

#define OHCI_HC_FMREM_FR_MASK			0x00003FFFUL
#define OHCI_HC_FMREM_FRT				0x80000000UL

#define OHCI_HC_FMNUMBER_FN				0x0000FFFFUL

#define OHCI_HC_PERSTART_PS_MASK		0x00003FFFUL

#define OHCI_HC_LSTTHRESH_LST_MASK		0x00000FFFUL

#define OHCI_HC_RHDESCA_NDP_MASK		0x000000FFUL
#define OHCI_HC_RHDESCA_PSM				0x00000100UL
#define OHCI_HC_RHDESCA_NPS				0x00000200UL
#define OHCI_HC_RHDESCA_DT				0x00000400UL
#define OHCI_HC_RHDESCA_OCPM			0x00000800UL
#define OHCI_HC_RHDESCA_NOCP			0x00001000UL
#define OHCI_HC_RHDESCA_POTPGT_MASK		0xFF000000UL
#define OHCI_HC_RHDESCA_POTPGT_SHIFT	24

#define OHCI_HC_RHDESCB_DR_PORT1		0x00000002UL
#define OHCI_HC_RHDESCB_DR_PORT2		0x00000004UL
#define OHCI_HC_RHDESCB_DR_MASK			0x0000FFFFUL
#define OHCI_HC_RHDESCB_PPCM_PORT1		0x00020000UL
#define OHCI_HC_RHDESCB_PPCM_PORT2		0x00040000UL
#define OHCI_HC_RHDESCB_PPCM_MASK		0xFFFF0000UL

#define OHCI_HC_RHSTAT_LPS				0x00000001UL
#define OHCI_HC_RHSTAT_OCI				0x00000002UL
#define OHCI_HC_RHSTAT_DRWE				0x00008000UL
#define OHCI_HC_RHSTAT_LPSC				0x00010000UL
#define OHCI_HC_RHSTAT_OCIC				0x00020000UL
#define OHCI_HC_RHSTAT_CRWE				0x80000000UL

#define OHCI_HC_RHPSTAT_CCS				0x00000001UL
#define OHCI_HC_RHPSTAT_PES				0x00000002UL
#define OHCI_HC_RHPSTAT_PSS				0x00000004UL
#define OHCI_HC_RHPSTAT_POCI			0x00000008UL
#define OHCI_HC_RHPSTAT_PRS				0x00000010UL
#define OHCI_HC_RHPSTAT_PPS				0x00000100UL
#define OHCI_HC_RHPSTAT_LSDA			0x00000200UL
#define OHCI_HC_RHPSTAT_CSC				0x00010000UL
#define OHCI_HC_RHPSTAT_PESC			0x00020000UL
#define OHCI_HC_RHPSTAT_PSSC			0x00040000UL
#define OHCI_HC_RHPSTAT_OCIC			0x00080000UL
#define OHCI_HC_RHPSTAT_PRSC			0x00100000UL

#endif /* MGT5200_USB_H */

