#ifndef MGT5200_SDRAM_H
#define MGT5200_SDRAM_H

/*
* (C) Copyright Motorola, Inc., 2000
*     All rights reserved.
*
* Module Name: sdram.h
* Description: tabasco sdram header file
* Rev History: see "cvs log sdram.h"
*
* sdram.h,v 1.6 2001/03/23 16:53:14 jharms Exp
*
*/

typedef struct sdram_register_set {
	volatile uint16   mode;          /* MBAR_SDRAM + 0x00 */
	volatile uint16   rsvd0;         /* MBAR_SDRAM + 0x02 */
	volatile uint32   control;       /* MBAR_SDRAM + 0x04 */
	volatile uint32   config1;       /* MBAR_SDRAM + 0x08 */
	volatile uint32   config2;       /* MBAR_SDRAM + 0x0c */
	volatile uint8    rsvd1;         /* MBAR_SDRAM + 0x10 */
} sdram_regs;

#define SDRAM_MODE_DDR_NORM_OP	0x0000
#define SDRAM_MODE_DDR_RST_DLL	0x0400
#define SDRAM_MODE_DDR_CAS_2	0x0080
#define SDRAM_MODE_DDR_CAS_25	0x0180
#define SDRAM_MODE_DDR_BT_SEQ	0x0000
#define SDRAM_MODE_DDR_BL_8		0x000C

#define SDRAM_MODE_EMODE		0x4000
#define SDRAM_EMODE_DDR_DDL_DIS	0x0004
#define SDRAM_EMODE_DDR_DRV_RED	0x0008

#define SDRAM_MODE_SDR_CAS_2	0x0080
#define SDRAM_MODE_SDR_CAS_3	0x00C0
#define SDRAM_MODE_SDR_BT_SEQ	0x0000
#define SDRAM_MODE_SDR_BL_8		0x000C

#define SDRAM_MODE_CMD			0x0001

#define SDRAM_CONTROL_MODE_EN		0x80000000UL
#define SDRAM_CONTROL_CKE			0x40000000UL
#define SDRAM_CONTROL_DDR			0x20000000UL
#define SDRAM_CONTROL_REF_EN		0x10000000UL
#define SDRAM_CONTROL_HI_ADDR		0x01000000UL
#define SDRAM_CONTROL_DRIVE_RULE	0x00400000UL
#define SDRAM_CONTROL_REFI_MASK		0x003F0000UL
#define SDRAM_CONTROL_REFI_SHIFT	16
#define SDRAM_CONTROL_DQS_OE3		0x00000800UL
#define SDRAM_CONTROL_DQS_OE2		0x00000400UL
#define SDRAM_CONTROL_DQS_OE1		0x00000200UL
#define SDRAM_CONTROL_DQS_OE0		0x00000100UL
#define SDRAM_CONTROL_SOFT_REF		0x00000004UL
#define SDRAM_CONTROL_SOFT_PRE		0x00000002UL

#define SDRAM_CONFIG1_SRD2RWP_MASK	0xF0000000UL
#define SDRAM_CONFIG1_SRD2RWP_SHIFT	28
#define SDRAM_CONFIG1_SWT2RWP_MASK	0x07000000UL
#define SDRAM_CONFIG1_SWT2RWP_SHIFT	24
#define SDRAM_CONFIG1_RD_LAT_MASK	0x00F00000UL
#define SDRAM_CONFIG1_RD_LAT_SHIFT	20
#define SDRAM_CONFIG1_ACT2RW_MASK	0x00070000UL
#define SDRAM_CONFIG1_ACT2RW_SHIFT	16
#define SDRAM_CONFIG1_PRE2ACT_MASK	0x00007000UL
#define SDRAM_CONFIG1_PRE2ACT_SHIFT	12
#define SDRAM_CONFIG1_REF2ACT_MASK	0x00000F00UL
#define SDRAM_CONFIG1_REF2ACT_SHIFT	8
#define SDRAM_CONFIG1_WR_LAT_MASK	0x00000070UL
#define SDRAM_CONFIG1_WR_LAT_SHIFT	4

#define SDRAM_CONFIG2_BRD2RP_MASK	0xF0000000UL
#define SDRAM_CONFIG2_BRD2RP_SHIFT	28
#define SDRAM_CONFIG2_BWT2RWP_MASK	0x0F000000UL
#define SDRAM_CONFIG2_BWT2RWP_SHIFT	24
#define SDRAM_CONFIG2_BRD2WT_MASK	0x00F00000UL
#define SDRAM_CONFIG2_BRD2WT_SHIFT	20
#define SDRAM_CONFIG2_BURST_MASK	0x000F0000UL
#define SDRAM_CONFIG2_BURST_SHIFT	16

#endif /* MGT5200_SDRAM_H */
