#ifndef MGT5200_SCLPC_H
#define MGT5200_SCLPC_H

/*
* (C) Copyright Motorola, Inc., 2000
*     All rights reserved.
*
* Module Name: sclpc.h
* Description: odin sclpc header file
* Rev History: see "cvs log sclpc.h"
*
* $Id: sclpc.h,v 1.1 2005/07/08 20:15:57 ra6707 Exp $
*
*/

typedef struct sclpc_register_set {
	volatile uint32 packet_size;		     /* MBAR_SCLPC + 0x00 */
	volatile uint32 start_address;		     /* MBAR_SCLPC + 0x04 */
	volatile uint32 control;			     /* MBAR_SCLPC + 0x08 */
	volatile uint32 enable;			         /* MBAR_SCLPC + 0x0C */
	volatile uint32 next_address;		     /* MBAR_SCLPC + 0x10 */
	volatile uint32 bytes_done;		         /* MBAR_SCLPC + 0x14 */
	volatile uint32 RES1[10];		         /* MBAR_SCLPC + 0x18 */

	/*Fifo Data registers begin*/
	volatile uint32 fifo_data;               /* MBAR_SCLPC + 0x40 */
	volatile uint8  fifo_status_frame;       /* MBAR_SCLPC + 0x44 */
	volatile uint8  fifo_status;             /* MBAR_SCLPC + 0x45 */
	volatile uint16 RES2[1];                 /* MBAR_SCLPC + 0x46 */
	volatile uint8  fifo_control;            /* MBAR_SCLPC + 0x48 */
	volatile uint8  RES3[5];                 /* MBAR_SCLPC + 0x49 */
	volatile uint16 fifo_alarm;		         /* MBAR_SCLPC + 0x4E */
	volatile uint16 RES4;                    /* MBAR_SCLPC + 0x50 */
	volatile uint16 fifo_rdp;                /* MBAR_SCLPC + 0x52 */
	volatile uint16 RES5;                    /* MBAR_SCLPC + 0x54 */
	volatile uint16 fifo_wrp;                /* MBAR_SCLPC + 0x56 */
	volatile uint16 RES6;                    /* MBAR_SCLPC + 0x58 */
	volatile uint16 fifo_lfrdp;              /* MBAR_SCLPC + 0x5A */
	volatile uint16 RES7;                    /* MBAR_SCLPC + 0x5C */
	volatile uint16 fifo_lfwrp;              /* MBAR_SCLPC + 0x5E */

	/*Final 8 registers are reserved*/
	volatile uint32 RES8[8];		         /*MBAR_SCLPC + 0x60 */
} sclpc_regs;

#endif /* MGT5200_SCLPC_H */
