#ifndef MGT5200_MSCAN_H
#define MGT5200_MSCAN_H

/*
* (C) Copyright Motorola, Inc., 2000
*     All rights reserved.
*
* Module Name: mscan.h
* Description: tabasco mcsan header file
* Rev History: see "cvs log mscan.h"
*
* mscan.h,v 1.2 2000/08/30 06:05:17 stahl Exp
*
*/

typedef struct mscan_register_set {
/*======================================================*/
/* register map for mscan1*/
/*======================================================*/
	volatile uint8  can1ctl0;         /* MBAR_MSCAN + 0x00*/
	volatile uint8  can1ctl1;         /* MBAR_MSCAN + 0x01*/
	volatile uint16 RES1;             /* MBAR_MSCAN + 0x02*/
	volatile uint8  can1btr0;         /* MBAR_MSCAN + 0x04*/
	volatile uint8  can1btr1;         /* MBAR_MSCAN + 0x05*/
	volatile uint16 RES2;             /* MBAR_MSCAN + 0x06*/
	volatile uint8  can1rflg;         /* MBAR_MSCAN + 0x08*/
	volatile uint8  can1rier;         /* MBAR_MSCAN + 0x09*/
	volatile uint16 RES3;             /* MBAR_MSCAN + 0x0a*/
	volatile uint8  can1tflg;         /* MBAR_MSCAN + 0x0c*/
	volatile uint8  can1tier;         /* MBAR_MSCAN + 0x0d*/
	volatile uint16 RES4;             /* MBAR_MSCAN + 0x0e*/
	volatile uint8  can1tarq;         /* MBAR_MSCAN + 0x10*/
	volatile uint8  can1taak;         /* MBAR_MSCAN + 0x11*/
	volatile uint16 RES5;             /* MBAR_MSCAN + 0x12*/
	volatile uint8  can1tbsel;        /* MBAR_MSCAN + 0x14*/
	volatile uint8  can1idac;         /* MBAR_MSCAN + 0x15*/
	volatile uint16 RES6;             /* MBAR_MSCAN + 0x16*/
	volatile uint8  can1test;         /* MBAR_MSCAN + 0x18*/
	volatile uint8  can1reservedd;    /* MBAR_MSCAN + 0x19*/
	volatile uint16 RES7;             /* MBAR_MSCAN + 0x1a*/
	volatile uint8  can1rxerr;        /* MBAR_MSCAN + 0x1c*/
	volatile uint8  can1txerr;        /* MBAR_MSCAN + 0x1d*/
	volatile uint16 RES8;             /* MBAR_MSCAN + 0x1e*/
	volatile uint8  can1idar0;        /* MBAR_MSCAN + 0x20*/
	volatile uint8  can1idar1;        /* MBAR_MSCAN + 0x21*/
	volatile uint16 RES9;             /* MBAR_MSCAN + 0x22*/
	volatile uint8  can1idar2;        /* MBAR_MSCAN + 0x24*/
	volatile uint8  can1idar3;        /* MBAR_MSCAN + 0x25*/
	volatile uint16 RES10;            /* MBAR_MSCAN + 0x26*/
	volatile uint8  can1idmr0;        /* MBAR_MSCAN + 0x28*/
	volatile uint8  can1idmr1;        /* MBAR_MSCAN + 0x29*/
	volatile uint16 RES11;            /* MBAR_MSCAN + 0x2a*/
	volatile uint8  can1idmr2;        /* MBAR_MSCAN + 0x2c*/
	volatile uint8  can1idmr3;        /* MBAR_MSCAN + 0x2d*/
	volatile uint16 RES12;            /* MBAR_MSCAN + 0x2e*/
	volatile uint8  can1idar4;        /* MBAR_MSCAN + 0x30*/
	volatile uint8  can1idar5;        /* MBAR_MSCAN + 0x31*/
	volatile uint16 RES13;            /* MBAR_MSCAN + 0x32*/
	volatile uint8  can1idar6;        /* MBAR_MSCAN + 0x34*/
	volatile uint8  can1idar7;        /* MBAR_MSCAN + 0x35*/
	volatile uint16 RES14;            /* MBAR_MSCAN + 0x36*/
	volatile uint8  can1idmr4;        /* MBAR_MSCAN + 0x38*/
	volatile uint8  can1idmr5;        /* MBAR_MSCAN + 0x39*/
	volatile uint16 RES15;            /* MBAR_MSCAN + 0x3a*/
	volatile uint8  can1idmr6;        /* MBAR_MSCAN + 0x3c*/
	volatile uint8  can1idmr7;        /* MBAR_MSCAN + 0x3d*/
	volatile uint16 RES16;            /* MBAR_MSCAN + 0x3e*/
	volatile uint8  can1rxidr0;       /* MBAR_MSCAN + 0x40*/
	volatile uint8  can1rxidr1;       /* MBAR_MSCAN + 0x41*/
	volatile uint16 RES17;            /* MBAR_MSCAN + 0x42*/
	volatile uint8  can1rxidr2;       /* MBAR_MSCAN + 0x44*/
	volatile uint8  can1rxidr3;       /* MBAR_MSCAN + 0x45*/
	volatile uint16 RES18;            /* MBAR_MSCAN + 0x46*/
	volatile uint8  can1rxdsr0;       /* MBAR_MSCAN + 0x48*/
	volatile uint8  can1rxdsr1;       /* MBAR_MSCAN + 0x49*/
	volatile uint16 RES19;            /* MBAR_MSCAN + 0x4a*/
	volatile uint8  can1rxdsr2;       /* MBAR_MSCAN + 0x4c*/
	volatile uint8  can1rxdsr3;       /* MBAR_MSCAN + 0x4d*/
	volatile uint16 RES20;            /* MBAR_MSCAN + 0x4e*/
	volatile uint8  can1rxdsr4;       /* MBAR_MSCAN + 0x50*/
	volatile uint8  can1rxdsr5;       /* MBAR_MSCAN + 0x51*/
	volatile uint16 RES21;            /* MBAR_MSCAN + 0x52*/
	volatile uint8  can1rxdsr6;       /* MBAR_MSCAN + 0x54*/
	volatile uint8  can1rxdsr7;       /* MBAR_MSCAN + 0x55*/
	volatile uint16 RES22;            /* MBAR_MSCAN + 0x56*/
	volatile uint8  can1rxdlr;        /* MBAR_MSCAN + 0x58*/
	volatile uint8  can1reserved2d;   /* MBAR_MSCAN + 0x59*/
	volatile uint16 RES23;            /* MBAR_MSCAN + 0x5a*/
	volatile uint8  can1rxtimh;       /* MBAR_MSCAN + 0x5c*/
	volatile uint8  can1rxtiml;       /* MBAR_MSCAN + 0x5d*/
	volatile uint16 RES24;            /* MBAR_MSCAN + 0x5e*/
	volatile uint8  can1txidr0;       /* MBAR_MSCAN + 0x60*/
	volatile uint8  can1txidr1;       /* MBAR_MSCAN + 0x61*/
	volatile uint16 RES25;            /* MBAR_MSCAN + 0x62*/
	volatile uint8  can1txidr2;       /* MBAR_MSCAN + 0x64*/
	volatile uint8  can1txidr3;       /* MBAR_MSCAN + 0x65*/
	volatile uint16 RES26;            /* MBAR_MSCAN + 0x66*/
	volatile uint8  can1txdsr0;       /* MBAR_MSCAN + 0x68*/
	volatile uint8  can1txdsr1;       /* MBAR_MSCAN + 0x69*/
	volatile uint16 RES27;            /* MBAR_MSCAN + 0x6a*/
	volatile uint8  can1txdsr2;       /* MBAR_MSCAN + 0x6c*/
	volatile uint8  can1txdsr3;       /* MBAR_MSCAN + 0x6d*/
	volatile uint16 RES28;            /* MBAR_MSCAN + 0x6e*/
	volatile uint8  can1txdsr4;       /* MBAR_MSCAN + 0x70*/
	volatile uint8  can1txdsr5;       /* MBAR_MSCAN + 0x71*/
	volatile uint16 RES29;            /* MBAR_MSCAN + 0x72*/
	volatile uint8  can1txdsr6;       /* MBAR_MSCAN + 0x74*/
	volatile uint8  can1txdsr7;       /* MBAR_MSCAN + 0x75*/
	volatile uint16 RES30;            /* MBAR_MSCAN + 0x76*/
	volatile uint8  can1txdlr;        /* MBAR_MSCAN + 0x78*/
	volatile uint8  can1txtbpr;       /* MBAR_MSCAN + 0x79*/
	volatile uint16 RES31;            /* MBAR_MSCAN + 0x7a*/
	volatile uint8  can1txtimh;       /* MBAR_MSCAN + 0x7c*/
	volatile uint8  can1txtiml;       /* MBAR_MSCAN + 0x7d*/
	volatile uint16 RES32;            /* MBAR_MSCAN + 0x7e*/

/*======================================================*/
/* register map for mscan2*/
/*======================================================*/
	volatile uint8  can2ctl0;         /* MBAR_MSCAN + 0x80*/
	volatile uint8  can2ctl1;         /* MBAR_MSCAN + 0x81*/
	volatile uint16 RES33;            /* MBAR_MSCAN + 0x82*/
	volatile uint8  can2btr0;         /* MBAR_MSCAN + 0x84*/
	volatile uint8  can2btr1;         /* MBAR_MSCAN + 0x85*/
	volatile uint16 RES34;            /* MBAR_MSCAN + 0x86*/
	volatile uint8  can2rflg;         /* MBAR_MSCAN + 0x88*/
	volatile uint8  can2rier;         /* MBAR_MSCAN + 0x89*/
	volatile uint16 RES35;            /* MBAR_MSCAN + 0x8a*/
	volatile uint8  can2tflg;         /* MBAR_MSCAN + 0x8c*/
	volatile uint8  can2tier;         /* MBAR_MSCAN + 0x8d*/
	volatile uint16 RES36;            /* MBAR_MSCAN + 0x8e*/
	volatile uint8  can2tarq;         /* MBAR_MSCAN + 0x90*/
	volatile uint8  can2taak;         /* MBAR_MSCAN + 0x91*/
	volatile uint16 RES37;            /* MBAR_MSCAN + 0x92*/
	volatile uint8  can2tbsel;        /* MBAR_MSCAN + 0x94*/
	volatile uint8  can2idac;         /* MBAR_MSCAN + 0x95*/
	volatile uint16 RES38;            /* MBAR_MSCAN + 0x96*/
	volatile uint8  can2test;         /* MBAR_MSCAN + 0x98*/
	volatile uint8  can2reservedd;    /* MBAR_MSCAN + 0x99*/
	volatile uint16 RES39;            /* MBAR_MSCAN + 0x9a*/
	volatile uint8  can2rxerr;        /* MBAR_MSCAN + 0x9c*/
	volatile uint8  can2txerr;        /* MBAR_MSCAN + 0x9d*/
	volatile uint16 RES40;            /* MBAR_MSCAN + 0x9e*/
	volatile uint8  can2idar0;        /* MBAR_MSCAN + 0xa0*/
	volatile uint8  can2idar1;        /* MBAR_MSCAN + 0xa1*/
	volatile uint16 RES41;            /* MBAR_MSCAN + 0xa2*/
	volatile uint8  can2idar2;        /* MBAR_MSCAN + 0xa4*/
	volatile uint8  can2idar3;        /* MBAR_MSCAN + 0xa5*/
	volatile uint16 RES42;            /* MBAR_MSCAN + 0xa6*/
	volatile uint8  can2idmr0;        /* MBAR_MSCAN + 0xa8*/
	volatile uint8  can2idmr1;        /* MBAR_MSCAN + 0xa9*/
	volatile uint16 RES43;            /* MBAR_MSCAN + 0xaa*/
	volatile uint8  can2idmr2;        /* MBAR_MSCAN + 0xac*/
	volatile uint8  can2idmr3;        /* MBAR_MSCAN + 0xad*/
	volatile uint16 RES44;            /* MBAR_MSCAN + 0xae*/
	volatile uint8  can2idar4;        /* MBAR_MSCAN + 0xb0*/
	volatile uint8  can2idar5;        /* MBAR_MSCAN + 0xb1*/
	volatile uint16 RES45;            /* MBAR_MSCAN + 0xb2*/
	volatile uint8  can2idar6;        /* MBAR_MSCAN + 0xb4*/
	volatile uint8  can2idar7;        /* MBAR_MSCAN + 0xb5*/
	volatile uint16 RES46;            /* MBAR_MSCAN + 0xb6*/
	volatile uint8  can2idmr4;        /* MBAR_MSCAN + 0xb8*/
	volatile uint8  can2idmr5;        /* MBAR_MSCAN + 0xb9*/
	volatile uint16 RES47;            /* MBAR_MSCAN + 0xba*/
	volatile uint8  can2idmr6;        /* MBAR_MSCAN + 0xbc*/
	volatile uint8  can2idmr7;        /* MBAR_MSCAN + 0xbd*/
	volatile uint16 RES48;            /* MBAR_MSCAN + 0xbe*/
	volatile uint8  can2rxidr0;       /* MBAR_MSCAN + 0xc0*/
	volatile uint8  can2rxidr1;       /* MBAR_MSCAN + 0xc1*/
	volatile uint16 RES49;            /* MBAR_MSCAN + 0xc2*/
	volatile uint8  can2rxidr2;       /* MBAR_MSCAN + 0xc4*/
	volatile uint8  can2rxidr3;       /* MBAR_MSCAN + 0xc5*/
	volatile uint16 RES50;            /* MBAR_MSCAN + 0xc6*/
	volatile uint8  can2rxdsr0;       /* MBAR_MSCAN + 0xc8*/
	volatile uint8  can2rxdsr1;       /* MBAR_MSCAN + 0xc9*/
	volatile uint16 RES51;            /* MBAR_MSCAN + 0xca*/
	volatile uint8  can2rxdsr2;       /* MBAR_MSCAN + 0xcc*/
	volatile uint8  can2rxdsr3;       /* MBAR_MSCAN + 0xcd*/
	volatile uint16 RES52;            /* MBAR_MSCAN + 0xce*/
	volatile uint8  can2rxdsr4;       /* MBAR_MSCAN + 0xd0*/
	volatile uint8  can2rxdsr5;       /* MBAR_MSCAN + 0xd1*/
	volatile uint16 RES53;            /* MBAR_MSCAN + 0xd2*/
	volatile uint8  can2rxdsr6;       /* MBAR_MSCAN + 0xd4*/
	volatile uint8  can2rxdsr7;       /* MBAR_MSCAN + 0xd5*/
	volatile uint16 RES54;            /* MBAR_MSCAN + 0xd6*/
	volatile uint8  can2rxdlr;        /* MBAR_MSCAN + 0xd8*/
	volatile uint8  can2reserved2d;   /* MBAR_MSCAN + 0xd9*/
	volatile uint16 RES55;            /* MBAR_MSCAN + 0xda*/
	volatile uint8  can2rxtimh;       /* MBAR_MSCAN + 0xdc*/
	volatile uint8  can2rxtiml;       /* MBAR_MSCAN + 0xdd*/
	volatile uint16 RES56;            /* MBAR_MSCAN + 0xde*/
	volatile uint8  can2txidr0;       /* MBAR_MSCAN + 0xe0*/
	volatile uint8  can2txidr1;       /* MBAR_MSCAN + 0xe1*/
	volatile uint16 RES57;            /* MBAR_MSCAN + 0xe2*/
	volatile uint8  can2txidr2;       /* MBAR_MSCAN + 0xe4*/
	volatile uint8  can2txidr3;       /* MBAR_MSCAN + 0xe5*/
	volatile uint16 RES58;            /* MBAR_MSCAN + 0xe6*/
	volatile uint8  can2txdsr0;       /* MBAR_MSCAN + 0xe8*/
	volatile uint8  can2txdsr1;       /* MBAR_MSCAN + 0xe9*/
	volatile uint16 RES59;            /* MBAR_MSCAN + 0xea*/
	volatile uint8  can2txdsr2;       /* MBAR_MSCAN + 0xec*/
	volatile uint8  can2txdsr3;       /* MBAR_MSCAN + 0xed*/
	volatile uint16 RES60;            /* MBAR_MSCAN + 0xee*/
	volatile uint8  can2txdsr4;       /* MBAR_MSCAN + 0xf0*/
	volatile uint8  can2txdsr5;       /* MBAR_MSCAN + 0xf1*/
	volatile uint16 RES61;            /* MBAR_MSCAN + 0xf2*/
	volatile uint8  can2txdsr6;       /* MBAR_MSCAN + 0xf4*/
	volatile uint8  can2txdsr7;       /* MBAR_MSCAN + 0xf5*/
	volatile uint16 RES62;            /* MBAR_MSCAN + 0xf6*/
	volatile uint8  can2txdlr;        /* MBAR_MSCAN + 0xf8*/
	volatile uint8  can2txtbpr;       /* MBAR_MSCAN + 0xf9*/
	volatile uint16 RES63;            /* MBAR_MSCAN + 0xfa*/
	volatile uint8  can2txtimh;       /* MBAR_MSCAN + 0xfc*/
	volatile uint8  can2txtiml;       /* MBAR_MSCAN + 0xfd*/
	volatile uint16 RES64;            /* MBAR_MSCAN + 0xfe*/
} mscan_regs;

#endif /* MGT5200_MSCAN_H */
