#ifndef MGT5200_INT_CTRL_H
#define MGT5200_INT_CTRL_H

/*
* (C) Copyright Motorola, Inc., 2000
*     All rights reserved.
*
* Module Name: int_ctrl.h
* Description: tabasco interrupt controller header file
* Rev History: see "cvs log int_ctrl.h"
*
* int_ctrl.h,v 1.6 2000/12/06 23:32:45 weintrit Exp
*
*/

typedef struct int_ctrl_register_set {
	volatile uint32   pimsk;     /* MBAR_INT_CTRL + 0x00 */
	volatile uint32   prisel1;   /* MBAR_INT_CTRL + 0x04 */
	volatile uint32   prisel2;   /* MBAR_INT_CTRL + 0x08 */
	volatile uint32   prisel3;   /* MBAR_INT_CTRL + 0x0c */
	volatile uint32   irqctl;    /* MBAR_INT_CTRL + 0x10 */
	volatile uint32   cprimmsk;  /* MBAR_INT_CTRL + 0x14 */
	volatile uint32   mpri1;     /* MBAR_INT_CTRL + 0x18 */
	volatile uint32   mpri2;     /* MBAR_INT_CTRL + 0x1c */
	volatile uint32   RES1;      /* MBAR_INT_CTRL + 0x20 */
	volatile uint32   istaec;    /* MBAR_INT_CTRL + 0x24 */
	volatile uint8    cstab;     /* MBAR_INT_CTRL + 0x28 */
	volatile uint8    RES2[3];   /* MBAR_INT_CTRL + 0x29 */
	volatile uint32   mstab;     /* MBAR_INT_CTRL + 0x2c */
	volatile uint32   pstab;     /* MBAR_INT_CTRL + 0x30 */
	volatile uint32   RES3;      /* MBAR_INT_CTRL + 0x34 */
	volatile uint8    been;      /* MBAR_INT_CTRL + 0x38 */
	volatile uint8    RES4[3];   /* MBAR_INT_CTRL + 0x39 */
	volatile uint32   RES5;      /* MBAR_INT_CTRL + 0x3c */
	volatile uint32   test1;     /* MBAR_INT_CTRL + 0x40 */
	volatile uint32   test2;     /* MBAR_INT_CTRL + 0x44 */
	volatile uint8    test3;     /* MBAR_INT_CTRL + 0x48 */
	volatile uint8    RES6[3];   /* MBAR_INT_CTRL + 0x49 */
} int_ctrl_regs;

#define PIMSK_BESTCOMM		0x80000000UL
#define PIMSK_PSC1			0x40000000UL
#define PIMSK_PSC2			0x20000000UL
#define PIMSK_PSC3			0x10000000UL
#define PIMSK_PSC6			0x08000000UL
#define PIMSK_ETHERNET		0x04000000UL
#define PIMSK_USB			0x02000000UL
#define PIMSK_ATA			0x01000000UL
#define PIMSK_PCI			0x00800000UL
#define PIMSK_PCI_BC_RX		0x00400000UL
#define PIMSK_PCI_BC_TX		0x00200000UL
#define PIMSK_PSC4			0x00100000UL
#define PIMSK_PSC5			0x00080000UL
#define PIMSK_SPI_MODF		0x00040000UL
#define PIMSK_SPI_SPIF		0x00020000UL
#define PIMSK_I2C1			0x00010000UL
#define PIMSK_I2C2			0x00008000UL
#define PIMSK_CAN1			0x00004000UL
#define PIMSK_CAN2			0x00002000UL
#define PIMSK_IR_RX			0x00001000UL
#define PIMSK_IR_TX			0x00000800UL
#define PIMSK_XLB_ARB		0x00000400UL
#define PIMSK_BDLC			0x00000200UL
#define PIMSK_BC_LP			0x00000100UL

#define IRQCTL_ECLR0			0x08000000UL
#define IRQCTL_ECLR1			0x04000000UL
#define IRQCTL_ECLR2			0x02000000UL
#define IRQCTL_ECLR3			0x01000000UL
#define IRQCTL_ETYPE0_MASK		0x00C00000UL
#define IRQCTL_ETYPE0_HIGH		0x00000000UL
#define IRQCTL_ETYPE0_RISE		0x00400000UL
#define IRQCTL_ETYPE0_FALL		0x00800000UL
#define IRQCTL_ETYPE0_LOW		0x00C00000UL
#define IRQCTL_ETYPE1_MASK		0x00300000UL
#define IRQCTL_ETYPE1_HIGH		0x00000000UL
#define IRQCTL_ETYPE1_RISE		0x00100000UL
#define IRQCTL_ETYPE1_FALL		0x00200000UL
#define IRQCTL_ETYPE1_LOW		0x00300000UL
#define IRQCTL_ETYPE2_MASK		0x000C0000UL
#define IRQCTL_ETYPE2_HIGH		0x00000000UL
#define IRQCTL_ETYPE2_RISE		0x00040000UL
#define IRQCTL_ETYPE2_FALL		0x00080000UL
#define IRQCTL_ETYPE2_LOW		0x000C0000UL
#define IRQCTL_ETYPE3_MASK		0x00030000UL
#define IRQCTL_ETYPE3_HIGH		0x00000000UL
#define IRQCTL_ETYPE3_RISE		0x00010000UL
#define IRQCTL_ETYPE3_FALL		0x00020000UL
#define IRQCTL_ETYPE3_LOW		0x00030000UL
#define IRQCTL_MEE				0x00001000UL
#define IRQCTL_EENA0			0x00000800UL
#define IRQCTL_EENA1			0x00000400UL
#define IRQCTL_EENA2			0x00000200UL
#define IRQCTL_EENA3			0x00000100UL
#define IRQCTL_CE				0x00000001UL

#define MSTAB_SLICE_TIMER2		0x00010000UL
#define MSTAB_IRQ1				0x00008000UL
#define MSTAB_IRQ2				0x00004000UL
#define MSTAB_IRQ3				0x00002000UL
#define MSTAB_LO_INT			0x00001000UL
#define MSTAB_RTC_PERIODIC		0x00000800UL
#define MSTAB_RTC_STOPWATCH		0x00000400UL
#define MSTAB_GPIO_STD			0x00000200UL
#define MSTAB_GPIO_WAKEUP		0x00000100UL
#define MSTAB_TMR0				0x00000080UL
#define MSTAB_TMR1				0x00000040UL
#define MSTAB_TMR2				0x00000020UL
#define MSTAB_TMR3				0x00000010UL
#define MSTAB_TMR4				0x00000008UL
#define MSTAB_TMR5				0x00000004UL
#define MSTAB_TMR6				0x00000002UL
#define MSTAB_TMR7				0x00000001UL

#define PSTAB_BC_LP				0x00800000UL
#define PSTAB_BDLC				0x00400000UL
#define PSTAB_BESTCOMM			0x00200000UL
#define PSTAB_PSC1				0x00100000UL
#define PSTAB_PSC2				0x00080000UL
#define PSTAB_PSC3				0x00040000UL
#define PSTAB_PSC6				0x00020000UL
#define PSTAB_ETHERNET			0x00010000UL
#define PSTAB_USB				0x00008000UL
#define PSTAB_ATA				0x00004000UL
#define PSTAB_PCI				0x00002000UL
#define PSTAB_PCI_BC_RX			0x00001000UL
#define PSTAB_PCI_BC_TX			0x00000800UL
#define PSTAB_PSC4				0x00000400UL
#define PSTAB_PSC5				0x00000200UL
#define PSTAB_SPI_MODF			0x00000100UL
#define PSTAB_SPI_SPIF			0x00000080UL
#define PSTAB_I2C1				0x00000040UL
#define PSTAB_I2C2				0x00000020UL
#define PSTAB_CAN1				0x00000010UL
#define PSTAB_CAN2				0x00000008UL
#define PSTAB_IR_RX				0x00000004UL
#define PSTAB_IR_TX				0x00000002UL
#define PSTAB_XLB_ARB			0x00000001UL

#endif /* MGT5200_INT_CTRL_H */
