#ifndef MGT5200_GPIO_STD_H
#define MGT5200_GPIO_STD_H

/*
* (C) Copyright Motorola, Inc., 2000
*     All rights reserved.
*
* Module Name: gpio_std.h
* Description: tabasco standard gpio header file
* Rev History: see "cvs log gpio_std.h"
*
* gpio_std.h,v 1.4 2001/07/24 17:50:51 weintrit Exp
*
*/

typedef struct gpio_std_register_set {
	volatile uint32 port_config;     /* MBAR_GPIO_STD + 0x00 */
	volatile uint32 simple_gpioe;    /* MBAR_GPIO_STD + 0x04 */
	volatile uint32 simple_ode;      /* MBAR_GPIO_STD + 0x08 */
	volatile uint32 simple_ddr;      /* MBAR_GPIO_STD + 0x0c */
	volatile uint32 simple_dvo;      /* MBAR_GPIO_STD + 0x10 */
	volatile uint32 simple_ival;     /* MBAR_GPIO_STD + 0x14 */
	volatile uint8  outo_gpioe;      /* MBAR_GPIO_STD + 0x18 */
	volatile uint8  RES1[3];         /* MBAR_GPIO_STD + 0x19 */
	volatile uint8  outo_dvo;        /* MBAR_GPIO_STD + 0x1c */
	volatile uint8  RES2[3];         /* MBAR_GPIO_STD + 0x1d */
	volatile uint8  sint_gpioe;      /* MBAR_GPIO_STD + 0x20 */
	volatile uint8  RES3[3];         /* MBAR_GPIO_STD + 0x21 */
	volatile uint8  sint_ode;        /* MBAR_GPIO_STD + 0x24 */
	volatile uint8  RES4[3];         /* MBAR_GPIO_STD + 0x25 */
	volatile uint8  sint_ddr;        /* MBAR_GPIO_STD + 0x28 */
	volatile uint8  RES5[3];         /* MBAR_GPIO_STD + 0x29 */
	volatile uint8  sint_dvo;        /* MBAR_GPIO_STD + 0x2c */
	volatile uint8  RES6[3];         /* MBAR_GPIO_STD + 0x2d */
	volatile uint8  sint_inten;      /* MBAR_GPIO_STD + 0x30 */
	volatile uint8  RES7[3];         /* MBAR_GPIO_STD + 0x31 */
	volatile uint16 sint_itype;      /* MBAR_GPIO_STD + 0x34 */
	volatile uint16 RES8;            /* MBAR_GPIO_STD + 0x36 */
	volatile uint8  gpio_control;    /* MBAR_GPIO_STD + 0x38 */
	volatile uint8  RES9[3];         /* MBAR_GPIO_STD + 0x39 */
	volatile uint8  sint_istat;      /* MBAR_GPIO_STD + 0x3c */
	volatile uint8  sint_ival;       /* MBAR_GPIO_STD + 0x3d */
	volatile uint16 RES10;           /* MBAR_GPIO_STD + 0x3e */
} gpio_std_regs;

#define PORT_CONFIG_CS1				0x80000000UL
#define PORT_CONFIG_ALT_MASK		0x30000000UL
#define PORT_CONFIG_ALT_SPI			0x20000000UL
#define PORT_CONFIG_ALT_CAN			0x10000000UL
#define PORT_CONFIG_CS7				0x08000000UL
#define PORT_CONFIG_CS6				0x04000000UL
#define PORT_CONFIG_ATA_MASK		0x03000000UL
#define PORT_CONFIG_ATA_TMR01		0x03000000UL
#define PORT_CONFIG_ATA_I2C2		0x02000000UL
#define PORT_CONFIG_ATA_CS45		0x01000000UL
#define PORT_CONFIG_IR_USB_CLK		0x00800000UL
#define PORT_CONFIG_IRDA_MASK		0x00700000UL
#define PORT_CONFIG_IRDA_111		0x00700000UL
#define PORT_CONFIG_IRDA_110		0x00600000UL
#define PORT_CONFIG_IRDA_101		0x00500000UL
#define PORT_CONFIG_IRDA_100		0x00400000UL
#define PORT_CONFIG_IRDA_011		0x00300000UL
#define PORT_CONFIG_IRDA_010		0x00200000UL
#define PORT_CONFIG_IRDA_001		0x00100000UL
#define PORT_CONFIG_IRDA_GPIO		0x00000000UL
#define PORT_CONFIG_ETHER_MASK		0x000F0000UL
#define PORT_CONFIG_ETHER_1100		0x000C0000UL
#define PORT_CONFIG_ETHER_1011		0x000B0000UL
#define PORT_CONFIG_ETHER_1010		0x000A0000UL
#define PORT_CONFIG_ETHER_1001		0x00090000UL
#define PORT_CONFIG_ETHER_1000		0x00080000UL
#define PORT_CONFIG_ETHER_0101		0x00050000UL
#define PORT_CONFIG_ETHER_0100		0x00040000UL
#define PORT_CONFIG_ETHER_0011		0x00030000UL
#define PORT_CONFIG_ETHER_0010		0x00020000UL
#define PORT_CONFIG_ETHER_0001		0x00010000UL
#define PORT_CONFIG_ETHER_GPIO		0x00000000UL
#define PORT_CONFIG_PCI_DIS			0x00008000UL
#define PORT_CONFIG_USB_SE			0x00004000UL
#define PORT_CONFIG_USB_MASK		0x00003000UL
#define PORT_CONFIG_USB_UART		0x00002000UL
#define PORT_CONFIG_USB_USB			0x00001000UL
#define PORT_CONFIG_USB_GPIO		0x00000000UL
#define PORT_CONFIG_PSC3_MASK		0x00000F00UL
#define PORT_CONFIG_PSC3_SPI		0x00000800UL
#define PORT_CONFIG_PSC3_CODEC_MCLK	0x00000700UL
#define PORT_CONFIG_PSC3_CODEC		0x00000600UL
#define PORT_CONFIG_PSC3_UARTE		0x00000500UL
#define PORT_CONFIG_PSC3_UART		0x00000400UL
#define PORT_CONFIG_PSC3_USB2		0x00000100UL
#define PORT_CONFIG_PSC3_GPIO		0x00000000UL
#define PORT_CONFIG_PSC2_MASK		0x00000070UL
#define PORT_CONFIG_PSC2_CODEC_MCLK	0x00000070UL
#define PORT_CONFIG_PSC2_CODEC		0x00000060UL
#define PORT_CONFIG_PSC2_UARTE		0x00000050UL
#define PORT_CONFIG_PSC2_UART		0x00000040UL
#define PORT_CONFIG_PSC2_AC97		0x00000020UL
#define PORT_CONFIG_PSC2_CAN		0x00000010UL
#define PORT_CONFIG_PSC2_GPIO		0x00000000UL
#define PORT_CONFIG_PSC1_MASK		0x00000007UL
#define PORT_CONFIG_PSC1_CODEC_MCLK	0x00000007UL
#define PORT_CONFIG_PSC1_CODEC		0x00000006UL
#define PORT_CONFIG_PSC1_UARTE		0x00000005UL
#define PORT_CONFIG_PSC1_UART		0x00000004UL
#define PORT_CONFIG_PSC1_AC97		0x00000002UL
#define PORT_CONFIG_PSC1_GPIO		0x00000000UL

#endif /* MGT5200_GPIO_STD_H */
