#ifndef MGT5200_ATA_H
#define MGT5200_ATA_H

/*
* (C) Copyright Motorola, Inc., 2000
*     All rights reserved.
*
* Module Name: ata.h
* Description: tabasco ata header file
* Rev History: see "cvs log ata.h"
*
* ata.h,v 1.28 2002/03/27 05:18:21 mughal Exp
*
*/

#define WORDS_PER_SECTOR	256

/* ATA register set */
typedef struct ata_register_set {
	/* [6:2]addr = 00  */
	volatile uint8 ata_config;		/* MBAR_ATA + 0x00 ATA configuration register */
	volatile uint8 ata_RES1[3];		/* MBAR_ATA + 0x01 3 8-bit reserved registers           */
	/* [6:2]addr = 01 */
	volatile uint8 ata_status;		/* MBAR_ATA + 0x04 ATA host controller status register */
	volatile uint8 ata_RES2[3];		/* MBAR_ATA + 0x05 3 8-bit reserved registers */
	/* [6:2]addr = 02 */
	volatile uint32 ata_pio1;
	/* [6:2]addr = 03 */
	volatile uint32 ata_pio2;
	/* [6:2]addr = 04 */
	volatile uint32 ata_dma1;
	/* [6:2]addr = 05 */
	volatile uint32 ata_dma2;
	/* [6:2]addr = 06 */
	volatile uint32 ata_udma1;
	/* [6:2]addr = 07 */
	volatile uint32 ata_udma2;
	/* [6:2]addr = 08 */
	volatile uint32 ata_udma3;
	/* [6:2]addr = 09 */
	volatile uint32 ata_udma4;
	/* [6:2]addr = 0a */
	volatile uint32 ata_udma5;
	/* [6:2]addr = 0b, 0c, 0d, 0e */
	volatile uint32 ata_invalid;	/* MBAR_ATA + 0x2c 4 32-bit reserved registers */
	volatile uint32 ata_RES6[3];	/* MBAR_ATA + 0x2d 4 32-bit reserved registers */
	/* [6:2]addr = 0f */
	volatile uint32 ata_fifo_data;	/* MBAR_ATA + 0x3c */
	/* [6:2]addr = 10 */
	volatile uint8 ata_fifo_status_frame;	/* MBAR_ATA + 0x40 */
	volatile uint8 ata_fifo_status;	/* MBAR_ATA + 0x41 */
	volatile uint16 ata_RES7[1];	/* MBAR_ATA + 0x42 3 8-bit reserved registers */
	/* [6:2]addr = 11 */
	volatile uint8 ata_fifo_control;/* MBAR_ATA + 0x44; */
	volatile uint8 ata_RES8[5];		/* MBAR_ATA + 0x45 3 8-bit reserved registers */
	volatile uint16 ata_fifo_alarm;	/* MBAR_ATA + 0x4a */
	/* [6:2]addr = 13 */
	volatile uint16 ata_RES9;		/* MBAR_ATA + 0x4c */
	volatile uint16 ata_fifo_rdp;	/* MBAR_ATA + 0x4e */
	/* [6:2]addr = 14 */
	volatile uint16 ata_RES10;		/* MBAR_ATA + 0x50 */
	volatile uint16 ata_fifo_wrp;	/* MBAR_ATA + 0x52 */
	/* [6:2]addr = 15 */
	volatile uint16 ata_RES11;		/* MBAR_ATA + 0x54 */
	volatile uint16 ata_fifo_lfrdp;	/* MBAR_ATA + 0x56 */
	/* [6:2]addr = 16 */
	volatile uint16 ata_RES12;		/* MBAR_ATA + 0x58 */
	volatile uint16 ata_fifo_lfwrp;	/* MBAR_ATA + 0x5a */
	/* [6:2]addr = 17 */
	volatile uint8 ata_drive_ctrl;	/* MBAR_ATA + 0x5c ATA drive control register */
	volatile uint8 ata_RES13[3];	/* MBAR_ATA + 0x5d 3 8-bit reserved registers */
	/* [6:2]addr = 18 */
	volatile uint16 ata_drive_data;	/* MBAR_ATA + 0x60 ATA drive data register (only 16 bit register on the drive) */
	volatile uint16 ata_RES14[1];	/* MBAR_ATA + 0x62 3 8-bit reserved registers */
	/* [6:2]addr = 19 */
	volatile uint8 ata_drive_ftr;	/* MBAR_ATA + 0x64 ATA drive features register */
	volatile uint8 ata_RES15[3];	/* MBAR_ATA + 0x65 3 8-bit reserved registers */
	/* [6:2]addr = 1a */
	volatile uint8 ata_drive_sc;	/* MBAR_ATA + 0x68 ATA drive sector count register */
	volatile uint8 ata_RES16[3];	/* MBAR_ATA + 0x69 3 8-bit reserved registers */
	/* [6:2]addr = 1b */
	volatile uint8 ata_drive_sn;	/* MBAR_ATA + 0x6c ATA drive sector number register */
	volatile uint8 ata_RES17[3];	/* MBAR_ATA + 0x6d 3 8-bit reserved registers */
	/* [6:2]addr = 1c */
	volatile uint8 ata_drive_cl;	/* MBAR_ATA + 0x70 ATA drive cylinder low register */
	volatile uint8 ata_RES18[3];	/* MBAR_ATA + 0x71 3 8-bit reserved registers */
	/* [6:2]addr = 1d */
	volatile uint8 ata_drive_ch;	/* MBAR_ATA + 0x74 ATA drive cylinder high register */
	volatile uint8 ata_RES19[3];	/* MBAR_ATA + 0x75 3 8-bit reserved registers */
	/* [6:2]addr = 1e */
	volatile uint8 ata_drive_dh;	/* MBAR_ATA + 0x78 ATA drive device/head register */
	volatile uint8 ata_RES20[3];	/* MBAR_ATA + 0x79 3 8-bit reserved registers */
	/* [6:2]addr = 1f */
	volatile uint8 ata_drive_cmd;	/* MBAR_ATA + 0x7c ATA drive command register */
	volatile uint8 ata_dma_mode;	/* MBAR_ATA + 0x7d ATA host dma mode configuration register */
	volatile uint16 ata_RES21[1];	/* MBAR_ATA + 0x7e 3 8-bit reserved registers */
} ata_regs;

/* ATA identify set     */
/* ATA/ATAPI-4, page 77 */
typedef struct ata_identify_set {
	uint16 general_config_bit;		/* General configuration bit */
	uint16 logical_cylinders;		/* Number of logical cylinders */
	uint16 RES1;					/* Reserved */
	uint16 logical_heads;			/* Number of logical heads */
	uint16 RES2[2];					/* Reserved */
	uint16 sectors_per_track;		/* Number of logical sectors per logical track */
	uint16 RES3[3];					/* Reserved */
	char serial_nr[20];				/* Serial number */
	uint16 RES4[3];					/* Reserved */
	char firmware[8];				/* Firmware revision */
	char model[40];					/* Model number */
	uint16 max_sectors_per_intrq;	/* Maximum number of sectors that shall be transferred per interrupt on READ/WRITE MULTIPLE commands */
	uint16 RES5;					/* Reserved */
	uint16 capabilities1;			/* Capabilities 1 */
	uint16 capabilities2;			/* Capabilities 2 */
	uint16 pio_mode;				/* PIO data transfer mode */
	uint16 RES6;					/* Reserved */
	uint16 valid_54_88;				/* Fields 54-58, 64-70, 88 are valid/invalid */
	uint16 current_cylinders;		/* Number of current logical sectors */
	uint16 current_heads;			/* Number of current logical heads */
	uint16 current_sectors_per_track;/* Number of current logical sectors per track */
	uint16 current_capacity[2];		/* Current capacity in sectors */
	uint16 multiple_sector_flag;	/* Flags for multiple sectors setting */
	uint16 adressable_sectors[2];	/* Total number of user addressable sectors */
	uint16 RES7;					/* Reserved */
	uint16 MDMA_flags;				/* Multiword DMA flags */
	uint16 advanced_PIO_flags;		/* Advanced PIO modes supported */
	uint16 MDMA_cycle_per_word;		/* Minimum Multiword DMA transfer cycle time per word */
	uint16 MDMA_cycle_time;			/* Manufecturer's recommended MDMA transfer cycle time */
	uint16 PIO_cycle_time;			/* Minimum PIO transfer cycle time without flow control */
	uint16 PIO_IORDY_cycle_time;	/* Minimum PIO transfer cycle time with IORDY flow control */
	uint16 RES8[2];					/* Reserved */
	uint16 RES9[4];					/* Reserved for IDENTIFY PACKET DEVICE command */
	uint16 queue_depth;				/* Queue depth */
	uint16 RES10[4];				/* Reserved */
	uint16 major_ver;				/* Major version number */
	uint16 minor_ver;				/* Minor version number */
	uint16 cmd_set1;				/* Command set supported */
	uint16 cmd_set2;				/* Command sets supported */
	uint16 cmd_ftr_sup;				/* Command set/feature supported extension */
	uint16 cmd_ftr_en1;				/* Command set/feature 1 enabled */
	uint16 cmd_ftr_en2;				/* Command set/feature 2 enabled */
	uint16 cmd_ftr_default;			/* Command set/feature default */
	uint16 UDMA_flags;				/* Ultra DMA flags */
	uint16 security_erase;			/* Time required for security erase completion */
	uint16 security_erase_enh;		/* Time required for Enhanced security erase completion */
	uint16 current_apm;				/* Current advanced power management value */
	uint16 RES11[35];				/* reserved */
	uint16 removable_ftr_set;		/* Removable Media Status notification feature set support */
	uint16 security_status;			/* Security status */
	uint16 RES12[31];				/* Vendor specific */
	uint16 RES13[90];				/* Reserved */
} ata_identify;

/* ----------- ATA command codes ------------- */
#define ATA_NOP									0x00
#define ATA_CFA_REQUEST_EXTENDED_ERROR_CODE		0x03
#define ATA_DEVICE_RESET						0x08
#define ATA_READ_SECTOR							0x20
#define ATA_WRITE_SECTOR						0x30
#define ATA_WRITE_SECTORS_WITHOUT_ERASE			0x38
#define ATA_READ_VERIFY_SECTOR					0x41
#define ATA_SEEK								0x70
#define ATA_CFA_TRANSLATE_SECTOR				0x87
#define ATA_EXECUTE_DEVICE_DIAGNOSTIC			0x90
#define ATA_INITIALIZE_DEVICE_PARAMETERS		0x91
#define ATA_DOWNLOAD_MICROCODE					0x92
#define ATA_PACKET								0xa0
#define ATA_IDENTIFY_PACKET_DEVICE				0xa1
#define ATA_SERVICE								0xa2
#define ATA_SMART_DISABLE_OPERATIONS			0xb0
#define ATA_CFA_ERASE_SECTORS					0xc0
#define ATA_READ_MULTIPLE						0xc4
#define ATA_WRITE_MULTIPLE						0xc5
#define ATA_SET_MULTIPLE_MODE					0xc6
#define	ATA_READ_DMA_QUEUED						0xc7
#define ATA_READ_DMA							0xc8
#define ATA_WRITE_DMA							0xca
#define ATA_WRITE_DMA_QUEUED					0xcc
#define ATA_CFA_WRITE_MULTIPLE_WITHOUT_ERASE	0xcd
#define ATA_GET_MEDIA_STATUS					0xda
#define ATA_MEDIA_LOCK							0xde
#define ATA_MEDIA_UNLOCK						0xdf
#define ATA_STANDBY_IMMEDIATE					0xe0
#define ATA_IDLE_IMMEDIATE						0xe1
#define ATA_STANDBY								0xe2
#define ATA_IDLE								0xe3
#define ATA_READ_BUFFER							0xe4
#define ATA_CHECK_POWER_MODE					0xe5
#define ATA_SLEEP								0xe6
#define ATA_FLUSH_CACHE							0xe7
#define ATA_WRITE_BUFFER						0xe8
#define ATA_IDENTIFY_DEVICE						0xec
#define ATA_MEDIA_EJECT							0xed
#define ATA_SET_FEATURES						0xef
#define ATA_SECURITY_SET_PASSWORD				0xf1
#define ATA_SECURITY_UNLOCK						0xf2
#define ATA_SECURITY_ERASE_PREPARE				0xf3
#define ATA_SECURITY_ERASE_UNIT					0xf4
#define ATA_SECURITY_DISABLE_PASSWORD			0xf6
#define ATA_READ_NATIVE_MAX_ADDRESS				0xf8

/* ------- ATA SET FEATURES definitions -------- */
/* ATA/ATAPI-4, page 161                         */
#define ATA_FTR_EN_WR_CACHE						0x02
#define ATA_FTR_SET_TRANSFER_MODE				0x03
#define ATA_FTR_EN_ADV_PWR_MGMNT				0x05
#define	ATA_FTR_DIS_MEDIA_STATUS_NFY			0x31
#define ATA_FTR_DIS_LOOK_AHEAD					0x55
#define ATA_FTR_EN_RELEASE_INTERRRUPT			0x5d
#define ATA_FTR_EN_SERVICE_INTERRUPT			0x5e
#define ATA_FTR_DIS_REVERTING_TO_POWER			0x66
#define ATA_FTR_DIS_WRITE_CACHE					0x82
#define ATA_FTR_DIS_ADV_PWR_MGMNT				0x85
#define ATA_FTR_EN_MEDIA_STATUS_NFY				0x95
#define ATA_FTR_EN_LOOK_AHEAD					0xaa
#define	ATA_FTR_EN_REVERTING_TO_POWER			0xcc
#define	ATA_FTR_DIS_RELEASE_INTERRUPT			0xdd
#define ATA_FTR_DIS_SERVICE_INTERRUPT			0xde

/* ------------- ATA transfer mode ------------- */
/* ATA/ATAPI-4, page 164                         */
#define ATA_MODE_PIO_DEFAULT					0x00
#define ATA_MODE_PIO_NO_IORDY					0x01
#define ATA_MODE_PIO_FLOW_CONTROL				0x08
#define ATA_MODE_MDMA							0x20
#define ATA_MODE_UDMA							0x40


/*  ----------- ATA DMA control register ------------- */
/* ///////////////////////////////////////////////////////////////// */
/*                                                                // */
/*                ata_dma_mode register bit config.               // */
/*        -------------------------------------------------       // */
/*        |  7  |  6  |  5  |  4  |  3  |  2  |  1  |  0  |       // */
/*        -------------------------------------------------       // */
/*        | PIE | HUT |  FR |  FE |  IE | UMB |  RD |  WR |       // */
/*        -------------------------------------------------       // */
/*        PIE -> ext pause Int. En, HUT -> Host UDMA terminate    // */
/*        FR  -> Soft FIFO Reset    FE  -> FIFO Flush Enable      // */
/*        IE  -> Interrupt Enable   UMB -> UDMA(1)/MDMA(0)        // */
/*        RD  -> Read               WR  -> Write                  // */
/*                                                                // */
/* ///////////////////////////////////////////////////////////////// */

/*  ----------- ATA Chip Selects Routing ------------------------- */
#define ATA_NOT_PRESENT  0x00000000
#define ATA_CS_ON_CS45   0x01000000
#define ATA_CS_ON_I2C2   0x02000000
#define ATA_CS_ON_TMR01  0x03000000

/***************/
/*  Bitfields  */
/***************/
/* ATA Host Status Register */
#define ATA_BIT_HOST_TIP	0x80	/* Transaction in Progress */
#define ATA_BIT_HOST_UREP	0x40	/* UDMA Read Extended Pause */
#define ATA_BIT_HOST_RERR	0x02	/* Read Error */
#define ATA_BIT_HOST_WERR	0x01	/* Write Error */
/* ATA Host Configuration Register */
#define ATA_BIT_HOST_SMR	0x80	/* State Machine Reset */
#define ATA_BIT_HOST_FR		0x40	/* FIFO Reset */
#define ATA_BIT_HOST_IE		0x02	/* Interrupt Enable (PIO modes) */
#define ATA_BIT_HOST_IORDY	0x01	/* IO Ready (required for PIO mode 3 and above) */
/* ATA Rx/Tx FIFO Status Register */
#define ATA_BIT_FIFO_ERR	0x40	/* Error */
#define ATA_BIT_FIFO_UF		0x20	/* Underflow */
#define ATA_BIT_FIFO_OF		0x10	/* Overflow */
#define ATA_BIT_FIFO_FULL	0x08	/* Full */
#define ATA_BIT_FIFO_HI		0x04	/* High */
#define ATA_BIT_FIFO_LO		0x02	/* Low */
#define ATA_BIT_FIFO_EMPTY	0x01	/* Empty */
/* ATA Rx/Tx FIFO Control Register */
/* ATA Drive Device Control Register */
#define ATA_BIT_DRIVE_SRST	0x04	/* Software Reset */
#define ATA_BIT_DRIVE_NIEN	0x02	/* Interrupt Enable */
/* ATA Drive Alternate Status Register */
#define ATA_BIT_DRIVE_BSY	0x80	/* Drive Busy */
#define ATA_BIT_DRIVE_DRDY	0x40	/* Drive Ready */
#define ATA_BIT_DRIVE_DRQ	0x08	/* Drive Request */
#define ATA_BIT_DRIVE_ERR	0x01	/* Drive Error */
/* ATA Drive Error Register */
#define ATA_BIT_DRIVE_ABRT	0x04	/* Abort (request command was aborted) */
/* ATA Drive Device Command/Status Register */
#define ATA_BIT_DRIVE_HUT	0x40	/* Host UDMA Burst Terminate */
#define ATA_BIT_DRIVE_FR	0x20	/* FIFO Reset */
#define ATA_BIT_DRIVE_FE	0x10	/* Enable FIFO Flush in Rx Mode */
#define ATA_BIT_DRIVE_IE	0x08	/* Interrupt Enable */
#define ATA_BIT_DRIVE_UDMA	0x04	/* 1=UDMA/0=MDMA */
#define ATA_BIT_DRIVE_READ	0x02	/* 1=when READ DMA command issued */
#define ATA_BIT_DRIVE_WRITE	0x01	/* 1=when WRITE DMA command issued */

#endif /* MGT5200_ATA_H */
