/** ###################################################################
**     Filename  : voltmeter_led.C
**     Project   : voltmeter_led
**     Processor : MC56F8006_48_LQFP
**     Version   : Driver 01.13
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 11/10/2008, 7:29 PM
**     Abstract  :
**           LED based voltmeter based on flashing leds in response to pot 
**         tied to adc input thru PGA (use variable flash duty cycles for off,
**         very dim, dim and bright). The key routine is AD1_OnEnd in events.c.
**           It will first do both offset & gain calibrations to get coefficient:
**         A = VDDA / [3 X (Vgain - Voffset)] Eqn. 6-12
**         B = VDDA X Voffset / [3 X (Vgain - Voffset)] Eqn. 6-13
**           Then start timer 0 to do acutal measurement thru PGA and change
**         LED luminance accordingly.
**           Before running the code, make sure the board power is down,
**         then connect a potentiometer with 
**         a series resistor to PGA- pin, draw a line to PGA+ 
**         from the middle of two series resistors with equal value.
**     Settings  :
**     Contents  :
**         No public methods
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/
/* MODULE voltmeter_led */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "AD1.h"
#include "PGA2.h"
#include "PWMC1.h"
#include "PDB1.h"
#include "Timer0.h"
#include "PC_M1.h"
#include "Inhr1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

// Function prototypes
void PGA_StartCalibration();

void main(void)
{
  /* Write your local variable definition here */

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  // Enable ADC H/W trigger
  setRegBit(ADC0_ADCSC2,ADTRG);

  // Start ADC
  AD1_Start();

  // Start PGA and calibration
  PGA_StartCalibration();
  
  for(;;) {}
}


/*
** ===================================================================
**     Method       :  PGA_StartCalibration 
**
**     Description :
**       This routine starts up PGA and triggers PGA with S/W to begin
**		 conversion.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/

void PGA_StartCalibration()
{
  // Enable PGA 
  PGA0_CNTL0 |= (PGA0_CNTL0_EN_MASK);
  
  asm
  {
  	nop
  	nop
  }
  
  // Wait for PGA to startup
  while(!(PGA0_STS & PGA0_STS_STCOMP_MASK))
  {  	
  }
    
  // Now it is time to trigger PGA by s/w
  PGA0_CNTL2 |= PGA0_CNTL2_SWTRIG_MASK;	
}

/* END voltmeter_led */
/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
