/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : AD1.H
**     Project   : voltmeter_led
**     Processor : MC56F8006_48_LQFP
**     Beantype  : ADC
**     Version   : Bean 01.499, Driver 01.00, CPU db: 3.00.177
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 11/12/2008, 11:38 AM
**     Abstract  :
**         This device "ADC" implements an A/D converter,
**         its control methods and interrupt/event handling procedure.
**     Settings  :
**         AD control register         : ADC0_ADCSC1A [F060]
**         AD control register         : ADC0_ADCSC2 [F061]
**         AD control register         : ADC0_ADCCFG [F066]
**         AD control register         : ADC0_ADCSC1B [F06A]
**         AD control register         : ADC0_ADCRA  [F06B]
**         AD control register         : ADC0_ADCRB  [F06C]
**         Interrupt name              : INT_ADC0_Complete
**         Priority                    : 0
**         User handling procedure     : AD1_OnEnd
**         Number of conversions       : 1
**         AD resolution               : 12-bit
**
**         Input pins
**
**
**         Initialization:
**              Conversion             : Enabled
**              Event                  : Enabled
**         High speed mode
**             Prescaler               : divide-by-8
**     Contents  :
**         Enable       - byte AD1_Enable(void);
**         Disable      - byte AD1_Disable(void);
**         Start        - byte AD1_Start(void);
**         Stop         - byte AD1_Stop(void);
**         Measure      - byte AD1_Measure(bool WaitForResult);
**         GetChanValue - byte AD1_GetChanValue(byte Channel, void* Value);
**         GetValue16   - byte AD1_GetValue16(word *Values);
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

#ifndef __AD1
#define __AD1

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

/* MODULE AD1. */

#include "Cpu.h"




#if defined(AD1_Interrupt_FAST_INT)
void AD1_Interrupt(void);
#else
void AD1_Interrupt(void);
#endif
/*
** ===================================================================
**     Method      :  AD1_Interrupt (bean ADC)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes event(s) of the bean.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

void AD1_HWEnDi(void);
/*
** ===================================================================
**     Method      :  AD1_HWEnDi (bean ADC)
**
**     Description :
**         Enables or disables the peripheral(s) associated with the bean.
**         The method is called automatically as a part of the Enable and 
**         Disable methods and several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/


byte AD1_Enable(void);
/*
** ===================================================================
**     Method      :  AD1_Enable (bean ADC)
**
**     Description :
**         Enables A/D converter bean. <Events> may be generated
**         (<DisableEvent>/<EnableEvent>). If possible, this method
**         switches on A/D converter device, voltage reference, etc.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

byte AD1_Disable(void);
/*
** ===================================================================
**     Method      :  AD1_Disable (bean ADC)
**
**     Description :
**         Disables A/D converter bean. No <events> will be generated.
**         If possible, this method switches off A/D converter device,
**         voltage reference, etc.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

byte AD1_Start(void);
/*
** ===================================================================
**     Method      :  AD1_Start (bean ADC)
**
**     Description :
**         This method starts continuous conversion on all channels
**         that are set in the bean inspector. When each measurement on
**         all channels has finished the <OnEnd > event may be invoked.
**         This method is not available if the <interrupt service> is
**         disabled and the device doesn't support the continuous mode.
**         Note: If time of measurement is too short and the
**         instruction clock is too slow then the conversion complete
**         interrupt and its handler may cause a system overflow.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_DISABLED - Device is disabled
**                           ERR_BUSY - A conversion is already running
** ===================================================================
*/

byte AD1_Stop(void);
/*
** ===================================================================
**     Method      :  AD1_Stop (bean ADC)
**
**     Description :
**         This method stops the continuous measurement or disables
**         a trigger mode (if supported by HW), which has been
**         started by one of the following methods:
**         Version specific information for Freescale 56800
**         derivatives ] 
**         - <Start> 
**         - <EnableIntTrigger>
**         - <EnableIntChanTrigger>
**         The Stop method is available if one of the previously
**         mentioned methods is supported by A/D converter device
**         and is enabled to be generated.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_BUSY - No continuous measurement is
**                           running. Neither internal trigger nor
**                           external trigger have been enabled (if
**                           these are supported by HW).
** ===================================================================
*/

byte AD1_Measure(bool WaitForResult);
/*
** ===================================================================
**     Method      :  AD1_Measure (bean ADC)
**
**     Description :
**         This method performs one measurement on all channels that
**         are set in the bean inspector. (Note: If the <number of
**         conversions> is more than one the conversion of A/D channels
**         is performed specified number of times.)
**     Parameters  :
**         NAME            - DESCRIPTION
**         WaitForResult   - Wait for a result of a
**                           conversion. If <interrupt service> is
**                           disabled, A/D peripheral doesn't support
**                           measuring all channels at once or Autoscan
**                           mode property isn't enabled and at the same
**                           time the <number of channel> is greater
**                           than 1, then the WaitForResult parameter is
**                           ignored and the method waits for each
**                           result every time. If the <interrupt
**                           service> is disabled and a <number of
**                           conversions> is greater than 1, the
**                           parameter is ignored and the method also
**                           waits for each result every time.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_DISABLED - Device is disabled
**                           ERR_BUSY - A conversion is already running
** ===================================================================
*/

#define AD1_GetChanValue(Ch,V) PE_AD1_GetChanValue(V)
byte PE_AD1_GetChanValue(void* Value);
/*
** ===================================================================
**     Method      :  AD1_GetChanValue (bean ADC)
**
**     Description :
**         Returns the last measured value of the required channel.
**         Format and width of the value is a native format of the A/D
**         converter.
**     Parameters  :
**         NAME            - DESCRIPTION
**         Channel         - Channel number. If only one
**                           channel in the bean is set then this
**                           parameter is ignored.
**       * Value           - Pointer to the measured value. Data
**                           type is a byte, a word or an int. It
**                           depends on the supported modes, resolution,
**                           etc. of the AD converter. See the Version
**                           specific information for the current CPU in
**                           <General Info>.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_NOTAVAIL - Requested value not
**                           available
**                           ERR_RANGE - Parameter "Channel" out of
**                           range
**                           ERR_OVERRUN - External trigger overrun flag
**                           was detected after the last value(s) was
**                           obtained (for example by GetValue). This
**                           error may not be supported on some CPUs
**                           (see generated code).
** ===================================================================
*/

byte AD1_GetValue16(word *Values);
/*
** ===================================================================
**     Method      :  AD1_GetValue16 (bean ADC)
**
**     Description :
**         This method returns the last measured values of all channels
**         justified to the left. Compared with <GetValue> method this
**         method returns more accurate result if the <number of
**         conversions> is greater than 1 and <AD resolution> is less
**         than 16 bits. In addition, the user code dependency on <AD
**         resolution> is eliminated.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Values          - Pointer to the array that contains
**                           the measured data.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
**                           ERR_NOTAVAIL - Requested value not
**                           available
**                           ERR_OVERRUN - External trigger overrun flag
**                           was detected after the last value(s) was
**                           obtained (for example by GetValue). This
**                           error may not be supported on some CPUs
**                           (see generated code).
** ===================================================================
*/

void AD1_Init(void);
/*
** ===================================================================
**     Method      :  AD1_Init (bean ADC)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/



/* END AD1. */

#endif /* ifndef __AD1 */
/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
