/** ###################################################################
**     Filename  : FirGeneration.C
**     Project   : FirGeneration
**     Processor : MC56F8006_48_LQFP
**     Version   : Driver 01.13
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 11/15/2008, 11:17 AM
**     Abstract  :
**         Main module.
**         This module contains user's application code.
**     Settings  :
**     Contents  :
**         No public methods
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/
/* MODULE FirGeneration */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "DFR1.h"
#include "MEM1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

// use const to output coefficients  to the data section to be placed in data memory.
 const
 #include "FirCoefs.h"
// Data samples represent sum of two sine waves with zero phase.
// Fs/4, and Fs/8 are the frequencies of the two.  They are of
// equal amplitude, 0.45.
// Sample zero is phase zero for both sine's. 
const Frac16 GeneratedSamples[] = {
	FRAC16(0.0),
	FRAC16(0.76819805153394638598037996294718),
	FRAC16(0.45),
	FRAC16(-0.131801948466053614019620037053),
	FRAC16(0.0),
	FRAC16(0.131801948466053614019620037053),
	FRAC16(-.45),
	FRAC16(-0.76819805153394638598037996294718)
};
Frac16 FirOutput[8] ;

void main(void)
{
 Frac16 * pC;
 dfr16_tFirStruct * pFIR;
 Frac16 * pX;
 Frac16 * pZ;

  /* Write your local variable definition here */

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  /* Write your code here */
  pC = (Frac16 *) FirCoefs ;
  pFIR =  DFR1_dfr16FIRCreate( pC,  31);
  pX = (Frac16 *) GeneratedSamples ;
  pZ = FirOutput ;

  for(;;) {
  DFR1_dfr16FIR( pFIR, pX, pZ,  8);
  }
}


/* END FirGeneration */
/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
