/** ###################################################################
**     Filename  : lab_tone_det.C
**     Project   : lab_tone_det
**     Processor : MC56F8006_48_LQFP
**     Version   : Driver 01.13
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 11/15/2008, 12:13 PM
**     Abstract  :
**         Main module.
**         This module contains user's application code.
**     Settings  :
**     Contents  :
**         No public methods
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/
/* MODULE lab_tone_det */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "DFR1.h"
#include "MEM1.h"
#include "Bits1.h"
#include "BTN1.h"
#include "Inhr1.h"
#include "FC1.h"
#include "TI1.h"
#include "AD1.h"
#include "AS1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"


#include "FreqDetector.h"

void TurnOnLed(UWord16 Led);
void TurnOffLed(UWord16 Led);

CFrac16 FFTInplaceBuf[MAX_RFFT_LEN/2];

UWord16 AdcBuffer[ADC_MAX_BUFFER_SIZE];
Word16 AdcWriteIndex = 0;
Word16 AdcReadIndex = 0;

volatile int DemoState;


volatile int test1;

void main(void)
{
    dfr16_tRFFTStruct RFFT;
    dfr16_tRFFTStruct *pRFFT = &RFFT;
    UInt16 options = FFT_SCALE_RESULTS_BY_N;
    Int16 res;
    UWord16  PerformFFT = false;
    Word16   i;
    Word32   Temp1,Temp2;
    UWord16  MaxFreqIndex;
    Word32   MaxFreqAmpl;
    UWord16  Led = 0;
    char     ch1;
    
   
    

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  /* Write your code here */

    DemoState = ON;

    /* INITIALIZE THE FFT ALGORITHM */

#if (MAX_RFFT_LEN == 8)
    dfr16RFFTInit (pRFFT, 8, options);
#elif (MAX_RFFT_LEN == 16)
    dfr16RFFTInit (pRFFT, 16, options);
#elif (MAX_RFFT_LEN == 32)
    dfr16RFFTInit (pRFFT, 32, options);
#elif (MAX_RFFT_LEN == 64)
    dfr16RFFTInit (pRFFT, 64, options);
#elif (MAX_RFFT_LEN == 128)
    dfr16RFFTInit (pRFFT, 128, options);
#elif (MAX_RFFT_LEN == 256)
    dfr16RFFTInit (pRFFT, 256, options);
#else
    #error RFFT SIZE IS INCORRECT
#endif


    Bits1_PutVal(0);


    while(1)
    {
        if (AdcReadIndex > AdcWriteIndex)
        {
            PerformFFT = true;
        }
        else if (AdcReadIndex <= (AdcWriteIndex-MAX_RFFT_LEN))
        {
            PerformFFT = true;
        }

        if (PerformFFT == true)
        {
            /* PERFORM FFT */

            res = dfr16RFFT (pRFFT, (Frac16 *) &AdcBuffer[AdcReadIndex], (dfr16_sInplaceCRFFT *) &FFTInplaceBuf[0]);

            if (res == FAIL)
            {
//				periphMemWrite(0xbf3f, &PWMA_PMOUT );
                while(1)
                {
                }
            }

            MaxFreqIndex = 0;
            MaxFreqAmpl = 0;

            Temp1 = abs_s(FFTInplaceBuf[0].real);
            Temp1 = Temp1*Temp1;

            MaxFreqAmpl = Temp1;

            for (i=1; i<=((MAX_RFFT_LEN/2)-1);i++)
            {
                Temp1 = abs_s(FFTInplaceBuf[i].real);
                Temp1 = Temp1*Temp1;
                Temp2 = abs_s(FFTInplaceBuf[i].imag);
                Temp2 = (Temp2*Temp2) + Temp1;

                if (Temp2 > MaxFreqAmpl)
                {
                    MaxFreqIndex = i;
                    MaxFreqAmpl = Temp2;
                }
            }

            Temp1 = abs_s(FFTInplaceBuf[0].imag);
            Temp1 = Temp1*Temp1;

            if (Temp1 > MaxFreqAmpl)
            {
                MaxFreqIndex = (MAX_RFFT_LEN/2) - 1;
                MaxFreqAmpl = Temp1;
            }


        
        
        ch1 = (MaxFreqIndex & 0x0F) + '0';
        
        
   
            
        AS1_SendChar( ch1 );
        
        

   
   /*        PUT MaxFreqIndex as  binary output  
   
            MaxFreqIndex = (MaxFreqIndex<<4) & 0xfff0;

            if (1) //(DemoState == ON)
            {
                for (i=0; i<=9; i++)
                {
                    if (MaxFreqIndex & 0x0001)
                    {
                        TurnOnLed(i);
                    }
                    else
                    {
                        TurnOffLed(i);
                    }
                    MaxFreqIndex = MaxFreqIndex>>1;
                }
            }
            
            */
            
            

            AdcReadIndex = AdcReadIndex+MAX_RFFT_LEN;

            if (AdcReadIndex >= ADC_MAX_BUFFER_SIZE)
            {
                AdcReadIndex = 0;
            }
            
            

            PerformFFT = false;
        }
    }

  for(;;) {}
}

/*****************************************************************************/

void TurnOnLed(UWord16 Led)
{
 Bits1_PutVal(0x25);

}

/*****************************************************************************/
void TurnOffLed(UWord16 Led)
{

 if (test1) 
 {
  Bits1_PutVal(0x02);	
  test1 =0;
 }
 else
 {
  Bits1_PutVal(0x04);	
  test1 =1;
 }

}

/* END FreqDetectorPE */
/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 03.30 for
**     the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
















