/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : TI1.C
**     Project   : lab_tone_det
**     Processor : MC56F8006_48_LQFP
**     Beantype  : TimerInt
**     Version   : Bean 02.157, Driver 02.00, CPU db: 3.00.177
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 11/15/2008, 12:59 PM
**     Abstract  :
**         This bean "TimerInt" implements a periodic interrupt.
**         When the bean and its events are enabled, the "OnInterrupt"
**         event is called periodically with the period that you specify.
**         TimerInt supports also changing the period in runtime.
**         The source of periodic interrupt can be timer compare or reload
**         register or timer-overflow interrupt (of free running counter).
**     Settings  :
**         Timer name                  : PIT (16-bit)
**         Compare name                : PIT_Modulo
**         Counter shared              : No
**
**         High speed mode
**             Prescaler               : divide-by-1
**             Clock                   : 32000000 Hz
**           Initial period/frequency
**             Xtal ticks              : 1000
**             microseconds            : 125
**             seconds (real)          : 0.000125
**             Hz                      : 8000
**             kHz                     : 8
**
**         Runtime setting             : none
**
**         Initialization:
**              Timer                  : Enabled
**              Events                 : Enabled
**
**         Timer registers
**              Counter                : PIT_CNTR  [F2E2]
**              Mode                   : PIT_CTRL  [F2E0]
**              Run                    : PIT_CTRL  [F2E0]
**              Prescaler              : PIT_CTRL  [F2E0]
**
**         Compare registers
**              Compare                : PIT_MOD   [F2E1]
**
**         Flip-flop registers
**     Contents  :
**         No public methods
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

/* MODULE TI1. */

#include "Events.h"
#include "TI1.h"



/* Internal method prototypes */
static void SetCV(word Val);
static void SetPV(byte Val);

/*
** ===================================================================
**     Method      :  SetCV (bean TimerInt)
**
**     Description :
**         Sets compare or preload register value. The method is called 
**         automatically as a part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetCV(word Val)
{
  setReg(PIT_MOD,Val);                 /* Store given value to the compare register */
}

/*
** ===================================================================
**     Method      :  SetPV (bean TimerInt)
**
**     Description :
**         Sets prescaler value. The method is called automatically as a 
**         part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetPV(byte Val)
{
  setRegBitGroup(PIT_CTRL,PRESCALER,Val); /* Store given value to the prescaler */
}

/*
** ===================================================================
**     Method      :  TI1_Init (bean TimerInt)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void TI1_Init(void)
{
  /* PIT_CTRL: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,PRESCALER=0,PRF=0,PRIE=1,CNT_EN=0 */
  setReg(PIT_CTRL,0x02);               /* Set up control register */
  SetCV((word)0x0FA0);                 /* Store appropriate value to the compare register according to the selected high speed CPU mode */
  SetPV((byte)0x00);                   /* Set prescaler register according to the selected high speed CPU mode */
  setRegBit(PIT_CTRL,CNT_EN);          /* Run counter */
}

/*
** ===================================================================
**     Method      :  TI1_Interrupt (bean TimerInt)
**
**     Description :
**         The method services the interrupt of the selected peripheral(s)
**         and eventually invokes the beans event(s).
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
#pragma interrupt alignsp saveall
void TI1_Interrupt(void)
{
  clrRegBit(PIT_CTRL,PRF);             /* Reset interrupt request flag */
  TI1_OnInterrupt();                   /* Invoke user event */
}

/* END TI1. */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
