/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : FC1.H
**     Project   : lab_tone_det
**     Processor : MC56F8006_48_LQFP
**     Beantype  : FreeCntr
**     Version   : Bean 01.093, Driver 02.01, CPU db: 3.00.177
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 11/15/2008, 12:56 PM
**     Abstract  :
**         This device "FreeCntr" implements a free running counter for
**         time measurement.
**     Settings  :
**         Timer name                  : TMR01 (32-bit)
**         Compare name                : TMR01_Compare
**         Counter shared              : No
**
**         High speed mode
**             Prescaler               : divide-by-1
**             Clock                   : 32000000 Hz
**           Period
**             Xtal ticks              : 400000
**             microseconds            : 50000
**             milliseconds            : 50
**             seconds (real)          : 0.05
**             Hz                      : 20
**           Frequency of counting (Bus clock / prescaler)
**             Hz                      : 32000000
**
**         Initialization:
**              Timer                  : Enabled
**
**         Timer registers
**              Counter                : TMR1_CNTR [F015]
**              Mode                   : TMR1_CTRL [F016]
**              Run                    : TMR1_CTRL [F016]
**              Prescaler              : TMR1_CTRL [F016]
**              Compare                : TMR1_COMP1 [F010]
**
**         Interrupt name              : INT_TMR1
**         Priority                    : 0
**         User handling procedure     : not specified
**     Contents  :
**         Reset           - byte FC1_Reset(void);
**         GetCounterValue - byte FC1_GetCounterValue(FC1_TTimerValue *Value);
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

#ifndef __FC1
#define __FC1

/* MODULE FC1. */

/*Include shared modules, which are used for whole project*/
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Cpu.h"

#ifndef __BWUserType_FC1_TTimerValue
#define __BWUserType_FC1_TTimerValue
  typedef dword FC1_TTimerValue;       /* Counter or compare value, width depend on timer width, 8, 16, 32 or 64 bits. */
#endif

#define FC1_PERIOD_VALUE   0x0020C350UL /* Initial period value in ticks of the timer. It is available only if the bean is enabled in high speed mode. */
#define FC1_PERIOD_VALUE_HIGH 0x0020C350UL /* Period value in ticks of the timer in high speed mode. It is available only if the bean is enabled in high speed mode. */
#define FC1_PRESCALER_VALUE 0x01UL     /* Initial prescaler value of the timer. It is available only if the bean is enabled in high speed mode. */
#define FC1_PRESCALER_VALUE_HIGH 0x01UL /* Prescaler value of the timer in high speed mode. It is available only if the bean is enabled in high speed mode. */
#define FC1_COUNTER_INPUT_CLOCK_HIGH 0x01E84800UL /* Counter input clock value in high speed mode [Hz] (integer number). It is available only if the bean is enabled in high speed mode. */
#define FC1_COUNTER_INPUT_CLOCK 0x01E84800UL /* Initial counter input clock value [Hz] (integer number). It is available only if the bean is enabled in high speed mode. */
/* Deprecated constants */
#define FC1_FChigh         0x01E84800UL /* Frequency of counting in high speed CPU mode */

byte FC1_Reset(void);
/*
** ===================================================================
**     Method      :  FC1_Reset (bean FreeCntr)
**
**     Description :
**         This method resets the timer-counter (sets to zero for
**         up-counting HW or to appropriate value for down-counting HW).
**         The method is available only if the counter register can be
**         written and the counter is not shared.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

byte FC1_GetCounterValue(FC1_TTimerValue *Value);
/*
** ===================================================================
**     Method      :  FC1_GetCounterValue (bean FreeCntr)
**
**     Description :
**         This method returns a content of counter.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Value           - A pointer to the returned 32-bit value.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/

void FC1_Init(void);
/*
** ===================================================================
**     Method      :  FC1_Init (bean FreeCntr)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/

/* END FC1. */

#endif /* ifndef __FC1 */
/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
