/** ###################################################################
**     THIS BEAN MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : FC1.C
**     Project   : lab_tone_det
**     Processor : MC56F8006_48_LQFP
**     Beantype  : FreeCntr
**     Version   : Bean 01.093, Driver 02.01, CPU db: 3.00.177
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 11/15/2008, 12:56 PM
**     Abstract  :
**         This device "FreeCntr" implements a free running counter for
**         time measurement.
**     Settings  :
**         Timer name                  : TMR01 (32-bit)
**         Compare name                : TMR01_Compare
**         Counter shared              : No
**
**         High speed mode
**             Prescaler               : divide-by-1
**             Clock                   : 32000000 Hz
**           Period
**             Xtal ticks              : 400000
**             microseconds            : 50000
**             milliseconds            : 50
**             seconds (real)          : 0.05
**             Hz                      : 20
**           Frequency of counting (Bus clock / prescaler)
**             Hz                      : 32000000
**
**         Initialization:
**              Timer                  : Enabled
**
**         Timer registers
**              Counter                : TMR1_CNTR [F015]
**              Mode                   : TMR1_CTRL [F016]
**              Run                    : TMR1_CTRL [F016]
**              Prescaler              : TMR1_CTRL [F016]
**              Compare                : TMR1_COMP1 [F010]
**
**         Interrupt name              : INT_TMR1
**         Priority                    : 0
**         User handling procedure     : not specified
**     Contents  :
**         Reset           - byte FC1_Reset(void);
**         GetCounterValue - byte FC1_GetCounterValue(FC1_TTimerValue *Value);
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/

/* MODULE FC1. */

#include "FC1.h"


/* Internal method prototypes */
static void SetCV(word Val0, word Val1);
static void SetPV(byte Val);

/*
** ===================================================================
**     Method      :  SetCV (bean FreeCntr)
**
**     Description :
**         Sets compare or preload register value. The method is called 
**         automatically as a part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetCV(word Val0, word Val1)
{
  EnterCritical();                     /* Disable global interrupts */
  setReg(TMR1_CMPLD1,Val1);            /* Store given value to the compare preload register */
  setReg(TMR0_CMPLD1,Val0);
  ExitCritical();                      /* Enable global interrupts */
}

/*
** ===================================================================
**     Method      :  SetPV (bean FreeCntr)
**
**     Description :
**         Sets prescaler value. The method is called automatically as a 
**         part of several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void SetPV(byte Val)
{
  EnterCritical();                     /* Disable global interrupts */
  setRegBitGroup(TMR0_CTRL,PCS,Val);   /* Store given value to the prescaler */
  setReg(TMR0_CNTR,0);                 /* Reset counter */
  setReg(TMR1_CNTR,0);
  ExitCritical();                      /* Enable global interrupts */
}

/*
** ===================================================================
**     Method      :  FC1_Reset (bean FreeCntr)
**
**     Description :
**         This method resets the timer-counter (sets to zero for
**         up-counting HW or to appropriate value for down-counting HW).
**         The method is available only if the counter register can be
**         written and the counter is not shared.
**     Parameters  : None
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte FC1_Reset(void)
{
  EnterCritical();                     /* Disable global interrupts */
  setReg(TMR0_CNTR,0x00);              /* Reset counter register */
  setReg(TMR1_CNTR,0x00);
  ExitCritical();                      /* Enable global interrupts */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  FC1_GetCounterValue (bean FreeCntr)
**
**     Description :
**         This method returns a content of counter.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * Value           - A pointer to the returned 32-bit value.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active speed mode
** ===================================================================
*/
byte FC1_GetCounterValue(FC1_TTimerValue *Value)
{
  *Value = getReg(TMR0_CNTR);          /* Get lower part */
  *Value += ((dword)getReg(TMR1_HOLD) << 16); /* Add higher part */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  FC1_Init (bean FreeCntr)
**
**     Description :
**         Initializes the associated peripheral(s) and the beans 
**         internal variables. The method is called automatically as a 
**         part of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void FC1_Init(void)
{
  /* TMR0_CTRL: CM=0,PCS=0,SCS=0,ONCE=0,LENGTH=1,DIR=0,Co_INIT=0,OM=0 */
  setReg(TMR0_CTRL,0x20);              /* Stop all functions of the timer */
  /* TMR1_CTRL: CM=7,PCS=4,SCS=0,ONCE=0,LENGTH=1,DIR=0,Co_INIT=0,OM=0 */
  setReg(TMR1_CTRL,0xE820);            /* Set up cascade counter mode */
  /* TMR1_SCTRL: TCF=0,TCFIE=0,TOF=0,TOFIE=0,IEF=0,IEFIE=0,IPS=0,INPUT=0,CAPTURE_MODE=0,MSTR=0,EEOF=0,VAL=0,FORCE=0,OPS=0,OEN=0 */
  setReg(TMR1_SCTRL,0x00);
  /* TMR0_SCTRL: TCF=0,TCFIE=0,TOF=0,TOFIE=0,IEF=0,IEFIE=0,IPS=0,INPUT=0,CAPTURE_MODE=0,MSTR=0,EEOF=0,VAL=0,FORCE=0,OPS=0,OEN=0 */
  setReg(TMR0_SCTRL,0x00);
  setReg(TMR1_CNTR,0x00);              /* Reset counter register */
  setReg(TMR0_CNTR,0x00);
  setReg(TMR1_LOAD,0x00);              /* Reset load register */
  setReg(TMR0_LOAD,0x00);
  setReg(TMR1_COMP1,0x1F);             /* Set up compare 1 register */
  setReg(TMR0_COMP1,0xC34F);
  /* TMR1_CSCTRL: DBG_EN=0,FAULT=0,ALT_LOAD=0,??=0,??=0,??=0,??=0,TCF2EN=0,TCF1EN=0,TCF2=0,TCF1=0,CL2=0,CL1=1 */
  setReg(TMR1_CSCTRL,0x01);            /* Set up comparator control registers */
  /* TMR0_CSCTRL: DBG_EN=0,FAULT=0,ALT_LOAD=0,??=0,??=0,??=0,??=0,TCF2EN=0,TCF1EN=0,TCF2=0,TCF1=0,CL2=0,CL1=1 */
  setReg(TMR0_CSCTRL,0x01);
  SetCV((word)0xC34F,(word)0x1F);      /* Store appropriate value to the compare register according to the selected high speed CPU mode */
  SetPV((byte)0x08);                   /* Set prescaler register according to the selected high speed CPU mode */
  setRegBitGroup(TMR0_CTRL,CM,0x01);   /* Run counter */
}

/* END FC1. */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
