/** ###################################################################
**     Filename  : Events.C
**     Project   : lab_tone_det
**     Processor : MC56F8006_48_LQFP
**     Beantype  : Events
**     Version   : Driver 01.03
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 11/15/2008, 12:13 PM
**     Abstract  :
**         This is user's event module.
**         Put your event handler code here.
**     Settings  :
**     Contents  :
**         BTN1_OnButton - void BTN1_OnButton(void);
**
**     (c) Copyright UNIS, a.s. 1997-2008
**     UNIS, a.s.
**     Jundrovska 33
**     624 00 Brno
**     Czech Republic
**     http      : www.processorexpert.com
**     mail      : info@processorexpert.com
** ###################################################################*/
/* MODULE Events */

#include "Cpu.h"
#include "Events.h"



#include "FreqDetector.h"

extern UWord16 AdcBuffer[];
extern Word16 AdcWriteIndex;

extern volatile int DemoState;




/*
** ===================================================================
**     Event       :  BTN1_OnButton (module Events)
**
**     From bean   :  BTN1 [Button]
**     Description :
**         This event is called when the button is pressed.
**         If button inactivity feature (advanced view) is enabled,
**         then the next OnButton event is not generated during dead
**         time.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#pragma interrupt called /* Comment this line if the appropriate 'Interrupt preserve registers' property */
                         /* is set to 'yes' (#pragma interrupt saveall is generated before the ISR)      */
void BTN1_OnButton(void)
{
    if (DemoState==ON)
    {
        DemoState = OFF;
       // Bits1_PutVal(0);  
    }
    else
    {
        DemoState = ON;
       // Bits1_PutVal(0x55);
    }

}

/*
** ===================================================================
**     Event       :  TI1_OnInterrupt (module Events)
**
**     From bean   :  TI1 [TimerInt]
**     Description :
**         When a timer interrupt occurs this event is called (only
**         when the bean is enabled - <Enable> and the events are
**         enabled - <EnableEvent>). This event is enabled only if a
**         <interrupt service/event> is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
#pragma interrupt called /* Comment this line if the appropriate 'Interrupt preserve registers' property */
                         /* is set to 'yes' (#pragma interrupt saveall is generated before the ISR)      */
void TI1_OnInterrupt(void)
{
    /* Write your code here ... */
    
    unsigned int temp;
    
    
    AD1_GetValue16(&temp);
    
    AdcBuffer[AdcWriteIndex]=temp;
 


 
    AdcWriteIndex++;
    AD1_Measure(0);   //Start next conversion   //periphMemRead(&ADCA_ADRSLT0);      /* ENABLE SAMPLE 0 */


    if (AdcWriteIndex >= ADC_MAX_BUFFER_SIZE)
    {
        AdcWriteIndex = 0;
    }
    
}

/*
** ===================================================================
**     Event       :  AD1_OnEnd (module Events)
**
**     From bean   :  AD1 [ADC]
**     Description :
**         This event is called after the measurement (which consists
**         of <1 or more conversions>) is/are finished.
**         The event is available only when the <Interrupt
**         service/event> property is enabled.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void AD1_OnEnd(void)
{
  /* Write your code here ... */
}


/* END Events */

/*
** ###################################################################
**
**     This file was created by UNIS Processor Expert 2.99 [04.17]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
