/*      IO DEFINITIONS FOR MC68HC08MP16  */

/*      version 1.1      Dave Wilson     02/13/98      */
/*      Cosmic C compiler                                */
/*      original file by Jim Gray                      */

typedef struct
  {
  unsigned char b0:1;
  unsigned char b1:1;
  unsigned char b2:1;
  unsigned char b3:1;
  unsigned char b4:1;
  unsigned char b5:1;
  unsigned char b6:1;
  unsigned char b7:1;
} BITS;

typedef union
  {
  unsigned char byte;
  BITS bit;
  } BIT_BYTE;



/*      PORTS section     */

@tiny volatile  BIT_BYTE PORTA    @0x00;  /* port A */
@tiny volatile  BIT_BYTE PORTB    @0x01;  /* port B */
@tiny volatile  BIT_BYTE PORTC    @0x02;  /* port C */
@tiny volatile  BIT_BYTE PORTD    @0x03;  /* port D */
@tiny volatile  BIT_BYTE PORTE    @0x04;  /* port E */
@tiny volatile  BIT_BYTE PORTF    @0x05;  /* port F */
@tiny           BIT_BYTE DDRA     @0x06;  /* data direction port A */
@tiny           BIT_BYTE DDRB     @0x07;  /* data direction port B */
@tiny           BIT_BYTE DDRC     @0x08;  /* data direction port C */
@tiny           BIT_BYTE DDRE     @0x0a;  /* data direction port E */
@tiny           BIT_BYTE DDRF     @0x0b;  /* data direction port F */



/*      A TIMER section   */

@tiny volatile  BIT_BYTE TASC     @0x0C;  /* timer A status/ctrl register */
@tiny volatile  int      TACNT    @0x0D;  /* timer A counter register */
@tiny volatile  char     TACNTH   @0x0D;  /* timer A counter high */
@tiny volatile  char     TACNTL   @0x0E;  /* timer A counter low */
@tiny volatile  int      TAMOD    @0x0F;  /* timer A modulo register */
@tiny volatile  char     TAMODH   @0x0F;  /* timer A modulo high */
@tiny volatile  char     TAMODL   @0x10;  /* timer A modulo low */
@tiny volatile  BIT_BYTE TASC0    @0x11;  /* timer A channel 0 status/ctrl */
@tiny volatile  int      TACH0    @0x12;  /* timer A channel 0 register */
@tiny volatile  char     TACH0H   @0x12;  /* timer A channel 0 high */
@tiny volatile  char     TACH0L   @0x13;  /* timer A channel 0 low */
@tiny volatile  BIT_BYTE TASC1    @0x14;  /* timer A channel 1 status/ctrl */
@tiny volatile  int      TACH1    @0x15;  /* timer A channel 1 register */
@tiny volatile  char     TACH1H   @0x15;  /* timer A channel 1 high */
@tiny volatile  char     TACH1L   @0x16;  /* timer A channel 1 low */




/*  A/D section */

@tiny volatile  BIT_BYTE ADSCR    @0x17;  /* ADC status and control */
@tiny volatile  char     ADR      @0x19;  /* ADC data register */
@tiny           char     ADCLK    @0x1a;  /* ADC clock register */




/*      SPI section */

@tiny           char     SPCR     @0x1b;  /* SPI control register */
@tiny volatile  char     SPSCR    @0x1c;  /* SPI control/status register */
@tiny volatile  char     SPDR     @0x1d;  /* SPI data register */




/*      INTERRUPT section */

@tiny volatile  char     ISCR     @0x1e;  /* IRQ control/status register */




/*      OPTION section */

@tiny           char     CONFIG   @0x1f;  /* Config. Write-Once Register */




/* PWM section */

@tiny           BIT_BYTE PCTL1    @0x20;  /* PWM control register 1 */
@tiny           BIT_BYTE PCTL2    @0x21;  /* PWM control register 2 */
@tiny           BIT_BYTE FCR      @0x22;  /* Fault control register  */
@tiny volatile  BIT_BYTE FSR      @0x23;  /* Fault Status register  */
@tiny           BIT_BYTE FTACK    @0x24;  /* Fault acknowledge register  */
@tiny           BIT_BYTE PWMOUT   @0x25;  /* PWM output control register  */
@tiny volatile  int      PCNT     @0x26;  /* PWM counter register   */
@tiny volatile  char     PCNTH    @0x26;  /* PWM counter register high  */
@tiny volatile  char     PCNTL    @0x27;  /* PWM counter register low  */
@tiny volatile  int      PMOD     @0x28;  /* PWM counter Modulo register   */
@tiny volatile  char     PMODH    @0x28;  /* PWM counter Modulo reg. high  */
@tiny volatile  char     PMODL    @0x29;  /* PWM counter Modulo reg. low  */
@tiny volatile  int      PVAL1    @0x2a;  /* PWM 1 value register   */
@tiny volatile  char     PVAL1H   @0x2a;  /* PWM 1 value register high  */
@tiny volatile  char     PVAL1L   @0x2b;  /* PWM 1 value register low  */
@tiny volatile  int      PVAL2    @0x2c;  /* PWM 2 value register   */
@tiny volatile  char     PVAL2H   @0x2c;  /* PWM 2 value register high  */
@tiny volatile  char     PVAL2L   @0x2d;  /* PWM 2 value register low  */
@tiny volatile  int      PVAL3    @0x2e;  /* PWM 3 value register   */
@tiny volatile  char     PVAL3H   @0x2e;  /* PWM 3 value register high  */
@tiny volatile  char     PVAL3L   @0x2f;  /* PWM 3 value register low  */
@tiny volatile  int      PVAL4    @0x30;  /* PWM 4 value register   */
@tiny volatile  char     PVAL4H   @0x30;  /* PWM 4 value register high  */
@tiny volatile  char     PVAL4L   @0x31;  /* PWM 4 value register low  */
@tiny volatile  int      PVAL5    @0x32;  /* PWM 5 value register   */
@tiny volatile  char     PVAL5H   @0x32;  /* PWM 5 value register high  */
@tiny volatile  char     PVAL5L   @0x33;  /* PWM 5 value register low  */
@tiny volatile  int      PVAL6    @0x34;  /* PWM 6 value register   */
@tiny volatile  char     PVAL6H   @0x34;  /* PWM 6 value register high  */
@tiny volatile  char     PVAL6L   @0x35;  /* PWM 6 value register low  */

@tiny volatile  char     DEADTM   @0x36;  /* Dead Time Write-once register */
@tiny volatile  BIT_BYTE DISMAP   @0x37;  /* PWM Disable Mapping register*/




/*  SCI section  */

@tiny           char     SCC1     @0x38;  /* SCI control register 1 */
@tiny           char     SCC2     @0x39;  /* SCI control register 2 */
@tiny           char     SCC3     @0x3a;  /* SCI control register 3 */
@tiny volatile  char     SCS1     @0x3b;  /* SCI status register 1 */
@tiny volatile  char     SCS2     @0x3c;  /* SCI status register 2 */
@tiny volatile  char     SCDR     @0x3d;  /* SCI data register */
@tiny           char     SCBR     @0x3e;  /* SCI baud rate */




/*      B TIMER section */

@tiny volatile  BIT_BYTE TBSC     @0x3F;  /* timer B status/ctrl register */
@tiny volatile  int      TBCNT    @0x40;  /* timer B counter register */
@tiny volatile  char     TBCNTH   @0x40;  /* timer B counter high */
@tiny volatile  char     TBCNTL   @0x41;  /* timer B counter low */
@tiny volatile  int      TBMOD    @0x42;  /* timer B modulo register */
@tiny volatile  char     TBMODH   @0x42;  /* timer B modulo high */
@tiny volatile  char     TBMODL   @0x43;  /* timer B modulo low */
@tiny volatile  BIT_BYTE TBSC0    @0x44;  /* timer B channel 0 status/ctrl */
@tiny volatile  int      TBCH0    @0x45;  /* timer B channel 0 register */
@tiny volatile  char     TBCH0H   @0x45;  /* timer B channel 0 high */
@tiny volatile  char     TBCH0L   @0x46;  /* timer B channel 0 low */
@tiny volatile  BIT_BYTE TBSC1    @0x47;  /* timer B channel 1 status/ctrl */
@tiny volatile  int      TBCH1    @0x48;  /* timer B channel 1 register */
@tiny volatile  char     TBCH1H   @0x48;  /* timer B channel 1 high */
@tiny volatile  char     TBCH1L   @0x49;  /* timer B channel 1 low */
@tiny volatile  BIT_BYTE TBSC2    @0x4a;  /* timer B channel 2 status/ctrl */
@tiny volatile  int      TBCH2    @0x4b;  /* timer B channel 2 register */
@tiny volatile  char     TBCH2H   @0x4b;  /* timer B channel 2 high */
@tiny volatile  char     TBCH2L   @0x4c;  /* timer B channel 2 low */
@tiny volatile  BIT_BYTE TBSC3    @0x4d;  /* timer B channel 3 status/ctrl */
@tiny volatile  int      TBCH3    @0x4e;  /* timer B channel 3 register */
@tiny volatile  char     TBCH3H   @0x4e;  /* timer B channel 3 high */
@tiny volatile  char     TBCH3L   @0x4f;  /* timer B channel 3 low */





/*      SIM section */

@near volatile  char     SBSR     @0xfe00; /* SIM break status register */
@near volatile  char     SRSR     @0xfe01; /* SIM reset status register */
@near           char     SBFCR    @0xfe03; /* SIM break control register */
@near           char     EPMCR    @0xfe07; /* EPROM control register */




/*      PLL section */

@near volatile  BIT_BYTE PCTL     @0xfe0b; /* PLL control register */
@near volatile  BIT_BYTE PBWC     @0xfe0c; /* PLL bandwidth register */
@near           char     PPG      @0xfe0d; /* PLL programming register */



/*      LVI register  */

@near volatile  BIT_BYTE LVISR    @0xfe0f; /* LVI status register */




/*      COP servicing   */

@near volatile  char     COPCTL   @0xffff; /* COP control register */


