/* ###################################################################
**     Filename    : Power_Supply.c
**     Project     : ClassD
**     Processor   : MKV10Z32VLF7
**     Component   :
**     Version     :
**     Compiler    :
**     Created on  : May 30, 2015
**     Author      : Marcelo Pires Macedo
**     Abstract    :
**         These are the functions used to control de switching power
**         supply of the Class-D Audio project
** ###################################################################*/

/* Including needed modules to compile this module/procedure */


/* Including shared modules, which are used for whole project */


/*My Includes */
#include "Power_Supply.h"
#include "Enable_Push_Pull.h"
#include "FTM1_Power_Supply.h"
#include "FTM_PDD.h"
#include "LED_Green.h"
#include "LED_Orange.h"


/*Global Variables Defined in this module*/



/*Variables used by multiple functions within this module*/
int Min_Power_Supply_Duty_Cycle = 3;                                           //Minimum value for the duty cycle value on the power supply. Range from 0 to 1250
int Max_Power_Supply_Duty_Cycle = 20;                                          //Maximum value for the duty cycle value on the power supply. Range from 0 to 1250
int duty_cycle = 5;                                                            //Duty Cycle value (do not exceed 1250 as Modulo Counter is 2500) ATENTION - INCREASE SLOWLY AS IT MAY CAUSE VOLTAGE TO EXCEED 200V


/*
** ===================================================================
**     Function    :  Power_Supply_Init
**
**     Description :
**         This function is used to initialize the switching power supply
**
**     Parameters  : void
**     Returns     : Nothing
** ===================================================================
*/
void Power_Supply_Init(void){
	int delay = 20000;                                                         //Delay for smooth duty cycle ramp up
    int temp_var = 0;                                                          //Temporary variable

	FTM1_Power_Supply_Init();                                                  //Initialize the FTM1
	Enable_Push_Pull_SetVal();                                                 //Enables the gate driver

	//Ramp up the PWM smoothly from 0 until duty cycle value
    while (temp_var<duty_cycle){
    	//FTM1_C0V = temp_var;                                                   //FTM1 Channel 0 value channel value
    	//FTM1_C1V = 1250-temp_var;                                              //FTM1 Channel 1 value channel value
    	//FTM1_SYNC = 0x80;                                                      //Software Trigger to update the channel values

    	Power_Supply_Change_Duty_Cycle(temp_var);

    	temp_var++;
    	for(int i=0; i<delay; i++);                                            //Delay
    }



/*FOR DEBUG
	int delay = 20000;                                                         //Delay for smooth duty cycle ramp up
    int duty_cycle = 2;                                                       //Maximum Duty Cycle value = 50% (do not exceed 1250 as Modulo Counter is 2500)
    int temp_var = 0;                                                          //Temporary variable

	FTM1_Power_Supply_Init();                                                  //Initialize the FTM1
	Enable_Push_Pull_SetVal();                                                 //Enables the gate driver

	//Ramp up the PWM smoothly from 0 until duty cycle value
    while (temp_var<duty_cycle){
    	FTM1_C0V = temp_var;                                                   //FTM1 Channel 0 value channel value
    	FTM1_C1V = 334-temp_var;                                              //FTM1 Channel 1 value channel value
    	FTM1_SYNC = 0x80;                                                      //Software Trigger to update the channel values
    	temp_var++;
    	for(int i=0; i<delay; i++);                                            //Delay
    }
*/


    LED_Green_SetVal();                                                        //Turn on Green LED
}

/*
** ===================================================================
**     Function    :  Power_Supply_Turn_Off
**
**     Description :
**         This function is used to shut down the switching power supply
**
**     Parameters  : void
**     Returns     : Nothing
** ===================================================================
*/
void Power_Supply_Turn_Off(void){

	Enable_Push_Pull_ClrVal();                                                 //Disables the gate driver

}

/*
** ===================================================================
**     Function    :  Power_Supply_Change_Duty_Cycle
**
**     Description :
**         This function is used to change the duty cycle of the
**         power supply
**
**     Parameters  : int Duty - Duty Cycle of the power supply
**     Returns     : Nothing
** ===================================================================
*/
void Power_Supply_Change_Duty_Cycle(int Duty){

	FTM1_C0V = Duty;    	                                               //FTM1 Channel 0 value channel value
	FTM1_C1V = 1250-Duty;                                                  //FTM1 Channel 1 value channel value
	FTM1_SYNC = 0x80;                                                      //Software Trigger to update the channel values

}
