/* ###################################################################
**     Filename    : Audio.c
**     Project     : ClassD
**     Processor   : MKV10Z32VLF7
**     Component   :
**     Version     :
**     Compiler    :
**     Created on  : June 6, 2015
**     Author      : Marcelo Pires Macedo
**     Abstract    :
**         These are the functions used for the audio manipulation on the
**         Class D amplifier
** ###################################################################*/

/* Including needed modules to compile this module/procedure */


/* Including shared modules, which are used for whole project */


/*My Includes */
#include "Audio.h"
#include "MKV10Z7.h"
#include "PE_Types.h"
#include "FTM0_Audio.h"

/*Global Variables Defined in this module*/



/*Variables used by multiple functions within this module*/
int Audio_10_Bits = 512;                                                       //Variable used to store the Audio measured from ADC
bool Audio_is_Muted = 0;
int Half_Module = 0;                                                           //Value of the timer module divided by 2 (50% duty cycle). Initialized at Audio_Variables_Init
int Mute_Trigger_Positive = 0;                                                 //Trigger to start considering a mute situation, initialized at Audio_Variables_Init
int Mute_Trigger_Negative = 0;                                                 //Trigger to start considering a mute situation, initialized at Audio_Variables_Init
int Mute_Max_Value = 8;                                                        //Value considered for mute check, between 512 and this value is too low, so count and after some time set mute state
int Mute_Min_Value = 8;                                                        //Value considered for mute check, between 512 and this value is too low, so count and after some time set mute state
int Debounce_Mute = 100000;                                                    //Above this count value, it`s considered at Mute state

/*
** ===================================================================
**     Function    :  Store_Audio
**
**     Description :
**         This function is used to store the measured audio from
**         ADC
**
**     Parameters  : int - Measured audio
**     Returns     : Nothing
** ===================================================================
*/
void Store_Audio(int audio){

	Audio_10_Bits = audio;

	//Audio_10_Bits = Audio_10_Bits; //Fix Me                                       //Manual adjust to put the PWM at 50%

}

/*
** ===================================================================
**     Function    :  Get_Stored_Audio
**
**     Description :
**         This function is used to store the measured audio from
**         ADC
**
**     Parameters  : None
**     Returns     : Return the last Measured Data from ADC
** ===================================================================
*/
int Get_Stored_Audio(void){

	return Audio_10_Bits;

}

/*
** ===================================================================
**     Function    :  Mute_Check
**
**     Description :
**         This function checks if the system is on mute state
**
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void Mute_Check(void){
	static int Counting_Mute = 0;                                              //Count the amount of ADC samples that is within the Mutes spec


	if(Get_Mute_Status() == FALSE){                                            //If not in Mute situation, check this routine
/*		if(Audio_10_Bits >= Half_Module && Audio_10_Bits < Mute_Trigger_Positive){     //Just considering the positive values, as the audio is somehow "symmetric"
			Counting_Mute++;
		}
		else{
			if(Audio_10_Bits >= Half_Module){
				Counting_Mute = 0;
			}
		}
*/
		if(Audio_10_Bits >= Half_Module){                                      //If positive value check this routine
			if(Audio_10_Bits < Mute_Trigger_Positive){                         //If audio is positive, but too low, count
				Counting_Mute++;
			}
			else{
				Counting_Mute = 0;
			}
		}
		else{                                                                  //Else it is a negative value, so check this routine
			if(Audio_10_Bits > Mute_Trigger_Negative){                         //If audio is negative, but too low, count
				Counting_Mute++;
			}
			else{
				Counting_Mute = 0;
		    }

		}

		if(Counting_Mute > Debounce_Mute){                                     //If the counting of low values is above the threshold, then set mute variable
			Set_Mute_Status(TRUE);
		}
	}

	if(Get_Mute_Status() == TRUE){                                              //If in Mute situation, check this routine
		if(Audio_10_Bits > Half_Module && Audio_10_Bits > Mute_Trigger_Positive){    //If value is above the trigger level, leave the Mute situation
			Set_Mute_Status(FALSE);
		}
	}
}

/*
** ===================================================================
**     Function    :  Mute_Audio
**
**     Description :
**         Disable the audio output.
**         Keeps running FTM0, but set the output values the way it
**         grounds both outputs
**
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void Mute_Audio(void){

	//Uses the module value + 1, so counting never reaches trigger value, keeping the channel always in  0
	//FTM0_C0V = FTM0_MOD+1;						                                           //set Channel 0 to 0 and as Channel 1 is complementary, it goes to 1
	//FTM0_C2V = 0;                                                                          //As Channel 2 is configured as low-true, setting channel to 0 triggers the output to be 0
	FTM0_C0V = Half_Module;
	FTM0_C2V = Half_Module;

}

/*
** ===================================================================
**     Function    :  Get_Mute_Status
**
**     Description :
**         Return if the audio is muted or not
**
**     Parameters  : None
**     Returns     : boolean:
** ===================================================================
*/
bool Get_Mute_Status(void){

return Audio_is_Muted;
}

/*
** ===================================================================
**     Function    :  Set_Mute_Status
**
**     Description :
**        Write the status of the Audio_is_Muted variable
**
**     Parameters  : bool: status if audio is muted or not
**     Returns     : Nothing
** ===================================================================
*/
void Set_Mute_Status(bool mute_var){

Audio_is_Muted = mute_var;
}

/*
** ===================================================================
**     Function    :  Audio_Init
**
**     Description :
**        Initialize all the needed to play audio
**
**     Parameters  : bool: status if audio is muted or not
**     Returns     : Nothing
** ===================================================================
*/
void Audio_Init(void){

	 FTM0_Audio_Init();                                                        //FTM0 Init
	 Half_Module = FTM0_MOD / 2;                                               //Half of Module register, used in some routines. Initialize once to optimize the code
     FTM0_C0V = Half_Module;						                           //Initialize the Channel 0 and 2 to 50% duty Cycle, the channel+1 is complementary
	 FTM0_C2V = Half_Module;
	 Mute_Trigger_Positive = Half_Module + Mute_Max_Value;                     //Trigger to consider the mute counting
	 Mute_Trigger_Negative = Half_Module - Mute_Min_Value;                     //Trigger to consider the mute counting

}

/*
** ===================================================================
**     Function    :  Convert_16bit_To_10Bit
**
**     Description :
**        Convert the 16 bit input to 10 bit output
**
**     Parameters  : Audio in 16 bit format
**     Returns     : Audio in 10 bit format, remove the 6 less significant bits
** ===================================================================
*/
word Convert_16bit_To_10Bit(word Data_16bits){
	word Data_10bits = 0;                                                       //Variable to store the 10 bit data
	word Temp_Var = 0;

	Temp_Var = Data_16bits;

	Temp_Var >>= 6;                                                             //Rotate 6 levels right
	Data_10bits = Temp_Var;



return Data_10bits;
}


/*
** ===================================================================
**     Function    :  Audio_Expansion
**
**     Description :
**        Convert the 16 bit input to 10 bit output
**
**     Parameters  :
**     Returns     : Audio in 10 bits
** ===================================================================
*/
word Audio_Expansion(word Data_16bits){
	word Data_10bits = 0;                                                       //Variable to store the 10 bit data
	word Temp_Var = 0;                                                          //Temporary variable
	word Signal_Var = 0;                                                        //Variable to store if the data is positive or negative

	Signal_Var = Data_16bits;
	Temp_Var = Data_16bits;
	Signal_Var >>= 6;                                                          //Rotate 6 right
	Signal_Var = Signal_Var & 0b0000001000000000;                              //Get just the bit 9, to know if it's positive or negative value

	Temp_Var >>= 5;                                                            //Filter to ignore the less significant bits, it's noise from ADC
	Temp_Var = Temp_Var & 0b0000000111111111;                                  //Mask to get just the less 9 significant bits


	Data_10bits = Signal_Var + Temp_Var;
	//Data_10bits = Temp_Var;

return Data_10bits;
}



