/* ###################################################################
**     This component module is generated by Processor Expert. Do not modify it.
**     Filename    : AdcLdd1.c
**     Project     : ClassD-V1_2
**     Processor   : MKV10Z32VLF7
**     Component   : ADC_LDD
**     Version     : Component 01.183, Driver 01.08, CPU db: 3.50.001
**     Repository  : Kinetis
**     Compiler    : GNU C Compiler
**     Date/Time   : 2015-06-14, 00:15, # CodeGen: 248
**     Abstract    :
**         This device "ADC_LDD" implements an A/D converter,
**         its control methods and interrupt/event handling procedure.
**     Settings    :
**          Component name                                 : AdcLdd1
**          A/D converter                                  : ADC1
**          Discontinuous mode                             : no
**          Interrupt service/event                        : Enabled
**            A/D interrupt                                : INT_ADC1
**            A/D interrupt priority                       : medium priority
**            ISR Name                                     : AdcLdd1_MeasurementCompleteInterrupt
**          DMA                                            : Disabled
**          A/D channel list                               : 1
**            Channel 0                                    : 
**              Channel mode                               : Differential
**                Input                                    : 
**                  A/D channel (pin)                      : ADC0_SE6/ADC1_SE1/ADC1_DP1/PTE18/SPI0_SOUT/UART1_CTS_b/I2C0_SDA/SPI0_SIN
**                Negative input                           : 
**                  A/D channel (pin)                      : ADC0_SE7/ADC1_SE7/ADC1_DM1/PTE19/SPI0_SIN/UART1_RTS_b/I2C0_SCL/SPI0_SOUT
**          Static sample groups                           : Disabled
**          Max. samples                                   : 8
**          A/D resolution                                 : 16 bits
**          Low-power mode                                 : Disabled
**          High-speed conversion mode                     : Enabled
**          Asynchro clock output                          : Disabled
**          Sample time                                    : 24 clock periods
**          Number of conversions                          : 1
**          Conversion time                                : 3.76 s
**          ADC clock                                      : 12.5 MHz (80 ns)
**          Single conversion time - Single-ended          : 4.2 us
**          Single conversion time - Differential          : 4.92 us
**          Additional conversion time - Single-ended      : 3.76 us
**          Additional conversion time - Differential      : 4.48 us
**          Result type                                    : signed 16 bits, right justified
**          Trigger                                        : Disabled
**          Voltage reference                              : 
**            High voltage reference                       : 
**              Volt. ref. pin                             : <Automatic>
**            Low voltage reference                        : 
**              Volt. ref. pin                             : <Automatic>
**          Initialization                                 : 
**            Enabled in init. code                        : no
**            Auto initialization                          : no
**            Event mask                                   : 
**              OnMeasurementComplete                      : Enabled
**              OnError                                    : Disabled
**          CPU clock/configuration selection              : 
**            Clock configuration 0                        : This component enabled
**            Clock configuration 1                        : This component disabled
**            Clock configuration 2                        : This component disabled
**            Clock configuration 3                        : This component disabled
**            Clock configuration 4                        : This component disabled
**            Clock configuration 5                        : This component disabled
**            Clock configuration 6                        : This component disabled
**            Clock configuration 7                        : This component disabled
**     Contents    :
**         Init                         - LDD_TDeviceData* AdcLdd1_Init(LDD_TUserData *UserDataPtr);
**         Enable                       - LDD_TError AdcLdd1_Enable(LDD_TDeviceData *DeviceDataPtr);
**         SetEventMask                 - LDD_TError AdcLdd1_SetEventMask(LDD_TDeviceData *DeviceDataPtr,...
**         StartSingleMeasurement       - LDD_TError AdcLdd1_StartSingleMeasurement(LDD_TDeviceData *DeviceDataPtr);
**         CancelMeasurement            - LDD_TError AdcLdd1_CancelMeasurement(LDD_TDeviceData *DeviceDataPtr);
**         GetMeasuredValues            - LDD_TError AdcLdd1_GetMeasuredValues(LDD_TDeviceData *DeviceDataPtr,...
**         CreateSampleGroup            - LDD_TError AdcLdd1_CreateSampleGroup(LDD_TDeviceData *DeviceDataPtr,...
**         GetMeasurementCompleteStatus - bool AdcLdd1_GetMeasurementCompleteStatus(LDD_TDeviceData *DeviceDataPtr);
**         StartCalibration             - LDD_TError AdcLdd1_StartCalibration(LDD_TDeviceData *DeviceDataPtr);
**         GetCalibrationResultStatus   - LDD_TError AdcLdd1_GetCalibrationResultStatus(LDD_TDeviceData *DeviceDataPtr);
**
**     Copyright : 1997 - 2015 Freescale Semiconductor, Inc. 
**     All Rights Reserved.
**     
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**     
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**     
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**     
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**     
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**     
**     http: www.freescale.com
**     mail: support@freescale.com
** ###################################################################*/
/*!
** @file AdcLdd1.c
** @version 01.08
** @brief
**         This device "ADC_LDD" implements an A/D converter,
**         its control methods and interrupt/event handling procedure.
*/         
/*!
**  @addtogroup AdcLdd1_module AdcLdd1 module documentation
**  @{
*/         

/* MODULE AdcLdd1. */

#include "AD1.h"
#include "AdcLdd1.h"
/* {Default RTOS Adapter} No RTOS includes */

#ifdef __cplusplus
extern "C" { 
#endif

#define AdcLdd1_AVAILABLE_EVENTS_MASK ((LDD_TEventMask)( \
          LDD_ADC_ON_MEASUREMENT_COMPLETE))

#define AdcLdd1_INIT_EVENTS_MASK ((LDD_TEventMask)( \
          LDD_ADC_ON_MEASUREMENT_COMPLETE))

#define AdcLdd1_AVAILABLE_CHANNEL0_31_PIN_MASK (LDD_ADC_CHANNEL_0_PIN) /*!< Mask of all allocated channel pins from 0 to 31 */
#define AdcLdd1_AVAILABLE_CHANNEL32_63_PIN_MASK 0x00U /*!< Mask of all allocated channel pins from 32 to 63 */
#define AdcLdd1_AVAILABLE_TRIGGER_PIN_MASK 0x00U /*!< Mask of all allocated trigger pins */
#define AdcLdd1_AVAILABLE_VOLT_REF_PIN_MASK (LDD_ADC_LOW_VOLT_REF_PIN | LDD_ADC_HIGH_VOLT_REF_PIN) /*!< Mask of all allocated voltage reference pins */

static const uint8_t ChannelToPin[] = { /* Channel to pin conversion table */
  /* ADC1_SC1A: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,COCO=0,AIEN=1,DIFF=1,ADCH=1 */
  0x61U                                /* Status and control register value */
};

typedef struct {
  uint8_t SampleCount;                 /* Number of samples in the last selected/created sample group */
  bool EnUser;                         /* Enable/Disable device */
  LDD_TEventMask EventMask;            /* Event mask of enabled events */
  uint8_t FirstSample;                 /* First sample of group store */
  uint8_t CompleteStatus;              /* Measurement complete status flag */
  LDD_TUserData *UserData;             /* RTOS device data structure */
} AdcLdd1_TDeviceData;                 /* Device data structure type */

typedef AdcLdd1_TDeviceData* AdcLdd1_TDeviceDataPtr ; /* Pointer to the device data structure. */

/* {Default RTOS Adapter} Static object used for simulation of dynamic driver memory allocation */
static AdcLdd1_TDeviceData DeviceDataPrv__DEFAULT_RTOS_ALLOC;
/* {Default RTOS Adapter} Global variable used for passing a parameter into ISR */
static AdcLdd1_TDeviceDataPtr INT_ADC1__DEFAULT_RTOS_ISRPARAM;
/*
** ===================================================================
**     Method      :  AdcLdd1_Init (component ADC_LDD)
*/
/*!
**     @brief
**         Initializes the device. Allocates memory for the device data
**         structure, allocates interrupt vectors and sets interrupt
**         priority, sets pin routing, sets timing, etc.
**         If the "Enable in init. code" is set to "yes" value then the
**         device is also enabled(see the description of the Enable()
**         method). In this case the Enable() method is not necessary
**         and needn't to be generated. 
**         This method can be called only once. Before the second call
**         of Init() the Deinit() must be called first.
**     @param
**         UserDataPtr     - Pointer to the user or
**                           RTOS specific data. This pointer will be
**                           passed as an event or callback parameter.
**     @return
**                         - Device data structure pointer.
*/
/* ===================================================================*/
LDD_TDeviceData* AdcLdd1_Init(LDD_TUserData *UserDataPtr)
{
  /* Allocate LDD device structure */
  AdcLdd1_TDeviceDataPtr DeviceDataPrv;

  /* {Default RTOS Adapter} Driver memory allocation: Dynamic allocation is simulated by a pointer to the static object */
  DeviceDataPrv = &DeviceDataPrv__DEFAULT_RTOS_ALLOC;
  DeviceDataPrv->UserData = UserDataPtr; /* Store the RTOS device structure */
  /* Interrupt vector(s) allocation */
  /* {Default RTOS Adapter} Set interrupt vector: IVT is static, ISR parameter is passed by the global variable */
  INT_ADC1__DEFAULT_RTOS_ISRPARAM = DeviceDataPrv;
  DeviceDataPrv->SampleCount = 0U;     /* Initializing SampleCount for right access of some methods to SC1n registers before first conversion is done */
  DeviceDataPrv->EnUser = FALSE;       /* Disable device */
  DeviceDataPrv->CompleteStatus = FALSE; /* Clear measurement complete status flag */
  DeviceDataPrv->EventMask = AdcLdd1_INIT_EVENTS_MASK;
  /* SIM_SCGC6: ADC1=1 */
  SIM_SCGC6 |= SIM_SCGC6_ADC1_MASK;
  /* Interrupt vector(s) priority setting */
  /* NVIC_IPR4: PRI_16=1 */
  NVIC_IPR4 = (uint32_t)((NVIC_IPR4 & (uint32_t)~(uint32_t)(
               NVIC_IP_PRI_16(0x02)
              )) | (uint32_t)(
               NVIC_IP_PRI_16(0x01)
              ));
  /* NVIC_ISER: SETENA31=0,SETENA30=0,SETENA29=0,SETENA28=0,SETENA27=0,SETENA26=0,SETENA25=0,SETENA24=0,SETENA23=0,SETENA22=0,SETENA21=0,SETENA20=0,SETENA19=0,SETENA18=0,SETENA17=0,SETENA16=1,SETENA15=0,SETENA14=0,SETENA13=0,SETENA12=0,SETENA11=0,SETENA10=0,SETENA9=0,SETENA8=0,SETENA7=0,SETENA6=0,SETENA5=0,SETENA4=0,SETENA3=0,SETENA2=0,SETENA1=0,SETENA0=0 */
  NVIC_ISER = NVIC_ISER_SETENA16_MASK;
  /* NVIC_ICER: CLRENA31=0,CLRENA30=0,CLRENA29=0,CLRENA28=0,CLRENA27=0,CLRENA26=0,CLRENA25=0,CLRENA24=0,CLRENA23=0,CLRENA22=0,CLRENA21=0,CLRENA20=0,CLRENA19=0,CLRENA18=0,CLRENA17=0,CLRENA16=0,CLRENA15=0,CLRENA14=0,CLRENA13=0,CLRENA12=0,CLRENA11=0,CLRENA10=0,CLRENA9=0,CLRENA8=0,CLRENA7=0,CLRENA6=0,CLRENA5=0,CLRENA4=0,CLRENA3=0,CLRENA2=0,CLRENA1=0,CLRENA0=0 */
  NVIC_ICER = 0x00U;
  /* Enable device clock gate */
  /* SIM_SCGC5: PORTE=1 */
  SIM_SCGC5 |= SIM_SCGC5_PORTE_MASK;
  /* SIM_SCGC6: ADC1=1 */
  SIM_SCGC6 |= SIM_SCGC6_ADC1_MASK;
  /* Initialization of pin routing */
  /* PORTE_PCR18: ISF=0,MUX=0 */
  PORTE_PCR18 &= (uint32_t)~(uint32_t)((PORT_PCR_ISF_MASK | PORT_PCR_MUX(0x07)));
  /* PORTE_PCR19: ISF=0,MUX=0 */
  PORTE_PCR19 &= (uint32_t)~(uint32_t)((PORT_PCR_ISF_MASK | PORT_PCR_MUX(0x07)));
  /* ADC1_SC2: REFSEL=0 */
  ADC1_SC2 &= (uint32_t)~(uint32_t)(ADC_SC2_REFSEL(0x03));
  /* ADC1_CFG1: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,ADLPC=0,ADIV=1,ADLSMP=1,MODE=3,ADICLK=0 */
  ADC1_CFG1 = ADC_CFG1_ADIV(0x01) |
              ADC_CFG1_ADLSMP_MASK |
              ADC_CFG1_MODE(0x03) |
              ADC_CFG1_ADICLK(0x00);

  /* ADC1_CFG2: MUXSEL=0,ADACKEN=0,ADHSC=1,ADLSTS=0 */
  ADC1_CFG2 = (uint32_t)((ADC1_CFG2 & (uint32_t)~(uint32_t)(
               ADC_CFG2_MUXSEL_MASK |
               ADC_CFG2_ADACKEN_MASK |
               ADC_CFG2_ADLSTS(0x03)
              )) | (uint32_t)(
               ADC_CFG2_ADHSC_MASK
              ));
  /* ADC1_SC2: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,ADACT=0,ADTRG=0,ACFE=0,ACFGT=0,ACREN=0,DMAEN=0,REFSEL=0 */
  ADC1_SC2 = ADC_SC2_REFSEL(0x00);
  /* ADC1_SC3: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,CAL=0,CALF=1,??=0,??=0,ADCO=0,AVGE=0,AVGS=0 */
  ADC1_SC3 = (ADC_SC3_CALF_MASK | ADC_SC3_AVGS(0x00));
  /* Registration of the device structure */
  PE_LDD_RegisterDeviceStructure(PE_LDD_COMPONENT_AdcLdd1_ID,DeviceDataPrv);
  return ((LDD_TDeviceData *)DeviceDataPrv); /* Return pointer to the data data structure */
}

/*
** ===================================================================
**     Method      :  AdcLdd1_Enable (component ADC_LDD)
*/
/*!
**     @brief
**         Enables ADC device. If possible, this method switches on A/D
**         converter device, voltage reference, etc. This method is
**         intended to be used together with [Disable()] method to
**         temporary switch On/Off the device after the device is
**         initialized. This method is required if the [Enabled in init.
**         code] property is set to "no" value.
**     @param
**         DeviceDataPtr   - Device data structure
**                           pointer returned by [Init] method.
**     @return
**                         - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - The device doesn't work in the
**                           active clock configuration
*/
/* ===================================================================*/
LDD_TError AdcLdd1_Enable(LDD_TDeviceData *DeviceDataPtr)
{
  ((AdcLdd1_TDeviceDataPtr)DeviceDataPtr)->EnUser = TRUE; /* Set the flag "device enabled" */
  return ERR_OK;                       /* If yes then set the flag "device enabled" */
}

/*
** ===================================================================
**     Method      :  AdcLdd1_SetEventMask (component ADC_LDD)
*/
/*!
**     @brief
**         Enables/disables event(s). The events contained within the
**         mask are enabled. Events not contained within the mask are
**         disabled. The component event masks are defined in the
**         PE_Types.h file. Note: At least one [event] must be
**         generated to generate this method. Events that are not
**         generated are not handled by this method. Pair method to
**         GetEventMask().
**     @param
**         DeviceDataPtr   - Device data structure
**                           pointer returned by [Init] method.
**     @param
**         EventMask       - Event mask
**     @return
**                         - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - The device doesn't work in the
**                           active clock configuration
**                           ERR_DISABLED - Component is disabled
**                           ERR_PARAM_MASK - Event mask is not valid
**                           (requested event is not defined by this
**                           component or event is generated)
*/
/* ===================================================================*/
LDD_TError AdcLdd1_SetEventMask(LDD_TDeviceData *DeviceDataPtr, LDD_TEventMask EventMask)
{
  /* Device state test - this test can be disabled by setting the "Ignore enable test"
     property to the "yes" value in the "Configuration inspector" */
  if (!((AdcLdd1_TDeviceDataPtr)DeviceDataPtr)->EnUser) { /* Is the device disabled by user? */
    return ERR_DISABLED;               /* If yes then error */
  }
  /* Event mask test - this test can be disabled by setting the "Ignore range checking"
     property to the "yes" value in the "Configuration inspector" */
  if ((EventMask & (LDD_TEventMask)(~(LDD_TEventMask)(AdcLdd1_AVAILABLE_EVENTS_MASK))) != 0U) { /* Is the parameter EventMask within an expected range? */
    return ERR_PARAM_MASK;             /* If no then error. */
  }
  /* {Default RTOS Adapter} Critical section begin, general PE function is used */
  EnterCritical();
  ((AdcLdd1_TDeviceDataPtr)DeviceDataPtr)->EventMask = EventMask; /* Set the new event mask. */
  /* {Default RTOS Adapter} Critical section end, general PE function is used */
  ExitCritical();
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  AdcLdd1_StartSingleMeasurement (component ADC_LDD)
*/
/*!
**     @brief
**         This method starts one measurement of the selected group of
**         samples and exits immediately. This is ADC SW trigger method.
**         The group of samples for measurement is specified by
**         preceding call to [SelectSampleGroup()] or
**         [CreateSampleGroup] method. 
**         DMA disabled: The [OnMeasurementComplete() ] event is
**         invoked after the measurement is done and if the event is
**         enabled. Results of the measurement can be read by the
**         [GetMeasuredValues()] method. 
**         DMA enabled: DMA request from configured ADC is enabled
**         automatically. The [OnMeasurementComplete() ] event is
**         invoked after the requested number of results are
**         transferred to destination buffer by DMA and if the event is
**         enabled. [GetMeasuredValues()] method is not available if
**         DMA mode is enabled. If the DMA transfer was completed
**         before and DMA is not recofingured, DMA error can occur. See
**         also [SetBuffer()] method. 
**         The state of the measurement can be also polled by the
**         [GetMeasurementCompleteStatus()] method. The [Discontinuous
**         mode] doesn't support this method.
**     @param
**         DeviceDataPtr   - Device data structure
**                           pointer returned by [Init] method.
**     @return
**                         - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - The device doesn't work in the
**                           active clock configuration
**                           ERR_DISABLED - Component is disabled
**                           ERR_BUSY - A measurement is in progress 
*/
/* ===================================================================*/
LDD_TError AdcLdd1_StartSingleMeasurement(LDD_TDeviceData *DeviceDataPtr)
{
  /* Device state test - this test can be disabled by setting the "Ignore enable test"
     property to the "yes" value in the "Configuration inspector" */
  if (!((AdcLdd1_TDeviceDataPtr)DeviceDataPtr)->EnUser) { /* Is the device disabled by user? */
    return ERR_DISABLED;               /* If yes then error */
  }
  if (ADC_PDD_GetConversionActiveFlag(ADC1_BASE_PTR) != 0U) { /* Last measurement still pending? */
    return ERR_BUSY;                   /* Yes, return ERR_BUSY */
  }
  ADC_PDD_SetContinuousMode(ADC1_BASE_PTR, ADC_PDD_ONE_CONVERSION); /* Set one conversion mode */
  ADC_PDD_SetConversionTriggerType(ADC1_BASE_PTR, ADC_PDD_SW_TRIGGER); /* Select SW triggering */
  ADC_PDD_WriteStatusControl1Reg(ADC1_BASE_PTR, 0U, ((AdcLdd1_TDeviceDataPtr)DeviceDataPtr)->FirstSample); /* Set sample 0 and start conversion */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  AdcLdd1_CancelMeasurement (component ADC_LDD)
*/
/*!
**     @brief
**         This method cancels the measurement in progress. Typically
**         the OnMeasurementComplete() event is not invoked for
**         cancelled measurement. If DMA mode is enabled, DMA request
**         from ADC is disabled and DMA transfer is cancelled. 
**     @param
**         DeviceDataPtr   - Device data structure
**                           pointer returned by [Init] method.
**     @return
**                         - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - The device doesn't work in the
**                           active clock configuration
**                           ERR_DISABLED - Component is disabled
*/
/* ===================================================================*/
LDD_TError AdcLdd1_CancelMeasurement(LDD_TDeviceData *DeviceDataPtr)
{
  /* Device state test - this test can be disabled by setting the "Ignore enable test"
     property to the "yes" value in the "Configuration inspector" */
  if (!((AdcLdd1_TDeviceDataPtr)DeviceDataPtr)->EnUser) { /* Is the device disabled by user? */
    return ERR_DISABLED;               /* If yes then error */
  }
  ADC_PDD_SetConversionTriggerType(ADC1_BASE_PTR, ADC_PDD_SW_TRIGGER); /* Select SW triggering */
  ADC_PDD_WriteStatusControl1Reg(ADC1_BASE_PTR, 0U, 0x1FU); /* Disable device - A */
  
  return ERR_OK;                       /* If yes then set the flag "device enabled" */  
}

/*
** ===================================================================
**     Method      :  AdcLdd1_CreateSampleGroup (component ADC_LDD)
*/
/*!
**     @brief
**         This method prepares HW for next measurement according to
**         array of samples defined during run-time. The array of
**         samples should be prepared prior to calling this method.
**         Pointer to the array is passed into this method in parameter
**         SampleGroupPtr. The number of samples is defined by
**         parameter SampleCount. Once any group is prepared, the
**         measurement can be started multiple times. Note: This method
**         works only with the sample groups defined during run-time.
**         For design-time defined groups use [SelectSampleGroup()]
**         method.
**     @param
**         DeviceDataPtr   - Device data structure
**                           pointer returned by [Init] method.
**     @param
**         SampleGroupPtr  - Pointer to the
**                           sample definition array. This array can be
**                           released as soon as the method ends.
**     @param
**         SampleCount     - Number of items in the
**                           sample definition array. Must be less than
**                           or equal to
**                           ComponentName_MAX_HW_SAMPLE_COUNT.
**     @return
**                         - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - The device doesn't work in the
**                           active clock configuration
**                           ERR_DISABLED - Component is disabled
**                           ERR_PARAM_INDEX - Channel index in
**                           SampleGroup structure is out of range
**                           ERR_PARAM_SAMPLE_COUNT - SampleCount
**                           variable value is out of range
**                           ERR_BUSY - Measurement is in progress 
*/
/* ===================================================================*/
LDD_TError AdcLdd1_CreateSampleGroup(LDD_TDeviceData *DeviceDataPtr, LDD_ADC_TSample *SampleGroupPtr, uint8_t SampleCount)
{
  AdcLdd1_TDeviceDataPtr DeviceDataPrv = (AdcLdd1_TDeviceDataPtr)DeviceDataPtr;

  /* Device state test - this test can be disabled by setting the "Ignore enable test"
     property to the "yes" value in the "Configuration inspector" */
  if (!((AdcLdd1_TDeviceDataPtr)DeviceDataPtr)->EnUser) { /* Is the device disabled by user? */
    return ERR_DISABLED;               /* If yes then error */
  }
  /* Sample count test - this test can be disabled by setting the "Ignore range checking"
     property to the "yes" value in the "Configuration inspector" */
  if ((SampleCount > AdcLdd1_MAX_HW_SAMPLE_COUNT) || (SampleCount == 0U)) { /* Is number of sample greater then supported by the HW? */
    return ERR_PARAM_SAMPLE_COUNT;     /* Yes, return ERR_PARAM_SAMPLE_COUNT */
  }
  if (ADC_PDD_GetConversionActiveFlag(ADC1_BASE_PTR) != 0U) { /* Last measurement still pending? */
    return ERR_BUSY;                   /* Yes, return ERR_BUSY */
  }
  DeviceDataPrv->SampleCount = SampleCount; /* Remember sample count */
  /* Channel index test - this test can be disabled by setting the "Ignore range checking"
     property to the "yes" value in the "Configuration inspector" */
  if (SampleGroupPtr[0].ChannelIdx >= AdcLdd1_CHANNEL_COUNT) { /* Is channel index out of range? */
    return ERR_PARAM_INDEX;            /* Yes, return ERR_PARAM_INDEX */
  }
  DeviceDataPrv->FirstSample = (ChannelToPin[SampleGroupPtr[0].ChannelIdx]) | (uint8_t)(LDD_ADC_ON_MEASUREMENT_COMPLETE); /* Remember first sample */
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  AdcLdd1_GetMeasuredValues (component ADC_LDD)
*/
/*!
**     @brief
**         This method copies results of the last measurement to the
**         user supplied buffer. Data size depends on the size of
**         measured sample group (see [SelectSampleGroup()] or
**         [CreateSampleGroup()] method). Data representation is
**         defined by the [Result type] property. Typically this method
**         is called from [OnMeasurementComplete] event to get results
**         of the last measurement. This method is not available if DMA
**         is enabled.
**     @param
**         DeviceDataPtr   - Device data structure
**                           pointer returned by [Init] method.
**     @param
**         BufferPtr       - Pointer to the start of the
**                           buffer for new results. Count of stored
**                           measured values equals to the count of the
**                           samples in the active sample group. It is
**                           in the user responsibility to provide
**                           buffer with appropriate size.
**     @return
**                         - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - The device doesn't work in the
**                           active clock configuration
**                           ERR_DISABLED - Component is disabled
*/
/* ===================================================================*/
LDD_TError AdcLdd1_GetMeasuredValues(LDD_TDeviceData *DeviceDataPtr, LDD_TData *BufferPtr)
{
  uint8_t Sample;
  AdcLdd1_TResultData *pBuffer = (AdcLdd1_TResultData *)BufferPtr;
  uint16_t ValueTemp;

  /* Device state test - this test can be disabled by setting the "Ignore enable test"
     property to the "yes" value in the "Configuration inspector" */
  if (!((AdcLdd1_TDeviceDataPtr)DeviceDataPtr)->EnUser) { /* Is the device disabled by user? */
    return ERR_DISABLED;               /* If yes then error */
  }
  /* Copy values from result registers defined in the active sample
     group to the user supplied buffer */
  for (Sample = 0U; Sample < ((AdcLdd1_TDeviceDataPtr)DeviceDataPtr)->SampleCount; Sample++) {
    ValueTemp =(uint16_t)(ADC_PDD_GetResultValueRaw(ADC1_BASE_PTR, Sample));
    pBuffer[Sample] = (int16_t)ValueTemp;
  }
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  AdcLdd1_GetMeasurementCompleteStatus (component ADC_LDD)
*/
/*!
**     @brief
**         Returns whether the measurement is done and the results can
**         be read by the user. It can be used to poll the state of
**         measurement if [Interrupt service/event] is disabled or if
**         [OnMeasurementComplete] event is disabled by the
**         [SetEventMask()] methods.
**     @param
**         DeviceDataPtr   - Device data structure
**                           pointer returned by [Init] method.
**     @return
**                         - Error code
**                           true - Measurement is done
**                           false - Measurement is in progress
*/
/* ===================================================================*/
bool AdcLdd1_GetMeasurementCompleteStatus(LDD_TDeviceData *DeviceDataPtr)
{
  uint8_t Status;
  AdcLdd1_TDeviceDataPtr DeviceDataPrv = (AdcLdd1_TDeviceDataPtr)DeviceDataPtr;
  /* {Default RTOS Adapter} Critical section begin, general PE function is used */
  EnterCritical();
  Status = DeviceDataPrv->CompleteStatus; /* Save flag for return */
  DeviceDataPrv->CompleteStatus = FALSE; /* Clear measurement complete status flag */
  /* {Default RTOS Adapter} Critical section end, general PE function is used */
  ExitCritical();
  return (bool)((Status)? TRUE : FALSE); /* Return saved status */
}

/*
** ===================================================================
**     Method      :  AdcLdd1_StartCalibration (component ADC_LDD)
*/
/*!
**     @brief
**         This method starts self calibration process. Calibration is
**         typically used to remove the effects of the gain and offset
**         from a specific reading.
**     @param
**         DeviceDataPtr   - Device data structure
**                           pointer returned by [Init] method.
**     @return
**                         - Error code
**                           ERR_OK - OK
**                           ERR_SPEED - The device doesn't work in the
**                           active clock configuration
**                           ERR_DISABLED - Component is disabled
**                           ERR_BUSY - A conversion is already running 
*/
/* ===================================================================*/
LDD_TError AdcLdd1_StartCalibration(LDD_TDeviceData *DeviceDataPtr)
{
  /* Device state test - this test can be disabled by setting the "Ignore enable test"
     property to the "yes" value in the "Configuration inspector" */
  if (!((AdcLdd1_TDeviceDataPtr)DeviceDataPtr)->EnUser) { /* Is the device disabled by user? */
    return ERR_DISABLED;               /* If yes then error */
  }
  if (ADC_PDD_GetConversionActiveFlag(ADC1_BASE_PTR) != 0U) { /* Last measurement still pending? */
    return ERR_BUSY;                   /* Yes, return ERR_BUSY */
  }
  ADC_PDD_SetConversionTriggerType(ADC1_BASE_PTR, ADC_PDD_SW_TRIGGER); /* Select SW triggering */
  ADC_PDD_WriteStatusControl1Reg(ADC1_BASE_PTR, 0U, ADC_PDD_MODULE_DISABLED | ((uint32_t)LDD_ADC_ON_MEASUREMENT_COMPLETE)); /* Set Control 1 register */
  ADC_PDD_StartCalibration(ADC1_BASE_PTR); /* Start calibration */
  return ERR_OK;
}

/*
** ===================================================================
**     Method      :  AdcLdd1_GetCalibrationResultStatus (component ADC_LDD)
*/
/*!
**     @brief
**         This method should be used for check the last calibration
**         result. If calibration completed normally the method finish
**         calibration process by writing gain calibration values.
**     @param
**         DeviceDataPtr   - Device data structure
**                           pointer returned by [Init] method.
**     @return
**                         - Error code
**                           ERR_OK - OK 
**                           ERR_FAILED - Last calibration hasn't been
**                           finished correctly
*/
/* ===================================================================*/
LDD_TError AdcLdd1_GetCalibrationResultStatus(LDD_TDeviceData *DeviceDataPtr)
{
  uint32_t GainValue;

  (void)DeviceDataPtr;                 /* Parameter is not used, suppress unused argument warning */
  if (ADC_PDD_GetCalibrationFailedStatusFlag(ADC1_BASE_PTR)) {
    return ERR_FAILED;
  }
  /* If calibration is successfully passed place calibrated value into gain registers */
  /* Cumulated gradually because of undefined behavior: the order of volatile accesses is undefined in this statement */
  GainValue = ADC_PDD_GetPlus0CalibrationValue(ADC1_BASE_PTR); /* Find plus gain value */
  GainValue += ADC_PDD_GetPlus1CalibrationValue(ADC1_BASE_PTR);
  GainValue += ADC_PDD_GetPlus2CalibrationValue(ADC1_BASE_PTR);
  GainValue += ADC_PDD_GetPlus3CalibrationValue(ADC1_BASE_PTR);
  GainValue += ADC_PDD_GetPlus4CalibrationValue(ADC1_BASE_PTR);
  GainValue += ADC_PDD_GetPlusSCalibrationValue(ADC1_BASE_PTR);
  GainValue = (GainValue >> 1U) | 0x8000U;
  ADC_PDD_SetPlusGainValue(ADC1_BASE_PTR,GainValue); /* Set plus gain value */
  GainValue = ADC_PDD_GetMinus0CalibrationValue(ADC1_BASE_PTR); /* Find minus gain value */
  GainValue += ADC_PDD_GetMinus1CalibrationValue(ADC1_BASE_PTR);
  GainValue += ADC_PDD_GetMinus2CalibrationValue(ADC1_BASE_PTR);
  GainValue += ADC_PDD_GetMinus3CalibrationValue(ADC1_BASE_PTR);
  GainValue += ADC_PDD_GetMinus4CalibrationValue(ADC1_BASE_PTR);
  GainValue += ADC_PDD_GetMinusSCalibrationValue(ADC1_BASE_PTR);
  GainValue =  (GainValue >> 1U) | 0x8000U;
  ADC_PDD_SetMinusGainValue(ADC1_BASE_PTR,GainValue); /* Set minus gain value */
  return ERR_OK;
}

/*
** ===================================================================
**     Method      :  AdcLdd1_MeasurementCompleteInterrupt (component ADC_LDD)
**
**     Description :
**         Measurement complete interrupt handler
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
PE_ISR(AdcLdd1_MeasurementCompleteInterrupt)
{
  /* {Default RTOS Adapter} ISR parameter is passed through the global variable */
  AdcLdd1_TDeviceDataPtr DeviceDataPrv = INT_ADC1__DEFAULT_RTOS_ISRPARAM;
  DeviceDataPrv->CompleteStatus = TRUE; /* Set measurement complete status flag */
  if ((DeviceDataPrv->EventMask & LDD_ADC_ON_MEASUREMENT_COMPLETE) != 0U) {
    AdcLdd1_OnMeasurementComplete(DeviceDataPrv->UserData);
  }
  (void)ADC_PDD_GetResultValueRaw(ADC1_BASE_PTR, 0U); /* Clear conversion complete flag */
}

/* END AdcLdd1. */

#ifdef __cplusplus
}  /* extern "C" */
#endif

/*!
** @}
*/
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.5 [05.21]
**     for the Freescale Kinetis series of microcontrollers.
**
** ###################################################################
*/
