/******************************************************************************
*
*       COPYRIGHT (c) 2003 MOTOROLA INC.
*       ALL RIGHTS RESERVED
*
* Filename:     mm.h
* Author:       Mark Jonas
* Revision:     1.0
*
* History:      2003-May-30: First release.
*
* Description:  Header file describing the registers in the MPC5200 Memory
*               Map module (MM).
*
* Notes:        
*
******************************************************************************/

#ifndef __MM_H
#define __MM_H

typedef struct mm_register_set {
	volatile uint32 ipbi_base_addr;      /* MBAR_MM + 0x0000 */
	volatile uint32 cs0_start_addr;      /* MBAR_MM + 0x0004 */
	volatile uint32 cs0_stop_addr;       /* MBAR_MM + 0x0008 */
	volatile uint32 cs1_start_addr;      /* MBAR_MM + 0x000c */
	volatile uint32 cs1_stop_addr;       /* MBAR_MM + 0x0010 */
	volatile uint32 cs2_start_addr;      /* MBAR_MM + 0x0014 */
	volatile uint32 cs2_stop_addr;       /* MBAR_MM + 0x0018 */
	volatile uint32 cs3_start_addr;      /* MBAR_MM + 0x001c */
	volatile uint32 cs3_stop_addr;       /* MBAR_MM + 0x0020 */
	volatile uint32 cs4_start_addr;      /* MBAR_MM + 0x0024 */
	volatile uint32 cs4_stop_addr;       /* MBAR_MM + 0x0028 */
	volatile uint32 cs5_start_addr;      /* MBAR_MM + 0x002c */
	volatile uint32 cs5_stop_addr;       /* MBAR_MM + 0x0030 */
	volatile uint32 sdram_cs0_cfg;       /* MBAR_MM + 0x0034 */
	volatile uint32 sdram_cs1_cfg;       /* MBAR_MM + 0x0038 */
	volatile uint32 rsvd0;               /* MBAR_MM + 0x003c */
	volatile uint32 rsvd1;               /* MBAR_MM + 0x0040 */
	volatile uint32 rsvd2;               /* MBAR_MM + 0x0044 */
	volatile uint32 rsvd3;               /* MBAR_MM + 0x0048 */
	volatile uint32 boot_start_addr;     /* MBAR_MM + 0x004c */
	volatile uint32 boot_stop_addr;      /* MBAR_MM + 0x0050 */
	volatile uint16 control_reg;         /* MBAR_MM + 0x0054 */
	volatile uint16 ipbi_wait_state_en;  /* MBAR_MM + 0x0056 */
	volatile uint32 cs6_start_addr;      /* MBAR_MM + 0x0058 */
	volatile uint32 cs6_stop_addr;       /* MBAR_MM + 0x005C */
	volatile uint32 cs7_start_addr;      /* MBAR_MM + 0x0060 */
	volatile uint32 cs7_stop_addr;       /* MBAR_MM + 0x0064 */
} mm_regs;

#endif /* __MM_H */
