/******************************************************************************
*
*       COPYRIGHT (c) 2003 MOTOROLA INC.
*       ALL RIGHTS RESERVED
*
* Filename:     gps.h
* Author:       Mark Jonas
* Revision:     1.0
*
* History:      2003-May-30: First release.
*
* Description:  Header file describing the registers in the MPC5200 GPIO
*               Standard module (GPS).
*
* Notes:        
*
******************************************************************************/

#ifndef __GPS_H
#define __GPS_H

typedef struct gpio_std_register_set {
	volatile uint32 port_config;     /* MBAR_GPS + 0x00 */
	volatile uint32 simple_gpioe;    /* MBAR_GPS + 0x04 */
	volatile uint32 simple_ode;      /* MBAR_GPS + 0x08 */
	volatile uint32 simple_ddr;      /* MBAR_GPS + 0x0c */
	volatile uint32 simple_dvo;      /* MBAR_GPS + 0x10 */
	volatile uint32 simple_ival;     /* MBAR_GPS + 0x14 */
	volatile uint8  outo_gpioe;      /* MBAR_GPS + 0x18 */
	volatile uint8  RES1[3];         /* MBAR_GPS + 0x19 */
	volatile uint8  outo_dvo;        /* MBAR_GPS + 0x1c */
	volatile uint8  RES2[3];         /* MBAR_GPS + 0x1d */
	volatile uint8  sint_gpioe;      /* MBAR_GPS + 0x20 */
	volatile uint8  RES3[3];         /* MBAR_GPS + 0x21 */
	volatile uint8  sint_ode;        /* MBAR_GPS + 0x24 */
	volatile uint8  RES4[3];         /* MBAR_GPS + 0x25 */
	volatile uint8  sint_ddr;        /* MBAR_GPS + 0x28 */
	volatile uint8  RES5[3];         /* MBAR_GPS + 0x29 */
	volatile uint8  sint_dvo;        /* MBAR_GPS + 0x2c */
	volatile uint8  RES6[3];         /* MBAR_GPS + 0x2d */
	volatile uint8  sint_inten;      /* MBAR_GPS + 0x30 */
	volatile uint8  RES7[3];         /* MBAR_GPS + 0x31 */
	volatile uint16 sint_itype;      /* MBAR_GPS + 0x34 */
	volatile uint16 RES8;            /* MBAR_GPS + 0x36 */
	volatile uint8  gpio_control;    /* MBAR_GPS + 0x38 */
	volatile uint8  RES9[3];         /* MBAR_GPS + 0x39 */
	volatile uint8  sint_istat;      /* MBAR_GPS + 0x3c */
	volatile uint8  sint_ival;       /* MBAR_GPS + 0x3d */
	volatile uint16 RES10;           /* MBAR_GPS + 0x3e */
} gps_regs;

#endif /* __GPS_H */
