/******************************************************************************
*
*       COPYRIGHT (c) 2003 MOTOROLA INC.
*       ALL RIGHTS RESERVED
*
* Filename:     cdm.h
* Author:       Mark Jonas
* Revision:     1.0
*
* History:      2003-May-30: First release.
*
* Description:  Header file describing the registers in the MPC5200 Clock
*               Distribution Module (CDM).
*
* Notes:        
*
******************************************************************************/

#ifndef __CDM_H
#define __CDM_H

typedef struct cdm_register_set {
    volatile uint32 jtag_id;            /* MBAR_CDM + 0x00 */
    volatile uint32 rstcfg;             /* MBAR_CDM + 0x04 */
    volatile uint32 breadcrumb;         /* MBAR_CDM + 0x08 */

    volatile uint8  mem_clk_sel;        /* MBAR_CDM + 0x0c */
    volatile uint8  xlb_clk_sel;        /* MBAR_CDM + 0x0d */
    volatile uint8  ipg_clk_sel;        /* MBAR_CDM + 0x0e */
    volatile uint8  pci_clk_sel;        /* MBAR_CDM + 0x0f */

    volatile uint8  ext_48mhz_en;       /* MBAR_CDM + 0x10 */
    volatile uint8  fd_enable;          /* MBAR_CDM + 0x11 */
    volatile uint16 fd_counters;        /* MBAR_CDM + 0x12 */

    volatile uint32 clk_enables;        /* MBAR_CDM + 0x14 */

    volatile uint8  osc_disable;        /* MBAR_CDM + 0x18 */
    volatile uint8  reserved0[3];       /* MBAR_CDM + 0x19 */

    volatile uint8  ccs_sleep_enable;   /* MBAR_CDM + 0x1c */
    volatile uint8  osc_sleep_enable;   /* MBAR_CDM + 0x1d */
    volatile uint8  reserved1;          /* MBAR_CDM + 0x1e */
    volatile uint8  ccs_qreq_test;      /* MBAR_CDM + 0x1f */

    volatile uint8  soft_reset;         /* MBAR_CDM + 0x20 */
    volatile uint8  no_ckstp;           /* MBAR_CDM + 0x21 */
    volatile uint8  reserved2[2];       /* MBAR_CDM + 0x22 */

    volatile uint8  pll_lock;           /* MBAR_CDM + 0x24 */
    volatile uint8  pll_looselock;      /* MBAR_CDM + 0x25 */
    volatile uint8  pll_sm_lockwin;     /* MBAR_CDM + 0x26 */
    volatile uint8  reserved3;          /* MBAR_CDM + 0x27 */

    volatile uint16 reserved4;          /* MBAR_CDM + 0x28 */
    volatile uint16 mclken_div_psc1;    /* MBAR_CDM + 0x2a */
    
    volatile uint16 reserved5;          /* MBAR_CDM + 0x2c */
    volatile uint16 mclken_div_psc2;    /* MBAR_CDM + 0x2e */
       
    volatile uint16 reserved6;          /* MBAR_CDM + 0x30 */
    volatile uint16 mclken_div_psc3;    /* MBAR_CDM + 0x32 */
    
    volatile uint16 reserved7;          /* MBAR_CDM + 0x34 */
    volatile uint16 mclken_div_psc6;    /* MBAR_CDM + 0x36 */
} cdm_regs;

#endif /* __CDM_H */


