/******************************************************************************
*
*       COPYRIGHT (c) 2003 MOTOROLA INC.
*       ALL RIGHTS RESERVED
*
* Filename:     core.h
* Author:       Mark Jonas
* Revision:     1.0
*
* History:      2003-May-30: First release.
*
* Description:  Header file for core.S. Supplies additional macros.
*
* Notes:        
*
******************************************************************************/

#ifndef __CORE_H
#define __CORE_H

#define NOP	__asm__ ("nop")
#define EIEIO 	__asm__ ("eieio")
#define SYNC 	__asm__ ("sync")
#define ISYNC 	__asm__ ("isync")

/*--------------------------------------------------------------------------
   Macro       : setbit(v,m)
   Description : Sets the bits set to 1 in m to 1 in v.
   Parameter(s): Variable to modify, bit mask
   Returns     : nothing
  --------------------------------------------------------------------------*/
#define setbit(v,m)		((v)|=(m))

/*--------------------------------------------------------------------------
   Macro       : clrbit(v,m)
   Description : Sets the bits set to 1 in m to 0 in v.
   Parameter(s): Variable to modify, bit mask
   Returns     : nothing
  --------------------------------------------------------------------------*/
#define clrbit(v,m)		((v)&=~(m))

/*--------------------------------------------------------------------------
   Macro       : togglebit(v,m)
   Description : Inverts the bits set to 1 in m in v, i.e. toggles them.
   Parameter(s): Variable to modify, bit mask
   Returns     : nothing
  --------------------------------------------------------------------------*/
#define togglebit(r,b)	((v)^=(m))

uint32 readMBAR (void);
uint64 readTBx (void);
void writeTBx (uint32 tbu, uint32 tbl);

#endif /* __CORE_H */