// vim: ts=4 softtabstop=4 shiftwidth=4 columns=120 lines=48 nobackup
// +FHDR------------------------------------------------------------------------
// Copyright (c) 20145Freescale Semiconductor, Inc. 
// All rights reserved
//
// This is unpublished proprietary source code of Freescale Semiconductor.
// The copyright notice above does not evidence any actual
// or intended publication of such source code.
//
// Freescale Confidential Proprietary
// -----------------------------------------------------------------------------
// FILE NAME:           sdhc_control.v
// DEPARTMENT:          Austin Hardware Design
// AUTHOR:              Gary Milliorn
// AUTHOR'S EMAIL:      gary.milliorn@freescale.com
// -----------------------------------------------------------------------------
// RELEASE HISTORY
// VERSION  DATE       AUTHOR DESCRIPTION
// 1.0      2015-06-30 Gary Milliorn         Original
// -----------------------------------------------------------------------------
// KEYWORDS:            SHDC VOLTAGE CONTROL
// -----------------------------------------------------------------------------
// PURPOSE:             Controls SDHC/EVDD operating voltage and signals.
// -----------------------------------------------------------------------------
// PARAMETERS
// -----------------------------------------------------------------------------
// REUSE ISSUES
// Reset Strategy:       HOT_RST_B:     asynchronous, active low
// Clock Domains:        HOT_CLK:       25 MHz system main clock
// Critical Timing:      <none>
// Test Features:        testmode_b:    If asserted, clock setup is bypassed.
// Asynchronous I/F:     <none>
// Scan Methodology:     <none>
// Instantiations:       <none>
// Synthesizable (y/n):  Yes
// Other:
// -FHDR------------------------------------------------------------------------

`resetall
`timescale 1ns/10ps

module sdhc_voltage ( 
    input   wire        sdslot_cd_b,
    input   wire        sdslot_wp,
    input   wire        sdhc_vs,
    input   wire        cfg_evdd_force,
    input   wire        cfg_mux_sd,
    input   wire        disable_io_b,

    output  wire        dut_cd_b,
    output  wire        dut_wp,
    output  wire        cfg_evdd_vsel
);


//---------------------------------------------------------------------------
// Basically, if for any reason we are connected to the on-board EMMC device, 
// EVDD must be limited to 1.8V.  On the LS1088ARDB:
//      0: EVDD=3.3V
//      1: EVDD=1.8V
//
    assign  cfg_evdd_vsel   = (!disable_io_b)   ? 1'b0          // OFF: keep at lowest potential
                            : (cfg_mux_sd)      ? 1'b1          // If eMMC selected, -> 1.8V
                            : (cfg_evdd_force)  ? 1'b1          // If force bit,     -> 1.8V
                            :                     sdhc_vs;      // Else DUT control.


//---------------------------------------------------------------------------
// Pass-through and translate CD/WP.  Since eMMC does not support this, set the appropriate
// levels.
//
    assign  dut_cd_b        = (!disable_io_b)   ? 1'bZ
                            : (cfg_mux_sd)      ? 1'b0
                            :                     sdslot_cd_b;

    assign  dut_wp          = (!disable_io_b)   ? 1'bZ
                            : (cfg_mux_sd)      ? 1'b0
                            :                     sdslot_wp;

endmodule
