// vim: ts=4 softtabstop=4 shiftwidth=4 columns=120 lines=48 syntax=verilog nobackup
// +FHDR------------------------------------------------------------------------
// Copyright (c) 2018 NXP Semiconductors
// All rights reserved
//
// This is unpublished proprietary source code of NXP Semiconductors.
// The copyright notice above does not evidence any actual
// or intended publication of such source code.
// -----------------------------------------------------------------------------
// FILE NAME:			qixis_defs.h
// DEPARTMENT:          Austin Hardware Design
// AUTHOR:              Gary Milliorn
// AUTHOR'S EMAIL:      gary.milliorn@nxp.com
// -----------------------------------------------------------------------------
// RELEASE HISTORY
// VERSION DATE AUTHOR DESCRIPTION
// 1.0 2018-0730  	    Gary Milliorn
// -----------------------------------------------------------------------------
// KEYWORDS:  		    QIXIS DEFS
// -----------------------------------------------------------------------------
// PURPOSE:             Definitions common to all Qixis/QixMin implementations.
// -----------------------------------------------------------------------------
// PARAMETERS
// -----------------------------------------------------------------------------
// REUSE ISSUES
// Reset Strategy:       <none>
// Clock Domains:        <none>
// Critical Timing:      <none>
// Test Features:        <none>
// Asynchronous I/F:     <none>
// Scan Methodology:     <none>
// Instantiations:       <none>
// Synthesizable (y/n):  n
// Other: 
// -FHDR------------------------------------------------------------------------



//---------------------------------------------------------------------------
// BCSRS Register Address Map
//		Standardized on all platforms.
//
	localparam [11:0]
		ADDR_ID             = 12'h000,				// 000-00F	:	ID/INFO
		ADDR_VER            = 12'h001,
		ADDR_QVER           = 12'h002,
		ADDR_MODEL          = 12'h003,				// Contents platform-specific
		ADDR_QTAG           = 12'h004,				// QDS, some newer RDBs
		ADDR_MINOR          = 12'h004,				// RDB only
		ADDR_CTL            = 12'h005,
		ADDR_AUX            = 12'h006,				// *AUX may/may not be same as AUX0
		ADDR_DBG            = 12'h007,				// *Was SPD (obsolete)
		ADDR_STAT_DUT       = 12'h008,
		ADDR_STAT_SYS       = 12'h009,
		ADDR_ALARM          = 12'h00A,
		ADDR_STAT_PRES1     = 12'h00B,
		ADDR_STAT_PRES2     = 12'h00C,
		ADDR_RCW_CTL        = 12'h00D,
		ADDR_LED            = 12'h00E,
		ADDR_QMODE          = 12'h00F,

		ADDR_RCFG           = 12'h010,				// 010-017	: RECONFIG/DCM
		ADDR_RCFG_STAT      = 12'h011,				//
		ADDR_DCM_ADDR       = 12'h012,				//
		ADDR_DCM_DATA       = 12'h013,				//
		ADDR_DCM_CMD        = 12'h014,				//
		ADDR_DCM_MSG        = 12'h015,				//
		ADDR_GDC            = 12'h016,				//
		ADDR_GDD            = 12'h017,				//

		ADDR_DCM_MACK       = 12'h018,				// 018-01E	: SPECIAL (*highly* variable)
		ADDR_SFP1			= 12'h018,

		ADDR_SFP2			= 12'h019,
		ADDR_VF_CTL         = 12'h019,

		ADDR_SFP3			= 12'h01A,
		ADDR_SDHC1          = 12'h01A,

		ADDR_SDHC2          = 12'h01B,
		ADDR_STAT_PRES3     = 12'h01C,

		ADDR_LOS_STAT       = 12'h01D,
		ADDR_USB_STAT       = 12'h01D,

		ADDR_USB_CTL        = 12'h01E,

		ADDR_WATCH          = 12'h01F,				// 01F		: WATCHDOG (always)

		ADDR_PWR_CTL1       = 12'h020,				// 020-02F	:	POWER (standardized)
		ADDR_PWR_CTL2       = 12'h021,				//
		ADDR_PWR_EVENT      = 12'h022,				//
							//     23				// reserved
		ADDR_PWR_MSTAT      = 12'h024,				//
		ADDR_PWR_STAT1      = 12'h025,				//
		ADDR_PWR_STAT2      = 12'h026,				//
		ADDR_PWR_STAT3      = 12'h027,				//
		ADDR_PWR_CFG0       = 12'h028,				//
		ADDR_PWR_CFG1       = 12'h029,				//
		ADDR_PWR_CFG2       = 12'h02A,				//
							//  2B-2F

		ADDR_CLK_SPD1		= 12'h030,				// 030-033	: CLOCK BASE
		ADDR_CLK_SPD2		= 12'h031,				//
		ADDR_CLK_CTL		= 12'h032,				//
		ADDR_CLK_ID			= 12'h033,				// ID describes 0x34..0x3F contents

													// 034-03F	: ID=0, no clock controls

		ADDR_CLK_A0			= 12'h034,				// 034-03F	: ID=1, QDS w 1..5 IDT 'FG041s
		ADDR_CLK_D0			= 12'h035,				//
		ADDR_CLK_A1			= 12'h036,				//
		ADDR_CLK_D1			= 12'h037,				//
		ADDR_CLK_A2			= 12'h038,				//
		ADDR_CLK_D2			= 12'h039,				//
		ADDR_CLK_A3			= 12'h03A,				//
		ADDR_CLK_D3			= 12'h03B,				//
		ADDR_CLK_A4			= 12'h03C,				//
		ADDR_CLK_D4			= 12'h03D,				//
							//     3E				// reserved
							//     3F				// reserved

		ADDR_CLK_SYSD0		= 12'h034,				// 034-03F	: ID=2, RDB w/SI5341
        ADDR_CLK_SYSD1		= 12'h035,				//
	
		ADDR_BLK_CTL		= 12'h038,				// 034-03F	: ID=3, QDS w/IDT UFT '287
		ADDR_BLK_STAT	    = 12'h039,				//

		ADDR_RST_CTL        = 12'h040,				// 040-04F	: RESET
		ADDR_RST_STAT       = 12'h041,				//
		ADDR_RST_REASON     = 12'h042,				//
		ADDR_RST_EVENT      = 12'h042,				//				RSTEVENT a/k/a REASON
		ADDR_RST_FORCE1     = 12'h043,				//
		ADDR_RST_FORCE2     = 12'h044,				//
		ADDR_RST_FORCE3     = 12'h045,				//
		ADDR_RST_FORCE4     = 12'h046,				//
							//     47				// reserved
		ADDR_RST_TRACK      = 12'h048,				//
		ADDR_RST_MASK1      = 12'h04B,				//
		ADDR_RST_MASK2      = 12'h04C,				//
		ADDR_RST_MASK3      = 12'h04D,				//
		ADDR_RST_MASK4      = 12'h04E,				//
							//     4F				// reserved

		ADDR_BRDCFG0        = 12'h050,				// 050-05F	: BRDCFG
		ADDR_BRDCFG1        = 12'h051,				//
		ADDR_BRDCFG2        = 12'h052,				//
		ADDR_BRDCFG3        = 12'h053,				//
		ADDR_BRDCFG4        = 12'h054,				//
		ADDR_BRDCFG5        = 12'h055,				//
		ADDR_BRDCFG6        = 12'h056,				//
		ADDR_BRDCFG7        = 12'h057,				//
		ADDR_BRDCFG8        = 12'h058,				//
		ADDR_BRDCFG9        = 12'h059,				//
		ADDR_BRDCFG10       = 12'h05A,				//
		ADDR_BRDCFG11       = 12'h05B,				//
		ADDR_BRDCFG12       = 12'h05C,				//
		ADDR_BRDCFG13       = 12'h05D,				//
		ADDR_BRDCFG14       = 12'h05E,				//
		ADDR_BRDCFG15       = 12'h05F,				//

		ADDR_DUTCFG0        = 12'h060,				// 060-06F	: DUTCFG
		ADDR_DUTCFG1        = 12'h061,				//
		ADDR_DUTCFG2        = 12'h062,				//
		ADDR_DUTCFG3        = 12'h063,				//
		ADDR_DUTCFG4        = 12'h064,				//
		ADDR_DUTCFG5        = 12'h065,				//
		ADDR_DUTCFG6        = 12'h066,				//
		ADDR_DUTCFG7        = 12'h067,				//
		ADDR_DUTCFG8        = 12'h068,				//
		ADDR_DUTCFG9        = 12'h069,				//
		ADDR_DUTCFG10       = 12'h06A,				//
		ADDR_DUTCFG11       = 12'h06B,				//
		ADDR_DUTCFG12       = 12'h06C,				//
		ADDR_DUTCFG13       = 12'h06D,				//
		ADDR_DUTCFG14       = 12'h06E,				//
		ADDR_DUTCFG15       = 12'h06F,				//

							// 070-077				// reserved
		ADDR_POST_CTL       = 12'h078,				// 078-07F:	POST/IRS (QDS only)
		ADDR_POST_STAT      = 12'h079,
		ADDR_POST_D0        = 12'h07A,
		ADDR_IRS_DATA0      = 12'h07A,
		ADDR_POST_D1        = 12'h07B,
		ADDR_IRS_DATA1      = 12'h07B,
		ADDR_POST_CMD0      = 12'h07C,
		ADDR_IRS_CMD        = 12'h07C,
		ADDR_POST_CMD1      = 12'h07D,
		ADDR_POST_CMD2      = 12'h07E,
		ADDR_POST_CMD3      = 12'h07F,

		ADDR_GPIO1_DRV0     = 12'h080,				// 080-087: GPIO1
		ADDR_GPIO1_DRV1     = 12'h081,
		ADDR_GPIO1_DRV2     = 12'h082,
		ADDR_GPIO1_DRV3     = 12'h083,
		ADDR_GPIO1_DIR0     = 12'h084,
		ADDR_GPIO1_DIR1     = 12'h085,
		ADDR_GPIO1_DIR2     = 12'h086,
		ADDR_GPIO1_DIR3     = 12'h087,

		ADDR_GPIO2_DRV0     = 12'h088,				// 088-08F: GPIO2
		ADDR_GPIO2_DRV1     = 12'h089,
		ADDR_GPIO2_DRV2     = 12'h08A,
		ADDR_GPIO2_DRV3     = 12'h08B,
		ADDR_GPIO2_DIR0     = 12'h08C,
		ADDR_GPIO2_DIR1     = 12'h08D,
		ADDR_GPIO2_DIR2     = 12'h08E,
		ADDR_GPIO2_DIR3     = 12'h08F,

		ADDR_IRQSTAT0       = 12'h090,				// 090-09F: INTERRUPT
		ADDR_IRQSTAT1       = 12'h091,
		ADDR_IRQSTAT2       = 12'h092,
							//    093  				// reserved
		ADDR_IRQCTL0		= 12'h094,
		ADDR_IRQCTL1		= 12'h095,
		ADDR_IRQCTL2		= 12'h096,
		ADDR_IRQCTL3		= 12'h097,
		ADDR_IRQDRV0        = 12'h098,
		ADDR_IRQDRV1        = 12'h099,
		ADDR_IRQDRV2        = 12'h09A,
		ADDR_IRQDRV3        = 12'h09B,
		ADDR_IRQDRV4        = 12'h09C,
		ADDR_IRQDRV5        = 12'h09D,
							//     9E				// reserved
							//     9F				// reserved

		ADDR_TRIG_SRC1      = 12'h0A0,				// TRIGEVT: QDS only
		ADDR_TRIG_SRC2      = 12'h0A1,
		ADDR_TRIG_SRC3      = 12'h0A2,
		ADDR_TRIG_SRC4      = 12'h0A3,
		ADDR_TRIG_DEST1     = 12'h0A4,
		ADDR_TRIG_DEST2     = 12'h0A5,
		ADDR_TRIG_DEST3     = 12'h0A6,
		ADDR_TRIG_DEST4     = 12'h0A7,
		ADDR_TRIG_STAT1     = 12'h0A8,
		ADDR_TRIG_STAT2     = 12'h0A9,
		ADDR_TRIG_CTL       = 12'h0AA,
		ADDR_TRIG_CTL2      = 12'h0AB,				// Undocumented
		ADDR_TRIG_DLY1      = 12'h0AC,
		ADDR_TRIG_DLY2      = 12'h0AD,
		ADDR_TRIG_DLY3      = 12'h0AE,
		ADDR_TRIG_DLY4      = 12'h0AF,

		ADDR_I1588_TTR      = 12'h0B0,
		ADDR_I1588_TPR      = 12'h0B1,
		ADDR_I1588_TAR      = 12'h0B2,
							// 0B3-0B7				// reserved
		ADDR_TPC0	 		= 12'h0B8,				// TPC: QDS only
		ADDR_TPC1	 		= 12'h0B9,
		ADDR_TPC2	 		= 12'h0BA,
		ADDR_TPC3	 		= 12'h0BB,
		ADDR_TPC4	 		= 12'h0BC,
		ADDR_TPC5	 		= 12'h0BD,
		ADDR_TPC6	 		= 12'h0BE,
		ADDR_TPC7	 		= 12'h0BF,

		ADDR_CM_FREQ0       = 12'h0C0,				// FM IP V4 or later
		ADDR_CM_FREQ1       = 12'h0C1,
		ADDR_CM_FREQ2       = 12'h0C2,
		ADDR_CM_FREQ3       = 12'h0C3,
							// 0C4-0CB				// varies
		ADDR_CM_STAT        = 12'h0CC,				// Format of 0C0..0CF
		ADDR_CM_CTL         = 12'h0CD,
		ADDR_CM_BASEH		= 12'h0CE,				// FM IPV2 or older
		ADDR_CM_BASEL		= 12'h0CF,				// "

		ADDR_IFLTCTL        = 12'h0D0,				// QDS only
		ADDR_IFLTSTAT       = 12'h0D1,				// "
		ADDR_IFLT2CTL       = 12'h0D2,				// QDS only (rare)
		ADDR_IFLT2STAT      = 12'h0D3,				// "
		ADDR_SSPI_CTL       = 12'h0D4,				// Simple SPI controller
		ADDR_SSPI_STAT      = 12'h0D5,				// "
		ADDR_SSPI_DATA      = 12'h0D6,				// "
							//     D7				// reserved
		ADDR_CMSA           = 12'h0D8,
		ADDR_CMSD           = 12'h0D9,
							// 0DA-0DB				// varies
		ADDR_SWS_CTL        = 12'h0DC,
		ADDR_SWS_STAT       = 12'h0DD,
		ADDR_PIXLAA         = 12'h0DE,				// QDS only: Pixla logic analyzer/trace
		ADDR_PIXLAD         = 12'h0DF,

		ADDR_AUX0			= 12'h0E0,				// Often an alias of AUX
		ADDR_AUX1			= 12'h0E1,
		ADDR_AUX2			= 12'h0E2,
		ADDR_AUX3			= 12'h0E3,
		ADDR_RAND0			= 12'h0E4,				// QDS (some)
		ADDR_RAND1			= 12'h0E5,				// "
		ADDR_RAND2			= 12'h0E6,				// "
		ADDR_RAND3			= 12'h0E7,				// "
		ADDR_AUX_ADDR       = 12'h0EE,
		ADDR_AUX_DATA       = 12'h0EF,

		ADDR_RCW0			= 12'h100,				// RCW space
		ADDR_RCW511			= 12'h2FF,				// "
		ADDR_RCW1023		= 12'h4FF,				// "

		ADDR_BSPI_CTL1 		= 12'hEB0,
        ADDR_BSPI_CTL2 		= 12'hEB1,
        ADDR_BSPI_STAT1 	= 12'hEB3,
        ADDR_BSPI_ADDR3 	= 12'hEB4,
        ADDR_BSPI_ADDR2 	= 12'hEB5,
        ADDR_BSPI_ADDR1 	= 12'hEB6,
        ADDR_BSPI_ADDR0 	= 12'hEB7,
        ADDR_BSPI_CSTIM1	= 12'hEB8,
        ADDR_BSPI_CSTIM0	= 12'hEB9,
        ADDR_BSPI_CKTIM1	= 12'hEBA,
        ADDR_BSPI_CKTIM0	= 12'hEBB,
        ADDR_BSPI_DBG		= 12'hEBD,
        ADDR_BSPI_TCR		= 12'hEBE,
        ADDR_BSPI_IP		= 12'hEBF,

		ADDR_QXCNT          = 12'hF00,
		ADDR_QXCTL          = 12'hF01,
		ADDR_QXSTAT         = 12'hF02,
		ADDR_QXDEVA         = 12'hF03,
		ADDR_QXBC           = 12'hF04,
		ADDR_QXD0           = 12'hF05,
		ADDR_QXD7           = 12'hF0C,				// Upper limit: BUFSIZ=8
		ADDR_QXD15          = 12'hF14,				// Upper limit: BUFSIZ=16
		ADDR_QXD31          = 12'hF24;				// Upper limit: BUFSIZ=32


//---------------------------------------------------------------------------
// PWR_EVENT field encoding.
//		Standardized on all platforms.
//
    localparam  [3:0]
		PWREVT_NONE			= 4'd0,
		PWREVT_FORCE		= 4'd1,
		PWREVT_AUTOON		= 4'd2,
		PWREVT_PWRON		= 4'd3,
		PWREVT_REGON		= 4'd4,
		PWREVT_OCMON		= 4'd5,
		PWREVT_ATXOFF		= 4'd6,
		PWREVT_PWROFF		= 4'd7,
		PWREVT_REGOFF		= 4'd8,
		PWREVT_OCMOFF		= 4'd9,
		PWREVT_THERM		= 4'd10,
		PWREVT_PFAULT		= 4'd11,
		PWREVT_PMTOG		= 4'd12,
		PWREVT_INVAL		= 4'd15;


//---------------------------------------------------------------------------
// Codes for RST_REASON/RST_PWREVENT
// 
    localparam [3:0]   
		RSTEVT_NONE         = 4'hF,
		RSTEVT_POWER        = 4'h0,
		RSTEVT_JTAG         = 4'h1,
		RSTEVT_WATCHDOG     = 4'h2,
		RSTEVT_REG          = 4'h3,
		RSTEVT_SWITCH       = 4'h4,
		RSTEVT_RECONFIG     = 4'h5,
		RSTEVT_RSTREQ       = 4'h6,
		RSTEVT_CORECPU      = 4'h7;


//---------------------------------------------------------------------------
// SPS: System Power Status 
//		Encoding allows sps[1]==0 means "stable"
//						sps[1]==1 means "transitioning"
//						sps[0]==0 means "off/mostly off"
//						sps[0]==1 means "on /mostly on"
//
    localparam  [1:0]
		SPS_ON				= 2'b01,
		SPS_POWERING		= 2'b11,
		SPS_DEPOWERING		= 2'b10,
		SPS_OFF				= 2'b00;

