/*
 * Decompiled with CFR 0.152.
 */
package com.mobileknowledge.library.utils.tlv;

import com.mobileknowledge.library.utils.Utils;

public class TLVUtils {
    public static byte[] buildTLV(byte type, byte length, byte[] value) {
        byte[] tlv = new byte[2 + length];
        tlv[0] = type;
        tlv[1] = length;
        System.arraycopy(value, 0, tlv, 2, length);
        return tlv;
    }

    public static byte[] buildTLV(byte type, byte[] value) {
        int lengthLength = 0;
        int valueLength = value.length;
        lengthLength = valueLength <= 127 ? 1 : (valueLength > 255 ? 3 : 2);
        byte[] tlv = new byte[1 + lengthLength + value.length];
        tlv[0] = type;
        if (valueLength <= 127) {
            tlv[1] = (byte)valueLength;
        } else if (valueLength > 255) {
            tlv[1] = -126;
            tlv[2] = (byte)(valueLength >> 8 & 0xFF);
            tlv[3] = (byte)(valueLength >> 0 & 0xFF);
        } else {
            tlv[1] = -127;
            tlv[2] = (byte)valueLength;
        }
        System.arraycopy(value, 0, tlv, 1 + lengthLength, value.length);
        return tlv;
    }

    public static byte[] buildTLV(short type, byte[] value) {
        int lengthLength = 0;
        int valueLength = value.length;
        lengthLength = valueLength <= 127 ? 1 : (valueLength > 255 ? 3 : 2);
        byte[] tlv = new byte[2 + lengthLength + value.length];
        tlv[0] = (byte)(type >> 8 & 0xFF);
        tlv[1] = (byte)(type >> 0 & 0xFF);
        if (valueLength <= 127) {
            tlv[2] = (byte)valueLength;
        } else if (valueLength > 255) {
            tlv[2] = -126;
            tlv[3] = (byte)(valueLength >> 8 & 0xFF);
            tlv[4] = (byte)(valueLength >> 0 & 0xFF);
        } else {
            tlv[2] = -127;
            tlv[3] = (byte)valueLength;
        }
        System.arraycopy(value, 0, tlv, 2 + lengthLength, value.length);
        return tlv;
    }

    public static byte[] getTagValue(byte[] tlv, byte tag, int offset) {
        byte[] retData = null;
        for (int i = offset; i < tlv.length; i &= 0xFF) {
            if (tag == tlv[i]) {
                int Len = 0;
                if ((tlv[i + 1] & 0x80) == 128) {
                    if ((tlv[i + 1] & 0xF) == 1) {
                        Len = tlv[i + 2] & 0xFF;
                        retData = new byte[Len];
                        System.arraycopy(tlv, i + 3, retData, 0, Len);
                        break;
                    }
                    if ((tlv[i + 1] & 0xF) != 2) break;
                    Len = tlv[i + 2] & 255 + (tlv[i + 3] & 0xFF) >> 8;
                    retData = new byte[Len];
                    System.arraycopy(tlv, i + 4, retData, 0, Len);
                    break;
                }
                Len = tlv[i + 1] & 0xFF;
                retData = new byte[Len];
                System.arraycopy(tlv, i + 2, retData, 0, Len);
                break;
            }
            if ((tlv[i] & 0x20) == 0) {
                if ((tlv[i] & 0x1F) == 31) {
                    if ((tlv[i + 2] & 0x80) == 128) {
                        if ((tlv[i + 2] & 0xF) == 1) {
                            i = i + 4 + tlv[i + 3];
                            continue;
                        }
                        if ((tlv[i + 3] & 0xF) != 2) continue;
                        i = i + 5 + tlv[i + 3] + tlv[i + 4] >> 8;
                        continue;
                    }
                    i = i + 3 + tlv[i + 2];
                    continue;
                }
                if ((tlv[i + 1] & 0x80) == 128) {
                    if ((tlv[i + 1] & 0xF) == 1) {
                        i = i + 3 + tlv[i + 2];
                        continue;
                    }
                    if ((tlv[i + 2] & 0xF) != 2) continue;
                    i = i + 4 + tlv[i + 2] + tlv[i + 3] >> 8;
                    continue;
                }
                i = i + 2 + tlv[i + 1];
                continue;
            }
            if ((tlv[i] & 0x1F) == 31) {
                if ((tlv[i + 1] & 0x80) == 128) {
                    if ((tlv[i + 1] & 0xF) == 1) {
                        i += 4;
                        continue;
                    }
                    if ((tlv[i + 2] & 0xF) != 2) continue;
                    i += 5;
                    continue;
                }
                i += 3;
                continue;
            }
            if ((tlv[i + 1] & 0x80) == 128) {
                if ((tlv[i + 1] & 0xF) == 1) {
                    i += 3;
                    continue;
                }
                if ((tlv[i + 2] & 0xF) != 2) continue;
                i += 4;
                continue;
            }
            i += 2;
        }
        return retData;
    }

    public static byte[] getTagValue(byte[] tlv, short tag, int offset) {
        byte[] tagByteArray = Utils.shortToByteArray(tag);
        byte[] retData = null;
        for (int i = offset; i < tlv.length; i &= 0xFF) {
            if (tagByteArray[0] == tlv[i] && tagByteArray[1] == tlv[i + 1]) {
                int Len = 0;
                if ((tlv[i + 2] & 0x80) == 128) {
                    if ((tlv[i + 2] & 0xF) == 1) {
                        Len = tlv[i + 3] & 0xFF;
                        retData = new byte[Len];
                        System.arraycopy(tlv, i + 4, retData, 0, Len);
                        break;
                    }
                    if ((tlv[i + 2] & 0xF) != 2) break;
                    Len = tlv[i + 3] & 255 + (tlv[i + 4] & 0xFF) >> 8;
                    retData = new byte[Len];
                    System.arraycopy(tlv, i + 5, retData, 0, Len);
                    break;
                }
                Len = tlv[i + 2] & 0xFF;
                retData = new byte[Len];
                System.arraycopy(tlv, i + 3, retData, 0, Len);
                break;
            }
            if ((tlv[i] & 0x20) == 0) {
                if ((tlv[i] & 0x1F) == 31) {
                    if ((tlv[i + 2] & 0x80) == 128) {
                        if ((tlv[i + 2] & 0xF) == 1) {
                            i = i + 4 + tlv[i + 3];
                            continue;
                        }
                        if ((tlv[i + 3] & 0xF) != 2) continue;
                        i = i + 5 + tlv[i + 3] + tlv[i + 4] >> 8;
                        continue;
                    }
                    i = i + 3 + tlv[i + 2];
                    continue;
                }
                if ((tlv[i + 1] & 0x80) == 128) {
                    if ((tlv[i + 1] & 0xF) == 1) {
                        i = i + 3 + tlv[i + 2];
                        continue;
                    }
                    if ((tlv[i + 2] & 0xF) != 2) continue;
                    i = i + 4 + tlv[i + 2] + tlv[i + 3] >> 8;
                    continue;
                }
                i = i + 2 + tlv[i + 1];
                continue;
            }
            if ((tlv[i] & 0x1F) == 31) {
                if ((tlv[i + 1] & 0x80) == 128) {
                    if ((tlv[i + 1] & 0xF) == 1) {
                        i += 4;
                        continue;
                    }
                    if ((tlv[i + 2] & 0xF) != 2) continue;
                    i += 5;
                    continue;
                }
                i += 3;
                continue;
            }
            if ((tlv[i + 1] & 0x80) == 128) {
                if ((tlv[i + 1] & 0xF) == 1) {
                    i += 3;
                    continue;
                }
                if ((tlv[i + 2] & 0xF) != 2) continue;
                i += 4;
                continue;
            }
            i += 2;
        }
        return retData;
    }
}

