/*
 * Copyright 2013, 2018, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Example Source for Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

/**
 * Header
 */
#include "Example-Rc663_ISO18000p3m3.h"
int __cdecl main(int argc, char *argv[])
{
    /* ******************************************************************************* */
    /* DECLARATION */
    /* ******************************************************************************* */
    /* data parameter storage */
    phbalReg_SerialWin_DataParams_t balSerial;
    phhalHw_Rc663_DataParams_t      halReader;
    phpalI18000p3m3_Sw_DataParams_t palI18000;
    phalI18000p3m3_Sw_DataParams_t  alI18000;

    /* common variables */
    uint8_t bIndex;
    char * pArgument;
    phStatus_t status;

    /* variables used by the BAL component */
    uint8_t * pComPort = (uint8_t*)"COM5";

    /* variables used by the HAL component */
    uint8_t bHalBufferReader[256];

    /* variables used by the AL component */
    uint8_t  bMemBank;
    uint8_t pWordPtr[4];
    uint8_t pBuffer[100];
    uint16_t wBufferSize;
    uint16_t wRxLen;
    uint8_t pMask[2];
    uint8_t pAction[2];
    int ch;
    uint8_t bWordPtrLen;
    uint8_t bWordCount;
    uint8_t bCoverCoding;
    uint8_t pPassword[5];
    uint8_t *pRecv;
    int wTmp;

    /* ******************************************************************************* */
    /* INITIALISATION */
    /* ******************************************************************************* */
    /* iterate through all arguments */
    for (bIndex = 0; bIndex < (uint8_t)argc; ++bIndex);
    {
        /* Retrive next argument */
        pArgument = argv[bIndex];

        /* */
        /* Insert argument handling here */
        /* */
    }

    /* Initialise the 'bus abstraction layer' BAL: */
    /* use the serial interface */
    status = phbalReg_SerialWin_Init(&balSerial, sizeof(phbalReg_SerialWin_DataParams_t), 0, NULL);
    CHECK_SUCCESS(status);

    status = phbalReg_SetPort(&balSerial, pComPort);
    CHECK_SUCCESS(status);

    /* initialise the 'hardware abstraction layer' HAL: */
    /* use the RC663 Reader IC, glue it together with the BAL component */
    status = phhalHw_Rc663_Init(
        &halReader,
        sizeof(phhalHw_Rc663_DataParams_t),
        &balSerial,
        NULL,
        bHalBufferReader,
        sizeof(bHalBufferReader),
        bHalBufferReader,
        sizeof(bHalBufferReader));
    CHECK_SUCCESS(status);

    /* initialise the 'protocol abstraction layer' PAL: */
    /* use the the ISO18000p3m3 (ICode EPC HF G2) protocol. */
    status = phpalI18000p3m3_Sw_Init(&palI18000, sizeof(palI18000), &halReader);
    CHECK_SUCCESS(status);

    status = phalI18000p3m3_Sw_Init(&alI18000, sizeof(alI18000), &palI18000);
    CHECK_SUCCESS(status);

    status = phbalReg_OpenPort(&balSerial);
    CHECK_SUCCESS(status);

    /* set the PCs baud rate to 115200 */
    status = phbalReg_SetConfig(&balSerial, PHBAL_REG_SERIALWIN_CONFIG_BITRATE, PHBAL_REG_SERIALWIN_VALUE_BITRATE_115200);
    CHECK_SUCCESS(status);

    /* On some machines the RS232 physical interface jitters when the port is opened. For that case, */
    /* send a dummy command in order to the resynchronise the interface. */
    phhalHw_WriteRegister(&halReader, 0x37, 0xFF);

    /* Configure HAL for ICode EPC HF G2 cards */
    status = phhalHw_ApplyProtocolSettings(&halReader, PHHAL_HW_CARDTYPE_I18000P3M3);
    CHECK_SUCCESS(status);

    /* ******************************************************************************* */
    /* CARD COMMUNICATION */
    /* ******************************************************************************* */
    /* Field Reset */
    status = phhalHw_FieldReset(&halReader);
    CHECK_SUCCESS(status);

    /* Activate card */
    /*status = phhalHw_Rc663_EnableTestMode(&halReader);
    CHECK_SUCCESS(status);*/

    /* Perform AckReq command */
    status = phhalHw_ExecuteCmd(&halReader,
        0x04,
        0,
        0,
        0,
        NULL,
        0,
        100,
        pBuffer,
        &wBufferSize);

    printf("Activate Card Status : %x\n", status);
    if (status != PH_ERR_SUCCESS)
    {
         _getch();
        return 0;
    }
    status = phalI18000p3m3_SetHandle(&alI18000,&pBuffer[wBufferSize - 2]);
    CHECK_SUCCESS(status);

    do
    {
        printf("ICODE ILT Examples\n\n");
        printf("1.Read\n");
        printf("2.Write\n");
        printf("3.BlockWrite\n");
        printf("4.Lock\n");
        printf("5.Access\n");
        printf("6.Kill\n");
        printf("7.Exit\n");
        printf("\nEnter your choice\n");
        scanf("%d", &ch);

        switch (ch)
        {
            case 1:
                printf("-------------------------------------\n");
                printf("MemBank Options:\n");
                printf("-------------------------------------\n");
                printf("0.Reserved Memory Bank\n");
                printf("1.EPC Memory Bank\n");
                printf("2.TID Memory Bank\n");
                printf("3.USER Memory Bank\n");
                printf("\nPlease Enter valid MemBank choice\n");
				scanf ( "%u", ( unsigned int * ) &bMemBank );
                if (bMemBank < 1 && bMemBank > 4)
                {
                    printf("Invalid MemBank choice\n");
                    break;
                }

                printf("-------------------------------------\n");
                printf("\nEnter Length of word pointer:\n");
                printf("-------------------------------------\n");
                printf("0.8-bit\n");
                printf("1.16-bit\n");
                printf("2.24-bit\n");
                printf("3.32-bit\n");
                scanf("%u", ( unsigned int * ) &bWordPtrLen);
                if (bWordPtrLen < 0 && bWordPtrLen > 3)
                {
                    printf("Invalid Word Pointer Length\n");
                    break;
                }

                printf("-------------------------------------\n");
                printf("Enter Word Pointer in hex\n");
                printf("-------------------------------------\n");
                for (bIndex = 0; bIndex < (bWordPtrLen + 1); bIndex++)
                {
                    scanf("%x", &wTmp);
                    pWordPtr[bIndex] = (uint8_t)wTmp;
                }

                printf("-------------------------------------\n");
                printf("No. of bytes to be read in hex\n");
                printf("Enter 0 to read whole memory bank\n");
                printf("-------------------------------------\n");
                scanf("%x", &wTmp);
                bWordCount = (uint8_t)wTmp;
                status = phalI18000p3m3_Read(&alI18000,
                    bMemBank,
                    pWordPtr,
                    bWordPtrLen,
                    bWordCount,
                    &pRecv,
                    &wRxLen);

                printf("Read Status : %x\n", status);
                if (status != PH_ERR_SUCCESS)
                {
                    printf("Read Unsuccessful\n");
                    break;
                }

                printf("-------------------------------------\n");
                printf("Data:\n");
                printf("-------------------------------------\n");
                printBufferHex(pRecv, (uint8_t)(wRxLen / 8));
                printf("\n\n");
                printf("-------------------------------------\n");
                break;

            case 2:
                printf("-------------------------------------\n");
                printf("Use Cover Coding?\n");
                printf("-------------------------------------\n");
                printf("0.No\n");
                printf("1.Yes\n");
                scanf("%u", ( unsigned int * ) &bCoverCoding);
                if (bCoverCoding < 0 && bCoverCoding > 1)
                {
                    printf("Invalid MemBank choice\n");
                    break;
                }

                printf("-------------------------------------\n");
                printf("MemBank Options:\n");
                printf("-------------------------------------\n");
                printf("0.Reserved Memory Bank\n");
                printf("1.EPC Memory Bank\n");
                printf("2.TID Memory Bank\n");
                printf("3.USER Memory Bank\n");
                printf("\nPlease Enter valid MemBank choice\n");
                scanf("%u", ( unsigned int * ) &bMemBank);
                if (bMemBank < 1 && bMemBank > 4)
                {
                    printf("Invalid MemBank choice\n");
                    break;
                }

                printf("-------------------------------------\n");
                printf("\nEnter Length of word pointer:\n");
                printf("-------------------------------------\n");
                printf("0.8-bit\n");
                printf("1.16-bit\n");
                printf("2.24-bit\n");
                printf("3.32-bit\n");
                scanf("%u", ( unsigned int * ) &bWordPtrLen);
                if (bWordPtrLen < 0 && bWordPtrLen > 3)
                {
                    printf("Invalid Word Pointer Length\n");
                    break;
                }

                printf("-------------------------------------\n");
                printf("Enter Word Pointer in hex\n");
                printf("-------------------------------------\n");
                for (bIndex = 0; bIndex < (bWordPtrLen + 1); bIndex++)
                {
                    scanf("%x", &wTmp);
                    pWordPtr[bIndex] = (uint8_t)wTmp;
                }
                printf("-------------------------------------\n");
                printf("Enter 1 word data in hex, one byte at a time\n");
                printf("-------------------------------------\n");
                scanf("%x", &wTmp);
                pBuffer[0] = (uint8_t)wTmp;
                scanf("%x", &wTmp);
                pBuffer[1] = (uint8_t)wTmp;

                status = phalI18000p3m3_Write(&alI18000,
                    bCoverCoding,
                    bMemBank,
                    pWordPtr,
                    bWordPtrLen,
                    pBuffer);

                printf("Write Status : %x\n", status);
                if (status != PH_ERR_SUCCESS)
                {
                    printf("Write Unsuccessful\n");
                    break;
                }
                printf("-------------------------------------\n");
                break;

            case 3:
                printf("-------------------------------------\n");
                printf("Block Write in ICODE ILT supoorts only two word write\n");
                printf("-------------------------------------\n");

                printf("-------------------------------------\n");
                printf("MemBank Options:\n");
                printf("-------------------------------------\n");
                printf("0.Reserved Memory Bank\n");
                printf("1.EPC Memory Bank\n");
                printf("2.TID Memory Bank\n");
                printf("3.USER Memory Bank\n");
                printf("\nPlease Enter valid MemBank choice\n");
                scanf("%u", ( unsigned int * ) &bMemBank);
                if (bMemBank < 1 && bMemBank > 4)
                {
                    printf("Invalid MemBank choice\n");
                    break;
                }

                printf("-------------------------------------\n");
                printf("\nEnter Length of word pointer:\n");
                printf("-------------------------------------\n");
                printf("0.8-bit\n");
                printf("1.16-bit\n");
                printf("2.24-bit\n");
                printf("3.32-bit\n");
                scanf("%u", ( unsigned int * ) &bWordPtrLen);
                if (bWordPtrLen < 0 && bWordPtrLen > 3)
                {
                    printf("Invalid Word Pointer Length\n");
                    break;
                }

                printf("-------------------------------------\n");
                printf("Enter Word Pointer in hex\n");
                printf("-------------------------------------\n");
                for (bIndex = 0; bIndex < (bWordPtrLen + 1); bIndex++)
                {
                    scanf("%x", &wTmp);
                    pWordPtr[bIndex] = (uint8_t)wTmp;
                }
                printf("-------------------------------------\n");
                printf("Enter 2 word data in hex, one byte at a time\n");
                printf("-------------------------------------\n");
                scanf("%x", &wTmp);
                pBuffer[0] = (uint8_t)wTmp;
                scanf("%x", &wTmp);
                pBuffer[1] = (uint8_t)wTmp;
                scanf("%x", &wTmp);
                pBuffer[2] = (uint8_t)wTmp;
                scanf("%x", &wTmp);
                pBuffer[3] = (uint8_t)wTmp;

                status = phalI18000p3m3_BlockWrite(&alI18000,
                    bMemBank,
                    pWordPtr,
                    bWordPtrLen,
                    2,
                    pBuffer);

                printf("BlockWrite Status : %x\n", status);
                if (status != PH_ERR_SUCCESS)
                {
                    printf("BlockWrite Unsuccessful\n");
                    break;
                }
                printf("-------------------------------------\n");
                break;

            case 4:
                printf("-------------------------------------\n");
                printf("\nPlease Enter Mask value in hex\n");
                printf("-------------------------------------\n");
                scanf("%x", &wTmp);
                if (wTmp > 1024)
                {
                    printf("Invalid Mask value\n");
                    break;
                }
                pMask[0] = (uint8_t)wTmp;
                pMask[1] = (uint8_t)(wTmp >> 8);

                printf("-------------------------------------\n");
                printf("\nPlease Enter Action value in hex\n");
                printf("-------------------------------------\n");
                scanf("%x", &wTmp);
                if (wTmp > 1024)
                {
                    printf("Invalid Action value\n");
                    break;
                }
                pAction[0] = (uint8_t)wTmp;
                pAction[1] = (uint8_t)(wTmp >> 8);

                status = phalI18000p3m3_Lock(&alI18000,
                    pMask,
                    pAction);

                printf("Lock Status : %x\n", status);
                if (status != PH_ERR_SUCCESS)
                {
                    printf("Lock Unsuccessful\n");
                    break;
                }
                printf("-------------------------------------\n");
                break;

            case 5:
                printf("-------------------------------------\n");
                printf("Use Cover Coding?\n");
                printf("-------------------------------------\n");
                printf("0.No\n");
                printf("1.Yes\n");
                scanf("%u", ( unsigned int * ) &bCoverCoding);
                if (bCoverCoding < 0 && bCoverCoding > 1)
                {
                    printf("Invalid MemBank choice\n");
                    break;
                }

                printf("-------------------------------------\n");
                printf("\nPlease Enter Access password in hex, one byte at a time\n");
                printf("-------------------------------------\n");
                scanf("%x", &wTmp);
                pPassword[0] = (uint8_t)wTmp;
                scanf("%x", &wTmp);
                pPassword[1] = (uint8_t)wTmp;
                scanf("%x", &wTmp);
                pPassword[2] = (uint8_t)wTmp;
                scanf("%x", &wTmp);
                pPassword[3] = (uint8_t)wTmp;

                status = phalI18000p3m3_Access(&alI18000,
                    bCoverCoding,
                    pPassword);

                printf("Access Status : %x\n", status);
                if (status != PH_ERR_SUCCESS)
                {
                    printf("Access Unsuccessful\n");
                    break;
                }
                printf("-------------------------------------\n");
                break;

            case 6:
                printf("-------------------------------------\n");
                printf("ICODE-ILT supports only Recom bit 3SB\n");
                printf("-------------------------------------\n");
                printf("\n\n-------------------------------------\n");
                printf("Use Cover Coding?\n");
                printf("-------------------------------------\n");
                printf("0.No\n");
                printf("1.Yes\n");
                scanf("%u", ( unsigned int * ) &bCoverCoding);
                if (bCoverCoding < 0 && bCoverCoding > 1)
                {
                    printf("Invalid MemBank choice\n");
                    break;
                }

                printf("-------------------------------------\n");
                printf("\nPlease Enter Access password in hex, one byte at a time\n");
                printf("-------------------------------------\n");
                scanf("%x", &wTmp);
                pPassword[1] = (uint8_t)wTmp;
                scanf("%x", &wTmp);
                pPassword[2] = (uint8_t)wTmp;
                scanf("%x", &wTmp);
                pPassword[3] = (uint8_t)wTmp;
                scanf("%x", &wTmp);
                pPassword[4] = (uint8_t)wTmp;

                status = phalI18000p3m3_Kill(&alI18000,
                    bCoverCoding,
                    pPassword,
                    4);

                printf("Kill Status : %x\n", status);
                if (status != PH_ERR_SUCCESS)
                {
                    printf("Kill Unsuccessful\n");
                    break;
                }
                printf("-------------------------------------\n");
                break;

            case 7:
                printf("Now exiting!!!");
                break;

            default:
                printf("Invalid Choice\n");
                break;
        }
    }while(ch > 0 && ch < 7);
    status = phbalReg_ClosePort(&balSerial);
    fprintf(stdout, "\npress any key to exit\n");
    _getch();
    return 0;
}

/**
* Helper functions
*/
void printBufferHex(uint8_t * pBuffer, uint8_t bLength)
{
    uint8_t bIndex;

    for (bIndex = 0; bIndex < bLength; ++bIndex)
    {
        printf("%02X ", pBuffer[bIndex]);
    }
    printf("\n");
}