/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Example Source for Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

/**
 * Header
 */
#include "Example-Rc663_ICodeEpcUid.h"
int __cdecl main(int argc, char *argv[])
{
    /* ******************************************************************************* */
    /* DECLARATION */
    /* ******************************************************************************* */
    /* data parameter storage */
    phbalReg_SerialWin_DataParams_t balSerial;
    phhalHw_Rc663_DataParams_t      halReader;
    phpalEpcUid_Sw_DataParams_t     palEpcUid;

    /* common variables */
    uint8_t bIndex;
    char * pArgument;
    phStatus_t status;

    /* variables used by the BAL component */
    uint8_t * pComPort = (uint8_t*)"COM1";

    /* variables used by the HAL component */
    uint8_t bHalBufferReader[256];

    /* variables used by the PAL component */
    uint8_t bNumSlots;
    uint8_t pMask[PHPAL_EPCUID_IDD_LENGTH], bMaskLength;
    uint8_t bHash, bTagType;
    uint8_t bMoreCardsAvaliable;
    uint8_t pUidOut[PHPAL_EPCUID_IDD_LENGTH], bRxLength;

    /* ******************************************************************************* */
    /* INITIALISATION */
    /* ******************************************************************************* */
    /* iterate through all arguments */
    for (bIndex = 0; bIndex < (uint8_t)argc; ++bIndex);
    {
        /* Retrive next argument */
        pArgument = argv[bIndex];

        /* */
        /* Insert argument handling here */
        /* */
    }

    /* initialise the 'bus abstraction layer' BAL: */
    /* use the serial interface */
    status = phbalReg_SerialWin_Init(&balSerial, sizeof(phbalReg_SerialWin_DataParams_t), 0, NULL);
    CHECK_SUCCESS(status);

    status = phbalReg_SetPort(&balSerial, pComPort);
    CHECK_SUCCESS(status);

    /* initialise the 'hardware abstraction layer' HAL: */
    /* use the RC663 Reader IC, glue it together with the BAL component */
    status = phhalHw_Rc663_Init(
        &halReader,
        sizeof(phhalHw_Rc663_DataParams_t),
        &balSerial,
        NULL,
        bHalBufferReader,
        sizeof(bHalBufferReader),
        bHalBufferReader,
        sizeof(bHalBufferReader));
    CHECK_SUCCESS(status);

    /* initialise the 'protocol abstraction layer' PAL: */
    /* use the the EpcUid protocol. */
    status = phpalEpcUid_Sw_Init(&palEpcUid, sizeof(palEpcUid), &halReader);
    CHECK_SUCCESS(status);

    status = phbalReg_OpenPort(&balSerial);
    CHECK_SUCCESS(status);

    /* set the PCs baud rate to 115200 */
    status = phbalReg_SetConfig(&balSerial, PHBAL_REG_SERIALWIN_CONFIG_BITRATE, PHBAL_REG_SERIALWIN_VALUE_BITRATE_115200);
    CHECK_SUCCESS(status);

    /* On some machines the RS232 physical interface jitters when the port is opened. For that case, */
    /* send a dummy command in order to the resynchronise the interface. */
    phhalHw_WriteRegister(&halReader, 0x37, 0xFF);

    /* Configure HAL for EpcUid tags */
    status = phhalHw_ApplyProtocolSettings(&halReader, PHHAL_HW_CARDTYPE_ICODEEPCUID);
    CHECK_SUCCESS(status);

    /* ******************************************************************************* */
    /* CARD COMMUNICATION */
    /* ******************************************************************************* */
    /* Switch on the field */
    status = phhalHw_FieldReset(&halReader);
    CHECK_SUCCESS(status);

    /* Activate EPC tag */
    bTagType = PHPAL_EPCUID_LABEL_EPC;
    bNumSlots = PHPAL_EPCUID_NUMSLOTS_1;
    bMaskLength = 0;
    bHash = 0;
    status = phpalEpcUid_ActivateCard(&palEpcUid, bTagType, bNumSlots,
                                                  pMask, bMaskLength, bHash, pUidOut,
                                                  &bRxLength, &bMoreCardsAvaliable);
    printf("phpalEpcUid_ActivateCard (EPC):  %04X\n", status);

    if(PH_ERR_SUCCESS == status)
    {
        status = phpalEpcUid_GetSerialNo(&palEpcUid, pUidOut, &bRxLength);
        printf("phpalEpcUid_GetSerialNo:   %04X\nUID: ", status);
        printBufferHex(pUidOut, bRxLength);
    }

    /* Activate UID tag */
    bTagType = PHPAL_EPCUID_LABEL_UID;
    bNumSlots = PHPAL_EPCUID_NUMSLOTS_1;
    bMaskLength = 0;
    bHash = 0;
    status = phpalEpcUid_ActivateCard(&palEpcUid, bTagType, bNumSlots,
                                                  pMask, bMaskLength, bHash, pUidOut,
                                                  &bRxLength, &bMoreCardsAvaliable);
    printf("phpalEpcUid_ActivateCard (UID):  %04X\n", status);

    if(PH_ERR_SUCCESS == status)
    {
        status = phpalEpcUid_GetSerialNo(&palEpcUid, pUidOut, &bRxLength);
        printf("phpalEpcUid_GetSerialNo:   %04X\nUID: ", status);
        printBufferHex(pUidOut, bRxLength);
    }

    status = phbalReg_ClosePort(&balSerial);
    fprintf(stdout, "\n press any key to exit\n");
    _getch();
    return 0;
}

/**
 * Helper functions
 */
void printBufferHex(uint8_t * pBuffer, uint8_t bLength)
{
    uint8_t bIndex;

    for (bIndex = 0; bIndex < bLength; ++bIndex)
    {
        printf("%02X ", pBuffer[bIndex]);
    }
    printf("\n");
}