/*
 * Copyright 2022 - 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Example program to demonstrate Random number features.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

/** Header for this file */
#include "Example-CryptoLibFootprint_RND.h"

#ifdef NXPBUILD__PH_CRYPTORNG

static void * pCryptoRng = NULL;

phStatus_t Demo_RandomNumber_Main()
{
    uint8_t bRndLen = 1;
    uint8_t bEndLoop = FALSE;
    uint32_t dwChoice = 0;
    char aChoice[5];

    uint8_t aSeed[16] = { 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F };
    uint8_t aRnd[16];

    do
    {
        dwChoice = 0;

        /* Clear the console. */
        system("cls");

        if(CRYPTORNG_MAX > 2)
        {
#ifdef NXPBUILD__PH_CRYPTORNG_SW
            printf("Press %d to demonstrate Randon number functionality using Software implementation. \n", CRYPTORNG_SOFTWARE);
#endif /* NXPBUILD__PH_CRYPTORNG_SW */

#ifdef NXPBUILD__PH_CRYPTORNG_MBEDTLS
            printf("Press %d to demonstrate Randon number functionality using external mBedTLS implementation. \n", CRYPTORNG_MBEDTLS);
#endif /* NXPBUILD__PH_CRYPTORNG_MBEDTLS */

            printf("\n");
            printf("Press x to exit the application.\n");
            printf("Press r to return to previous demo description.\n");
            printf("Enter the option and press Enter to perform the demo - ");
            scanf("%s", aChoice);

            /* Convert to Integer value. */
            ToInt(aChoice, dwChoice);

            /* Return to previous demo description if requested */
            RETURN_IF_REQUESTED(dwChoice);

            /* Exit if requested by user. */
            EXIT_IF_REQUESTED(dwChoice);
        }
        else
        {
            dwChoice = 1;
        }

        printf("\n\n");

        switch(dwChoice)
        {
#ifdef NXPBUILD__PH_CRYPTORNG_SW
            case CRYPTORNG_SOFTWARE:
                /* Initialize CryptoSym component. */
                CHECK_SUCCESS(phCryptoSym_Sw_Init(&stCryptoSymRng_Sw, (uint16_t) sizeof(phCryptoSym_Sw_DataParams_t), pKeyStore), TRUE);

                /* Initialize CryptoRng component. */
                CHECK_SUCCESS(phCryptoRng_Sw_Init(&stCryptoRng_Sw, (uint16_t) sizeof(phCryptoRng_Sw_DataParams_t), &stCryptoSymRng_Sw), TRUE);

                pCryptoRng = &stCryptoRng_Sw;

                /* End the loop */
                bEndLoop = TRUE;
                break;
#endif /* NXPBUILD__PH_CRYPTORNG_SW */

#ifdef NXPBUILD__PH_CRYPTORNG_MBEDTLS
            case CRYPTORNG_MBEDTLS:
                /* Initialize CryptoRng component. */
                CHECK_SUCCESS(phCryptoRng_mBedTLS_Init(&stCryptoRng_mBedTLS, (uint16_t) sizeof(phCryptoRng_mBedTLS_DataParams_t)), TRUE);

                pCryptoRng = &stCryptoRng_mBedTLS;

                /* End the loop */
                bEndLoop = TRUE;
                break;
#endif /* NXPBUILD__PH_CRYPTORNG_MBEDTLS */

            default:
                printf("Invalid option selected.\n");
                printf("--------------------------------------------------------------------------------------------------- \n");
                printf("\n\n");
                printf("Press any key to continue with the demonstration.\n");
                printf("Press r to return to previous demo description.\n");
                printf("Press x to exit the demonstration.\n");
                dwChoice = _getch();

                /* Return to previous demo description if requested */
                RETURN_IF_REQUESTED(dwChoice);

                /* Exit if requested by user. */
                EXIT_IF_REQUESTED(dwChoice);
                break;
        }
    } while(!bEndLoop);

    /* Clear the console. */
    system("cls");

    printf("Seeding the Random number generator.\n");
    CHECK_SUCCESS(phCryptoRng_Seed(pCryptoRng, aSeed, (uint8_t) sizeof(aSeed)), TRUE);
    printf("\tSeedLength: %d\n", (uint8_t) sizeof(aSeed));
    printf("\tSeedData  : ");
    PrintData(aSeed, sizeof(aSeed), "%02X ", "\n\n");

    printf("Generating the Random number.\n");

    for(bRndLen = 1; bRndLen <= 16; bRndLen++)
    {
        CHECK_SUCCESS(phCryptoRng_Rnd(pCryptoRng, bRndLen, aRnd), TRUE);
        printf("\tRndLength : %d\n", bRndLen);
        printf("\tRndData   : ");
        PrintData(aRnd, bRndLen, "%02X ", "\n\n");
    }

    printf("\n\n");
    printf("Press any key to continue with the demonstration.\n");
    printf("Press x to exit the demonstration.\n");
    dwChoice = _getch();

    /* Return to previous demo description if requested */
    RETURN_IF_REQUESTED(dwChoice);

    /* Exit if requested by user. */
    EXIT_IF_REQUESTED(dwChoice);

    return PH_ERR_SUCCESS;
}

#endif /* NXPBUILD__PH_CRYPTORNG */
