/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Software MIFARE(R) Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHPALMIFARE_RD710_H
#define PHPALMIFARE_RD710_H

#include <ph_Status.h>

phStatus_t phpalMifare_Rd710_ExchangeL3(
                                        phpalMifare_Rd710_DataParams_t * pDataParams,
                                        uint16_t wOption,
                                        uint8_t * pTxBuffer,
                                        uint16_t wTxLength,
                                        uint8_t ** ppRxBuffer,
                                        uint16_t * pRxLength
                                        );

phStatus_t phpalMifare_Rd710_ExchangeL4(
                                        phpalMifare_Rd710_DataParams_t * pDataParams,
                                        uint16_t wOption,
                                        uint8_t * pTxBuffer,
                                        uint16_t wTxLength,
                                        uint8_t ** ppRxBuffer,
                                        uint16_t * pRxLength
                                        );

phStatus_t phpalMifare_Rd710_ExchangePc(
                                        phpalMifare_Rd710_DataParams_t * pDataParams,
                                        uint16_t wOption,
                                        uint8_t * pTxBuffer,
                                        uint16_t wTxLength,
                                        uint8_t ** ppRxBuffer,
                                        uint16_t * pRxLength
                                        );

phStatus_t phpalMifare_Rd710_ExchangeRaw(
                                        phpalMifare_Rd710_DataParams_t * pDataParams,
                                        uint16_t wOption,
                                        uint8_t * pTxBuffer,
                                        uint16_t wTxLength,
                                        uint8_t bTxLastBits,
                                        uint8_t ** ppRxBuffer,
                                        uint16_t * pRxLength,
                                        uint8_t * pRxLastBits
                                        );

phStatus_t phpalMifare_Rd710_MfcAuthenticateKeyNo(
                                        phpalMifare_Rd710_DataParams_t * pDataParams,
                                        uint8_t bBlockNo,
                                        uint8_t bKeyType,
                                        uint16_t wKeyNo,
                                        uint16_t wKeyVersion,
                                        uint8_t * pUid
                                        );

phStatus_t  phpalMifare_Rd710_MfcAuthenticate(
                                        phpalMifare_Rd710_DataParams_t * pDataParams,
                                        uint8_t bBlockNo,
                                        uint8_t bKeyType,
                                        uint8_t * pKey,
                                        uint8_t * pUid
                                        );

#endif /* PHPALMIFARE_RD710_H */
