/*
 * Copyright 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * PCSC ISO14443-4A Component of Reader Library.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHPALI14443P4A_PCSC_H
#define PHPALI14443P4A_PCSC_H

#include <ph_Status.h>

/* Response check */
#define I14443P4A_PCSC_IS_INVALID_BLOCK_STATUS(bStatus)                       \
    ((                                                                      \
    (((bStatus) & PH_ERR_MASK) == PH_ERR_IO_TIMEOUT) ||                     \
    (((bStatus) & PH_ERR_MASK) == PH_ERR_INTEGRITY_ERROR) ||                \
    (((bStatus) & PH_ERR_MASK) == PH_ERR_FRAMING_ERROR) ||                  \
    (((bStatus) & PH_ERR_MASK) == PH_ERR_COLLISION_ERROR))                  \
    ? 1 : 0                                                                 \
    )

#define PHPAL_I14443P4A_PCSC_FWI_DEFAULT            0x04U       /* FWI default value. */
#define PHPAL_I14443P4A_PCSC_SFGI_DEFAULT           0x00U       /* SFGI default value. */
#define PHPAL_I14443P4A_PCSC_FSCI_DEFAULT           0x02U       /* FSCI default value. */

#define PHPAL_I14443P4A_PCSC_RATS                   0xE0U       /* Rats Command code. */
#define PHPAL_I14443P4A_PCSC_HALT_CMD               0x50U       /* HltA Command code. */
#define PHPAL_I14443P4A_PCSC_PPSS                   0xD0U       /* PPS Command code. */
#define PHPAL_I14443P4A_PCSC_PPS0                   0x11U       /* PPS0 code. */

#define PHPAL_I14443P4A_PCSC_S_BLOCK                0xC0U       /* ISO 14443-4 S-Block. */
#define PHPAL_I14443P4A_PCSC_S_BLOCK_RFU_BITS       0x02U       /* ISO 14443-4 S-Block RFU bits. */
#define PHPAL_I14443P4A_PCSC_PCB_CID_FOLLOWING      0x08U       /* Bit within PCB which signals presence of CID byte .*/
#define PHPAL_I14443P4A_PCSC_PCB_DESELECT           0x00U       /* Bits within PCB which signal a DESELECT command. */
#define PHPAL_I14443P4A_PCSC_ATS_T0                 1U          /* Position of T0 within ATS. */
#define PHPAL_I14443P4A_PCSC_ATS_TA1_PRESENT        0x10U       /* Bit which signals TA(1) presence. */
#define PHPAL_I14443P4A_PCSC_ATS_TB1_PRESENT        0x20U       /* Bit which signals TB(1) presence. */
#define PHPAL_I14443P4A_PCSC_ATS_TC1_PRESENT        0x40U       /* Bit which signals TC(1) presence. */
#define PHPAL_I14443P4A_PCSC_ATS_TC1_NAD_SUPPORT    0x01U       /* Bit within TC(1) which signals NAD support. */
#define PHPAL_I14443P4A_PCSC_ATS_TC1_CID_SUPPORT    0x02U       /* Bit within TC(1) which signals CID support. */

#define PHPAL_I14443P4A_PCSC_FWT_ACTIVATION_US      4833U       /* Activation FTW in microseconds. */
#define PHPAL_I14443P4A_PCSC_EXT_TIME_US            100U        /* Time extension in microseconds for all commands. */
#define PHPAL_I14443P4A_PCSC_FWT_MIN_US             303U        /* FTW min in microseconds. */
#define PHPAL_I14443P4A_PCSC_HALT_TIME_US           1100U       /* Wait time for halt command in microseconds. */

phStatus_t phpalI14443p4a_Pcsc_Rats(
    phpalI14443p4a_Pcsc_DataParams_t * pDataParams,
    uint8_t bFsdi,
    uint8_t bCid,
    uint8_t * pAts
    );

phStatus_t phpalI14443p4a_Pcsc_Pps(
    phpalI14443p4a_Pcsc_DataParams_t * pDataParams,
    uint8_t bDri,
    uint8_t bDsi
    );

phStatus_t phpalI14443p4a_Pcsc_ActivateCard(
    phpalI14443p4a_Pcsc_DataParams_t * pDataParams,
    uint8_t bFsdi,
    uint8_t bCid,
    uint8_t bDri,
    uint8_t bDsi,
    uint8_t * pAts
    );

phStatus_t phpalI14443p4a_Pcsc_GetProtocolParams(
    phpalI14443p4a_Pcsc_DataParams_t * pDataParams,
    uint8_t * pCidEnabled,
    uint8_t * pCid,
    uint8_t * pNadSupported,
    uint8_t * pFwi,
    uint8_t * pFsdi,
    uint8_t * pFsci
    );

#endif /* PHPALI14443P4A_PCSC_H */
