/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Software ISO14443-4 Component of Basic Function Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <phpalI14443p4.h>
#include <ph_RefDefs.h>

#ifdef NXPBUILD__PHPAL_I14443P4_RD710

#include "phpalI14443p4_Rd710.h"
#include <phhalHw_Rd710_Cmd.h>

phStatus_t phpalI14443p4_Rd710_Init(
                                    phpalI14443p4_Rd710_DataParams_t * pDataParams,
                                    uint16_t wSizeOfDataParams,
                                    phhalHw_Rd710_DataParams_t * pHalDataParams
                                    )
{
    if (sizeof(phpalI14443p4_Rd710_DataParams_t) != wSizeOfDataParams)
    {
        return PH_ADD_COMPCODE(PH_ERR_INVALID_DATA_PARAMS, PH_COMP_PAL_ISO14443P4);
    }
    PH_ASSERT_NULL (pDataParams);
    PH_ASSERT_NULL (pHalDataParams);

    /* Init private data */
    pDataParams->wId            = PH_COMP_PAL_ISO14443P4 | PHPAL_I14443P4_RD710_ID;
    pDataParams->pHalDataParams = pHalDataParams;

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_PAL_ISO14443P4);
}

phStatus_t phpalI14443p4_Rd710_SetProtocol(
    phpalI14443p4_Rd710_DataParams_t * pDataParams,
    uint8_t   bCidEnable,
    uint8_t   bCid,
    uint8_t   bNadEnable,
    uint8_t   bNad,
    uint8_t   bFwi,
    uint8_t   bFsdi,
    uint8_t   bFsci
    )
{
    return phhalHw_Rd710_Cmd_I14443P4_SetProtocol(
        pDataParams->pHalDataParams,
        bCidEnable,
        bCid,
        bNadEnable,
        bNad,
        bFwi,
        bFsdi,
        bFsci
        );
}

phStatus_t phpalI14443p4_Rd710_ResetProtocol(
    phpalI14443p4_Rd710_DataParams_t * pDataParams
    )
{
    return phhalHw_Rd710_Cmd_I14443P4_ResetProtocol(
        pDataParams->pHalDataParams
        );
}

phStatus_t phpalI14443p4_Rd710_Deselect(
                                        phpalI14443p4_Rd710_DataParams_t * pDataParams
                                        )
{
    return phhalHw_Rd710_Cmd_I14443P4_Deselect(
        pDataParams->pHalDataParams
        );
}

phStatus_t phpalI14443p4_Rd710_PresCheck(
    phpalI14443p4_Rd710_DataParams_t * pDataParams
    )
{
    return phhalHw_Rd710_Cmd_I14443P4_PresCheck(
        pDataParams->pHalDataParams
        );
}

phStatus_t phpalI14443p4_Rd710_Exchange(
                                        phpalI14443p4_Rd710_DataParams_t * pDataParams,
                                        uint16_t wOption,
                                        uint8_t * pTxBuffer,
                                        uint16_t wTxLength,
                                        uint8_t ** ppRxBuffer,
                                        uint16_t * pRxLength
                                        )
{
    return phhalHw_Rd710_Cmd_I14443P4_Exchange(
        pDataParams->pHalDataParams,
        wOption,
        pTxBuffer,
        wTxLength,
        ppRxBuffer,
        pRxLength
        );
}

phStatus_t phpalI14443p4_Rd710_SetConfig(
    phpalI14443p4_Rd710_DataParams_t * pDataParams,
    uint16_t wConfig,
    uint16_t wValue
    )
{
    return phhalHw_Rd710_Cmd_I14443P4_SetConfig(
        pDataParams->pHalDataParams,
        wConfig,
        wValue
        );
}

phStatus_t phpalI14443p4_Rd710_GetConfig(
    phpalI14443p4_Rd710_DataParams_t * pDataParams,
    uint16_t wConfig,
    uint16_t * pValue
    )
{
    return phhalHw_Rd710_Cmd_I14443P4_GetConfig(
        pDataParams->pHalDataParams,
        wConfig,
        pValue
        );
}

#endif /* NXPBUILD__PHPAL_I14443P4_RD710 */
