/*
 * Copyright 2017, 2020, 2023, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal definitions for Software palFelica Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHPALFELICA_SW_INT_H
#define PHPALFELICA_SW_INT_H

#include <ph_Status.h>

/** \addtogroup ph_Private
* @{
*/

/** \name Felica Command Codes
*/
/** @{ */
#define PHPAL_FELICA_SW_CMD_REQC            0x00U   /**< RequestC. */
#define PHPAL_FELICA_SW_CMD_REQ_RESP        0x04U   /**< Request Response. */
#define PHPAL_FELICA_SW_CMD_REQ_SERVICE     0x02U   /**< Request Service. */
#define PHPAL_FELICA_SW_CMD_READ            0x06U   /**< Read. */
#define PHPAL_FELICA_SW_CMD_WRITE           0x08U   /**< Write. */
#define PHPAL_FELICA_SW_CMD_AUTH1           0x10U   /**< Authentication1. */
#define PHPAL_FELICA_SW_CMD_AUTH2           0x12U   /**< Authentication2. */
#define PHPAL_FELICA_SW_CMD_READ_SECF       0x14U   /**< Read from secure file. */
#define PHPAL_FELICA_SW_CMD_WRITE_SECF      0x16U   /**< Write to secure file. */
#define PHPAL_FELICA_SW_RSP_REQC            0x01U   /**< Response to RequestC. */
/** @} */

/** \name Flags
*/
/** @{ */
/** Error Flag. */
#define PHPAL_FELICA_SW_FLAG_ERROR      0x01U
/** Addressed Flag. */
#define PHPAL_FELICA_SW_FLAG_ADDRESSED  0x20U
/** Selected Flag. */
#define PHPAL_FELICA_SW_FLAG_SELECTED   0x10U
/** @} */

/** \name Values
*/
/** @{ */
/** Stored UID is valid. */
#define PHPAL_FELICA_SW_IDMPMM_VALID    0x01U
/** Stored UID is not valid. */
#define PHPAL_FELICA_SW_IDMPMM_INVALID  0x00U
/** @} */

/** \name Timing constants
*/
/** @{ */
#define PHPAL_FELICA_SW_TIME_T_US						302U
#define PHPAL_FELICA_SW_EXT_TIME_US						120U    /**< Time extension in microseconds for all commands.  */
#define PHPAL_FELICA_SW_RESP_TIME_A_US					(2417U + PHPAL_FELICA_SW_EXT_TIME_US)
#define PHPAL_FELICA_SW_RESP_TIME_B_US					1208U
#define PHPAL_FELICA_SW_SENSE_F_RESP_DURATION_212_US    944U
#define PHPAL_FELICA_SW_SENSE_F_RESP_DURATION_424_US    472U
#define PHPAL_FELICA_SW_TR1_DURATION_212_US             227U
#define PHPAL_FELICA_SW_TR1_DURATION_424_US             114U
#define PHPAL_FELICA_SW_RESP_TIME_B_US                  1208U
/** @} */

/**
* end of ph_Private
* @}
*/

#endif /* PHPALFELICA_SW_INT_H */
