/*
 * Copyright 2013, 2015, 2017, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal definitions for FPGA-Box Reader specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#include <ph_Status.h>
#include <phbalReg.h>
#include <ph_RefDefs.h>
#include <string.h>
#include <phTools.h>

#ifdef NXPBUILD__PHHAL_HW_RDFPGAV6

#include "phhalHw_RdFpgaV6.h"
#include "phhalHw_RdFpgaV6_Int.h"

#ifdef _WIN32

#pragma warning(push)                   /* PRQA S 3116 */
#pragma warning(disable:4001)           /* PRQA S 3116 */
#include "external/phDefines.h"
#pragma warning(pop)                    /* PRQA S 3116 */

#endif

phStatus_t phhalHw_RdFpgaV6_Int_ConvertError(phhalHw_RdFpgaV6_DataParams_t * pDataParams,
                                             int16_t status)
{
    switch (status)
    {
    case PH_RDL_ERR_OK:
        return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_HAL);

    case PH_RDL_ERR_IO_TIMEOUT:
        return PH_ADD_COMPCODE(PH_ERR_IO_TIMEOUT, PH_COMP_HAL);

    case PH_RDL_ERR_CRC_ERROR:
    case PH_RDL_ERR_PARITY_ERROR:
        return PH_ADD_COMPCODE(PH_ERR_INTEGRITY_ERROR, PH_COMP_HAL);

    case PH_RDL_ERR_BITCOUNT_ERROR:
    case PH_RDL_ERR_FRAMING_ERROR:
        return PH_ADD_COMPCODE(PH_ERR_FRAMING_ERROR, PH_COMP_HAL);

    case PH_RDL_ERR_COLLISION_ERROR:
        return PH_ADD_COMPCODE(PH_ERR_COLLISION_ERROR, PH_COMP_HAL);

    case PH_RDL_ERR_PROTOCOL_ERROR:
        return PH_ADD_COMPCODE(PH_ERR_PROTOCOL_ERROR, PH_COMP_HAL);

    case PH_RDL_ERR_BUF_TOO_SMALL:
        return PH_ADD_COMPCODE(PH_ERR_BUFFER_OVERFLOW, PH_COMP_HAL);

    case PH_RDL_ERR_INVALID_PARAMETER:
        return PH_ADD_COMPCODE(PH_ERR_INVALID_PARAMETER, PH_COMP_HAL);

    case PH_RDL_ERR_READER_OPENING_FAILED:
        return PH_ADD_COMPCODE(PH_ERR_INTERFACE_ERROR, PH_COMP_HAL);

    case PH_RDL_ERR_PARAM_HAL_SETTING:
    case PH_RDL_ERR_PARAM_NOT_SUPPORTED:
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_PARAMETER, PH_COMP_HAL);

    case PH_RDL_ERR_NOT_IMPLEMENTED:
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_HAL);

    case PH_RDL_ERR_INTERNAL_ERROR:
    case PH_RDL_ERR_NOT_MATCH_ERROR:
        return PH_ADD_COMPCODE(PH_ERR_INTERNAL_ERROR, PH_COMP_HAL);

    default:
        pDataParams->wAdditionalInfo = (uint16_t) status;
        return PH_ADD_COMPCODE(PHHAL_HW_RDFPGAV6_ERR_DLL, PH_COMP_HAL);
    }
}

phStatus_t phhalHw_RdFpgaV6_Int_Wait(uint16_t wWaitTime)
{
#ifdef _WIN32
    phTools_Sleep(wWaitTime);

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_DL_RDFPGA);
#else
    return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_COMMAND, PH_COMP_DL_RDFPGA);
#endif
}

phStatus_t phhalHw_RdFpgaV6_Int_GetDigDelay(
    phhalHw_RdFpgaV6_DataParams_t * pDataParams,
    uint32_t * pdwTimeoutUs
    )
{
    phStatus_t  PH_MEMLOC_REM statusTmp;
    uint16_t wClearAfterColl;

    /* get the status of RxNoError */
    PH_CHECK_SUCCESS_FCT(statusTmp, phhalHw_RdFpgaV6_GetConfig(pDataParams, PHHAL_HW_CONFIG_CLEARBITSAFTERCOLL, &wClearAfterColl));

    switch (pDataParams->bCardType)
    {
    case PHHAL_HW_CARDTYPE_ISO14443A:
        /* add additional timeout */
        if (wClearAfterColl == PH_ON)
        {
            *pdwTimeoutUs = *pdwTimeoutUs + PHHAL_HW_RDFPGAV6_V6_I14443_ADD_DELAY_US;
        }
        else
        {
            *pdwTimeoutUs = *pdwTimeoutUs + PHHAL_HW_RDFPGAV6_V6_I14443_ADD_DELAY_US_ANTICOLLISION;
        }
        break;

    case PHHAL_HW_CARDTYPE_ISO14443B:
        *pdwTimeoutUs = *pdwTimeoutUs + PHHAL_HW_RDFPGAV6_V6_I14443_ADD_DELAY_US_TYPEB;
        break;
    case PHHAL_HW_CARDTYPE_FELICA:
        *pdwTimeoutUs = *pdwTimeoutUs + PHHAL_HW_RDFPGAV6_V6_I14443_ADD_DELAY_US_TYPEF;
        break;

    default:
        /* card not supported */
        return PH_ADD_COMPCODE(PH_ERR_UNSUPPORTED_PARAMETER, PH_COMP_HAL);
    }

    return PH_ADD_COMPCODE(PH_ERR_SUCCESS, PH_COMP_DL_RDFPGA);
}

#endif /* NXPBUILD__PHHAL_HW_RDFPGAV6 */
