/*
 * Copyright 2017 - 2018, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal functions and definitions for PCSC HAL.
 *
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_PCSC_INT_H
#define PHHALHW_PCSC_INT_H

#include <ph_Status.h>
#include <phhalHw.h>
#include <phbalReg.h>

phStatus_t phhalHw_Pcsc_Int_GetTxBuffer(
    phhalHw_Pcsc_DataParams_t * pDataParams,
    uint8_t ** pTxBuffer,
    uint16_t * pTxBufferLen,
    uint16_t * pTxBufferSize
    );

phStatus_t phhalHw_Pcsc_Int_GetRxBuffer(
    phhalHw_Pcsc_DataParams_t * pDataParams,
    uint8_t ** pRxBuffer,
    uint16_t * pRxBufferLen,
    uint16_t * pRxBufferSize
    );

phStatus_t phhalHw_Pcsc_Int_CheckErrorCode(
    phhalHw_Pcsc_DataParams_t * pDataParams,
    uint8_t * pErrorCode
    );

phStatus_t phhalHw_Pcsc_Int_CheckResponse(
    phhalHw_Pcsc_DataParams_t * pDataParams,
    uint8_t * pInData,
    uint16_t wInDataLength,
    uint8_t ** ppOutData,
    uint16_t * pOutDataLength
    );

phStatus_t phhalHw_Pcsc_Int_IsTransparentSession(
    phhalHw_Pcsc_DataParams_t * pDataParams
    );

void phhalHw_Pcsc_Int_GetLcValue(
    uint16_t * pLc,
    uint16_t wTxLength,
    uint8_t bTxBitsLen
    );

phStatus_t phhalHw_Pcsc_Int_SetMinFDT(
    phhalHw_Pcsc_DataParams_t * pDataParams,
    uint16_t wValue
    );

#endif  /* PHHALHW_PCSC_INT_H */
