/*
 * Copyright 2013, 2019 - 2020, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
* Internal definitions for RS232 (Windows) BAL Component of Reader Library Framework.
* $Author: Rajendran Kumar (nxp99556) $
* $Revision: 7467 $
* $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
*/

#ifndef PHBALREG_SERIALWIN_INT_H
#define PHBALREG_SERIALWIN_INT_H

#include <ph_Status.h>

#ifdef _WIN32
#pragma warning(push)           /* PRQA S 3116 */
#pragma warning(disable:4001)   /* PRQA S 3116 */
#include <Windows.h>
#pragma warning(pop)            /* PRQA S 3116 */
#endif

/** \addtogroup ph_Private
* @{
*/

/** Default timeout value to guarantee no deadlocks (ReadBus & WriteBus) */
#define PHBAL_REG_SERIALWIN_RX_TIMEOUT_VAL    100

/**
* \brief Change host bit rate
*
* Changes host bit rate, stop bits and applies default settings (parity and the like).
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlaying component.
*/
phStatus_t phbalReg_SerialWin_Int_SetMode(
    void * phPort,          /**< [In] handle to an open communication port */
    uint32_t dwBitRate,     /**< [In] bit rate value in windows-style (like '115200', in decimal) */
    uint8_t bStopBits,      /**< [In] number of stop bits */
    uint8_t bParity,        /**< [In] parity */
    uint8_t bDtr,			/**< [In] DTR Signal */
    uint8_t bRts			/**< [In] RTS Signal */
    );

/**
* \brief Change reception timeout
*
* Applies new serial reception timeout
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlaying component.
*/
phStatus_t phbalReg_SerialWin_Int_SetTimeout(
    phbalReg_SerialWin_DataParams_t * pDataParams
    );

phStatus_t phbalReg_SerialWin_Int_SetBitRate(
    void * phPort,          /**< [In] handle to an open communication port */
    uint32_t dwBitRate      /**< [In] bit rate value in windows-style (like '115200', in decimal) */
    );

phStatus_t phbalReg_SerialWin_Int_SetBitRateFromFiDi(
                                                     phbalReg_SerialWin_DataParams_t * pDataParams
                                                     );


/** @}
* end of ph_Private group
*/

#endif /* PHBALREG_SERIALWIN_INT_H */
