/*
 * Copyright 2024 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
* SAM (Secure Access Module) internal implementation via I2C interface for Reader Library
* $Author: Rajendran Kumar (nxp99556) $
* $Revision: 7467 $
* $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
*
* History:
*  Rajendran Kumar: Generated 08. Feb 2024
*
*/

#ifndef PHBALREG_SAM_I2C_H
#define PHBALREG_SAM_I2C_H

#include <ph_Status.h>

#ifdef NXPBUILD__PHBAL_REG_SAM

#include <phbalReg.h>

#define PHBAL_SAM_CONFIG_I2C_ADDRESS            0x2BU

#define PHBAL_SAM_CMD_CLA_COMMUNICATION_I2C     0x60U
#define PHBAL_SAM_CMD_INS_I2C_EXCHANGE_DATA     0x02U
#define PHBAL_SAM_CMD_INS_I2C_TRANSMIT_DATA     0x03U
#define PHBAL_SAM_CMD_INS_I2C_RECEIVE_DATA      0x04U

#define PHBAL_SAM_CMD_CLA_CONFIGURATION         0xB0U
#define PHBAL_SAM_CMD_INS_CONFIGURATION_SET     0x03U

#define PHBAL_SAM_I2C_CONFIG_BITRATE            0x0062U
#define PHBAL_SAM_I2C_CONFIG_TIMEOUT_MS         0x0063U
#define PHBAL_SAM_I2C_CONFIG_POWER_SAM          0x0065U

#define PHBAL_SAM_I2C_POWER_OFF_SAM             0x01U
#define PHBAL_SAM_I2C_POWER_ON_SAM              0x00U

#define PHBAL_SAM_I2C_READ_UNKNOWN              0x00U

#define PHBAL_SAM_I2C_CMD_EXCHANGE_DATA         0x6002U
#define PHBAL_SAM_I2C_CMD_TRANSMIT_DATA         0x6003U
#define PHBAL_SAM_I2C_CMD_RECEIVE_DATA          0x6004U

#define PHBAL_SAM_I2C_CMD_SET_CONFIGURATION     0xB003U

phStatus_t phbalReg_Sam_Int_Exchange_I2C(phbalReg_Sam_DataParams_t * pDataParams, uint8_t bCommType, uint8_t bCmd,
    uint8_t * pData, uint16_t wDataLen, uint32_t dwBytesToRead, uint8_t ** ppResponse, uint16_t * pRspLen);





phStatus_t phbalReg_Sam_ActivateSam_I2C(phbalReg_Sam_DataParams_t * pDataParams);

phStatus_t phbalReg_Sam_DeActivateSam_I2C(phbalReg_Sam_DataParams_t * pDataParams);

phStatus_t phbalReg_Sam_TransmitData_I2C(phbalReg_Sam_DataParams_t * pDataParams, uint8_t * pTxBuffer, uint16_t wTxBufLen,
    uint16_t wRxBufSize, uint8_t * pRxBuffer, uint16_t * pRxBufLen);

#endif /* NXPBUILD__PHBAL_REG_SAM */

#endif /* PHBALREG_SAM_I2C_H */
