/*
 * Copyright 2013 - 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Build System Definitions for Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PH_NXPBUILD_H
#define PH_NXPBUILD_H

/** \defgroup ph_NxpBuild NXP Build
 * \brief Controls build behavior of components.
 * @{
 */

/* NXPBUILD_DELETE: included code lines should be always removed from code */

/* NXP Build defines                            */
/* use #define to include components            */
/* comment out #define to exclude components    */

/* DEBUG build mode */

#ifdef _DEBUG
#endif

/* BAL components ------------------------------------------------------------------------------------------------------------ */
#define NXPBUILD__PHBAL_REG_STUB                            /**< Stub BAL definition */
#define NXPBUILD__PHBAL_REG_SERIALWIN                       /**< SerialWin BAL definition */
#define NXPBUILD__PHBAL_REG_PCSCWIN                         /**< PcscWin BAL definition */
#define NXPBUILD__PHBAL_REG_RD70XUSBWIN                     /**< Rd70X_UsbWin BAL definition */
#define NXPBUILD__PHBAL_REG_PIPELIN                         /**< PipeLin BAL definition */
#define NXPBUILD__PHBAL_REG_RD710SAM                        /**< Rd710Sam BAL definition */
#define NXPBUILD__PHBAL_REG_SAM                             /**< Sam BAL definition */
#define NXPBUILD__PHBAL_REG_SAM_INTERNAL                    /**< Sam BAL definition available in internal package only. */
#define NXPBUILD__PHBAL_REG_SOCKETWIN                       /**< SocketWin BAL definition #### SD */
#define NXPBUILD__PHBAL_REG_VISA                            /**< VISA BAL definition */
#define NXPBUILD__PHBAL_REG_RDFPGAV6                        /**< FPGA BOX BAL definition */
#define NXPBUILD__PHBAL_REG_PS6000USB                       /**< PicoScope OSCI BAL definition */
#define NXPBUILD__PHBAL_REG_MP300USB                        /**< Mp300Usb BAL definition */
#define NXPBUILD__PHBAL_REG_MULTISOCKET                     /**< MultiSocket BAL definition */
#define NXPBUILD__PHBAL_REG_PROXILAB                        /**< ProxiLAB BAL definition */
#define NXPBUILD__PHBAL_REG_RDSCR01                         /**< RdScr01 BAL definition */
#define NXPBUILD__PHBAL_REG_RDSCR2                          /**< RdScr2 BAL definition */
#define NXPBUILD__PHBAL_REG_CONTACTLAB                      /**< ContactLAB BAL definition */
#define NXPBUILD__PHBAL_REG_SMARTWARE                       /**< SmartWare BAL definition */

#if defined (NXPBUILD__PHBAL_REG_STUB) || \
    defined (NXPBUILD__PHBAL_REG_SERIALWIN) || \
    defined (NXPBUILD__PHBAL_REG_PCSCWIN) || \
    defined (NXPBUILD__PHBAL_REG_RD70XUSBWIN) || \
    defined (NXPBUILD__PHBAL_REG_PIPELIN) || \
    defined (NXPBUILD__PHBAL_REG_SOCKETWIN) || \
    defined (NXPBUILD__PHBAL_REG_RD710SAM) || \
    defined (NXPBUILD__PHBAL_REG_SAM) || \
    defined (NXPBUILD__PHBAL_REG_SAM_INTERNAL) || \
    defined (NXPBUILD__PHBAL_REG_VISA) || \
    defined (NXPBUILD__PHBAL_REG_RDFPGAV6) || \
    defined (NXPBUILD__PHBAL_REG_PS6000USB) || \
    defined (NXPBUILD__PHBAL_REG_MP300USB) || \
    defined (NXPBUILD__PHBAL_REG_MULTISOCKET) || \
    defined (NXPBUILD__PHBAL_REG_PROXILAB) || \
    defined (NXPBUILD__PHBAL_REG_RDSCR01) || \
    defined (NXPBUILD__PHBAL_REG_RDSCR2) || \
    defined (NXPBUILD__PHBAL_REG_CONTACTLAB) || \
    defined (NXPBUILD__PHBAL_REG_SMARTWARE)
    #define NXPBUILD__PHBAL_REG                             /**< Generic BAL definition */
#endif




/* HAL components ------------------------------------------------------------------------------------------------------------ */
#define NXPBUILD__PHHAL_HW_RC523                            /**< Rc523 HAL definition */
#define NXPBUILD__PHHAL_HW_SAM                              /**< Sam HAL definition. This will be common for SAM AV3, SAM AV4, and future SAM's */
#define NXPBUILD__PHHAL_HW_SAMAV2                           /**< SamAV2 HAL definition */
#define NXPBUILD__PHHAL_HW_SAMAV3                           /**< SamAV3 HAL definition */
#define NXPBUILD__PHHAL_HW_RD70X                            /**< Rd70X HAL definition */
#define NXPBUILD__PHHAL_HW_RC632                            /**< Rc632 HAL definition */
#define NXPBUILD__PHHAL_HW_RDCARDSIM                        /**< RdCardSim HAL definition */
#define NXPBUILD__PHHAL_HW_LICENSEEWRAPPER                  /**< LicenseeWrapper HAL definition */
#define NXPBUILD__PHHAL_HW_CALLBACK                         /**< Callback HAL definition */
#define NXPBUILD__PHHAL_HW_RC663                            /**< Rc663 HAL definition */
#define NXPBUILD__PHHAL_HW_RD710                            /**< Rd710 HAL definition */
#define NXPBUILD__PHHAL_HW_MP300                            /**< Mp300 HAL definition */
#define NXPBUILD__PHHAL_HW_MFCCRYPTO                        /**< MIFARE (R) Crypto HAL definition */
#define NXPBUILD__PHHAL_HW_RDFPGAV6                         /**< RdFpga HAL definition */
#define NXPBUILD__PHHAL_HW_DUT                              /**< DUT HAL Definition*/
#define NXPBUILD__PHHAL_HW_DUT_CMD_VERSION                  /**< DUT HAL Definition for Version */
#define NXPBUILD__PHHAL_HW_DUT_CMD_HAL                      /**< DUT HAL Definition for Hal Commands */
#define NXPBUILD__PHHAL_HW_DUT_CMD_RDOPS                    /**< DUT HAL Definition for Reader Operations */
#define NXPBUILD__PHHAL_HW_DUT_CMD_CC                       /**< DUT HAL Definition for Contact Card */
#define NXPBUILD__PHHAL_HW_DUT_CMD_I2C                      /**< DUT HAL Definition for I2C */
#define NXPBUILD__PHHAL_HW_DUT_CMD_CRYPTOSYM                /**< DUT HAL Definition for Symmetric Crypto */
#define NXPBUILD__PHHAL_HW_DUT_CMD_CRYPTORNG                /**< DUT HAL Definition for Random number generator */
#define NXPBUILD__PHHAL_HW_DUT_CMD_KEYSTORE                 /**< DUT HAL Definition for KeyStore */
#define NXPBUILD__PHHAL_HW_DUT_CMD_KEYSTORE_NDA             /**< DUT HAL Definition for KeyStore NDA */
#define NXPBUILD__PHHAL_HW_ISO3                             /**< ISO3 HAL definition */
#define NXPBUILD__PHHAL_HW_PROXILAB                         /**< ProxiLAB HAL */
#define NXPBUILD__PHHAL_HW_PCSC                             /**< PCSC HAL definition */

#if defined (NXPBUILD__PHHAL_HW_RC523) || \
    defined (NXPBUILD__PHHAL_HW_SAM) || \
    defined (NXPBUILD__PHHAL_HW_SAMAV2) || \
    defined (NXPBUILD__PHHAL_HW_SAMAV3) || \
    defined (NXPBUILD__PHHAL_HW_RD70X) || \
    defined (NXPBUILD__PHHAL_HW_RDCARDSIM) || \
    defined (NXPBUILD__PHHAL_HW_CALLBACK) || \
    defined (NXPBUILD__PHHAL_HW_RC663) || \
    defined (NXPBUILD__PHHAL_HW_RC632) || \
    defined (NXPBUILD__PHHAL_HW_MFCCRYPTO) || \
    defined (NXPBUILD__PHHAL_HW_RD710) || \
    defined (NXPBUILD__PHHAL_HW_MP300) || \
    defined (NXPBUILD__PHHAL_HW_RDFPGAV6) || \
    defined (NXPBUILD__PHHAL_HW_DUT) || \
    defined (NXPBUILD__PHHAL_HW_DUT_CMD_VERSION) || \
    defined (NXPBUILD__PHHAL_HW_DUT_CMD_HAL) || \
    defined (NXPBUILD__PHHAL_HW_DUT_CMD_RDOPS) || \
    defined (NXPBUILD__PHHAL_HW_DUT_CMD_CC) || \
    defined (NXPBUILD__PHHAL_HW_DUT_CMD_I2C) || \
    defined (NXPBUILD__PHHAL_HW_DUT_CMD_CRYPTOSYM) || \
    defined (NXPBUILD__PHHAL_HW_DUT_CMD_CRYPTORNG) || \
    defined (NXPBUILD__PHHAL_HW_DUT_CMD_KEYSTORE) || \
    defined (NXPBUILD__PHHAL_HW_DUT_CMD_KEYSTORE_NDA) || \
    defined (NXPBUILD__PHHAL_HW_ISO3) || \
    defined (NXPBUILD__PHHAL_HW_PROXILAB) || \
    defined (NXPBUILD__PHHAL_HW_LICENSEEWRAPPER) || \
    defined (NXPBUILD__PHHAL_HW_PCSC)
    #define NXPBUILD__PHHAL_HW                              /**< Generic HAL definition */
#endif

/* Contact HAL components ------------------------------------------------------------------------------------------------------------ */

#define NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS               /**< Contact based MicroPross HAL */
#define NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT              /**< Contact based Transparent HAL */
#define NXPBUILD__PHHAL_HW_CONTACT_RDSCR01                  /**< Contact based RDSCR01 HAL */
#define NXPBUILD__PHHAL_HW_CONTACT_RDSCR2                   /**< Contact based RDSCR2 HAL */
#define NXPBUILD__PHHAL_HW_CONTACT_SMARTWARE                /**< Contact based SmartWare HAL */
#define NXPBUILD__PHHAL_HW_CONTACT_KEOLABS                  /**< Contact based KeoLabs HAL */
#define NXPBUILD__PHHAL_HW_CONTACT_CALLBACK                 /**< Callback HALContact definition */

#if defined (NXPBUILD__PHHAL_HW_CONTACT_CALLBACK) || \
    defined (NXPBUILD__PHHAL_HW_CONTACT_MICROPROSS) || \
    defined (NXPBUILD__PHHAL_HW_CONTACT_TRANSPARENT) || \
    defined (NXPBUILD__PHHAL_HW_CONTACT_RDSCR01) || \
    defined (NXPBUILD__PHHAL_HW_CONTACT_RDSCR2) || \
    defined (NXPBUILD__PHHAL_HW_CONTACT_SMARTWARE) || \
    defined (NXPBUILD__PHHAL_HW_CONTACT_KEOLABS)
    #define NXPBUILD__PHHAL_HWCONTACT                       /**< Generic HAL Contact definition */
#endif


/* PAL components ------------------------------------------------------------------------------------------------------------ */
/* PAL ISO 14443-3A components */
#define NXPBUILD__PHPAL_I14443P3A_NDA                       /**< Internal PAL ISO 14443-3A definition */
#define NXPBUILD__PHPAL_I14443P3A_SW                        /**< Software PAL ISO 14443-3A definition */
#define NXPBUILD__PHPAL_I14443P3A_SAMAV2_X                  /**< SamAV2 X PAL ISO 14443-3A definition */
#define NXPBUILD__PHPAL_I14443P3A_SAMAV3_X                  /**< SamAV3 X PAL ISO 14443-3A definition */
#define NXPBUILD__PHPAL_I14443P3A_SAM_X                     /**< SAM (AV4 and future SAM's) X PAL ISO 14443-3A definition */
#define NXPBUILD__PHPAL_I14443P3A_RD70X                     /**< Rd70X PAL ISO 14443-3A definition */
#define NXPBUILD__PHPAL_I14443P3A_RD710                     /**< Rd710 PAL ISO 14443-3A definition */
#define NXPBUILD__PHPAL_I14443P3A_PCSC                      /**< PCSC PAL ISO 14443-3A definition */
#define NXPBUILD__PHPAL_I14443P3A_CALLBACK                  /**< Callback PAL ISO 14443-3A definition */

#if defined (NXPBUILD__PHPAL_I14443P3A_NDA) || \
    defined (NXPBUILD__PHPAL_I14443P3A_SW) || \
    defined (NXPBUILD__PHPAL_I14443P3A_SAMAV2_X) || \
    defined (NXPBUILD__PHPAL_I14443P3A_SAMAV3_X) || \
    defined (NXPBUILD__PHPAL_I14443P3A_SAM_X) || \
    defined (NXPBUILD__PHPAL_I14443P3A_RD70X) || \
    defined (NXPBUILD__PHPAL_I14443P3A_RD710) || \
    defined (NXPBUILD__PHPAL_I14443P3A_PCSC) || \
    defined (NXPBUILD__PHPAL_I14443P3A_CALLBACK)
    #define NXPBUILD__PHPAL_I14443P3A                       /**< Generic PAL ISO 14443-3A definition */
#endif

/* PAL ISO 14443-3B components */
#define NXPBUILD__PHPAL_I14443P3B_SW                        /**< Software PAL ISO 14443-3B definition */

#if defined (NXPBUILD__PHPAL_I14443P3B_SW)
    #define NXPBUILD__PHPAL_I14443P3B                       /**< Generic PAL ISO 14443-3B definition */
#endif

/* PAL ISO 14443-4A components */
#define NXPBUILD__PHPAL_I14443P4A_SW                        /**< Software PAL ISO 14443-4A definition */
#define NXPBUILD__PHPAL_I14443P4A_SAMAV2_X                  /**< SamAV2_X PAL ISO 14443-4A definition */
#define NXPBUILD__PHPAL_I14443P4A_SAMAV3_X                  /**< SamAV3_X PAL ISO 14443-4A definition */
#define NXPBUILD__PHPAL_I14443P4A_SAM_X                     /**< SAM (AV4 and future SAM's) PAL ISO 14443-4A definition */
#define NXPBUILD__PHPAL_I14443P4A_RD710                     /**< Rd710 PAL ISO 14443-4A definition */
#define NXPBUILD__PHPAL_I14443P4A_PCSC                      /**< PCSC PAL ISO 14443-4A definition */
#define NXPBUILD__PHPAL_I14443P4A_CALLBACK                  /**< Callback PAL ISO 14443-4A definition */
#if defined (NXPBUILD__PHPAL_I14443P4A_SW) || \
    defined (NXPBUILD__PHPAL_I14443P4A_SAMAV2_X) || \
    defined (NXPBUILD__PHPAL_I14443P4A_SAMAV3_X) || \
    defined (NXPBUILD__PHPAL_I14443P4A_SAM_X) || \
    defined (NXPBUILD__PHPAL_I14443P4A_RD710) || \
    defined (NXPBUILD__PHPAL_I14443P4A_PCSC) || \
    defined (NXPBUILD__PHPAL_I14443P4A_CALLBACK)
    #define NXPBUILD__PHPAL_I14443P4A                       /**< Generic PAL ISO 14443-4A definition */
#endif

/* PAL ISO 14443-4 components */
#define NXPBUILD__PHPAL_I14443P4_SW                         /**< Software PAL ISO 14443-4 definition */
#define NXPBUILD__PHPAL_I14443P4_SAMAV2_X                   /**< SamAV2_X PAL ISO 14443-4 definition */
#define NXPBUILD__PHPAL_I14443P4_SAMAV3_X                   /**< SamAV3_X PAL ISO 14443-4 definition */
#define NXPBUILD__PHPAL_I14443P4_SAM_X                      /**< SAM (AV4 and future SAM's) PAL ISO 14443-4 definition */
#define NXPBUILD__PHPAL_I14443P4_RD710                      /**< Rd710 PAL ISO 14443-4 definition */
#define NXPBUILD__PHPAL_I14443P4_ANDROID                    /**< Android dummy PAL for ISO 14443-4 definition */
#define NXPBUILD__PHPAL_I14443P4_PCSC                       /**< PCSC PAL ISO 14443-4 definition */
#define NXPBUILD__PHPAL_I14443P4_CALLBACK                   /**< Callback PAL ISO 14443-4 definition */

#if defined (NXPBUILD__PHPAL_I14443P4_SW) || \
    defined (NXPBUILD__PHPAL_I14443P4_SAMAV2_X) || \
    defined (NXPBUILD__PHPAL_I14443P4_SAMAV3_X) || \
    defined (NXPBUILD__PHPAL_I14443P4_SAM_X) || \
    defined (NXPBUILD__PHPAL_I14443P4_RD710) || \
    defined (NXPBUILD__PHPAL_I14443P4_ANDROID) || \
    defined (NXPBUILD__PHPAL_I14443P4_PCSC) || \
    defined (NXPBUILD__PHPAL_I14443P4_CALLBACK)
    #define NXPBUILD__PHPAL_I14443P4                        /**< Generic PAL ISO 14443-4 definition */
#endif

/* PAL ISO 7816P4 components */
#define NXPBUILD__PHPAL_I7816P4_SW                          /**< Software PAL ISO 7816 definition */

#if defined (NXPBUILD__PHPAL_I7816P4_SW)
    #define NXPBUILD__PHPAL_I7816P4                         /**< Generic PAL ISO 7816 definition */
#endif

/* PAL ISO 7816P4A components */
#define NXPBUILD__PHPAL_I7816P4A_SW                         /**< Software PAL ISO 7816 definition */

#if defined (NXPBUILD__PHPAL_I7816P4A_SW)
    #define NXPBUILD__PHPAL_I7816P4A                        /**< Generic PAL ISO 7816 definition */
#endif

/* PAL MIFARE components */
#define NXPBUILD__PHPAL_MIFARE_STUB                         /**< Stub PAL MIFARE */
#define NXPBUILD__PHPAL_MIFARE_SW                           /**< Software PAL MIFARE */
#define NXPBUILD__PHPAL_MIFARE_SW_CONTACT                   /**< Software PAL MIFARE using contact interface */
#define NXPBUILD__PHPAL_MIFARE_SAMAV2_X                     /**< SamAV2_X PAL MIFARE */
#define NXPBUILD__PHPAL_MIFARE_SAMAV3_X                     /**< SamAV3_X PAL MIFARE */
#define NXPBUILD__PHPAL_MIFARE_SAM_X                        /**< SAM (AV4 and future SAM's) PAL MIFARE */
#define NXPBUILD__PHPAL_MIFARE_RD710                        /**< Rd710 PAL MIFARE */
#define NXPBUILD__PHPAL_MIFARE_PCSC                         /**< PCSC PAL MIFARE */

#if defined (NXPBUILD__PHPAL_MIFARE_STUB) || \
    defined (NXPBUILD__PHPAL_MIFARE_SW) || \
    defined (NXPBUILD__PHPAL_MIFARE_SW_CONTACT) || \
    defined (NXPBUILD__PHPAL_MIFARE_SAMAV2_X) || \
    defined (NXPBUILD__PHPAL_MIFARE_SAMAV3_X) || \
    defined (NXPBUILD__PHPAL_MIFARE_SAM_X) || \
    defined (NXPBUILD__PHPAL_MIFARE_RD710) || \
    defined (NXPBUILD__PHPAL_MIFARE_PCSC)
    #define NXPBUILD__PHPAL_MIFARE                          /**< Generic PAL MIFARE definition */
#endif

/* PAL ISO15693 ICode SLI components */
#define NXPBUILD__PHPAL_SLI15693_SW                         /**< Software PAL SLI 15693 */
#define NXPBUILD__PHPAL_SLI15693_RD710                      /**< PAL SLI 15693 using RD710 Hardware */
#define NXPBUILD__PHPAL_SLI15693_INTERNAL 


#if defined (NXPBUILD__PHPAL_SLI15693_SW) || \
    defined (NXPBUILD__PHPAL_SLI15693_RD710)
    #define NXPBUILD__PHPAL_SLI15693                        /**< Generic PAL SLI 15693 definition */
#endif

/* PAL FeLiCa components */
#define NXPBUILD__PHPAL_FELICA_SW                           /**< Software PAL FeLiCa */

#if defined (NXPBUILD__PHPAL_FELICA_SW)
    #define NXPBUILD__PHPAL_FELICA                          /**< Generic PAL FeLiCa definition */
#endif

/* PAL ICode EPC/UID components */
#define NXPBUILD__PHPAL_EPCUID_SW                           /**< Software ICode EPC/UID */

#if defined (NXPBUILD__PHPAL_EPCUID_SW)
    #define NXPBUILD__PHPAL_EPCUID                          /**< Generic PAL ICode EPC/UID definition */
#endif

/* PAL I18000p3m3 components */
#define NXPBUILD__PHPAL_I18000P3M3_SW                       /**< Software I18000p3m3 */

#if defined (NXPBUILD__PHPAL_I18000P3M3_SW)
    #define    NXPBUILD__PHPAL_I18000P3M3                   /**< Generic PAL I18000p3m3 definition */
#endif

/* PAL ISO 18092 components */
#define NXPBUILD__PHPAL_I18092MPI_SW                        /**< Software PAL ISO 18092 definition */

#if defined (NXPBUILD__PHPAL_I18092MPI_SW)
    #define NXPBUILD__PHPAL_I18092MPI                       /**< Generic PAL ISO 18092 definition */
#endif




/* AL components ------------------------------------------------------------------------------------------------------------- */
/* AL FeLiCa components */
#define NXPBUILD__PHAL_FELICA_SW                            /**< Software AL FeLiCa */

#if defined (NXPBUILD__PHAL_FELICA_SW)
    #define NXPBUILD__PHAL_FELICA                           /**< Generic AL FeLiCa definition */
#endif

/* AL MIFARE Ultralight components */
#define NXPBUILD__PHAL_MFUL_SW                              /**< Software MIFARE Ultralight */
#define NXPBUILD__PHAL_MFUL_SAM_NONX                        /**< Sam NonX MIFARE Ultralight */
#define NXPBUILD__PHAL_MFUL_SAMAV2_NONX                     /**< Sam AV2 NonX MIFARE Ultralight */
#define NXPBUILD__PHAL_MFUL_SAMAV3_NONX                     /**< Sam AV3 NonX MIFARE Ultralight */
#define NXPBUILD__PHAL_MFUL_SAM_X                           /**< Sam X MIFARE Ultralight */
#define NXPBUILD__PHAL_MFUL_SAMAV2_X                        /**< Sam AV3 X MIFARE Ultralight */
#define NXPBUILD__PHAL_MFUL_SAMAV3_X                        /**< Sam AV3 X MIFARE Ultralight */

#if defined (NXPBUILD__PHAL_MFUL_SW) || \
    defined (NXPBUILD__PHAL_MFUL_SAM_NONX) || \
    defined (NXPBUILD__PHAL_MFUL_SAM_X)
    #define NXPBUILD__PHAL_MFUL                             /**< Generic AL MIFARE Ultralight definition */
#endif

/* AL MIFARE Classic components */
#define NXPBUILD__PHAL_MFC_SW                               /**< Software MIFARE Classic */
#define NXPBUILD__PHAL_MFC_SAM_X                            /**< Sam_X MIFARE Classic */
#define NXPBUILD__PHAL_MFC_SAMAV2_X                         /**< MIFARE Classic SAM AV2 X component. */
#define NXPBUILD__PHAL_MFC_SAMAV3_X                         /**< MIFARE Classic SAM AV3 X component. */

#if defined (NXPBUILD__PHAL_MFC_SW) || \
    defined (NXPBUILD__PHAL_MFC_SAM_X)
    #define NXPBUILD__PHAL_MFC                              /**< Generic AL MIFARE Classic definition */
#endif

/* AL MIFARE Plus components */
#define NXPBUILD__PHAL_MFP_NDA                              /**< MIFARE Plus build macro for IP Protection */
#define NXPBUILD__PHAL_MFP_SW                               /**< Software MIFARE Plus */
#define NXPBUILD__PHAL_MFP_SAM_NONX                         /**< Sam_NonX MIFARE Plus */
#define NXPBUILD__PHAL_MFP_SAM_X                            /**< SamAV2_X MIFARE Plus */
#define NXPBUILD__PHAL_MFP_SAMAV3_NONX 

#define NXPBUILD__PHAL_MFP_SAMAV3_X 


#if defined (NXPBUILD__PHAL_MFP_NDA) || \
    defined (NXPBUILD__PHAL_MFP_SW) || \
    defined (NXPBUILD__PHAL_MFP_SAM_NONX) || \
    defined (NXPBUILD__PHAL_MFP_SAM_X)
    #define NXPBUILD__PHAL_MFP                              /**< Generic AL MIFARE Plus definition */
#endif

/* AL MIFARE Plus EVx components */
#define NXPBUILD__PHAL_MFPEVX_INTERNAL                     /**< MIFARE Plus EVx build macro for internal development */
#define NXPBUILD__PHAL_MFPEVX_NDA                           /**< MIFARE Plus EVx build macro for IP Protection */
#define NXPBUILD__PHAL_MFPEVX_SW                            /**< Software MIFARE Plus EVx */
#define NXPBUILD__PHAL_MFPEVX_SAM_NONX                      /**< Sam NonX AL for MIFARE Plus EVx */
#define NXPBUILD__PHAL_MFPEVX_SAM_X                         /**< SAM AV3 X-Mode MIFARE Plus EVx */

#if defined (NXPBUILD__PHAL_MFPEVX_NDA) || \
    defined (NXPBUILD__PHAL_MFPEVX_SW) || \
    defined (NXPBUILD__PHAL_MFPEVX_SAM_NONX) || \
    defined (NXPBUILD__PHAL_MFPEVX_SAM_X)
    #define NXPBUILD__PHAL_MFPEVX                           /**< Generic AL MIFARE Plus EVx definition */
#endif

/* AL MIFARE DESFire components */
#define NXPBUILD__PHAL_MFDF_NDA                             /**< MIFARE DESFire build macro for IP Protection */
#define NXPBUILD__PHAL_MFDF_SW                              /**< Software MIFARE DESFire */
#define NXPBUILD__PHAL_MFDF_SAM_NONX                        /**< SAM S-Mode MIFARE DESFire */
#define NXPBUILD__PHAL_MFDF_SAM_X                           /**< SAM X-Mode MIFARE DESFire */
#define NXPBUILD__PHAL_MFDF_SAMAV3_NONX                     /**< Sam AV3 NONX MIFARE DESFire */
#define NXPBUILD__PHAL_MFDF_SAMAV3_X                        /**< Sam AV3 X MIFARE DESFire */

#if defined (NXPBUILD__PHAL_MFDF_NDA) || \
    defined (NXPBUILD__PHAL_MFDF_SW) || \
    defined (NXPBUILD__PHAL_MFDF_SAM_NONX) || \
    defined (NXPBUILD__PHAL_MFDF_SAM_X)
    #define NXPBUILD__PHAL_MFDF                             /**< Generic AL MIFARE DESFire definition */
#endif

/* AL MIFARE DESFire EVx components */
#define NXPBUILD__PHAL_MFDFEVX_INTERNAL                     /**< MIFARE DESFire EVx build macro for internal development */
#define NXPBUILD__PHAL_MFDFEVX_NDA                          /**< MIFARE DESFire EVx build macro for IP Protection */
#define NXPBUILD__PHAL_MFDFEVX_SW                           /**< Software MIFARE DESFire EVx */
#define NXPBUILD__PHAL_MFDFEVX_SAM_NONX                     /**< Sam NonX MIFARE DESFire EVx */
#define NXPBUILD__PHAL_MFDFEVX_SAM_X                        /**< Sam X-Mode MIFARE DESFire EVx */

#if defined (NXPBUILD__PHAL_MFDFEVX_NDA) || \
    defined (NXPBUILD__PHAL_MFDFEVX_SW) || \
    defined (NXPBUILD__PHAL_MFDFEVX_SAM_NONX) || \
    defined (NXPBUILD__PHAL_MFDFEVX_SAM_X)
    #define NXPBUILD__PHAL_MFDFEVX                          /**< Generic AL MIFARE DESFire EVx definition */
#endif

/* AL MIFARE DESFire Light components */
#define NXPBUILD__PHAL_MFDFLIGHT_SW                         /**< Software MIFARE DESFire Light */
#define NXPBUILD__PHAL_MFDFLIGHT_SAM_NONX                   /**< SAM NONX MIFARE DESFire Light */
#define NXPBUILD__PHAL_MFDFLIGHT_SAM_X                      /**< SAM X MIFARE DESFire Light */

#if defined (NXPBUILD__PHAL_MFDFLIGHT_SW) || \
    defined (NXPBUILD__PHAL_MFDFLIGHT_SAM_NONX) || \
    defined (NXPBUILD__PHAL_MFDFLIGHT_SAM_X)
    #define NXPBUILD__PHAL_MFDFLIGHT                        /**< Generic AL MIFARE DESFire Light definition */
#endif

/* AL MIFARE DUOX components */
#define NXPBUILD__PHAL_MFDUOX_NDA                           /**< MIFARE DUOX build macro for IP Protection */
#define NXPBUILD__PHAL_MFDUOX_SW                            /**< Software MIFARE DUOX. */

#if defined (NXPBUILD__PHAL_MFDUOX_NDA) || \
    defined (NXPBUILD__PHAL_MFDUOX_SW)
    #define NXPBUILD__PHAL_MFDUOX                           /**< Generic AL MIFARE DUOX definition */
#endif

/* AL MIFARE IDENTITY components */
#define NXPBUILD__PHAL_MFIDENTITY_SW                        /**< Software MIFARE Identity */
#define NXPBUILD__PHAL_MFIDENTITY_SAM_NONX                  /**< SAM NONX MIFARE Identity */
#define NXPBUILD__PHAL_MFIDENTITY_SAM_X                     /**< SAM X MIFARE Identity */

#if defined (NXPBUILD__PHAL_MFIDENTITY_SW) || \
    defined (NXPBUILD__PHAL_MFIDENTITY_SAM_NONX) || \
    defined (NXPBUILD__PHAL_MFIDENTITY_SAM_X)
    #define NXPBUILD__PHAL_MFIDENTITY                       /**< Generic AL MIFARE Identity definition */
#endif

/* AL MIFARE PRIME Ntag42XDna components */
#define NXPBUILD__PHAL_MFNTAG42XDNA_SW                      /**< Software MIFARE Ntag42XDna */
#define NXPBUILD__PHAL_MFNTAG42XDNA_SAM_NONX                /**< SAM NONX MIFARE Ntag42XDna */
#define NXPBUILD__PHAL_MFNTAG42XDNA_SAM_X                   /**< SAM X MIFARE Ntag42XDna */

#if defined (NXPBUILD__PHAL_MFNTAG42XDNA_SW) || \
    defined (NXPBUILD__PHAL_MFNTAG42XDNA_SAM_NONX) || \
    defined (NXPBUILD__PHAL_MFNTAG42XDNA_SAM_X)
    #define NXPBUILD__PHAL_MFNTAG42XDNA                     /**< Generic AL MIFARE Prime Ntag42XDna definition */
#endif

/* AL NTAG X DNA components */
#define NXPBUILD__PHAL_NTAGXDNA_SW                          /**< Software NTAG X DNA */

#if defined (NXPBUILD__PHAL_NTAGXDNA_SW)
    #define NXPBUILD__PHAL_NTAGXDNA                         /**< Generic AL MIFARE Prime Ntag42XDna definition */
#endif

/* AL MIFARE PRIME NTAG 413 components */
#define NXPBUILD__PHAL_MFPRIMENTAG_SW                       /**< Software MIFARE Prime NTAG */
#define NXPBUILD__PHAL_MFPRIMENTAG_SAM_NONX                 /**< SAM NONX MIFARE Prime NTAG */
#define NXPBUILD__PHAL_MFPRIMENTAG_SAM_X                    /**< SAM X MIFARE Prime NTAG */

#if defined (NXPBUILD__PHAL_MFPRIMENTAG_SW) || \
    defined (NXPBUILD__PHAL_MFPRIMENTAG_SAM_NONX) || \
    defined (NXPBUILD__PHAL_MFPRIMENTAG_SAM_X)
    #define NXPBUILD__PHAL_MFPRIMENTAG                      /**< Generic AL MIFARE Prime NTAG definition */
#endif

/* AL Virtual Card Architecture components */
#define NXPBUILD__PHAL_VCA_INTERNAL                         /**< VCA ? PC build macro for internal development */
#define NXPBUILD__PHAL_VCA_SW                               /**< Software Virtual Card Architecture */
#define NXPBUILD__PHAL_VCA_SAM_NONX                         /**< SamAV2 Virtual Card Architecture */
#define NXPBUILD__PHAL_VCA_SAM_X                            /**< SamAV2_X Virtual Card Architecture */
#define NXPBUILD__PHAL_VCA_SAMAV3_NONX 

#define NXPBUILD__PHAL_VCA_SAMAV3_X 


#if defined (NXPBUILD__PHAL_VCA_SW) || \
    defined (NXPBUILD__PHAL_VCA_SAM_X) || \
    defined (NXPBUILD__PHAL_VCA_SAM_NONX)
    #define NXPBUILD__PHAL_VCA                              /**< Generic AL Virtual Card Architecture definition */
#endif

/* AL ICode components */
#define NXPBUILD__PHAL_ICODE_SW                             /**< Software AL for ICode */
#define NXPBUILD__PHAL_ICODE_SAM_NONX                       /**< Sam NonX AL for ICode */
#define NXPBUILD__PHAL_ICODE_INTERNAL 


#if defined (NXPBUILD__PHAL_ICODE_SW) || \
    defined (NXPBUILD__PHAL_ICODE_SAM_NONX)
    #define NXPBUILD__PHAL_ICODE                            /**< Generic AL ICode definition */
#endif

/* AL ISO 18000P3M3 components */
#define NXPBUILD__PHAL_I18000P3M3_SW                        /**< Software AL I18000p3m3 */

#if defined (NXPBUILD__PHAL_I18000P3M3_SW)
#define NXPBUILD__PHAL_I18000P3M3                           /**< Generic AL I18000p3m3 definition */
#endif

/* AL P40 PrivateCommands components */
#define NXPBUILD__PHAL_P40CMDPRIV_SW                        /**< Software AL P40  PrivateCommands*/

#if defined (NXPBUILD__PHAL_P40CMDPRIV_SW)
#define NXPBUILD__PHAL_P40CMDPRIV                           /**< Generic AL P40 PrivateCommand definition */
#endif

/* AL P40 PublicCommand components */
#define NXPBUILD__PHAL_P40CMDPUB_SW                         /**< Software AL P40 PublicCommand*/

#if defined (NXPBUILD__PHAL_P40CMDPUB_SW)
#define NXPBUILD__PHAL_P40CMDPUB                            /**< Generic AL P40 PublicCommand definition */
#endif




/* Device Layer components --------------------------------------------------------------------------------------------------- */
/* DL FPGA Box components */
#define NXPBUILD__PHDL_RDFPGA_V6                            /**< FPGA Box measurement reader */

#if defined (NXPBUILD__PHDL_RDFPGA_V6)
    #define NXPBUILD__PHDL_RDFPGA                           /**< Generic FPGA Box reader definition */
#endif

/* DL ISO3 components */
#ifdef NXPBUILD__PHHAL_HW_ISO3
#define NXPBUILD__PHDL_ISO3_FDT                         /**< ISO3 Device layer */
#define NXPBUILD__PHDL_ISO3_FILTERCALIBRATION           /**< ISO3 Filter Calibration */

#if defined (NXPBUILD__PHDL_ISO3_FDT) || \
    defined (NXPBUILD__PHDL_ISO3_FILTERCALIBRATION)
        #define NXPBUILD__PHDL_ISO3
    #endif
#endif

/* DL Amplifier components */
#define NXPBUILD__PHDL_AMP_AR75A250                         /**< AR75A250 Amplifier */
#define NXPBUILD__PHDL_AMP_BBA100                           /**< BBA100 Amplifier */
#define NXPBUILD__PHDL_AMP_BBA150                           /**< BBA150 Amplifier */
#define NXPBUILD__PHDL_AMP_MPRFA                            /**< MicroPross MPRFA Amplifier */

#if defined (NXPBUILD__PHDL_AMP_AR75A250) || \
    defined (NXPBUILD__PHDL_AMP_BBA100) || \
    defined (NXPBUILD__PHDL_AMP_BBA150) || \
    defined (NXPBUILD__PHDL_AMP_MPRFA)
    #define NXPBUILD__PHDL_AMP                              /**< Generic Amplifier definition */
#endif

/* DL ThermoStream components */
#define NXPBUILD__PHDL_THSTRM_TP04030                       /**< TP04030 ThermoStream */
#define NXPBUILD__PHDL_THSTRM_ATS545                        /**< ATS545 ThermoStream */

#if defined (NXPBUILD__PHDL_THSTRM_TP04030) || \
    defined (NXPBUILD__PHDL_THSTRM_ATS545)
    #define NXPBUILD__PHDL_THSTRM                           /**< Generic ThermoStream definition */
#endif

/* DL Oscilloscope components */
#define NXPBUILD__PHDL_OSCI_LW64XI                          /**< 64Xi Oscilloscope */
#define NXPBUILD__PHDL_OSCI_DSO7052A                        /**< DSO7052A Oscilloscope */
#define NXPBUILD__PHDL_OSCI_PICOSCOPE6000                   /**< PicoScope 6000 Oscilloscope */
#ifdef NXPBUILD__PHHAL_HW_ISO3
#define NXPBUILD__PHDL_OSCI_ISO3SOFTSCOPE               /**< ISO 3 Soft Oscilloscope */
#endif

#if defined (NXPBUILD__PHDL_OSCI_LW64XI) || \
    defined (NXPBUILD__PHDL_OSCI_DSO7052A) || \
    defined (NXPBUILD__PHDL_OSCI_PICOSCOPE6000) || \
    defined (NXPBUILD__PHDL_OSCI_ISO3SOFTSCOPE)
    #define NXPBUILD__PHDL_OSCI                             /**< Generic Oscilloscope definition */
#endif

/* DL Spectrum Analyzer components */
#define NXPBUILD__PHDL_SPA_FSV                              /**< R&S FSV */

#if defined (NXPBUILD__PHDL_SPA_FSV)
    #define NXPBUILD__PHDL_SPA                              /**< Generic Spectrum Analyzer definition */
#endif

/* DL PowerSupply components */
#define NXPBUILD__PHDL_POWERSUPPLY_E3631A                   /**< E3631A PowerSupply */

#if defined (NXPBUILD__PHDL_POWERSUPPLY_E3631A)
    #define NXPBUILD__PHDL_POWERSUPPLY                      /**< Generic Oscilloscope definition */
#endif

/* DL Master Amplifier Oscilloscope components */
#define NXPBUILD__PHDL_MSTAMPOSC_AR75A250                   /**< Software Master Amplifier Oscilloscope */
#define NXPBUILD__PHDL_MSTAMPOSC_ISOSETUP                   /**< ISO Setup Master Amplifier Oscilloscope */
#define NXPBUILD__PHDL_MSTAMPOSC_MP300                      /**< Mp300 Setup Master Amplifier Oscilloscope */
#ifdef NXPBUILD__PHHAL_HW_ISO3
#define NXPBUILD__PHDL_MSTAMPOSC_ISO3                   /**< ISO 3 Setup */
#endif

#if defined (NXPBUILD__PHDL_MSTAMPOSC_ISO3) || \
    defined (NXPBUILD__PHDL_MSTAMPOSC_AR75A250) || \
    defined (NXPBUILD__PHDL_MSTAMPOSC_ISOSETUP) || \
    defined (NXPBUILD__PHDL_MSTAMPOSC_MP300)
    #define NXPBUILD__PHDL_MSTAMPOSC                        /**< Generic Master Amplifier Oscilloscope definition */
#endif


/* DL Stepper components */
#define NXPBUILD__PHDL_STEPPER_V1                           /**< V1 Stepper */
#define NXPBUILD__PHDL_STEPPER_ROBOT                        /**< Robot Stepper */
#define NXPBUILD__PHDL_STEPPER_MICROBOT                     /**< MicroBot Stepper */
#define NXPBUILD__PHDL_STEPPER_HIGHZ                        /**< High-Z S-400, S-720 and S-1000 robot */
#define NXPBUILD__PHDL_STEPPER_DENSO_VS60                   /**< Denso VS 60 Robot */
#define NXPBUILD__PHDL_STEPPER_WACHLER                      /**< Wachler */

#if defined (NXPBUILD__PHDL_STEPPER_V1) || \
    defined (NXPBUILD__PHDL_STEPPER_ROBOT) || \
    defined (NXPBUILD__PHDL_STEPPER_MICROBOT) || \
    defined (NXPBUILD__PHDL_STEPPER_HIGHZ) || \
    defined (NXPBUILD__PHDL_STEPPER_WACHLER)
    #define NXPBUILD__PHDL_STEPPER                          /**< Generic Stepper definition */
#endif




/* Common components --------------------------------------------------------------------------------------------------------- */
/* CID Manager components */
#define NXPBUILD__PH_CIDMANAGER_SW                          /**< Software CID Manager */
#define NXPBUILD__PH_CIDMANAGER_RD710                       /**< Rd710 CID Manager */

#if defined (NXPBUILD__PH_CIDMANAGER_SW) || \
    defined (NXPBUILD__PH_CIDMANAGER_RD710)
    #define NXPBUILD__PH_CIDMANAGER                         /**< Generic CID Manager definition */
#endif

/* Crypto Sym components */
#define NXPBUILD__PH_CRYPTOSYM_SW                           /**< Software CryptoSym */
#define NXPBUILD__PH_CRYPTOSYM_LRP                          /**< LRP CryptoSym */
#define NXPBUILD__PH_CRYPTOSYM_STUB                         /**< Stub CryptoSym */
#define NXPBUILD__PH_CRYPTOSYM_MBEDTLS                      /**< mBedTLS CryptoSym */
#define NXPBUILD__PH_CRYPTOSYM_DUT                          /**< mBedTLS CryptoSym */
#define NXPBUILD__PH_CRYPTOASYM_STUB                        /**< Stub Crypto ASym */

#if defined (NXPBUILD__PH_CRYPTOSYM_SW) || \
    defined (NXPBUILD__PH_CRYPTOSYM_LRP) || \
    defined (NXPBUILD__PH_CRYPTOSYM_MBEDTLS) || \
    defined (NXPBUILD__PH_CRYPTOSYM_DUT) || \
    defined (NXPBUILD__PH_CRYPTOSYM_STUB)
    #define NXPBUILD__PH_CRYPTOSYM                          /**< Generic CryptoSym definition */
#endif

/* Crypto ASym components */
#define NXPBUILD__PH_CRYPTOASYM_MBEDTLS                     /**< Software Crypto ASym using mBedTLS library. */
#define NXPBUILD__PH_CRYPTOASYM_STUB                        /**< Stub Crypto ASym */
#define NXPBUILD__PH_CRYPTOASYM_ECC                         /**< Crypto ASym for ECC */
#define NXPBUILD__PH_CRYPTOASYM_HASH                        /**< Crypto ASym for Hash */

#if defined (NXPBUILD__PH_CRYPTOASYM_MBEDTLS) || \
    defined (NXPBUILD__PH_CRYPTOASYM_STUB) || \
    defined (NXPBUILD__PH_CRYPTOASYM_ECC) || \
    defined (NXPBUILD__PH_CRYPTOASYM_HASH)
    #define NXPBUILD__PH_CRYPTOASYM                         /**< Generic Crypto ASym definition */
#endif

/* CryptoRng components */
#define NXPBUILD__PH_CRYPTORNG_SW                           /**< Software CryptoRng */
#define NXPBUILD__PH_CRYPTORNG_MBEDTLS                      /**< mBedTLs CryptoRng */
#define NXPBUILD__PH_CRYPTORNG_DUT                          /**< DUT CryptoRng */
#define NXPBUILD__PH_CRYPTORNG_STUB                         /**< Stub CryptoRng */

#if defined (NXPBUILD__PH_CRYPTORNG_SW) || \
    defined (NXPBUILD__PH_CRYPTORNG_MBEDTLS) || \
    defined (NXPBUILD__PH_CRYPTORNG_DUT) || \
    defined (NXPBUILD__PH_CRYPTORNG_STUB)
    #define NXPBUILD__PH_CRYPTORNG                          /**< Generic CryptoRng definition */
#endif

/* KeyStore components */
#define NXPBUILD__PH_KEYSTORE_SW                            /**< Software KeyStore */
#define NXPBUILD__PH_KEYSTORE_ASYM                          /**< ASymmetric Software KeyStore */
#define NXPBUILD__PH_KEYSTORE_SAM                           /**< SAM (AV4 and future SAM's) KeyStore */
#define NXPBUILD__PH_KEYSTORE_SAMAV2                        /**< SamAV2 KeyStore */
#define NXPBUILD__PH_KEYSTORE_SAMAV3                        /**< SamAV3 KeyStore */
#define NXPBUILD__PH_KEYSTORE_RC632                         /**< RC632 KeyStore */
#define NXPBUILD__PH_KEYSTORE_RC663                         /**< RC663 KeyStore */
#define NXPBUILD__PH_KEYSTORE_RD710                         /**< Rd710 KeyStore */
#define NXPBUILD__PH_KEYSTORE_DUT                           /**< KeyStore part of DUT */
#define NXPBUILD__PH_KEYSTORE_DUT_NDA                       /**< KeyStore part of DUT NDA */

#if defined (NXPBUILD__PH_KEYSTORE_SW) || \
    defined (NXPBUILD__PH_KEYSTORE_ASYM) || \
    defined (NXPBUILD__PH_KEYSTORE_SAM) || \
    defined (NXPBUILD__PH_KEYSTORE_SAMAV2) || \
    defined (NXPBUILD__PH_KEYSTORE_SAMAV3) || \
    defined (NXPBUILD__PH_KEYSTORE_RC663) || \
    defined (NXPBUILD__PH_KEYSTORE_RC632) || \
    defined (NXPBUILD__PH_KEYSTORE_RD710)
    #define NXPBUILD__PH_KEYSTORE                           /**< Generic KeyStore definition */
#endif

/* TMIUtils component */
#define NXPBUILD__PH_TMIUTILS 


/* Log component */
#define NXPBUILD__PH_LOG 


/** @}
* end of ph_NxpBuild
*/

#define NXPBUILD__PHHAL_HW_RFIDLITE 


#endif /* PH_NXPBUILD_H */
