/*
 * Copyright 2013, 2025 NXP
 * NXP Confidential and Proprietary.
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms. By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms. If you do not agree to be
 * bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

/** \file
 * Internal definitions for Rc523 specific HAL-Component of Reader Library Framework.
 * $Author: Rajendran Kumar (nxp99556) $
 * $Revision: 7467 $
 * $Date: 2025-08-31 13:27:22 +0530 (Sun, 31 Aug 2025) $
 */

#ifndef PHHALHW_MFCCRYPTO_CMD_H
#define PHHALHW_MFCCRYPTO_CMD_H

#include <ph_Status.h>

#ifdef __cplusplus
extern "C" {
#endif	/* __cplusplus */

#ifdef  NXPBUILD__PHHAL_HW_MFCCRYPTO

/** \defgroup phhalHw_MfcCrypto_Cmd MIFARE Crypto Commands
* \brief Supported MfcCrypto commands.
* @{
*/

/**
* \name Authentication Modes
*/
/*@{*/
#define PHHAL_HW_MFCCRYPTO_CMD_AUTHTYPE_KEYA     0x60U   /**< Authentication type for key type A. */
#define PHHAL_HW_MFCCRYPTO_CMD_AUTHTYPE_KEYB     0x61U   /**< Authentication type for key type B. */
/*@}*/

/**
* \brief Prepares a bit stream data block for the MIFARE authentication part 1 ready to be transmitted to the MIFARE card.
*
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlaying component.
*/
phStatus_t phhalHw_MfcCrypto_Cmd_EncodeAuth1(
    phhalHw_MfcCrypto_DataParams_t * pDataParams,   /**< [In] Pointer to this layer's parameter structure. */
    uint8_t bAuthType,                              /**< [In] Authentication type. */
    uint8_t bBlockAddr,                             /**< [In] Block address. */
    uint8_t * pAuth1Msg                             /**< [Out] Encrypted authentication 1 message, ready to send. */
    );

/**
* \brief Decodes and checks the bit stream data block retrieved from the MIFARE card for authentication part 1.
*
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval #PH_ERR_INVALID_PARAMETER Input length parameters does not match.
* \retval Other Depending on implementation and underlaying component.
*/
phStatus_t phhalHw_MfcCrypto_Cmd_DecodeAuth1(
    phhalHw_MfcCrypto_DataParams_t * pDataParams,   /**< [In] Pointer to this layer's parameter structure. */
    uint8_t* pAuth1Reply,                           /**< [In] Authentication reply. */
    uint16_t wAuth1ReplyLength,                     /**< [In] Authentication reply length. */
    uint8_t bAuth1ReplyBits,                        /**< [In] Authentication reply bit length of the last byte. */
    uint8_t* pUid,                                  /**< [In] Uid. */
    uint8_t* pKey,                                  /**< [In] Key. */
    uint8_t* pRndA,                                 /**< [In] Random A. */
    uint8_t* pRndB                                  /**< [Out] Random B. */
    );

/**
* \brief Prepares a bit stream data block for the MIFARE authentication part 2 ready to be transmitted to the MIFARE card.
*
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlaying component.
*/
phStatus_t phhalHw_MfcCrypto_Cmd_EncodeAuth2(
    phhalHw_MfcCrypto_DataParams_t * pDataParams,   /**< [In] Pointer to this layer's parameter structure. */
    uint8_t * pAuth2Msg                             /**< [Out] Encrypted authentication 2 message, ready to send. */
    );

/**
* \brief Decodes and checks the bit stream data block retrieved from the MIFARE card for authentication part 2.
*
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval #PH_ERR_INVALID_PARAMETER Input length parameters does not match.
* \retval #PH_ERR_AUTH_ERROR Random number does not match, authentication failed.
* \retval Other Depending on implementation and underlaying component.
*/
phStatus_t phhalHw_MfcCrypto_Cmd_DecodeAuth2(
    phhalHw_MfcCrypto_DataParams_t * pDataParams,   /**< [In] Pointer to this layer's parameter structure. */
    uint8_t * pAuth2Reply,                          /**< [In] Authentication reply. */
    uint16_t wAuth2ReplyLength,                     /**< [In] Authentication reply length. */
    uint8_t bAuth2ReplyBits,                        /**< [In] Authentication reply bit length of the last byte. */
    uint8_t * pRndB2                                /**< [Out] Random B'. */
    );

/**
* \brief Encode/Decodes a bit stream with the MIFARE Crypto 1.
* This can only be used after a successful authentication.
*
* \return Status code
* \retval #PH_ERR_SUCCESS Operation successful.
* \retval Other Depending on implementation and underlaying component.
*/
phStatus_t phhalHw_MfcCrypto_Cmd_CodeData(
    phhalHw_MfcCrypto_DataParams_t * pDataParams,   /**< [In] Pointer to this layer's parameter structure. */
    uint8_t * pDataIn,                              /**< [In] Input buffer. */
    uint32_t dwDataBitLen,                          /**< [In] Buffer bit length. */
    uint8_t * pDataOut                              /**< [Out] Output buffer. */
    );

/** @} */
#endif /* NXPBUILD__PHHAL_HW_MFCCRYPTO */

#ifdef __cplusplus
} /* Extern C */
#endif

#endif /* PHHALHW_MFCCRYPTO_CMD_H */
